/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw2d.geometry;

import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PrecisionDimension;
import org.eclipse.draw2d.geometry.PrecisionGeometry;
import org.eclipse.draw2d.geometry.PrecisionPoint;
import org.eclipse.draw2d.geometry.Rectangle;

public final class PrecisionRectangle
extends Rectangle {
    private static final long serialVersionUID = 1L;
    @Deprecated(since="3.7", forRemoval=true)
    public double preciseHeight;
    @Deprecated(since="3.7", forRemoval=true)
    public double preciseWidth;
    @Deprecated(since="3.7", forRemoval=true)
    public double preciseX;
    @Deprecated(since="3.7", forRemoval=true)
    public double preciseY;

    public PrecisionRectangle() {
    }

    public PrecisionRectangle(double x, double y, double width, double height) {
        this.setPreciseLocation(x, y);
        this.setPreciseSize(width, height);
    }

    public PrecisionRectangle(Point p, Dimension d) {
        this(p.preciseX(), p.preciseY(), d.preciseWidth(), d.preciseHeight());
    }

    public PrecisionRectangle(Rectangle rect) {
        this(rect.preciseX(), rect.preciseY(), rect.preciseWidth(), rect.preciseHeight());
    }

    @Override
    public boolean contains(double x, double y) {
        return this.containsPrecise(x, y);
    }

    @Override
    public boolean contains(int x, int y) {
        return this.containsPrecise(x, y);
    }

    @Override
    public boolean contains(Point p) {
        return this.containsPrecise(p.preciseX(), p.preciseY());
    }

    @Override
    public boolean contains(Rectangle rect) {
        return this.preciseX() <= rect.preciseX() && this.preciseY() <= rect.preciseY() && this.right() >= rect.right() && this.bottom() >= rect.bottom();
    }

    private boolean containsPrecise(double x, double y) {
        return y >= this.preciseY() && y < this.preciseY() + this.preciseHeight() && x >= this.preciseX() && x < this.preciseX() + this.preciseWidth();
    }

    @Override
    public boolean equals(Object o) {
        if (o instanceof PrecisionRectangle) {
            PrecisionRectangle rect = (PrecisionRectangle)o;
            return super.equals(o) && Math.abs(rect.preciseX() - this.preciseX()) < 1.0E-9 && Math.abs(rect.preciseY() - this.preciseY()) < 1.0E-9 && Math.abs(rect.preciseWidth() - this.preciseWidth()) < 1.0E-9 && Math.abs(rect.preciseHeight() - this.preciseHeight()) < 1.0E-8;
        }
        return super.equals(o);
    }

    @Override
    public Rectangle expand(double h, double v) {
        return this.expandPrecise(h, v);
    }

    @Override
    public Rectangle expand(Insets insets) {
        if (insets == null) {
            return this;
        }
        this.setPreciseX(this.preciseX() - (double)insets.left);
        this.setPreciseY(this.preciseY() - (double)insets.top);
        this.setPreciseWidth(this.preciseWidth() + (double)insets.getWidth());
        this.setPreciseHeight(this.preciseHeight() + (double)insets.getHeight());
        return this;
    }

    @Override
    public Rectangle expand(int h, int v) {
        return this.expandPrecise(h, v);
    }

    private PrecisionRectangle expandPrecise(double h, double v) {
        return this.shrinkPrecise(-h, -v);
    }

    @Override
    public Point getBottom() {
        return new PrecisionPoint(this.preciseX() + this.preciseWidth() / 2.0, (double)this.bottom());
    }

    @Override
    public Point getBottomLeft() {
        return new PrecisionPoint(this.preciseX(), this.preciseY() + this.preciseHeight());
    }

    @Override
    public Point getBottomRight() {
        return new PrecisionPoint(this.preciseX() + this.preciseWidth(), this.preciseY() + this.preciseHeight());
    }

    @Override
    public Point getCenter() {
        return new PrecisionPoint(this.preciseX() + this.preciseWidth() / 2.0, this.preciseY() + this.preciseHeight() / 2.0);
    }

    @Override
    public Rectangle getCopy() {
        return this.getPreciseCopy();
    }

    public PrecisionRectangle getPreciseCopy() {
        return new PrecisionRectangle(this.preciseX(), this.preciseY(), this.preciseWidth(), this.preciseHeight());
    }

    @Override
    public Point getTop() {
        return new PrecisionPoint(this.preciseX() + this.preciseWidth() / 2.0, this.preciseY());
    }

    @Override
    public Point getTopLeft() {
        return new PrecisionPoint(this.preciseX(), this.preciseY());
    }

    @Override
    public Point getTopRight() {
        return new PrecisionPoint(this.preciseX() + this.preciseWidth(), this.preciseY());
    }

    @Override
    public Rectangle intersect(Rectangle rect) {
        return this.intersectPrecise(rect);
    }

    private PrecisionRectangle intersectPrecise(Rectangle rect) {
        double x1 = Math.max(this.preciseX(), rect.preciseX());
        double x2 = Math.min(this.preciseX() + this.preciseWidth(), rect.preciseX() + rect.preciseWidth());
        double y1 = Math.max(this.preciseY(), rect.preciseY());
        double y2 = Math.min(this.preciseY() + this.preciseHeight(), rect.preciseY() + rect.preciseHeight());
        if (x2 - x1 < 0.0 || y2 - y1 < 0.0) {
            return this.setPreciseBounds(0.0, 0.0, 0.0, 0.0);
        }
        return this.setPreciseBounds(x1, y1, x2 - x1, y2 - y1);
    }

    @Override
    public void performScale(double factor) {
        this.setPreciseX(this.preciseX() * factor);
        this.setPreciseY(this.preciseY() * factor);
        this.setPreciseWidth(this.preciseWidth() * factor);
        this.setPreciseHeight(this.preciseHeight() * factor);
    }

    @Override
    public void performTranslate(int dx, int dy) {
        this.setPreciseX(this.preciseX() + (double)dx);
        this.setPreciseY(this.preciseY() + (double)dy);
    }

    public double preciseBottom() {
        return this.preciseHeight() + this.preciseY();
    }

    @Override
    public double preciseHeight() {
        this.updatePreciseHeightDouble();
        return this.preciseHeight;
    }

    public double preciseRight() {
        return this.preciseWidth() + this.preciseX();
    }

    @Override
    public double preciseWidth() {
        this.updatePreciseWidthDouble();
        return this.preciseWidth;
    }

    @Override
    public double preciseX() {
        this.updatePreciseXDouble();
        return this.preciseX;
    }

    @Override
    public double preciseY() {
        this.updatePreciseYDouble();
        return this.preciseY;
    }

    @Override
    public Rectangle resize(Dimension d) {
        return this.resizePrecise(d.preciseWidth(), d.preciseHeight());
    }

    @Override
    public Rectangle resize(double w, double h) {
        return this.resizePrecise(w, h);
    }

    @Override
    public Rectangle resize(int w, int h) {
        return this.resizePrecise(w, h);
    }

    private PrecisionRectangle resizePrecise(double w, double h) {
        this.setPreciseWidth(this.preciseWidth() + w);
        this.setPreciseHeight(this.preciseHeight() + h);
        return this;
    }

    @Override
    public Rectangle scale(double scaleX, double scaleY) {
        this.setPreciseX(this.preciseX() * scaleX);
        this.setPreciseY(this.preciseY() * scaleY);
        this.setPreciseWidth(this.preciseWidth() * scaleX);
        this.setPreciseHeight(this.preciseHeight() * scaleY);
        return this;
    }

    @Override
    public Rectangle setBounds(int x, int y, int width, int height) {
        return this.setPreciseBounds(x, y, width, height);
    }

    @Override
    public Rectangle setBounds(Point location, Dimension size) {
        return this.setPreciseBounds(location.preciseX(), location.preciseY(), size.preciseWidth(), size.preciseHeight());
    }

    @Override
    public Rectangle setBounds(Rectangle rect) {
        return this.setPreciseBounds(rect.preciseX(), rect.preciseY(), rect.preciseWidth(), rect.preciseHeight());
    }

    @Deprecated(since="3.7", forRemoval=true)
    public void setHeight(double value) {
        this.setPreciseHeight(value);
    }

    @Override
    public Rectangle setHeight(int height) {
        return this.setPreciseHeight(height);
    }

    @Override
    public Rectangle setLocation(int x, int y) {
        return this.setPreciseLocation(x, y);
    }

    @Override
    public Rectangle setLocation(Point loc) {
        return this.setPreciseLocation(loc.preciseX(), loc.preciseY());
    }

    public PrecisionRectangle setPreciseBounds(double x, double y, double width, double height) {
        this.setPreciseLocation(x, y);
        this.setPreciseSize(width, height);
        return this;
    }

    public PrecisionRectangle setPreciseHeight(double value) {
        this.preciseHeight = value;
        this.updateHeightInt();
        return this;
    }

    public PrecisionRectangle setPreciseLocation(double x, double y) {
        this.setPreciseX(x);
        this.setPreciseY(y);
        return this;
    }

    public PrecisionRectangle setPreciseLocation(PrecisionPoint loc) {
        return this.setPreciseLocation(loc.preciseX(), loc.preciseY());
    }

    public PrecisionRectangle setPreciseSize(double w, double h) {
        this.setPreciseWidth(w);
        this.setPreciseHeight(h);
        return this;
    }

    public PrecisionRectangle setPreciseSize(PrecisionDimension size) {
        return this.setPreciseSize(size.preciseWidth(), size.preciseHeight());
    }

    public PrecisionRectangle setPreciseWidth(double value) {
        this.preciseWidth = value;
        this.updateWidthInt();
        return this;
    }

    public PrecisionRectangle setPreciseX(double value) {
        this.preciseX = value;
        this.updateXInt();
        return this;
    }

    public PrecisionRectangle setPreciseY(double value) {
        this.preciseY = value;
        this.updateYInt();
        return this;
    }

    @Override
    public Rectangle setSize(Dimension d) {
        return this.setPreciseSize(d.preciseWidth(), d.preciseHeight());
    }

    @Override
    public Rectangle setSize(int w, int h) {
        return this.setPreciseSize(w, h);
    }

    @Deprecated(since="3.7", forRemoval=true)
    public void setWidth(double value) {
        this.setPreciseWidth(value);
    }

    @Override
    public Rectangle setWidth(int width) {
        return this.setPreciseWidth(width);
    }

    @Deprecated(since="3.7", forRemoval=true)
    public void setX(double value) {
        this.setPreciseX(value);
    }

    @Override
    public Rectangle setX(int value) {
        return this.setPreciseX(value);
    }

    @Deprecated(since="3.7", forRemoval=true)
    public void setY(double value) {
        this.setPreciseY(value);
    }

    @Override
    public Rectangle setY(int value) {
        return this.setPreciseY(value);
    }

    @Override
    public Rectangle shrink(double h, double v) {
        return this.shrinkPrecise(h, v);
    }

    @Override
    public Rectangle shrink(Insets insets) {
        if (insets == null) {
            return this;
        }
        this.setPreciseX(this.preciseX() + (double)insets.left);
        this.setPreciseY(this.preciseY() + (double)insets.top);
        this.setPreciseWidth(this.preciseWidth() - (double)insets.getWidth());
        this.setPreciseHeight(this.preciseHeight() - (double)insets.getHeight());
        return this;
    }

    @Override
    public Rectangle shrink(int h, int v) {
        return this.shrinkPrecise(h, v);
    }

    private PrecisionRectangle shrinkPrecise(double h, double v) {
        this.setPreciseX(this.preciseX() + h);
        this.setPreciseWidth(this.preciseWidth() - (h + h));
        this.setPreciseY(this.preciseY() + v);
        this.setPreciseHeight(this.preciseHeight() - (v + v));
        return this;
    }

    @Override
    public boolean touches(Rectangle rect) {
        return rect.preciseX() <= this.preciseX() + this.preciseWidth() && rect.preciseY() <= this.preciseY() + this.preciseHeight() && rect.preciseX() + rect.preciseWidth() >= this.preciseX() && rect.preciseY() + rect.preciseHeight() >= this.preciseY();
    }

    @Override
    public Rectangle translate(double dx, double dy) {
        return this.translatePrecise(dx, dy);
    }

    @Override
    public Rectangle translate(int dx, int dy) {
        return this.translatePrecise(dx, dy);
    }

    @Override
    public Rectangle translate(Point p) {
        return this.translatePrecise(p.preciseX(), p.preciseY());
    }

    private PrecisionRectangle translatePrecise(double dx, double dy) {
        this.setPreciseX(this.preciseX() + dx);
        this.setPreciseY(this.preciseY() + dy);
        return this;
    }

    @Override
    public Rectangle transpose() {
        double temp = this.preciseX();
        this.setPreciseX(this.preciseY());
        this.setPreciseY(temp);
        temp = this.preciseWidth();
        this.setPreciseWidth(this.preciseHeight());
        this.setPreciseHeight(temp);
        return this;
    }

    @Override
    public Rectangle union(double x, double y) {
        return this.unionPrecise(x, y);
    }

    @Override
    public Rectangle union(double x, double y, double w, double h) {
        return this.unionPrecise(x, y, w, h);
    }

    @Override
    public Rectangle union(int x, int y) {
        return this.unionPrecise(x, y);
    }

    @Override
    public Rectangle union(int x, int y, int w, int h) {
        return this.unionPrecise(x, y, w, h);
    }

    @Override
    public void union(Point p) {
        this.unionPrecise(p.preciseX(), p.preciseY());
    }

    @Deprecated(since="3.7", forRemoval=true)
    public PrecisionRectangle union(PrecisionRectangle rect) {
        if (rect == null || rect.isEmpty()) {
            return this;
        }
        return this.unionPrecise(rect.preciseX(), rect.preciseY(), rect.preciseWidth(), rect.preciseHeight());
    }

    @Override
    public Rectangle union(Rectangle rect) {
        if (rect == null || rect.isEmpty()) {
            return this;
        }
        return this.unionPrecise(rect.preciseX(), rect.preciseY(), rect.preciseWidth(), rect.preciseHeight());
    }

    private PrecisionRectangle unionPrecise(double x, double y) {
        if (x < this.preciseX()) {
            this.setPreciseWidth(this.preciseWidth() + (this.preciseX() - x));
            this.setPreciseX(x);
        } else {
            double right = this.preciseX() + this.preciseWidth();
            if (x > right) {
                this.setPreciseWidth(x - this.preciseX());
            }
        }
        if (y < this.preciseY()) {
            this.setPreciseHeight(this.preciseHeight() + (this.preciseY() - y));
            this.setPreciseY(y);
        } else {
            double bottom = this.preciseY() + this.preciseHeight();
            if (y > bottom) {
                this.setPreciseHeight(y - this.preciseY());
            }
        }
        return this;
    }

    private PrecisionRectangle unionPrecise(double x, double y, double w, double h) {
        double right = Math.max(this.preciseX() + this.preciseWidth(), x + w);
        double bottom = Math.max(this.preciseY() + this.preciseHeight(), y + h);
        this.setPreciseX(Math.min(this.preciseX(), x));
        this.setPreciseY(Math.min(this.preciseY(), y));
        this.setPreciseWidth(right - this.preciseX());
        this.setPreciseHeight(bottom - this.preciseY());
        return this;
    }

    private final void updateHeightInt() {
        this.height = PrecisionGeometry.doubleToInteger(this.preciseHeight);
    }

    @Deprecated(since="3.7", forRemoval=true)
    public void updateInts() {
        this.updateXInt();
        this.updateYInt();
        this.updateWidthInt();
        this.updateHeightInt();
    }

    private final void updatePreciseHeightDouble() {
        if (this.height != PrecisionGeometry.doubleToInteger(this.preciseHeight)) {
            this.preciseHeight = this.height;
        }
    }

    private final void updatePreciseWidthDouble() {
        if (this.width != PrecisionGeometry.doubleToInteger(this.preciseWidth)) {
            this.preciseWidth = this.width;
        }
    }

    private final void updatePreciseXDouble() {
        if (this.x != PrecisionGeometry.doubleToInteger(this.preciseX)) {
            this.preciseX = this.x;
        }
    }

    private final void updatePreciseYDouble() {
        if (this.y != PrecisionGeometry.doubleToInteger(this.preciseY)) {
            this.preciseY = this.y;
        }
    }

    private final void updateWidthInt() {
        this.width = PrecisionGeometry.doubleToInteger(this.preciseWidth);
    }

    private final void updateXInt() {
        this.x = PrecisionGeometry.doubleToInteger(this.preciseX);
    }

    private final void updateYInt() {
        this.y = PrecisionGeometry.doubleToInteger(this.preciseY);
    }
}

