/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.graphics;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.RGBA;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.internal.gtk.GdkRGBA;

public final class Color
extends Resource {
    public GdkRGBA handle;
    int alpha = 0;

    Color(Device device) {
        super(device);
    }

    public Color(Device device, int red, int green, int blue) {
        super(device);
        this.init(red, green, blue, 255);
        this.init();
    }

    public Color(int red, int green, int blue) {
        this.init(red, green, blue, 255);
    }

    public Color(Device device, int red, int green, int blue, int alpha) {
        super(device);
        this.init(red, green, blue, alpha);
        this.init();
    }

    public Color(int red, int green, int blue, int alpha) {
        this.init(red, green, blue, alpha);
    }

    public Color(Device device, RGB rgb) {
        super(device);
        if (rgb == null) {
            SWT.error(4);
        }
        this.init(rgb.red, rgb.green, rgb.blue, 255);
        this.init();
    }

    public Color(RGB rgb) {
        if (rgb == null) {
            SWT.error(4);
        }
        this.init(rgb.red, rgb.green, rgb.blue, 255);
    }

    public Color(Device device, RGBA rgba) {
        super(device);
        if (rgba == null) {
            SWT.error(4);
        }
        this.init(rgba.rgb.red, rgba.rgb.green, rgba.rgb.blue, rgba.alpha);
        this.init();
    }

    public Color(RGBA rgba) {
        if (rgba == null) {
            SWT.error(4);
        }
        this.init(rgba.rgb.red, rgba.rgb.green, rgba.rgb.blue, rgba.alpha);
    }

    public Color(Device device, RGB rgb, int alpha) {
        super(device);
        if (rgb == null) {
            SWT.error(4);
        }
        this.init(rgb.red, rgb.green, rgb.blue, alpha);
        this.init();
    }

    public Color(RGB rgb, int alpha) {
        if (rgb == null) {
            SWT.error(4);
        }
        this.init(rgb.red, rgb.green, rgb.blue, alpha);
    }

    @Override
    void destroy() {
        this.handle = null;
    }

    @Override
    public void dispose() {
        this.destroy();
        this.device = null;
    }

    @Override
    public Device getDevice() {
        if (this.device == null && this.handle != null) {
            return Device.getDevice();
        }
        return super.getDevice();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof Color)) {
            return false;
        }
        Color color = (Color)object;
        if (this.isDisposed() || color.isDisposed()) {
            return false;
        }
        GdkRGBA gdkRGBA = color.handle;
        if (this.handle == gdkRGBA) {
            return true;
        }
        if (this.getRed() != color.getRed()) {
            return false;
        }
        if (this.getGreen() != color.getGreen()) {
            return false;
        }
        if (this.getBlue() != color.getBlue()) {
            return false;
        }
        return this.getAlpha() == color.getAlpha();
    }

    public int getAlpha() {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        return this.alpha;
    }

    public int getBlue() {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        int b = (int)(this.handle.blue * 65535.0 + 0.5) >> 8;
        return Math.min(b, 255);
    }

    public int getGreen() {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        int g = (int)(this.handle.green * 65535.0 + 0.5) >> 8;
        return Math.min(g, 255);
    }

    public int getRed() {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        int r = (int)(this.handle.red * 65535.0 + 0.5) >> 8;
        return Math.min(r, 255);
    }

    public int hashCode() {
        if (this.isDisposed()) {
            return 0;
        }
        return ((this.getAlpha() * 31 + this.getGreen()) * 31 + this.getBlue()) * 31 + this.getRed();
    }

    public RGB getRGB() {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        return new RGB(this.getRed(), this.getGreen(), this.getBlue());
    }

    public RGBA getRGBA() {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        return new RGBA(this.getRed(), this.getGreen(), this.getBlue(), this.getAlpha());
    }

    public static Color gtk_new(Device device, GdkRGBA gdkRGBA) {
        Color color = new Color(device);
        color.handle = gdkRGBA;
        color.alpha = (int)(gdkRGBA.alpha * 255.0);
        return color;
    }

    public static Color gtk_new(Device device, GdkRGBA gdkRGBA, int alpha) {
        Color color = new Color(device);
        color.handle = gdkRGBA;
        color.alpha = alpha;
        return color;
    }

    void init(int red, int green, int blue, int alpha) {
        if (red > 255 || red < 0 || green > 255 || green < 0 || blue > 255 || blue < 0 || alpha > 255 || alpha < 0) {
            SWT.error(5);
        }
        GdkRGBA rgba = new GdkRGBA();
        rgba.red = (double)red / 255.0;
        rgba.green = (double)green / 255.0;
        rgba.blue = (double)blue / 255.0;
        rgba.alpha = (double)alpha / 255.0;
        this.alpha = alpha;
        this.handle = rgba;
    }

    @Override
    void init() {
    }

    @Override
    public boolean isDisposed() {
        return this.handle == null;
    }

    public String toString() {
        if (this.isDisposed()) {
            return "Color {*DISPOSED*}";
        }
        return "Color {" + this.getRed() + ", " + this.getGreen() + ", " + this.getBlue() + ", " + this.getAlpha() + "}";
    }
}

