/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.reorg;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourceAttributes;
import org.eclipse.core.resources.mapping.IResourceChangeDescriptionFactory;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IImportContainer;
import org.eclipse.jdt.core.IImportDeclaration;
import org.eclipse.jdt.core.IInitializer;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaModel;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IOpenable;
import org.eclipse.jdt.core.IPackageDeclaration;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.ISourceReference;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.jdt.core.dom.AnonymousClassDeclaration;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.EnumConstantDeclaration;
import org.eclipse.jdt.core.dom.EnumDeclaration;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.ImportDeclaration;
import org.eclipse.jdt.core.dom.Javadoc;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.PackageDeclaration;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.StructuralPropertyDescriptor;
import org.eclipse.jdt.core.dom.SwitchStatement;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.core.dom.rewrite.ListRewrite;
import org.eclipse.jdt.core.refactoring.CompilationUnitChange;
import org.eclipse.jdt.core.refactoring.descriptors.JavaRefactoringDescriptor;
import org.eclipse.jdt.internal.core.manipulation.util.Strings;
import org.eclipse.jdt.internal.core.refactoring.descriptors.RefactoringSignatureDescriptorFactory;
import org.eclipse.jdt.internal.corext.codemanipulation.ContextSensitiveImportRewriteContext;
import org.eclipse.jdt.internal.corext.codemanipulation.StubUtility;
import org.eclipse.jdt.internal.corext.dom.ASTNodeFactory;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.corext.dom.BodyDeclarationRewrite;
import org.eclipse.jdt.internal.corext.refactoring.Checks;
import org.eclipse.jdt.internal.corext.refactoring.JDTRefactoringDescriptorComment;
import org.eclipse.jdt.internal.corext.refactoring.JavaRefactoringArguments;
import org.eclipse.jdt.internal.corext.refactoring.JavaRefactoringDescriptorUtil;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.jdt.internal.corext.refactoring.changes.CopyCompilationUnitChange;
import org.eclipse.jdt.internal.corext.refactoring.changes.CopyPackageChange;
import org.eclipse.jdt.internal.corext.refactoring.changes.CopyPackageFragmentRootChange;
import org.eclipse.jdt.internal.corext.refactoring.changes.CopyResourceChange;
import org.eclipse.jdt.internal.corext.refactoring.changes.DynamicValidationStateChange;
import org.eclipse.jdt.internal.corext.refactoring.changes.MoveCompilationUnitChange;
import org.eclipse.jdt.internal.corext.refactoring.changes.MovePackageChange;
import org.eclipse.jdt.internal.corext.refactoring.changes.MovePackageFragmentRootChange;
import org.eclipse.jdt.internal.corext.refactoring.reorg.ASTNodeDeleteUtil;
import org.eclipse.jdt.internal.corext.refactoring.reorg.ArrayTypeConverter;
import org.eclipse.jdt.internal.corext.refactoring.reorg.CopyModifications;
import org.eclipse.jdt.internal.corext.refactoring.reorg.CreateCopyOfCompilationUnitChange;
import org.eclipse.jdt.internal.corext.refactoring.reorg.CreateTargetExecutionLog;
import org.eclipse.jdt.internal.corext.refactoring.reorg.DeleteChangeCreator;
import org.eclipse.jdt.internal.corext.refactoring.reorg.ICreateTargetQueries;
import org.eclipse.jdt.internal.corext.refactoring.reorg.ICreateTargetQuery;
import org.eclipse.jdt.internal.corext.refactoring.reorg.INewNameQueries;
import org.eclipse.jdt.internal.corext.refactoring.reorg.INewNameQuery;
import org.eclipse.jdt.internal.corext.refactoring.reorg.IReorgDestination;
import org.eclipse.jdt.internal.corext.refactoring.reorg.IReorgPolicy;
import org.eclipse.jdt.internal.corext.refactoring.reorg.IReorgQueries;
import org.eclipse.jdt.internal.corext.refactoring.reorg.MoveCuUpdateCreator;
import org.eclipse.jdt.internal.corext.refactoring.reorg.MoveModifications;
import org.eclipse.jdt.internal.corext.refactoring.reorg.OverwriteHelper;
import org.eclipse.jdt.internal.corext.refactoring.reorg.ParentChecker;
import org.eclipse.jdt.internal.corext.refactoring.reorg.ReadOnlyResourceFinder;
import org.eclipse.jdt.internal.corext.refactoring.reorg.RefactoringModifications;
import org.eclipse.jdt.internal.corext.refactoring.reorg.ReorgDestinationFactory;
import org.eclipse.jdt.internal.corext.refactoring.reorg.ReorgUtils;
import org.eclipse.jdt.internal.corext.refactoring.structure.ASTNodeSearchUtil;
import org.eclipse.jdt.internal.corext.refactoring.structure.CompilationUnitRewrite;
import org.eclipse.jdt.internal.corext.refactoring.structure.ImportRewriteUtil;
import org.eclipse.jdt.internal.corext.refactoring.util.Changes;
import org.eclipse.jdt.internal.corext.refactoring.util.JavaElementUtil;
import org.eclipse.jdt.internal.corext.refactoring.util.QualifiedNameFinder;
import org.eclipse.jdt.internal.corext.refactoring.util.QualifiedNameSearchResult;
import org.eclipse.jdt.internal.corext.refactoring.util.RefactoringASTParser;
import org.eclipse.jdt.internal.corext.refactoring.util.ResourceUtil;
import org.eclipse.jdt.internal.corext.refactoring.util.TextChangeManager;
import org.eclipse.jdt.internal.corext.util.JavaConventionsUtil;
import org.eclipse.jdt.internal.corext.util.JavaElementResourceMapping;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.ui.JavaElementLabels;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.ChangeDescriptor;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.ltk.core.refactoring.NullChange;
import org.eclipse.ltk.core.refactoring.RefactoringChangeDescriptor;
import org.eclipse.ltk.core.refactoring.RefactoringDescriptor;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.participants.CheckConditionsContext;
import org.eclipse.ltk.core.refactoring.participants.CopyArguments;
import org.eclipse.ltk.core.refactoring.participants.MoveArguments;
import org.eclipse.ltk.core.refactoring.participants.RefactoringParticipant;
import org.eclipse.ltk.core.refactoring.participants.RefactoringProcessor;
import org.eclipse.ltk.core.refactoring.participants.ReorgExecutionLog;
import org.eclipse.ltk.core.refactoring.participants.ResourceChangeChecker;
import org.eclipse.ltk.core.refactoring.participants.SharableParticipants;
import org.eclipse.ltk.core.refactoring.participants.ValidateEditChecker;
import org.eclipse.ltk.core.refactoring.resource.MoveResourceChange;

public final class ReorgPolicyFactory {
    private static final String ATTRIBUTE_FILES = "files";
    private static final String ATTRIBUTE_FOLDERS = "folders";
    private static final String ATTRIBUTE_FRAGMENTS = "fragments";
    private static final String ATTRIBUTE_LOG = "log";
    private static final String ATTRIBUTE_MEMBERS = "members";
    private static final String ATTRIBUTE_PATTERNS = "patterns";
    private static final String ATTRIBUTE_POLICY = "policy";
    private static final String ATTRIBUTE_QUALIFIED = "qualified";
    private static final String ATTRIBUTE_ROOTS = "roots";
    private static final String ATTRIBUTE_UNITS = "units";
    private static final String DELIMITER_ELEMENT = "\t";
    private static final String DELIMITER_RECORD = "\n";
    private static final String NO_ID = "no_id";
    private static final String NO_POLICY = "no_policy";
    private static final String UNUSED_STRING = "unused";

    private static boolean containsNull(Object[] objects) {
        int i = 0;
        while (i < objects.length) {
            if (objects[i] == null) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static IReorgPolicy.ICopyPolicy createCopyPolicy(IResource[] resources, IJavaElement[] javaElements) throws JavaModelException {
        return (IReorgPolicy.ICopyPolicy)ReorgPolicyFactory.createReorgPolicy(true, resources, javaElements);
    }

    public static IReorgPolicy.ICopyPolicy createCopyPolicy(RefactoringStatus status, JavaRefactoringArguments arguments) {
        String policy = arguments.getAttribute(ATTRIBUTE_POLICY);
        if (policy != null && !"".equals(policy)) {
            if ("org.eclipse.jdt.ui.copyResources".equals(policy)) {
                return new CopyFilesFoldersAndCusPolicy(null, null, null);
            }
            if ("org.eclipse.jdt.ui.copyRoots".equals(policy)) {
                return new CopyPackageFragmentRootsPolicy(null);
            }
            if ("org.eclipse.jdt.ui.copyPackages".equals(policy)) {
                return new CopyPackagesPolicy(null);
            }
            if ("org.eclipse.jdt.ui.copyMembers".equals(policy)) {
                return new CopySubCuElementsPolicy(null);
            }
            status.merge(RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_illegal_argument, new String[]{policy, ATTRIBUTE_POLICY})));
        } else {
            status.merge(RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, ATTRIBUTE_POLICY)));
        }
        return null;
    }

    public static IReorgPolicy.IMovePolicy createMovePolicy(IResource[] resources, IJavaElement[] javaElements) throws JavaModelException {
        return (IReorgPolicy.IMovePolicy)ReorgPolicyFactory.createReorgPolicy(false, resources, javaElements);
    }

    public static IReorgPolicy.IMovePolicy createMovePolicy(RefactoringStatus status, JavaRefactoringArguments arguments) {
        String policy = arguments.getAttribute(ATTRIBUTE_POLICY);
        if (policy != null && !"".equals(policy)) {
            if ("org.eclipse.jdt.ui.moveResources".equals(policy)) {
                return new MoveFilesFoldersAndCusPolicy(null, null, null);
            }
            if ("org.eclipse.jdt.ui.moveRoots".equals(policy)) {
                return new MovePackageFragmentRootsPolicy(null);
            }
            if ("org.eclipse.jdt.ui.movePackages".equals(policy)) {
                return new MovePackagesPolicy(null);
            }
            if ("org.eclipse.jdt.ui.moveMembers".equals(policy)) {
                return new MoveMembersPolicy(null);
            }
            if ("org.eclipse.jdt.ui.moveImportDeclarations".equals(policy)) {
                return new MoveImportDeclarationsPolicy(null);
            }
            status.merge(RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_illegal_argument, new String[]{policy, ATTRIBUTE_POLICY})));
        } else {
            status.merge(RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, ATTRIBUTE_POLICY)));
        }
        return null;
    }

    private static IReorgPolicy createReorgPolicy(boolean copy, IResource[] selectedResources, IJavaElement[] selectedJavaElements) throws JavaModelException {
        ReorgPolicy NO = copy ? new NoCopyPolicy() : new NoMovePolicy();
        ActualSelectionComputer selectionComputer = new ActualSelectionComputer(selectedJavaElements, selectedResources);
        Object[] resources = selectionComputer.getActualResourcesToReorg();
        Object[] javaElements = selectionComputer.getActualJavaElementsToReorg();
        if (resources.length == 0 && javaElements.length == 0) {
            return NO;
        }
        if (ReorgPolicyFactory.containsNull(resources)) {
            return NO;
        }
        if (ReorgPolicyFactory.containsNull(javaElements)) {
            return NO;
        }
        if (ReorgUtils.isArchiveOrExternalMember((IJavaElement[])javaElements) && ReorgUtils.getElementsOfType((IJavaElement[])javaElements, 3).size() != javaElements.length) {
            return NO;
        }
        if (ReorgUtils.hasElementsOfType((IJavaElement[])javaElements, 2)) {
            return NO;
        }
        if (ReorgUtils.hasElementsOfType((IJavaElement[])javaElements, 1)) {
            return NO;
        }
        if (ReorgUtils.hasElementsOfType((IResource[])resources, 12)) {
            return NO;
        }
        if (!new ParentChecker((IResource[])resources, (IJavaElement[])javaElements).haveCommonParent()) {
            return NO;
        }
        if (ReorgUtils.hasElementsOfType((IJavaElement[])javaElements, 4)) {
            if (resources.length != 0 || ReorgUtils.hasElementsNotOfType((IJavaElement[])javaElements, 4)) {
                return NO;
            }
            if (copy) {
                return new CopyPackagesPolicy(ArrayTypeConverter.toPackageArray(javaElements));
            }
            return new MovePackagesPolicy(ArrayTypeConverter.toPackageArray(javaElements));
        }
        if (ReorgUtils.hasElementsOfType((IJavaElement[])javaElements, 3)) {
            if (resources.length != 0 || ReorgUtils.hasElementsNotOfType((IJavaElement[])javaElements, 3)) {
                return NO;
            }
            if (copy) {
                return new CopyPackageFragmentRootsPolicy(ArrayTypeConverter.toPackageFragmentRootArray(javaElements));
            }
            return new MovePackageFragmentRootsPolicy(ArrayTypeConverter.toPackageFragmentRootArray(javaElements));
        }
        if (ReorgUtils.hasElementsOfType((IResource[])resources, 3) || ReorgUtils.hasElementsOfType((IJavaElement[])javaElements, 5)) {
            if (ReorgUtils.hasElementsNotOfType((IJavaElement[])javaElements, 5)) {
                return NO;
            }
            if (ReorgUtils.hasElementsNotOfType((IResource[])resources, 3)) {
                return NO;
            }
            if (copy) {
                return new CopyFilesFoldersAndCusPolicy(ReorgUtils.getFiles((IResource[])resources), ReorgUtils.getFolders((IResource[])resources), ArrayTypeConverter.toCuArray(javaElements));
            }
            return new MoveFilesFoldersAndCusPolicy(ReorgUtils.getFiles((IResource[])resources), ReorgUtils.getFolders((IResource[])resources), ArrayTypeConverter.toCuArray(javaElements));
        }
        if (ReorgPolicyFactory.hasOnlyMembers((IJavaElement[])javaElements)) {
            if (ReorgPolicyFactory.hasAnonymousClassDeclarations((IJavaElement[])javaElements)) {
                return NO;
            }
            if (copy) {
                return new CopySubCuElementsPolicy((IJavaElement[])javaElements);
            }
            List<Object> members = Arrays.asList(javaElements);
            return new MoveMembersPolicy(members.toArray(new IMember[members.size()]));
        }
        if (ReorgPolicyFactory.hasOnlyImportDeclarations((IJavaElement[])javaElements)) {
            if (copy) {
                return new CopySubCuElementsPolicy((IJavaElement[])javaElements);
            }
            List<?> declarations = ReorgUtils.getElementsOfType((IJavaElement[])javaElements, 13);
            return new MoveImportDeclarationsPolicy(declarations.toArray(new IImportDeclaration[declarations.size()]));
        }
        if (copy && ReorgPolicyFactory.hasElementsSmallerThanCuOrClassFile((IJavaElement[])javaElements)) {
            if (ReorgUtils.hasElementsOfType((IJavaElement[])javaElements, 11)) {
                return NO;
            }
            if (ReorgPolicyFactory.hasAnonymousClassDeclarations((IJavaElement[])javaElements)) {
                return NO;
            }
            Assert.isTrue((resources.length == 0 ? 1 : 0) != 0);
            return new CopySubCuElementsPolicy((IJavaElement[])javaElements);
        }
        return NO;
    }

    private static boolean hasAnonymousClassDeclarations(IJavaElement[] javaElements) throws JavaModelException {
        int i = 0;
        while (i < javaElements.length) {
            IType type;
            if (javaElements[i] instanceof IType && (type = (IType)javaElements[i]).isAnonymous()) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private static boolean hasElementsSmallerThanCuOrClassFile(IJavaElement[] javaElements) {
        int i = 0;
        while (i < javaElements.length) {
            if (ReorgUtils.isInsideCompilationUnit(javaElements[i])) {
                return true;
            }
            if (ReorgUtils.isInsideClassFile(javaElements[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private static boolean hasOnlyImportDeclarations(IJavaElement[] javaElements) {
        int i = 0;
        while (i < javaElements.length) {
            if (javaElements[i].getElementType() != 13) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private static boolean hasOnlyMembers(IJavaElement[] javaElements) {
        int i = 0;
        while (i < javaElements.length) {
            if (!(javaElements[i] instanceof IMember)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static CreateTargetExecutionLog loadCreateTargetExecutionLog(JavaRefactoringArguments arguments) {
        CreateTargetExecutionLog log = new CreateTargetExecutionLog();
        String value = arguments.getAttribute(ATTRIBUTE_LOG);
        if (value != null) {
            StringTokenizer tokenizer = new StringTokenizer(value, DELIMITER_RECORD, false);
            while (tokenizer.hasMoreTokens()) {
                String token = tokenizer.nextToken();
                ReorgPolicyFactory.processCreateTargetExecutionRecord(log, arguments, token);
            }
        }
        return log;
    }

    public static ReorgExecutionLog loadReorgExecutionLog(JavaRefactoringArguments arguments) {
        ReorgExecutionLog log = new ReorgExecutionLog();
        String value = arguments.getAttribute(ATTRIBUTE_LOG);
        if (value != null) {
            StringTokenizer tokenizer = new StringTokenizer(value, DELIMITER_RECORD, false);
            while (tokenizer.hasMoreTokens()) {
                String token = tokenizer.nextToken();
                ReorgPolicyFactory.processReorgExecutionRecord(log, arguments, token);
            }
        }
        return log;
    }

    private static void processCreateTargetExecutionRecord(CreateTargetExecutionLog log, JavaRefactoringArguments arguments, String token) {
        StringTokenizer tokenizer = new StringTokenizer(token, DELIMITER_ELEMENT, false);
        String value = null;
        if (tokenizer.hasMoreTokens()) {
            value = tokenizer.nextToken();
            IJavaElement selection = JavaRefactoringDescriptorUtil.handleToElement(arguments.getProject(), value, false);
            if (selection == null) {
                selection = JavaRefactoringDescriptorUtil.handleToResource(arguments.getProject(), value);
            }
            if (selection != null && tokenizer.hasMoreTokens()) {
                value = tokenizer.nextToken();
                IJavaElement created = JavaRefactoringDescriptorUtil.handleToElement(arguments.getProject(), value, false);
                if (created == null) {
                    created = JavaRefactoringDescriptorUtil.handleToResource(arguments.getProject(), value);
                }
                if (created != null) {
                    log.markAsCreated(selection, created);
                }
            }
        }
    }

    private static void processReorgExecutionRecord(ReorgExecutionLog log, JavaRefactoringArguments arguments, String token) {
        StringTokenizer tokenizer = new StringTokenizer(token, DELIMITER_ELEMENT, false);
        String value = null;
        if (tokenizer.hasMoreTokens()) {
            value = tokenizer.nextToken();
            IJavaElement element = JavaRefactoringDescriptorUtil.handleToElement(arguments.getProject(), value);
            if (element == null) {
                element = JavaRefactoringDescriptorUtil.handleToResource(arguments.getProject(), value);
            }
            if (tokenizer.hasMoreTokens()) {
                boolean renamed;
                boolean processed = Boolean.valueOf(tokenizer.nextToken());
                if (processed) {
                    log.markAsProcessed((Object)element);
                    if (element instanceof IJavaElement) {
                        log.markAsProcessed((Object)JavaElementResourceMapping.create(element));
                    }
                }
                if (tokenizer.hasMoreTokens() && (renamed = Boolean.valueOf(tokenizer.nextToken()).booleanValue()) && tokenizer.hasMoreTokens()) {
                    String name = tokenizer.nextToken();
                    log.setNewName((Object)element, name);
                    if (element instanceof IJavaElement) {
                        log.setNewName((Object)JavaElementResourceMapping.create(element), name);
                    }
                }
            }
        }
    }

    public static void storeCreateTargetExecutionLog(String project, Map<String, String> arguments, CreateTargetExecutionLog log) {
        if (log != null) {
            StringBuffer buffer = new StringBuffer(64);
            Object[] selections = log.getSelectedElements();
            int index = 0;
            while (index < selections.length) {
                Object created;
                Object selection = selections[index];
                if (selection != null && (created = log.getCreatedElement(selection)) != null) {
                    ReorgPolicyFactory.storeLogElement(buffer, project, selection);
                    buffer.append(DELIMITER_ELEMENT);
                    ReorgPolicyFactory.storeLogElement(buffer, project, created);
                    buffer.append(DELIMITER_RECORD);
                }
                ++index;
            }
            String value = new String(buffer.toString().trim());
            if (!"".equals(value)) {
                arguments.put(ATTRIBUTE_LOG, value);
            }
        }
    }

    private static boolean storeLogElement(StringBuffer buffer, String project, Object object) {
        if (object instanceof IJavaElement) {
            IJavaElement element = (IJavaElement)object;
            buffer.append(JavaRefactoringDescriptorUtil.elementToHandle(project, element));
            return true;
        }
        if (object instanceof IResource) {
            IResource resource = (IResource)object;
            buffer.append(JavaRefactoringDescriptorUtil.resourceToHandle(project, resource));
            return true;
        }
        return false;
    }

    public static void storeReorgExecutionLog(String project, Map<String, String> arguments, ReorgExecutionLog log) {
        if (log != null) {
            HashSet<Object> set = new HashSet<Object>();
            set.addAll(Arrays.asList(log.getProcessedElements()));
            set.addAll(Arrays.asList(log.getRenamedElements()));
            StringBuffer buffer = new StringBuffer(64);
            for (Object e : set) {
                if (!ReorgPolicyFactory.storeLogElement(buffer, project, e)) continue;
                buffer.append(DELIMITER_ELEMENT);
                buffer.append(log.isProcessed(e));
                buffer.append(DELIMITER_ELEMENT);
                boolean renamed = log.isRenamed(e);
                buffer.append(renamed);
                if (renamed) {
                    buffer.append(DELIMITER_ELEMENT);
                    buffer.append(log.getNewName(e));
                }
                buffer.append(DELIMITER_RECORD);
            }
            String value = new String(buffer.toString().trim());
            if (!"".equals(value)) {
                arguments.put(ATTRIBUTE_LOG, value);
            }
        }
    }

    private ReorgPolicyFactory() {
    }

    private static final class ActualSelectionComputer {
        private final IJavaElement[] fJavaElements;
        private final IResource[] fResources;

        public ActualSelectionComputer(IJavaElement[] javaElements, IResource[] resources) {
            this.fJavaElements = javaElements;
            this.fResources = resources;
        }

        public IJavaElement[] getActualJavaElementsToReorg() throws JavaModelException {
            ArrayList<Object> result = new ArrayList<Object>();
            int i = 0;
            while (i < this.fJavaElements.length) {
                IJavaElement element = this.fJavaElements[i];
                if (element != null) {
                    if (element instanceof IType) {
                        IType type = (IType)element;
                        ICompilationUnit cu = type.getCompilationUnit();
                        if (cu != null && type.getDeclaringType() == null && cu.exists() && cu.getTypes().length == 1 && !result.contains(cu)) {
                            result.add(cu);
                        } else if (!result.contains(type)) {
                            result.add(type);
                        }
                    } else if (!result.contains(element)) {
                        result.add(element);
                    }
                }
                ++i;
            }
            return result.toArray(new IJavaElement[result.size()]);
        }

        public IResource[] getActualResourcesToReorg() {
            HashSet<IJavaElement> javaElementSet = new HashSet<IJavaElement>(Arrays.asList(this.fJavaElements));
            ArrayList<IResource> result = new ArrayList<IResource>();
            int i = 0;
            while (i < this.fResources.length) {
                IJavaElement element;
                if (!(this.fResources[i] == null || (element = JavaCore.create((IResource)this.fResources[i])) != null && element.exists() && javaElementSet.contains(element) || result.contains(this.fResources[i]))) {
                    result.add(this.fResources[i]);
                }
                ++i;
            }
            return result.toArray(new IResource[result.size()]);
        }
    }

    private static final class CopyFilesFoldersAndCusPolicy
    extends FilesFoldersAndCusReorgPolicy
    implements IReorgPolicy.ICopyPolicy {
        private static final String POLICY_COPY_RESOURCE = "org.eclipse.jdt.ui.copyResources";
        private CopyModifications fModifications;
        private ReorgExecutionLog fReorgExecutionLog;

        private static Change copyCuToPackage(ICompilationUnit cu, IPackageFragment dest, NewNameProposer nameProposer, INewNameQueries copyQueries) {
            IResource res = ReorgUtils.getResource((IJavaElement)cu);
            if (res != null && res.isLinked() && ResourceUtil.getResource(dest) instanceof IContainer) {
                return CopyFilesFoldersAndCusPolicy.copyFileToContainer(cu, (IContainer)ResourceUtil.getResource(dest), nameProposer, copyQueries);
            }
            String newName = nameProposer.createNewName(cu, dest);
            CopyCompilationUnitChange simpleCopy = new CopyCompilationUnitChange(cu, dest, copyQueries.createStaticQuery(newName));
            if (newName == null || newName.equals(cu.getElementName())) {
                return simpleCopy;
            }
            try {
                IPath newPath = cu.getResource().getParent().getFullPath().append(JavaModelUtil.getRenamedCUName((ICompilationUnit)cu, (String)newName));
                INewNameQuery nameQuery = copyQueries.createNewCompilationUnitNameQuery(cu, newName);
                return new CreateCopyOfCompilationUnitChange(newPath, cu.getSource(), cu, nameQuery);
            }
            catch (CoreException coreException) {
                return simpleCopy;
            }
        }

        private static Change copyFileToContainer(ICompilationUnit cu, IContainer dest, NewNameProposer nameProposer, INewNameQueries copyQueries) {
            IResource resource = ReorgUtils.getResource((IJavaElement)cu);
            return CopyFilesFoldersAndCusPolicy.createCopyResourceChange(resource, nameProposer, copyQueries, dest);
        }

        private static Change createCopyResourceChange(IResource resource, NewNameProposer nameProposer, INewNameQueries copyQueries, IContainer destination) {
            if (resource == null || destination == null) {
                return new NullChange();
            }
            String name = nameProposer.createNewName(resource, destination);
            INewNameQuery nameQuery = name == null ? copyQueries.createNullQuery() : copyQueries.createNewResourceNameQuery(resource, name);
            return new CopyResourceChange(resource, destination, nameQuery);
        }

        CopyFilesFoldersAndCusPolicy(IFile[] files, IFolder[] folders, ICompilationUnit[] cus) {
            super(files, folders, cus);
        }

        private Change createChange(ICompilationUnit unit, NewNameProposer nameProposer, INewNameQueries copyQueries) {
            IPackageFragment pack = this.getDestinationAsPackageFragment();
            if (pack != null) {
                return CopyFilesFoldersAndCusPolicy.copyCuToPackage(unit, pack, nameProposer, copyQueries);
            }
            IContainer container = this.getDestinationAsContainer();
            return CopyFilesFoldersAndCusPolicy.copyFileToContainer(unit, container, nameProposer, copyQueries);
        }

        @Override
        public Change createChange(IProgressMonitor pm, INewNameQueries copyQueries) {
            IFile[] file = this.getFiles();
            IFolder[] folders = this.getFolders();
            ICompilationUnit[] cus = this.getCus();
            pm.beginTask("", cus.length + file.length + folders.length);
            NewNameProposer nameProposer = new NewNameProposer();
            DynamicValidationStateChange composite = new DynamicValidationStateChange(RefactoringCoreMessages.ReorgPolicy_copy);
            composite.markAsSynthetic();
            int i = 0;
            while (i < cus.length) {
                composite.add(this.createChange(cus[i], nameProposer, copyQueries));
                pm.worked(1);
                ++i;
            }
            if (pm.isCanceled()) {
                throw new OperationCanceledException();
            }
            i = 0;
            while (i < file.length) {
                composite.add(this.createChange((IResource)file[i], nameProposer, copyQueries));
                pm.worked(1);
                ++i;
            }
            if (pm.isCanceled()) {
                throw new OperationCanceledException();
            }
            i = 0;
            while (i < folders.length) {
                composite.add(this.createChange((IResource)folders[i], nameProposer, copyQueries));
                pm.worked(1);
                ++i;
            }
            pm.done();
            return composite;
        }

        private Change createChange(IResource resource, NewNameProposer nameProposer, INewNameQueries copyQueries) {
            IContainer dest = this.getDestinationAsContainer();
            return CopyFilesFoldersAndCusPolicy.createCopyResourceChange(resource, nameProposer, copyQueries, dest);
        }

        @Override
        protected JavaRefactoringDescriptor createRefactoringDescriptor(JDTRefactoringDescriptorComment comment, Map<String, String> arguments, String description, String project, int flags) {
            ReorgExecutionLog log = this.getReorgExecutionLog();
            ReorgPolicyFactory.storeReorgExecutionLog(project, arguments, log);
            return RefactoringSignatureDescriptorFactory.createCopyDescriptor((String)project, (String)description, (String)comment.asString(), arguments, (int)flags);
        }

        @Override
        protected String getDescriptionPlural() {
            int kind = this.getContentKind();
            switch (kind) {
                case 0: {
                    return RefactoringCoreMessages.ReorgPolicyFactory_copy_folders;
                }
                case 1: {
                    return RefactoringCoreMessages.ReorgPolicyFactory_copy_files;
                }
                case 2: {
                    return RefactoringCoreMessages.ReorgPolicyFactory_copy_compilation_units;
                }
            }
            return RefactoringCoreMessages.ReorgPolicyFactory_copy_description_plural;
        }

        @Override
        protected String getDescriptionSingular() {
            int kind = this.getContentKind();
            switch (kind) {
                case 0: {
                    return RefactoringCoreMessages.ReorgPolicyFactory_copy_folder;
                }
                case 1: {
                    return RefactoringCoreMessages.ReorgPolicyFactory_copy_file;
                }
                case 2: {
                    return RefactoringCoreMessages.ReorgPolicyFactory_copy_compilation_unit;
                }
            }
            return RefactoringCoreMessages.ReorgPolicyFactory_copy_description_singular;
        }

        private Object getDestination() {
            IPackageFragment result = this.getDestinationAsPackageFragment();
            if (result != null) {
                return result;
            }
            return this.getDestinationAsContainer();
        }

        @Override
        protected String getHeaderPatternSingular() {
            return RefactoringCoreMessages.ReorgPolicyFactory_copy_header_singular;
        }

        @Override
        protected String getHeaderPatternPlural() {
            return RefactoringCoreMessages.ReorgPolicyFactory_copy_header_plural;
        }

        @Override
        protected RefactoringModifications getModifications() throws CoreException {
            if (this.fModifications != null) {
                return this.fModifications;
            }
            this.fModifications = new CopyModifications();
            this.fReorgExecutionLog = new ReorgExecutionLog();
            CopyArguments jArgs = new CopyArguments(this.getDestination(), this.fReorgExecutionLog);
            CopyArguments rArgs = new CopyArguments((Object)this.getDestinationAsContainer(), this.fReorgExecutionLog);
            ICompilationUnit[] cus = this.getCus();
            int i = 0;
            while (i < cus.length) {
                this.fModifications.copy(cus[i], jArgs, rArgs);
                ++i;
            }
            IResource[] resources = ReorgUtils.union((IResource[])this.getFiles(), (IResource[])this.getFolders());
            int i2 = 0;
            while (i2 < resources.length) {
                this.fModifications.copy(resources[i2], rArgs);
                ++i2;
            }
            return this.fModifications;
        }

        @Override
        public String getPolicyId() {
            return POLICY_COPY_RESOURCE;
        }

        @Override
        protected String getProcessorId() {
            return "org.eclipse.jdt.ui.copy";
        }

        @Override
        protected String getRefactoringId() {
            return "org.eclipse.jdt.ui.copy";
        }

        @Override
        public ReorgExecutionLog getReorgExecutionLog() {
            return this.fReorgExecutionLog;
        }
    }

    private static final class CopyPackageFragmentRootsPolicy
    extends PackageFragmentRootsReorgPolicy
    implements IReorgPolicy.ICopyPolicy {
        private static final String POLICY_COPY_ROOTS = "org.eclipse.jdt.ui.copyRoots";
        private CopyModifications fModifications;
        private ReorgExecutionLog fReorgExecutionLog;

        public CopyPackageFragmentRootsPolicy(IPackageFragmentRoot[] roots) {
            super(roots);
        }

        private Change createChange(IPackageFragmentRoot root, IJavaProject destination, NewNameProposer nameProposer, INewNameQueries copyQueries) {
            IProject destinationProject;
            IResource res = root.getResource();
            String newName = nameProposer.createNewName(res, (IContainer)(destinationProject = destination.getProject()));
            INewNameQuery nameQuery = newName == null ? copyQueries.createNullQuery() : copyQueries.createNewPackageFragmentRootNameQuery(root, newName);
            return new CopyPackageFragmentRootChange(root, destinationProject, nameQuery, null);
        }

        private Change createChange(IPackageFragmentRoot root, IContainer destination, NewNameProposer nameProposer, INewNameQueries copyQueries) {
            IResource res = root.getResource();
            String newName = nameProposer.createNewName(res, destination);
            INewNameQuery nameQuery = newName == null ? copyQueries.createNullQuery() : copyQueries.createNewResourceNameQuery(res, newName);
            return new CopyResourceChange(res, destination, nameQuery);
        }

        @Override
        public Change createChange(IProgressMonitor pm, INewNameQueries copyQueries) {
            NewNameProposer nameProposer = new NewNameProposer();
            IPackageFragmentRoot[] roots = this.getPackageFragmentRoots();
            pm.beginTask("", roots.length);
            DynamicValidationStateChange composite = new DynamicValidationStateChange(RefactoringCoreMessages.ReorgPolicy_copy_source_folder);
            composite.markAsSynthetic();
            IJavaProject destination = this.getDestinationJavaProject();
            int i = 0;
            while (i < roots.length) {
                if (destination == null) {
                    composite.add(this.createChange(roots[i], (IContainer)this.getResourceDestination(), nameProposer, copyQueries));
                } else {
                    composite.add(this.createChange(roots[i], destination, nameProposer, copyQueries));
                }
                pm.worked(1);
                ++i;
            }
            pm.done();
            return composite;
        }

        @Override
        protected JavaRefactoringDescriptor createRefactoringDescriptor(JDTRefactoringDescriptorComment comment, Map<String, String> arguments, String description, String project, int flags) {
            ReorgExecutionLog log = this.getReorgExecutionLog();
            ReorgPolicyFactory.storeReorgExecutionLog(project, arguments, log);
            return RefactoringSignatureDescriptorFactory.createCopyDescriptor((String)project, (String)description, (String)comment.asString(), arguments, (int)flags);
        }

        @Override
        protected String getDescriptionPlural() {
            return RefactoringCoreMessages.ReorgPolicyFactory_copy_roots_plural;
        }

        @Override
        protected String getDescriptionSingular() {
            return RefactoringCoreMessages.ReorgPolicyFactory_copy_roots_singular;
        }

        @Override
        protected String getHeaderPatternSingular() {
            return RefactoringCoreMessages.ReorgPolicyFactory_copy_roots_header_singular;
        }

        @Override
        protected String getHeaderPatternPlural() {
            return RefactoringCoreMessages.ReorgPolicyFactory_copy_roots_header_plural;
        }

        @Override
        protected RefactoringModifications getModifications() throws CoreException {
            if (this.fModifications != null) {
                return this.fModifications;
            }
            this.fModifications = new CopyModifications();
            this.fReorgExecutionLog = new ReorgExecutionLog();
            IJavaProject destination = this.getDestinationJavaProject();
            if (destination == null) {
                IPackageFragmentRoot[] roots = this.getRoots();
                int i = 0;
                while (i < roots.length) {
                    this.fModifications.copy(roots[i].getResource(), new CopyArguments((Object)this.getResourceDestination(), this.fReorgExecutionLog));
                    ++i;
                }
            } else {
                CopyArguments javaArgs = new CopyArguments((Object)destination, this.fReorgExecutionLog);
                CopyArguments resourceArgs = new CopyArguments((Object)destination.getProject(), this.fReorgExecutionLog);
                IPackageFragmentRoot[] roots = this.getRoots();
                int i = 0;
                while (i < roots.length) {
                    this.fModifications.copy(roots[i], javaArgs, resourceArgs);
                    ++i;
                }
            }
            return this.fModifications;
        }

        @Override
        public String getPolicyId() {
            return POLICY_COPY_ROOTS;
        }

        @Override
        protected String getProcessorId() {
            return "org.eclipse.jdt.ui.copy";
        }

        @Override
        protected String getRefactoringId() {
            return "org.eclipse.jdt.ui.copy";
        }

        @Override
        public ReorgExecutionLog getReorgExecutionLog() {
            return this.fReorgExecutionLog;
        }
    }

    private static final class CopyPackagesPolicy
    extends PackagesReorgPolicy
    implements IReorgPolicy.ICopyPolicy {
        private static final String POLICY_COPY_PACKAGES = "org.eclipse.jdt.ui.copyPackages";
        private CopyModifications fModifications;
        private ReorgExecutionLog fReorgExecutionLog;

        public CopyPackagesPolicy(IPackageFragment[] packageFragments) {
            super(packageFragments);
        }

        private Change createChange(IPackageFragment pack, IPackageFragmentRoot destination, NewNameProposer nameProposer, INewNameQueries copyQueries) {
            String newName = nameProposer.createNewName(pack, destination);
            if (newName == null || JavaConventionsUtil.validatePackageName(newName, (IJavaElement)destination).getSeverity() < 4) {
                INewNameQuery nameQuery = newName == null ? copyQueries.createNullQuery() : copyQueries.createNewPackageNameQuery(pack, newName);
                return new CopyPackageChange(pack, destination, nameQuery);
            }
            if (destination.getResource() instanceof IContainer) {
                IContainer dest = (IContainer)destination.getResource();
                IResource res = pack.getResource();
                INewNameQuery nameQuery = copyQueries.createNewResourceNameQuery(res, newName);
                return new CopyResourceChange(res, dest, nameQuery);
            }
            return new NullChange();
        }

        private Change createChange(IPackageFragment pack, IContainer container, NewNameProposer nameProposer, INewNameQueries copyQueries) {
            String newName = nameProposer.createNewName(pack.getResource(), container);
            if (newName == null) {
                return new CopyResourceChange(pack.getResource(), container, copyQueries.createNullQuery());
            }
            IResource res = pack.getResource();
            INewNameQuery nameQuery = copyQueries.createNewResourceNameQuery(res, newName);
            return new CopyResourceChange(res, container, nameQuery);
        }

        @Override
        public Change createChange(IProgressMonitor pm, INewNameQueries newNameQueries) throws JavaModelException {
            NewNameProposer nameProposer = new NewNameProposer();
            IPackageFragment[] fragments = this.getPackages();
            pm.beginTask("", fragments.length);
            DynamicValidationStateChange composite = new DynamicValidationStateChange(RefactoringCoreMessages.ReorgPolicy_copy_package);
            composite.markAsSynthetic();
            IPackageFragmentRoot root = this.getDestinationAsPackageFragmentRoot();
            int i = 0;
            while (i < fragments.length) {
                if (root == null) {
                    composite.add(this.createChange(fragments[i], (IContainer)this.getResourceDestination(), nameProposer, newNameQueries));
                } else {
                    composite.add(this.createChange(fragments[i], root, nameProposer, newNameQueries));
                }
                pm.worked(1);
                ++i;
            }
            pm.done();
            return composite;
        }

        @Override
        protected JavaRefactoringDescriptor createRefactoringDescriptor(JDTRefactoringDescriptorComment comment, Map<String, String> arguments, String description, String project, int flags) {
            ReorgExecutionLog log = this.getReorgExecutionLog();
            ReorgPolicyFactory.storeReorgExecutionLog(project, arguments, log);
            return RefactoringSignatureDescriptorFactory.createCopyDescriptor((String)project, (String)description, (String)comment.asString(), arguments, (int)flags);
        }

        @Override
        protected String getDescriptionPlural() {
            return RefactoringCoreMessages.ReorgPolicyFactory_copy_packages_plural;
        }

        @Override
        protected String getDescriptionSingular() {
            return RefactoringCoreMessages.ReorgPolicyFactory_copy_package_singular;
        }

        @Override
        protected String getHeaderPatternSingular() {
            return RefactoringCoreMessages.ReorgPolicyFactory_copy_packages_header_singular;
        }

        @Override
        protected String getHeaderPatternPlural() {
            return RefactoringCoreMessages.ReorgPolicyFactory_copy_packages_header_plural;
        }

        @Override
        protected RefactoringModifications getModifications() throws CoreException {
            if (this.fModifications != null) {
                return this.fModifications;
            }
            this.fModifications = new CopyModifications();
            this.fReorgExecutionLog = new ReorgExecutionLog();
            IPackageFragmentRoot destination = this.getDestinationAsPackageFragmentRoot();
            if (destination == null) {
                IPackageFragment[] packages = this.getPackages();
                int i = 0;
                while (i < packages.length) {
                    this.fModifications.copy(packages[i].getResource(), new CopyArguments((Object)this.getResourceDestination(), this.fReorgExecutionLog));
                    ++i;
                }
            } else {
                CopyArguments javaArgs = new CopyArguments((Object)destination, this.fReorgExecutionLog);
                CopyArguments resourceArgs = new CopyArguments((Object)destination.getResource(), this.fReorgExecutionLog);
                IPackageFragment[] packages = this.getPackages();
                int i = 0;
                while (i < packages.length) {
                    this.fModifications.copy(packages[i], javaArgs, resourceArgs);
                    ++i;
                }
            }
            return this.fModifications;
        }

        @Override
        public String getPolicyId() {
            return POLICY_COPY_PACKAGES;
        }

        @Override
        protected String getProcessorId() {
            return "org.eclipse.jdt.ui.copy";
        }

        @Override
        protected String getRefactoringId() {
            return "org.eclipse.jdt.ui.copy";
        }

        @Override
        public ReorgExecutionLog getReorgExecutionLog() {
            return this.fReorgExecutionLog;
        }
    }

    private static final class CopySubCuElementsPolicy
    extends SubCuElementReorgPolicy
    implements IReorgPolicy.ICopyPolicy {
        private static final String POLICY_COPY_MEMBERS = "org.eclipse.jdt.ui.copyMembers";
        private CopyModifications fModifications;
        private ReorgExecutionLog fReorgExecutionLog;

        CopySubCuElementsPolicy(IJavaElement[] javaElements) {
            super(javaElements);
        }

        @Override
        public boolean canEnable() throws JavaModelException {
            return super.canEnable() && (this.getSourceCu() != null || this.getSourceClassFile() != null);
        }

        @Override
        public Change createChange(IProgressMonitor pm, INewNameQueries copyQueries) throws JavaModelException {
            try {
                CompilationUnit sourceCuNode = this.createSourceCuNode();
                ICompilationUnit targetCu = CopySubCuElementsPolicy.getEnclosingCompilationUnit(this.getJavaElementDestination());
                CompilationUnitRewrite targetRewriter = new CompilationUnitRewrite(targetCu);
                IJavaElement[] javaElements = this.getJavaElements();
                int i = 0;
                while (i < javaElements.length) {
                    this.copyToDestination(javaElements[i], targetRewriter, sourceCuNode, targetRewriter.getRoot());
                    ++i;
                }
                return CopySubCuElementsPolicy.createCompilationUnitChange(targetRewriter);
            }
            catch (JavaModelException e) {
                throw e;
            }
            catch (CoreException e) {
                throw new JavaModelException(e);
            }
        }

        @Override
        protected JavaRefactoringDescriptor createRefactoringDescriptor(JDTRefactoringDescriptorComment comment, Map<String, String> arguments, String description, String project, int flags) {
            ReorgExecutionLog log = this.getReorgExecutionLog();
            ReorgPolicyFactory.storeReorgExecutionLog(project, arguments, log);
            return RefactoringSignatureDescriptorFactory.createCopyDescriptor((String)project, (String)description, (String)comment.asString(), arguments, (int)flags);
        }

        private CompilationUnit createSourceCuNode() {
            Assert.isTrue((this.getSourceCu() != null || this.getSourceClassFile() != null ? 1 : 0) != 0);
            Assert.isTrue((this.getSourceCu() == null || this.getSourceClassFile() == null ? 1 : 0) != 0);
            ASTParser parser = ASTParser.newParser((int)9);
            parser.setBindingsRecovery(true);
            parser.setResolveBindings(true);
            if (this.getSourceCu() != null) {
                parser.setSource(this.getSourceCu());
            } else {
                parser.setSource(this.getSourceClassFile());
            }
            return (CompilationUnit)parser.createAST(null);
        }

        @Override
        public IFile[] getAllModifiedFiles() {
            return ReorgUtils.getFiles(new IResource[]{ReorgUtils.getResource((IJavaElement)CopySubCuElementsPolicy.getEnclosingCompilationUnit(this.getJavaElementDestination()))});
        }

        @Override
        protected String getDescriptionPlural() {
            if (!ReorgUtils.hasElementsNotOfType(this.getJavaElements(), 7)) {
                return RefactoringCoreMessages.ReorgPolicyFactory_copy_types;
            }
            if (!ReorgUtils.hasElementsNotOfType(this.getJavaElements(), 8)) {
                return RefactoringCoreMessages.ReorgPolicyFactory_copy_fields;
            }
            if (!ReorgUtils.hasElementsNotOfType(this.getJavaElements(), 9)) {
                return RefactoringCoreMessages.ReorgPolicyFactory_copy_methods;
            }
            if (!ReorgUtils.hasElementsNotOfType(this.getJavaElements(), 10)) {
                return RefactoringCoreMessages.ReorgPolicyFactory_copy_initializers;
            }
            if (!ReorgUtils.hasElementsNotOfType(this.getJavaElements(), 11)) {
                return RefactoringCoreMessages.ReorgPolicyFactory_copy_package_declarations;
            }
            if (!ReorgUtils.hasElementsNotOfType(this.getJavaElements(), 12)) {
                return RefactoringCoreMessages.ReorgPolicyFactory_copy_import_containers;
            }
            if (!ReorgUtils.hasElementsNotOfType(this.getJavaElements(), 13)) {
                return RefactoringCoreMessages.ReorgPolicyFactory_copy_imports;
            }
            return RefactoringCoreMessages.ReorgPolicyFactory_copy_elements_plural;
        }

        @Override
        protected String getDescriptionSingular() {
            if (!ReorgUtils.hasElementsNotOfType(this.getJavaElements(), 7)) {
                return RefactoringCoreMessages.ReorgPolicyFactory_copy_type;
            }
            if (!ReorgUtils.hasElementsNotOfType(this.getJavaElements(), 8)) {
                return RefactoringCoreMessages.ReorgPolicyFactory_copy_field;
            }
            if (!ReorgUtils.hasElementsNotOfType(this.getJavaElements(), 9)) {
                return RefactoringCoreMessages.ReorgPolicyFactory_copy_method;
            }
            if (!ReorgUtils.hasElementsNotOfType(this.getJavaElements(), 10)) {
                return RefactoringCoreMessages.ReorgPolicyFactory_copy_initializer;
            }
            if (!ReorgUtils.hasElementsNotOfType(this.getJavaElements(), 11)) {
                return RefactoringCoreMessages.ReorgPolicyFactory_copy_package;
            }
            if (!ReorgUtils.hasElementsNotOfType(this.getJavaElements(), 12)) {
                return RefactoringCoreMessages.ReorgPolicyFactory_copy_import_section;
            }
            if (!ReorgUtils.hasElementsNotOfType(this.getJavaElements(), 13)) {
                return RefactoringCoreMessages.ReorgPolicyFactory_copy_import;
            }
            return RefactoringCoreMessages.ReorgPolicyFactory_copy_elements_singular;
        }

        @Override
        protected String getHeaderPatternSingular() {
            return RefactoringCoreMessages.ReorgPolicyFactory_copy_elements_header_singular;
        }

        @Override
        protected String getHeaderPatternPlural() {
            return RefactoringCoreMessages.ReorgPolicyFactory_copy_elements_header_plural;
        }

        @Override
        protected RefactoringModifications getModifications() throws CoreException {
            if (this.fModifications != null) {
                return this.fModifications;
            }
            this.fModifications = new CopyModifications();
            this.fReorgExecutionLog = new ReorgExecutionLog();
            CopyArguments args = new CopyArguments((Object)this.getJavaElementDestination(), this.fReorgExecutionLog);
            IJavaElement[] javaElements = this.getJavaElements();
            int i = 0;
            while (i < javaElements.length) {
                this.fModifications.copy(javaElements[i], args, null);
                ++i;
            }
            return this.fModifications;
        }

        @Override
        public String getPolicyId() {
            return POLICY_COPY_MEMBERS;
        }

        @Override
        protected String getProcessorId() {
            return "org.eclipse.jdt.ui.copy";
        }

        @Override
        protected String getRefactoringId() {
            return "org.eclipse.jdt.ui.copy";
        }

        @Override
        public ReorgExecutionLog getReorgExecutionLog() {
            return this.fReorgExecutionLog;
        }

        private IClassFile getSourceClassFile() {
            return (IClassFile)this.getJavaElements()[0].getAncestor(6);
        }
    }

    private static abstract class FilesFoldersAndCusReorgPolicy
    extends ReorgPolicy {
        protected static final int ONLY_CUS = 2;
        protected static final int ONLY_FILES = 1;
        protected static final int ONLY_FOLDERS = 0;
        private ICompilationUnit[] fCus;
        private IFile[] fFiles;
        private IFolder[] fFolders;

        private static IContainer getAsContainer(IResource resDest) {
            if (resDest instanceof IContainer) {
                return (IContainer)resDest;
            }
            if (resDest instanceof IFile) {
                return ((IFile)resDest).getParent();
            }
            return null;
        }

        public FilesFoldersAndCusReorgPolicy(IFile[] files, IFolder[] folders, ICompilationUnit[] cus) {
            this.fFiles = files;
            this.fFolders = folders;
            this.fCus = cus;
        }

        @Override
        public boolean canChildrenBeDestinations(IJavaElement javaElement) {
            switch (javaElement.getElementType()) {
                case 1: 
                case 2: {
                    return true;
                }
                case 3: {
                    IPackageFragmentRoot root = (IPackageFragmentRoot)javaElement;
                    return !root.isArchive() && !root.isExternal();
                }
            }
            return false;
        }

        @Override
        public boolean canChildrenBeDestinations(IResource resource) {
            return resource instanceof IContainer;
        }

        @Override
        public boolean canElementBeDestination(IJavaElement javaElement) {
            switch (javaElement.getElementType()) {
                case 4: {
                    return true;
                }
            }
            return false;
        }

        @Override
        public boolean canElementBeDestination(IResource resource) {
            return resource instanceof IProject || resource instanceof IFolder;
        }

        @Override
        public RefactoringStatus checkFinalConditions(IProgressMonitor pm, CheckConditionsContext context, IReorgQueries reorgQueries) throws CoreException {
            this.confirmOverwriting(reorgQueries);
            RefactoringStatus status = super.checkFinalConditions(pm, context, reorgQueries);
            return status;
        }

        private void confirmOverwriting(IReorgQueries reorgQueries) {
            OverwriteHelper helper = new OverwriteHelper();
            helper.setFiles(this.fFiles);
            helper.setFolders(this.fFolders);
            helper.setCus(this.fCus);
            IPackageFragment destPack = this.getDestinationAsPackageFragment();
            if (destPack != null) {
                helper.confirmOverwriting(reorgQueries, destPack);
            } else {
                IContainer destinationAsContainer = this.getDestinationAsContainer();
                if (destinationAsContainer != null) {
                    helper.confirmOverwriting(reorgQueries, destinationAsContainer);
                }
            }
            this.fFiles = helper.getFilesWithoutUnconfirmedOnes();
            this.fFolders = helper.getFoldersWithoutUnconfirmedOnes();
            this.fCus = helper.getCusWithoutUnconfirmedOnes();
        }

        protected boolean containsLinkedResources() {
            return ReorgUtils.containsLinkedResources((IResource[])this.fFiles) || ReorgUtils.containsLinkedResources((IResource[])this.fFolders) || ReorgUtils.containsLinkedResources((IJavaElement[])this.fCus);
        }

        protected abstract JavaRefactoringDescriptor createRefactoringDescriptor(JDTRefactoringDescriptorComment var1, Map<String, String> var2, String var3, String var4, int var5);

        protected final int getContentKind() {
            int length = this.fCus.length + this.fFiles.length + this.fFolders.length;
            if (length == this.fCus.length) {
                return 2;
            }
            if (length == this.fFiles.length) {
                return 1;
            }
            if (length == this.fFolders.length) {
                return 0;
            }
            return -1;
        }

        protected final ICompilationUnit[] getCus() {
            return this.fCus;
        }

        private final String getSingleElementName() {
            switch (this.getContentKind()) {
                case 0: {
                    return this.fFolders[0].getName();
                }
                case 1: {
                    return this.fFiles[0].getName();
                }
                case 2: {
                    return this.fCus[0].getElementName();
                }
            }
            return null;
        }

        @Override
        public final ChangeDescriptor getDescriptor() {
            HashMap<String, String> arguments = new HashMap<String, String>();
            int length = this.fFiles.length + this.fFolders.length + this.fCus.length;
            String description = length == 1 ? this.getDescriptionSingular() : this.getDescriptionPlural();
            IProject resource = this.getSingleProject();
            String project = resource != null ? resource.getName() : null;
            String header = length == 1 ? Messages.format(this.getHeaderPatternSingular(), new String[]{this.getSingleElementName(), this.getDestinationLabel()}) : Messages.format(this.getHeaderPatternPlural(), new String[]{String.valueOf(length), this.getDestinationLabel()});
            int flags = 589830;
            JDTRefactoringDescriptorComment comment = new JDTRefactoringDescriptorComment(project, this, header);
            arguments.put(ReorgPolicyFactory.ATTRIBUTE_POLICY, this.getPolicyId());
            arguments.put(ReorgPolicyFactory.ATTRIBUTE_FILES, new Integer(this.fFiles.length).toString());
            int offset = 0;
            while (offset < this.fFiles.length) {
                arguments.put("element" + (offset + 1), JavaRefactoringDescriptorUtil.resourceToHandle(project, (IResource)this.fFiles[offset]));
                ++offset;
            }
            arguments.put(ReorgPolicyFactory.ATTRIBUTE_FOLDERS, new Integer(this.fFolders.length).toString());
            offset = 0;
            while (offset < this.fFolders.length) {
                arguments.put("element" + (offset + this.fFiles.length + 1), JavaRefactoringDescriptorUtil.resourceToHandle(project, (IResource)this.fFolders[offset]));
                ++offset;
            }
            arguments.put(ReorgPolicyFactory.ATTRIBUTE_UNITS, new Integer(this.fCus.length).toString());
            offset = 0;
            while (offset < this.fCus.length) {
                arguments.put("element" + (offset + this.fFolders.length + this.fFiles.length + 1), JavaRefactoringDescriptorUtil.elementToHandle(project, (IJavaElement)this.fCus[offset]));
                ++offset;
            }
            arguments.putAll(this.getRefactoringArguments(project));
            JavaRefactoringDescriptor descriptor = this.createRefactoringDescriptor(comment, arguments, description, project, flags);
            return new RefactoringChangeDescriptor((RefactoringDescriptor)descriptor);
        }

        protected final IContainer getDestinationAsContainer() {
            IResource resDest = this.getResourceDestination();
            if (resDest != null) {
                return FilesFoldersAndCusReorgPolicy.getAsContainer(resDest);
            }
            IJavaElement jelDest = this.getJavaElementDestination();
            Assert.isNotNull((Object)jelDest);
            return FilesFoldersAndCusReorgPolicy.getAsContainer(ReorgUtils.getResource(jelDest));
        }

        protected IPackageFragment getDestinationAsPackageFragment() {
            IPackageFragment javaAsPackage = this.getJavaDestinationAsPackageFragment(this.getJavaElementDestination());
            if (javaAsPackage != null) {
                return javaAsPackage;
            }
            return this.getResourceDestinationAsPackageFragment(this.getResourceDestination());
        }

        protected final IJavaElement getDestinationContainerAsJavaElement() {
            if (this.getJavaElementDestination() != null) {
                return this.getJavaElementDestination();
            }
            IContainer destinationAsContainer = this.getDestinationAsContainer();
            if (destinationAsContainer == null) {
                return null;
            }
            IJavaElement je = JavaCore.create((IResource)destinationAsContainer);
            if (je != null && je.exists()) {
                return je;
            }
            return null;
        }

        protected final IFile[] getFiles() {
            return this.fFiles;
        }

        protected final IFolder[] getFolders() {
            return this.fFolders;
        }

        private IPackageFragment getJavaDestinationAsPackageFragment(IJavaElement javaDest) {
            if (javaDest == null || this.fCheckDestination && !javaDest.exists()) {
                return null;
            }
            if (javaDest instanceof IPackageFragment) {
                return (IPackageFragment)javaDest;
            }
            if (javaDest instanceof IPackageFragmentRoot) {
                return ((IPackageFragmentRoot)javaDest).getPackageFragment("");
            }
            if (javaDest instanceof IJavaProject) {
                try {
                    IPackageFragmentRoot root = ReorgUtils.getCorrespondingPackageFragmentRoot((IJavaProject)javaDest);
                    if (root != null) {
                        return root.getPackageFragment("");
                    }
                }
                catch (JavaModelException javaModelException) {}
            }
            return (IPackageFragment)javaDest.getAncestor(4);
        }

        @Override
        public final IJavaElement[] getJavaElements() {
            return this.fCus;
        }

        private IPackageFragment getResourceDestinationAsPackageFragment(IResource resource) {
            if (resource instanceof IFile) {
                return this.getJavaDestinationAsPackageFragment(JavaCore.create((IResource)resource.getParent()));
            }
            return null;
        }

        @Override
        public final IResource[] getResources() {
            return ReorgUtils.union((IResource[])this.fFiles, (IResource[])this.fFolders);
        }

        private IProject getSingleProject() {
            IProject result = null;
            int index = 0;
            while (index < this.fFiles.length) {
                if (result == null) {
                    result = this.fFiles[index].getProject();
                } else if (!result.equals((Object)this.fFiles[index].getProject())) {
                    return null;
                }
                ++index;
            }
            index = 0;
            while (index < this.fFolders.length) {
                if (result == null) {
                    result = this.fFolders[index].getProject();
                } else if (!result.equals((Object)this.fFolders[index].getProject())) {
                    return null;
                }
                ++index;
            }
            index = 0;
            while (index < this.fCus.length) {
                if (result == null) {
                    result = this.fCus[index].getJavaProject().getProject();
                } else if (!result.equals((Object)this.fCus[index].getJavaProject().getProject())) {
                    return null;
                }
                ++index;
            }
            return result;
        }

        @Override
        public RefactoringStatus initialize(JavaRefactoringArguments arguments) {
            IResource resource;
            String attribute;
            RefactoringStatus status = new RefactoringStatus();
            int fileCount = 0;
            int folderCount = 0;
            int unitCount = 0;
            String value = arguments.getAttribute(ReorgPolicyFactory.ATTRIBUTE_FILES);
            if (value != null && !"".equals(value)) {
                try {
                    fileCount = Integer.parseInt(value);
                }
                catch (NumberFormatException numberFormatException) {
                    return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, ReorgPolicyFactory.ATTRIBUTE_FILES));
                }
            } else {
                return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, ReorgPolicyFactory.ATTRIBUTE_FILES));
            }
            value = arguments.getAttribute(ReorgPolicyFactory.ATTRIBUTE_FOLDERS);
            if (value != null && !"".equals(value)) {
                try {
                    folderCount = Integer.parseInt(value);
                }
                catch (NumberFormatException numberFormatException) {
                    return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, ReorgPolicyFactory.ATTRIBUTE_FOLDERS));
                }
            } else {
                return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, ReorgPolicyFactory.ATTRIBUTE_FOLDERS));
            }
            value = arguments.getAttribute(ReorgPolicyFactory.ATTRIBUTE_UNITS);
            if (value != null && !"".equals(value)) {
                try {
                    unitCount = Integer.parseInt(value);
                }
                catch (NumberFormatException numberFormatException) {
                    return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, ReorgPolicyFactory.ATTRIBUTE_UNITS));
                }
            } else {
                return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, ReorgPolicyFactory.ATTRIBUTE_UNITS));
            }
            String handle = null;
            ArrayList<Object> elements = new ArrayList<Object>();
            int index = 0;
            while (index < fileCount) {
                attribute = "element" + (index + 1);
                handle = arguments.getAttribute(attribute);
                if (handle != null && !"".equals(handle)) {
                    resource = JavaRefactoringDescriptorUtil.handleToResource(arguments.getProject(), handle);
                    if (resource == null || !resource.exists()) {
                        status.merge(JavaRefactoringDescriptorUtil.createInputWarningStatus(resource, this.getProcessorId(), this.getRefactoringId()));
                    } else {
                        elements.add(resource);
                    }
                } else {
                    return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, attribute));
                }
                ++index;
            }
            this.fFiles = elements.toArray(new IFile[elements.size()]);
            elements = new ArrayList();
            index = 0;
            while (index < folderCount) {
                attribute = "element" + (fileCount + index + 1);
                handle = arguments.getAttribute(attribute);
                if (handle != null && !"".equals(handle)) {
                    resource = JavaRefactoringDescriptorUtil.handleToResource(arguments.getProject(), handle);
                    if (resource == null || !resource.exists()) {
                        status.merge(JavaRefactoringDescriptorUtil.createInputWarningStatus(resource, this.getProcessorId(), this.getRefactoringId()));
                    } else {
                        elements.add(resource);
                    }
                } else {
                    return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, attribute));
                }
                ++index;
            }
            this.fFolders = elements.toArray(new IFolder[elements.size()]);
            elements = new ArrayList();
            index = 0;
            while (index < unitCount) {
                attribute = "element" + (folderCount + fileCount + index + 1);
                handle = arguments.getAttribute(attribute);
                if (handle != null && !"".equals(handle)) {
                    IJavaElement element = JavaRefactoringDescriptorUtil.handleToElement(arguments.getProject(), handle, false);
                    if (element == null || !element.exists() || element.getElementType() != 5) {
                        status.merge(JavaRefactoringDescriptorUtil.createInputWarningStatus(element, this.getProcessorId(), this.getRefactoringId()));
                    } else {
                        elements.add(element);
                    }
                } else {
                    return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, attribute));
                }
                ++index;
            }
            this.fCus = elements.toArray(new ICompilationUnit[elements.size()]);
            status.merge(super.initialize(arguments));
            return status;
        }

        private boolean isChildOfOrEqualToAnyFolder(IResource resource) {
            int i = 0;
            while (i < this.fFolders.length) {
                IFolder folder = this.fFolders[i];
                if (folder.equals((Object)resource) || ParentChecker.isDescendantOf(resource, (IResource)folder)) {
                    return true;
                }
                ++i;
            }
            return false;
        }

        @Override
        protected RefactoringStatus verifyDestination(IJavaElement javaElement) throws JavaModelException {
            IOpenable openable;
            Assert.isNotNull((Object)javaElement);
            if (!this.fCheckDestination) {
                return new RefactoringStatus();
            }
            if (!javaElement.exists()) {
                return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ReorgPolicyFactory_doesnotexist0);
            }
            if (javaElement instanceof IJavaModel) {
                return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ReorgPolicyFactory_jmodel);
            }
            if (javaElement.isReadOnly()) {
                return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ReorgPolicyFactory_readonly);
            }
            if (!javaElement.isStructureKnown()) {
                return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ReorgPolicyFactory_structure);
            }
            if (javaElement instanceof IOpenable && !(openable = (IOpenable)javaElement).isConsistent()) {
                return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ReorgPolicyFactory_inconsistent);
            }
            if (javaElement instanceof IPackageFragmentRoot) {
                IPackageFragmentRoot root = (IPackageFragmentRoot)javaElement;
                if (root.isArchive()) {
                    return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ReorgPolicyFactory_archive);
                }
                if (root.isExternal()) {
                    return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ReorgPolicyFactory_external);
                }
            }
            if (ReorgUtils.isInsideCompilationUnit(javaElement)) {
                return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ReorgPolicyFactory_cannot);
            }
            IContainer destinationAsContainer = this.getDestinationAsContainer();
            if (destinationAsContainer == null || this.isChildOfOrEqualToAnyFolder((IResource)destinationAsContainer)) {
                return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ReorgPolicyFactory_not_this_resource);
            }
            if (this.containsLinkedResources() && !ReorgUtils.canBeDestinationForLinkedResources(javaElement)) {
                return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ReorgPolicyFactory_linked);
            }
            return new RefactoringStatus();
        }

        @Override
        protected RefactoringStatus verifyDestination(IResource resource) throws JavaModelException {
            Assert.isNotNull((Object)resource);
            if (!resource.exists() || resource.isPhantom()) {
                return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ReorgPolicyFactory_phantom);
            }
            if (!resource.isAccessible()) {
                return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ReorgPolicyFactory_inaccessible);
            }
            if (resource.getType() == 8) {
                return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ReorgPolicyFactory_not_this_resource);
            }
            if (this.isChildOfOrEqualToAnyFolder(resource)) {
                return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ReorgPolicyFactory_not_this_resource);
            }
            if (this.containsLinkedResources() && !ReorgUtils.canBeDestinationForLinkedResources(resource)) {
                return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ReorgPolicyFactory_linked);
            }
            return new RefactoringStatus();
        }
    }

    private static final class MoveFilesFoldersAndCusPolicy
    extends FilesFoldersAndCusReorgPolicy
    implements IReorgPolicy.IMovePolicy {
        private static final String POLICY_MOVE_RESOURCES = "org.eclipse.jdt.ui.moveResources";
        private TextChangeManager fChangeManager;
        private CreateTargetExecutionLog fCreateTargetExecutionLog = new CreateTargetExecutionLog();
        private String fFilePatterns;
        private MoveModifications fModifications;
        private QualifiedNameSearchResult fQualifiedNameSearchResult = new QualifiedNameSearchResult();
        private boolean fUpdateQualifiedNames = false;
        private boolean fUpdateReferences = true;

        private static Change moveCuToPackage(ICompilationUnit cu, IPackageFragment dest) {
            IResource resource = cu.getResource();
            if (resource != null && resource.isLinked() && ResourceUtil.getResource(dest) instanceof IContainer) {
                return MoveFilesFoldersAndCusPolicy.moveFileToContainer(cu, (IContainer)ResourceUtil.getResource(dest));
            }
            return new MoveCompilationUnitChange(cu, dest);
        }

        private static Change moveFileToContainer(ICompilationUnit cu, IContainer dest) {
            return new MoveResourceChange(cu.getResource(), dest);
        }

        MoveFilesFoldersAndCusPolicy(IFile[] files, IFolder[] folders, ICompilationUnit[] cus) {
            super(files, folders, cus);
        }

        @Override
        public boolean canEnableQualifiedNameUpdating() {
            return this.getCus().length > 0 && !JavaElementUtil.isDefaultPackage(this.getCommonParent());
        }

        @Override
        public boolean canUpdateJavaReferences() {
            return true;
        }

        @Override
        public boolean canUpdateQualifiedNames() {
            if (!this.canEnableQualifiedNameUpdating()) {
                return false;
            }
            IPackageFragment pack = this.getDestinationAsPackageFragment();
            if (pack == null) {
                return false;
            }
            if (pack.isDefaultPackage()) {
                return false;
            }
            IJavaElement destination = this.getJavaElementDestination();
            return !(destination instanceof IPackageFragmentRoot) || this.getCus().length <= 0;
        }

        private boolean cannotUpdateReferencesForDestination() {
            if (this.getCus().length == 0) {
                return false;
            }
            IPackageFragment pack = this.getDestinationAsPackageFragment();
            if (pack == null || pack.isDefaultPackage()) {
                return true;
            }
            IJavaElement destination = this.getJavaElementDestination();
            if (destination instanceof IPackageFragmentRoot && this.getCus().length > 0) {
                return false;
            }
            Object commonParent = this.getCommonParent();
            return JavaElementUtil.isDefaultPackage(commonParent);
        }

        @Override
        public RefactoringStatus checkFinalConditions(IProgressMonitor pm, CheckConditionsContext context, IReorgQueries reorgQueries) throws CoreException {
            try {
                pm.beginTask("", this.fUpdateQualifiedNames ? 7 : 3);
                RefactoringStatus result = new RefactoringStatus();
                this.confirmMovingReadOnly(reorgQueries);
                this.fChangeManager = this.createChangeManager((IProgressMonitor)new SubProgressMonitor(pm, 2), result);
                if (this.fUpdateQualifiedNames) {
                    this.computeQualifiedNameMatches((IProgressMonitor)new SubProgressMonitor(pm, 4));
                }
                result.merge(super.checkFinalConditions((IProgressMonitor)new SubProgressMonitor(pm, 1), context, reorgQueries));
                RefactoringStatus refactoringStatus = result;
                return refactoringStatus;
            }
            catch (JavaModelException e) {
                throw e;
            }
            catch (CoreException e) {
                throw new JavaModelException(e);
            }
            finally {
                pm.done();
            }
        }

        @Override
        protected IPackageFragment getDestinationAsPackageFragment() {
            IJavaElement destination = this.getJavaElementDestination();
            if (destination instanceof IPackageFragmentRoot && this.getCus().length > 0) {
                String packageName = ((IPackageFragment)this.getCus()[0].getParent()).getElementName();
                return ((IPackageFragmentRoot)destination).getPackageFragment(packageName);
            }
            return super.getDestinationAsPackageFragment();
        }

        private void computeQualifiedNameMatches(IProgressMonitor pm) throws JavaModelException {
            if (!this.fUpdateQualifiedNames) {
                return;
            }
            IPackageFragment destination = this.getDestinationAsPackageFragment();
            if (destination != null) {
                ICompilationUnit[] cus = this.getCus();
                pm.beginTask("", cus.length);
                pm.subTask(RefactoringCoreMessages.MoveRefactoring_scanning_qualified_names);
                int i = 0;
                while (i < cus.length) {
                    ICompilationUnit cu = cus[i];
                    IType[] types = cu.getTypes();
                    SubProgressMonitor typesMonitor = new SubProgressMonitor(pm, 1);
                    typesMonitor.beginTask("", types.length);
                    int j = 0;
                    while (j < types.length) {
                        this.handleType(types[j], destination, (IProgressMonitor)new SubProgressMonitor((IProgressMonitor)typesMonitor, 1));
                        if (typesMonitor.isCanceled()) {
                            throw new OperationCanceledException();
                        }
                        ++j;
                    }
                    typesMonitor.done();
                    ++i;
                }
            }
            pm.done();
        }

        private void confirmMovingReadOnly(IReorgQueries reorgQueries) throws CoreException {
            if (!ReadOnlyResourceFinder.confirmMoveOfReadOnlyElements(this.getJavaElements(), this.getResources(), reorgQueries)) {
                throw new OperationCanceledException();
            }
        }

        private Change createChange(ICompilationUnit cu) {
            IPackageFragment pack = this.getDestinationAsPackageFragment();
            if (pack != null) {
                return MoveFilesFoldersAndCusPolicy.moveCuToPackage(cu, pack);
            }
            IContainer container = this.getDestinationAsContainer();
            if (container == null) {
                return new NullChange();
            }
            return MoveFilesFoldersAndCusPolicy.moveFileToContainer(cu, container);
        }

        @Override
        public Change createChange(IProgressMonitor pm) throws JavaModelException {
            if (!this.fUpdateReferences) {
                return this.createSimpleMoveChange(pm);
            }
            return this.createReferenceUpdatingMoveChange(pm);
        }

        private Change createChange(IResource res) {
            IContainer destinationAsContainer = this.getDestinationAsContainer();
            if (destinationAsContainer == null) {
                return new NullChange();
            }
            return new MoveResourceChange(res, destinationAsContainer);
        }

        private TextChangeManager createChangeManager(IProgressMonitor pm, RefactoringStatus status) throws JavaModelException {
            pm.beginTask("", 1);
            try {
                if (!this.fUpdateReferences) {
                    TextChangeManager textChangeManager = new TextChangeManager();
                    return textChangeManager;
                }
                IPackageFragment packageDest = this.getDestinationAsPackageFragment();
                if (packageDest != null) {
                    MoveCuUpdateCreator creator = new MoveCuUpdateCreator(this.getCus(), packageDest);
                    TextChangeManager textChangeManager = creator.createChangeManager((IProgressMonitor)new SubProgressMonitor(pm, 1), status);
                    return textChangeManager;
                }
                TextChangeManager textChangeManager = new TextChangeManager();
                return textChangeManager;
            }
            finally {
                pm.done();
            }
        }

        @Override
        protected JavaRefactoringDescriptor createRefactoringDescriptor(JDTRefactoringDescriptorComment comment, Map<String, String> arguments, String description, String project, int flags) {
            CreateTargetExecutionLog log = this.getCreateTargetExecutionLog();
            ReorgPolicyFactory.storeCreateTargetExecutionLog(project, arguments, log);
            return RefactoringSignatureDescriptorFactory.createMoveDescriptor((String)project, (String)description, (String)comment.asString(), arguments, (int)flags);
        }

        private Change createReferenceUpdatingMoveChange(IProgressMonitor pm) throws JavaModelException {
            pm.beginTask("", 2 + (this.fUpdateQualifiedNames ? 1 : 0));
            try {
                DynamicValidationStateChange composite = new DynamicValidationStateChange(RefactoringCoreMessages.ReorgPolicy_move);
                composite.markAsSynthetic();
                if (this.fChangeManager == null) {
                    this.fChangeManager = this.createChangeManager((IProgressMonitor)new SubProgressMonitor(pm, 1), new RefactoringStatus());
                    RefactoringStatus status = Checks.validateModifiesFiles(this.getAllModifiedFiles(), null);
                    if (status.hasFatalError()) {
                        this.fChangeManager = new TextChangeManager();
                    }
                }
                composite.merge(new CompositeChange(RefactoringCoreMessages.MoveRefactoring_reorganize_elements, (Change[])this.fChangeManager.getAllChanges()));
                Change fileMove = this.createSimpleMoveChange((IProgressMonitor)new SubProgressMonitor(pm, 1));
                if (fileMove instanceof CompositeChange) {
                    composite.merge((CompositeChange)fileMove);
                } else {
                    composite.add(fileMove);
                }
                DynamicValidationStateChange dynamicValidationStateChange = composite;
                return dynamicValidationStateChange;
            }
            finally {
                pm.done();
            }
        }

        private Change createSimpleMoveChange(IProgressMonitor pm) {
            DynamicValidationStateChange result = new DynamicValidationStateChange(RefactoringCoreMessages.ReorgPolicy_move);
            result.markAsSynthetic();
            IFile[] files = this.getFiles();
            IFolder[] folders = this.getFolders();
            ICompilationUnit[] cus = this.getCus();
            pm.beginTask("", files.length + folders.length + cus.length);
            int i = 0;
            while (i < files.length) {
                result.add(this.createChange((IResource)files[i]));
                pm.worked(1);
                ++i;
            }
            if (pm.isCanceled()) {
                throw new OperationCanceledException();
            }
            i = 0;
            while (i < folders.length) {
                result.add(this.createChange((IResource)folders[i]));
                pm.worked(1);
                ++i;
            }
            if (pm.isCanceled()) {
                throw new OperationCanceledException();
            }
            i = 0;
            while (i < cus.length) {
                result.add(this.createChange(cus[i]));
                pm.worked(1);
                ++i;
            }
            pm.done();
            return result;
        }

        @Override
        public IFile[] getAllModifiedFiles() {
            HashSet<IFile> result = new HashSet<IFile>();
            result.addAll(Arrays.asList(ResourceUtil.getFiles(this.fChangeManager.getAllCompilationUnits())));
            result.addAll(Arrays.asList(this.fQualifiedNameSearchResult.getAllFiles()));
            if (!(this.getJavaElementDestination() instanceof IPackageFragmentRoot) && this.getDestinationAsPackageFragment() != null && this.getUpdateReferences()) {
                result.addAll(Arrays.asList(ResourceUtil.getFiles(this.getCus())));
            }
            return result.toArray(new IFile[result.size()]);
        }

        private Object getCommonParent() {
            return new ParentChecker(this.getResources(), this.getJavaElements()).getCommonParent();
        }

        @Override
        public CreateTargetExecutionLog getCreateTargetExecutionLog() {
            return this.fCreateTargetExecutionLog;
        }

        @Override
        public ICreateTargetQuery getCreateTargetQuery(ICreateTargetQueries createQueries) {
            return createQueries.createNewPackageQuery();
        }

        @Override
        protected String getDescriptionPlural() {
            int kind = this.getContentKind();
            switch (kind) {
                case 0: {
                    return RefactoringCoreMessages.ReorgPolicyFactory_move_folders;
                }
                case 1: {
                    return RefactoringCoreMessages.ReorgPolicyFactory_move_files;
                }
                case 2: {
                    return RefactoringCoreMessages.ReorgPolicyFactory_move_compilation_units;
                }
            }
            return RefactoringCoreMessages.ReorgPolicyFactory_move_description_plural;
        }

        @Override
        protected String getDescriptionSingular() {
            int kind = this.getContentKind();
            switch (kind) {
                case 0: {
                    return RefactoringCoreMessages.ReorgPolicyFactory_move_folder;
                }
                case 1: {
                    return RefactoringCoreMessages.ReorgPolicyFactory_move_file;
                }
                case 2: {
                    return RefactoringCoreMessages.ReorgPolicyFactory_move_compilation_unit;
                }
            }
            return RefactoringCoreMessages.ReorgPolicyFactory_move_description_singular;
        }

        @Override
        public String getFilePatterns() {
            return this.fFilePatterns;
        }

        @Override
        protected String getHeaderPatternSingular() {
            return RefactoringCoreMessages.ReorgPolicyFactory_move_header_singular;
        }

        @Override
        protected String getHeaderPatternPlural() {
            return RefactoringCoreMessages.ReorgPolicyFactory_move_header_plural;
        }

        @Override
        protected RefactoringModifications getModifications() throws CoreException {
            int i;
            if (this.fModifications != null) {
                return this.fModifications;
            }
            this.fModifications = new MoveModifications();
            IPackageFragment pack = this.getDestinationAsPackageFragment();
            IContainer container = this.getDestinationAsContainer();
            Object unitDestination = null;
            unitDestination = pack != null ? pack : container;
            boolean updateReferenes = this.getUpdateReferences();
            if (unitDestination != null) {
                ICompilationUnit[] units = this.getCus();
                i = 0;
                while (i < units.length) {
                    this.fModifications.move(units[i], new MoveArguments(unitDestination, updateReferenes));
                    ++i;
                }
            }
            if (container != null) {
                IFile[] files = this.getFiles();
                i = 0;
                while (i < files.length) {
                    this.fModifications.move((IResource)files[i], new MoveArguments((Object)container, updateReferenes));
                    ++i;
                }
                IFolder[] folders = this.getFolders();
                int i2 = 0;
                while (i2 < folders.length) {
                    this.fModifications.move((IResource)folders[i2], new MoveArguments((Object)container, updateReferenes));
                    ++i2;
                }
            }
            return this.fModifications;
        }

        @Override
        public String getPolicyId() {
            return POLICY_MOVE_RESOURCES;
        }

        @Override
        protected String getProcessorId() {
            return "org.eclipse.jdt.ui.move";
        }

        @Override
        protected Map<String, String> getRefactoringArguments(String project) {
            HashMap<String, String> arguments = new HashMap<String, String>();
            arguments.putAll(super.getRefactoringArguments(project));
            if (this.fFilePatterns != null && !"".equals(this.fFilePatterns)) {
                arguments.put(ReorgPolicyFactory.ATTRIBUTE_PATTERNS, this.fFilePatterns);
            }
            arguments.put("references", Boolean.valueOf(this.fUpdateReferences).toString());
            arguments.put(ReorgPolicyFactory.ATTRIBUTE_QUALIFIED, Boolean.valueOf(this.fUpdateQualifiedNames).toString());
            return arguments;
        }

        @Override
        protected String getRefactoringId() {
            return "org.eclipse.jdt.ui.move";
        }

        @Override
        public boolean getUpdateQualifiedNames() {
            return this.fUpdateQualifiedNames;
        }

        @Override
        public boolean getUpdateReferences() {
            return this.fUpdateReferences;
        }

        private void handleType(IType type, IPackageFragment destination, IProgressMonitor pm) {
            QualifiedNameFinder.process(this.fQualifiedNameSearchResult, type.getFullyQualifiedName(), String.valueOf(destination.getElementName()) + "." + type.getTypeQualifiedName(), this.fFilePatterns, type.getJavaProject().getProject(), pm);
        }

        @Override
        public boolean hasAllInputSet() {
            if (this.getResourceDestination() == null && this.getJavaElementDestination() == null) {
                return false;
            }
            return !this.canUpdateQualifiedNames();
        }

        @Override
        public RefactoringStatus initialize(JavaRefactoringArguments arguments) {
            String patterns = arguments.getAttribute(ReorgPolicyFactory.ATTRIBUTE_PATTERNS);
            this.fFilePatterns = patterns != null && !"".equals(patterns) ? patterns : "";
            String references = arguments.getAttribute("references");
            if (references == null) {
                return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, "references"));
            }
            this.fUpdateReferences = Boolean.valueOf(references);
            String qualified = arguments.getAttribute(ReorgPolicyFactory.ATTRIBUTE_QUALIFIED);
            if (qualified == null) {
                return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, ReorgPolicyFactory.ATTRIBUTE_QUALIFIED));
            }
            this.fUpdateQualifiedNames = Boolean.valueOf(qualified);
            return super.initialize(arguments);
        }

        @Override
        public boolean isTextualMove() {
            return false;
        }

        @Override
        public Change postCreateChange(Change[] participantChanges, IProgressMonitor pm) throws CoreException {
            if (this.fQualifiedNameSearchResult != null) {
                return this.fQualifiedNameSearchResult.getSingleChange(Changes.getModifiedFiles(participantChanges));
            }
            return null;
        }

        @Override
        public void setDestinationCheck(boolean check) {
            this.fCheckDestination = check;
        }

        @Override
        public void setFilePatterns(String patterns) {
            Assert.isNotNull((Object)patterns);
            this.fFilePatterns = patterns;
        }

        @Override
        public void setUpdateQualifiedNames(boolean update) {
            this.fUpdateQualifiedNames = update;
        }

        @Override
        public void setUpdateReferences(boolean update) {
            this.fUpdateReferences = update;
        }

        @Override
        protected RefactoringStatus verifyDestination(IJavaElement destination) throws JavaModelException {
            RefactoringStatus superStatus = super.verifyDestination(destination);
            if (superStatus.hasFatalError()) {
                return superStatus;
            }
            Object commonParent = new ParentChecker(this.getResources(), this.getJavaElements()).getCommonParent();
            if (destination.equals(commonParent)) {
                return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ReorgPolicyFactory_parent);
            }
            IContainer destinationAsContainer = this.getDestinationAsContainer();
            if (destinationAsContainer != null && (destinationAsContainer.equals(commonParent) || commonParent instanceof IPackageFragmentRoot && destinationAsContainer.equals((Object)((IPackageFragmentRoot)commonParent).getResource()))) {
                return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ReorgPolicyFactory_parent);
            }
            IPackageFragment destinationAsPackage = this.getDestinationAsPackageFragment();
            if (destinationAsPackage != null && destinationAsPackage.equals(commonParent)) {
                return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ReorgPolicyFactory_parent);
            }
            if (this.cannotUpdateReferencesForDestination()) {
                superStatus.addInfo(RefactoringCoreMessages.ReorgPolicyFactory_noJavaUpdates);
            }
            return superStatus;
        }

        @Override
        protected RefactoringStatus verifyDestination(IResource destination) throws JavaModelException {
            RefactoringStatus superStatus = super.verifyDestination(destination);
            if (superStatus.hasFatalError()) {
                return superStatus;
            }
            Object commonParent = this.getCommonParent();
            if (destination.equals(commonParent)) {
                return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ReorgPolicyFactory_parent);
            }
            IContainer destinationAsContainer = this.getDestinationAsContainer();
            if (destinationAsContainer != null && destinationAsContainer.equals(commonParent)) {
                return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ReorgPolicyFactory_parent);
            }
            IJavaElement destinationContainerAsPackage = this.getDestinationContainerAsJavaElement();
            if (destinationContainerAsPackage != null && destinationContainerAsPackage.equals(commonParent)) {
                return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ReorgPolicyFactory_parent);
            }
            if (this.cannotUpdateReferencesForDestination()) {
                superStatus.addInfo(RefactoringCoreMessages.ReorgPolicyFactory_noJavaUpdates);
            }
            return superStatus;
        }
    }

    private static final class MoveImportDeclarationsPolicy
    extends MoveSubCuElementsPolicy {
        private static final String POLICY_MOVE_IMPORT_DECLARATIONS = "org.eclipse.jdt.ui.moveImportDeclarations";

        MoveImportDeclarationsPolicy(IImportDeclaration[] importDeclarations) {
            super((IJavaElement[])importDeclarations);
        }

        @Override
        public String getPolicyId() {
            return POLICY_MOVE_IMPORT_DECLARATIONS;
        }
    }

    private static final class MoveMembersPolicy
    extends MoveSubCuElementsPolicy {
        private static final String POLICY_MOVE_MEMBERS = "org.eclipse.jdt.ui.moveMembers";

        MoveMembersPolicy(IMember[] members) {
            super((IJavaElement[])members);
        }

        @Override
        public String getPolicyId() {
            return POLICY_MOVE_MEMBERS;
        }
    }

    private static final class MovePackageFragmentRootsPolicy
    extends PackageFragmentRootsReorgPolicy
    implements IReorgPolicy.IMovePolicy {
        private static final String POLICY_MOVE_ROOTS = "org.eclipse.jdt.ui.moveRoots";
        private CreateTargetExecutionLog fCreateTargetExecutionLog = new CreateTargetExecutionLog();
        private MoveModifications fModifications;
        private boolean fUpdateReferences = true;

        private static boolean isParentOfAny(IJavaProject javaProject, IPackageFragmentRoot[] roots) {
            int i = 0;
            while (i < roots.length) {
                if (ReorgUtils.isParentInWorkspaceOrOnDisk(roots[i], javaProject)) {
                    return true;
                }
                ++i;
            }
            return false;
        }

        MovePackageFragmentRootsPolicy(IPackageFragmentRoot[] roots) {
            super(roots);
        }

        @Override
        public boolean canEnable() throws JavaModelException {
            if (!super.canEnable()) {
                return false;
            }
            IPackageFragmentRoot[] roots = this.getPackageFragmentRoots();
            int i = 0;
            while (i < roots.length) {
                ResourceAttributes attributes;
                IPackageFragmentRoot root = roots[i];
                if (root.isReadOnly() && !root.isArchive() && !root.isExternal() && ((attributes = roots[i].getResource().getResourceAttributes()) == null || attributes.isReadOnly())) {
                    return false;
                }
                ++i;
            }
            return roots.length > 0;
        }

        @Override
        public RefactoringStatus checkFinalConditions(IProgressMonitor pm, CheckConditionsContext context, IReorgQueries reorgQueries) throws CoreException {
            try {
                RefactoringStatus status = super.checkFinalConditions(pm, context, reorgQueries);
                this.confirmMovingReadOnly(reorgQueries);
                return status;
            }
            catch (JavaModelException e) {
                throw e;
            }
            catch (CoreException e) {
                throw new JavaModelException(e);
            }
        }

        private void confirmMovingReadOnly(IReorgQueries reorgQueries) throws CoreException {
            if (!ReadOnlyResourceFinder.confirmMoveOfReadOnlyElements(this.getJavaElements(), this.getResources(), reorgQueries)) {
                throw new OperationCanceledException();
            }
        }

        private Change createChange(IPackageFragmentRoot root, IJavaProject destination) {
            return new MovePackageFragmentRootChange(root, (IContainer)destination.getProject(), null);
        }

        @Override
        public Change createChange(IProgressMonitor pm) throws JavaModelException {
            IPackageFragmentRoot[] roots = this.getPackageFragmentRoots();
            pm.beginTask("", roots.length);
            DynamicValidationStateChange composite = new DynamicValidationStateChange(RefactoringCoreMessages.ReorgPolicy_move_source_folder);
            composite.markAsSynthetic();
            IJavaProject destination = this.getDestinationJavaProject();
            int i = 0;
            while (i < roots.length) {
                if (destination == null) {
                    composite.add((Change)new MovePackageFragmentRootChange(roots[i], (IContainer)this.getResourceDestination(), null));
                } else {
                    composite.add(this.createChange(roots[i], destination));
                }
                pm.worked(1);
                ++i;
            }
            pm.done();
            return composite;
        }

        @Override
        protected JavaRefactoringDescriptor createRefactoringDescriptor(JDTRefactoringDescriptorComment comment, Map<String, String> arguments, String description, String project, int flags) {
            CreateTargetExecutionLog log = this.getCreateTargetExecutionLog();
            ReorgPolicyFactory.storeCreateTargetExecutionLog(project, arguments, log);
            return RefactoringSignatureDescriptorFactory.createMoveDescriptor((String)project, (String)description, (String)comment.asString(), arguments, (int)flags);
        }

        @Override
        public CreateTargetExecutionLog getCreateTargetExecutionLog() {
            return this.fCreateTargetExecutionLog;
        }

        @Override
        public ICreateTargetQuery getCreateTargetQuery(ICreateTargetQueries createQueries) {
            return null;
        }

        @Override
        protected String getDescriptionPlural() {
            return RefactoringCoreMessages.ReorgPolicyFactory_move_roots_plural;
        }

        @Override
        protected String getDescriptionSingular() {
            return RefactoringCoreMessages.ReorgPolicyFactory_move_roots_singular;
        }

        @Override
        protected String getHeaderPatternSingular() {
            return RefactoringCoreMessages.ReorgPolicyFactory_move_roots_header_singular;
        }

        @Override
        protected String getHeaderPatternPlural() {
            return RefactoringCoreMessages.ReorgPolicyFactory_move_roots_header_plural;
        }

        @Override
        protected RefactoringModifications getModifications() throws CoreException {
            if (this.fModifications != null) {
                return this.fModifications;
            }
            this.fModifications = new MoveModifications();
            IJavaProject destination = this.getDestinationJavaProject();
            boolean updateReferences = this.getUpdateReferences();
            if (destination != null) {
                IPackageFragmentRoot[] roots = this.getPackageFragmentRoots();
                int i = 0;
                while (i < roots.length) {
                    this.fModifications.move(roots[i], new MoveArguments((Object)destination, updateReferences));
                    ++i;
                }
            } else {
                IPackageFragmentRoot[] roots = this.getPackageFragmentRoots();
                int i = 0;
                while (i < roots.length) {
                    this.fModifications.move(roots[i], new MoveArguments((Object)this.getResourceDestination(), updateReferences));
                    ++i;
                }
            }
            return this.fModifications;
        }

        @Override
        public String getPolicyId() {
            return POLICY_MOVE_ROOTS;
        }

        @Override
        protected String getProcessorId() {
            return "org.eclipse.jdt.ui.move";
        }

        @Override
        protected String getRefactoringId() {
            return "org.eclipse.jdt.ui.move";
        }

        @Override
        public boolean isTextualMove() {
            return false;
        }

        @Override
        public Change postCreateChange(Change[] participantChanges, IProgressMonitor pm) throws CoreException {
            return null;
        }

        @Override
        public void setDestinationCheck(boolean check) {
            this.fCheckDestination = check;
        }

        @Override
        protected RefactoringStatus verifyDestination(IJavaElement javaElement) throws JavaModelException {
            RefactoringStatus superStatus = super.verifyDestination(javaElement);
            if (superStatus.hasFatalError()) {
                return superStatus;
            }
            IJavaProject javaProject = this.getDestinationJavaProject();
            if (MovePackageFragmentRootsPolicy.isParentOfAny(javaProject, this.getPackageFragmentRoots())) {
                return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ReorgPolicyFactory_element2parent);
            }
            return superStatus;
        }

        @Override
        protected RefactoringStatus verifyDestination(IResource destination) {
            RefactoringStatus superStatus = super.verifyDestination(destination);
            if (superStatus.hasFatalError()) {
                return superStatus;
            }
            Object commonParent = new ParentChecker(this.getResources(), this.getJavaElements()).getCommonParent();
            if (destination.equals(commonParent)) {
                return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ReorgPolicyFactory_cannot_move_source_to_parent);
            }
            return superStatus;
        }

        @Override
        public boolean canEnableQualifiedNameUpdating() {
            return false;
        }

        @Override
        public boolean getUpdateQualifiedNames() {
            return false;
        }

        @Override
        public boolean canUpdateQualifiedNames() {
            return false;
        }

        @Override
        public void setUpdateQualifiedNames(boolean update) {
        }

        @Override
        public void setFilePatterns(String patterns) {
        }

        @Override
        public String getFilePatterns() {
            return null;
        }

        @Override
        public boolean canUpdateJavaReferences() {
            return false;
        }

        @Override
        public boolean getUpdateReferences() {
            return this.fUpdateReferences;
        }

        @Override
        public void setUpdateReferences(boolean update) {
            this.fUpdateReferences = update;
        }

        @Override
        public boolean hasAllInputSet() {
            return this.getJavaElementDestination() != null || this.getResourceDestination() != null;
        }
    }

    private static final class MovePackagesPolicy
    extends PackagesReorgPolicy
    implements IReorgPolicy.IMovePolicy {
        private static final String POLICY_MOVE_PACKAGES = "org.eclipse.jdt.ui.movePackages";
        private CreateTargetExecutionLog fCreateTargetExecutionLog = new CreateTargetExecutionLog();
        private MoveModifications fModifications;
        private boolean fUpdateReferences = true;

        private static boolean isParentOfAny(IPackageFragmentRoot root, IPackageFragment[] fragments) {
            int i = 0;
            while (i < fragments.length) {
                IPackageFragment fragment = fragments[i];
                if (ReorgUtils.isParentInWorkspaceOrOnDisk(fragment, root)) {
                    return true;
                }
                ++i;
            }
            return false;
        }

        MovePackagesPolicy(IPackageFragment[] packageFragments) {
            super(packageFragments);
        }

        @Override
        public RefactoringStatus checkFinalConditions(IProgressMonitor pm, CheckConditionsContext context, IReorgQueries reorgQueries) throws CoreException {
            try {
                RefactoringStatus status = super.checkFinalConditions(pm, context, reorgQueries);
                this.confirmMovingReadOnly(reorgQueries);
                return status;
            }
            catch (JavaModelException e) {
                throw e;
            }
            catch (CoreException e) {
                throw new JavaModelException(e);
            }
        }

        private void confirmMovingReadOnly(IReorgQueries reorgQueries) throws CoreException {
            if (!ReadOnlyResourceFinder.confirmMoveOfReadOnlyElements(this.getJavaElements(), this.getResources(), reorgQueries)) {
                throw new OperationCanceledException();
            }
        }

        private Change createChange(IPackageFragment pack, IPackageFragmentRoot destination) {
            return new MovePackageChange(pack, destination);
        }

        private Change createChange(IPackageFragment pack, IContainer destination) {
            return new MoveResourceChange(pack.getResource(), destination);
        }

        @Override
        public Change createChange(IProgressMonitor pm) throws JavaModelException {
            IPackageFragment[] fragments = this.getPackages();
            pm.beginTask("", fragments.length);
            DynamicValidationStateChange result = new DynamicValidationStateChange(RefactoringCoreMessages.ReorgPolicy_move_package);
            result.markAsSynthetic();
            IPackageFragmentRoot root = this.getDestinationAsPackageFragmentRoot();
            int i = 0;
            while (i < fragments.length) {
                if (root == null) {
                    result.add(this.createChange(fragments[i], (IContainer)this.getResourceDestination()));
                } else {
                    result.add(this.createChange(fragments[i], root));
                }
                pm.worked(1);
                if (pm.isCanceled()) {
                    throw new OperationCanceledException();
                }
                ++i;
            }
            pm.done();
            return result;
        }

        @Override
        protected JavaRefactoringDescriptor createRefactoringDescriptor(JDTRefactoringDescriptorComment comment, Map<String, String> arguments, String description, String project, int flags) {
            CreateTargetExecutionLog log = this.getCreateTargetExecutionLog();
            ReorgPolicyFactory.storeCreateTargetExecutionLog(project, arguments, log);
            return RefactoringSignatureDescriptorFactory.createMoveDescriptor((String)project, (String)description, (String)comment.asString(), arguments, (int)flags);
        }

        @Override
        public CreateTargetExecutionLog getCreateTargetExecutionLog() {
            return this.fCreateTargetExecutionLog;
        }

        @Override
        public ICreateTargetQuery getCreateTargetQuery(ICreateTargetQueries createQueries) {
            return null;
        }

        @Override
        protected String getDescriptionPlural() {
            return RefactoringCoreMessages.ReorgPolicyFactory_move_packages_plural;
        }

        @Override
        protected String getDescriptionSingular() {
            return RefactoringCoreMessages.ReorgPolicyFactory_move_packages_singular;
        }

        @Override
        protected String getHeaderPatternSingular() {
            return RefactoringCoreMessages.ReorgPolicyFactory_move_packages_header_singular;
        }

        @Override
        protected String getHeaderPatternPlural() {
            return RefactoringCoreMessages.ReorgPolicyFactory_move_packages_header_plural;
        }

        @Override
        protected RefactoringModifications getModifications() throws CoreException {
            if (this.fModifications != null) {
                return this.fModifications;
            }
            this.fModifications = new MoveModifications();
            boolean updateReferences = this.getUpdateReferences();
            IPackageFragment[] packages = this.getPackages();
            IPackageFragmentRoot javaDestination = this.getDestinationAsPackageFragmentRoot();
            int i = 0;
            while (i < packages.length) {
                if (javaDestination == null) {
                    this.fModifications.move(packages[i].getResource(), new MoveArguments((Object)this.getResourceDestination(), updateReferences));
                } else {
                    this.fModifications.move(packages[i], new MoveArguments((Object)javaDestination, updateReferences));
                }
                ++i;
            }
            return this.fModifications;
        }

        @Override
        public String getPolicyId() {
            return POLICY_MOVE_PACKAGES;
        }

        @Override
        protected String getProcessorId() {
            return "org.eclipse.jdt.ui.move";
        }

        @Override
        protected String getRefactoringId() {
            return "org.eclipse.jdt.ui.move";
        }

        @Override
        public boolean isTextualMove() {
            return false;
        }

        @Override
        public Change postCreateChange(Change[] participantChanges, IProgressMonitor pm) throws CoreException {
            return null;
        }

        @Override
        public void setDestinationCheck(boolean check) {
            this.fCheckDestination = check;
        }

        @Override
        protected RefactoringStatus verifyDestination(IJavaElement javaElement) throws JavaModelException {
            RefactoringStatus superStatus = super.verifyDestination(javaElement);
            if (superStatus.hasFatalError()) {
                return superStatus;
            }
            IPackageFragmentRoot root = this.getDestinationAsPackageFragmentRoot();
            if (MovePackagesPolicy.isParentOfAny(root, this.getPackages())) {
                return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ReorgPolicyFactory_package2parent);
            }
            return superStatus;
        }

        @Override
        protected RefactoringStatus verifyDestination(IResource destination) {
            RefactoringStatus superStatus = super.verifyDestination(destination);
            if (superStatus.hasFatalError()) {
                return superStatus;
            }
            Object commonParent = new ParentChecker(this.getResources(), this.getJavaElements()).getCommonParent();
            if (destination.equals(commonParent)) {
                return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ReorgPolicyFactory_cannot_move_package_to_parent);
            }
            return superStatus;
        }

        @Override
        public boolean canEnableQualifiedNameUpdating() {
            return false;
        }

        @Override
        public boolean getUpdateQualifiedNames() {
            return false;
        }

        @Override
        public boolean canUpdateQualifiedNames() {
            return false;
        }

        @Override
        public void setUpdateQualifiedNames(boolean update) {
        }

        @Override
        public void setFilePatterns(String patterns) {
        }

        @Override
        public String getFilePatterns() {
            return null;
        }

        @Override
        public boolean canUpdateJavaReferences() {
            return false;
        }

        @Override
        public boolean getUpdateReferences() {
            return this.fUpdateReferences;
        }

        @Override
        public void setUpdateReferences(boolean update) {
            this.fUpdateReferences = update;
        }

        @Override
        public boolean hasAllInputSet() {
            return this.getJavaElementDestination() != null || this.getResourceDestination() != null;
        }
    }

    private static abstract class MoveSubCuElementsPolicy
    extends SubCuElementReorgPolicy
    implements IReorgPolicy.IMovePolicy {
        private CreateTargetExecutionLog fCreateTargetExecutionLog = new CreateTargetExecutionLog();
        private boolean fUpdateReferences = true;

        MoveSubCuElementsPolicy(IJavaElement[] javaElements) {
            super(javaElements);
        }

        @Override
        public boolean canEnable() throws JavaModelException {
            return super.canEnable() && this.getSourceCu() != null;
        }

        @Override
        public Change createChange(IProgressMonitor pm) throws JavaModelException {
            pm.beginTask("", 3);
            try {
                CompilationUnitRewrite targetRewriter;
                ICompilationUnit sourceCu = this.getSourceCu();
                CompilationUnit sourceCuNode = RefactoringASTParser.parseWithASTProvider((ITypeRoot)sourceCu, true, (IProgressMonitor)new SubProgressMonitor(pm, 1));
                CompilationUnitRewrite sourceRewriter = new CompilationUnitRewrite(sourceCu, sourceCuNode);
                ICompilationUnit destinationCu = MoveSubCuElementsPolicy.getEnclosingCompilationUnit(this.getJavaElementDestination());
                if (sourceCu.equals(destinationCu)) {
                    targetRewriter = sourceRewriter;
                    pm.worked(1);
                } else {
                    CompilationUnit destinationCuNode = RefactoringASTParser.parseWithASTProvider((ITypeRoot)destinationCu, true, (IProgressMonitor)new SubProgressMonitor(pm, 1));
                    targetRewriter = new CompilationUnitRewrite(destinationCu, destinationCuNode);
                }
                IJavaElement[] javaElements = this.getJavaElements();
                int i = 0;
                while (i < javaElements.length) {
                    this.copyToDestination(javaElements[i], targetRewriter, sourceRewriter.getRoot(), targetRewriter.getRoot());
                    ++i;
                }
                ASTNodeDeleteUtil.markAsDeleted(javaElements, sourceRewriter, null);
                CompilationUnitChange targetCuChange = MoveSubCuElementsPolicy.createCompilationUnitChange(targetRewriter);
                if (sourceCu.equals(destinationCu)) {
                    CompilationUnitChange compilationUnitChange = targetCuChange;
                    return compilationUnitChange;
                }
                DynamicValidationStateChange result = new DynamicValidationStateChange(RefactoringCoreMessages.ReorgPolicy_move_members);
                result.markAsSynthetic();
                result.add((Change)targetCuChange);
                if (Arrays.asList(this.getJavaElements()).containsAll(Arrays.asList(sourceCu.getTypes()))) {
                    result.add(DeleteChangeCreator.createDeleteChange(null, new IResource[0], (IJavaElement[])new ICompilationUnit[]{sourceCu}, RefactoringCoreMessages.ReorgPolicy_move, Collections.emptyList()));
                } else {
                    result.add((Change)MoveSubCuElementsPolicy.createCompilationUnitChange(sourceRewriter));
                }
                DynamicValidationStateChange dynamicValidationStateChange = result;
                return dynamicValidationStateChange;
            }
            catch (JavaModelException e) {
                throw e;
            }
            catch (CoreException e) {
                throw new JavaModelException(e);
            }
            finally {
                pm.done();
            }
        }

        @Override
        protected JavaRefactoringDescriptor createRefactoringDescriptor(JDTRefactoringDescriptorComment comment, Map<String, String> arguments, String description, String project, int flags) {
            CreateTargetExecutionLog log = this.getCreateTargetExecutionLog();
            ReorgPolicyFactory.storeCreateTargetExecutionLog(project, arguments, log);
            return RefactoringSignatureDescriptorFactory.createMoveDescriptor((String)project, (String)description, (String)comment.asString(), arguments, (int)flags);
        }

        @Override
        public IFile[] getAllModifiedFiles() {
            return ReorgUtils.getFiles(new IResource[]{ReorgUtils.getResource((IJavaElement)this.getSourceCu()), ReorgUtils.getResource((IJavaElement)MoveSubCuElementsPolicy.getEnclosingCompilationUnit(this.getJavaElementDestination()))});
        }

        @Override
        public CreateTargetExecutionLog getCreateTargetExecutionLog() {
            return this.fCreateTargetExecutionLog;
        }

        @Override
        public ICreateTargetQuery getCreateTargetQuery(ICreateTargetQueries createQueries) {
            return null;
        }

        @Override
        protected String getDescriptionPlural() {
            if (!ReorgUtils.hasElementsNotOfType(this.getJavaElements(), 7)) {
                return RefactoringCoreMessages.ReorgPolicyFactory_move_types;
            }
            if (!ReorgUtils.hasElementsNotOfType(this.getJavaElements(), 8)) {
                return RefactoringCoreMessages.ReorgPolicyFactory_move_fields;
            }
            if (!ReorgUtils.hasElementsNotOfType(this.getJavaElements(), 9)) {
                return RefactoringCoreMessages.ReorgPolicyFactory_move_methods;
            }
            if (!ReorgUtils.hasElementsNotOfType(this.getJavaElements(), 10)) {
                return RefactoringCoreMessages.ReorgPolicyFactory_move_initializers;
            }
            if (!ReorgUtils.hasElementsNotOfType(this.getJavaElements(), 11)) {
                return RefactoringCoreMessages.ReorgPolicyFactory_move_package_declarations;
            }
            if (!ReorgUtils.hasElementsNotOfType(this.getJavaElements(), 12)) {
                return RefactoringCoreMessages.ReorgPolicyFactory_move_import_containers;
            }
            if (!ReorgUtils.hasElementsNotOfType(this.getJavaElements(), 13)) {
                return RefactoringCoreMessages.ReorgPolicyFactory_move_import_declarations;
            }
            return RefactoringCoreMessages.ReorgPolicyFactory_move_elements_plural;
        }

        @Override
        protected String getDescriptionSingular() {
            if (!ReorgUtils.hasElementsNotOfType(this.getJavaElements(), 7)) {
                return RefactoringCoreMessages.ReorgPolicyFactory_move_type;
            }
            if (!ReorgUtils.hasElementsNotOfType(this.getJavaElements(), 8)) {
                return RefactoringCoreMessages.ReorgPolicyFactory_move_field;
            }
            if (!ReorgUtils.hasElementsNotOfType(this.getJavaElements(), 9)) {
                return RefactoringCoreMessages.ReorgPolicyFactory_move_method;
            }
            if (!ReorgUtils.hasElementsNotOfType(this.getJavaElements(), 10)) {
                return RefactoringCoreMessages.ReorgPolicyFactory_move_initializer;
            }
            if (!ReorgUtils.hasElementsNotOfType(this.getJavaElements(), 11)) {
                return RefactoringCoreMessages.ReorgPolicyFactory_move_package_declaration;
            }
            if (!ReorgUtils.hasElementsNotOfType(this.getJavaElements(), 12)) {
                return RefactoringCoreMessages.ReorgPolicyFactory_move_import_section;
            }
            if (!ReorgUtils.hasElementsNotOfType(this.getJavaElements(), 13)) {
                return RefactoringCoreMessages.ReorgPolicyFactory_move_import_declaration;
            }
            return RefactoringCoreMessages.ReorgPolicyFactory_move_elements_singular;
        }

        @Override
        protected String getHeaderPatternSingular() {
            return RefactoringCoreMessages.ReorgPolicyFactory_move_elements_header_singular;
        }

        @Override
        protected String getHeaderPatternPlural() {
            return RefactoringCoreMessages.ReorgPolicyFactory_move_elements_header_plural;
        }

        @Override
        protected String getProcessorId() {
            return "org.eclipse.jdt.ui.move";
        }

        @Override
        protected String getRefactoringId() {
            return "org.eclipse.jdt.ui.move";
        }

        @Override
        public boolean isTextualMove() {
            return true;
        }

        @Override
        public Change postCreateChange(Change[] participantChanges, IProgressMonitor pm) throws CoreException {
            return null;
        }

        @Override
        public void setDestinationCheck(boolean check) {
            this.fCheckDestination = check;
        }

        @Override
        protected RefactoringStatus verifyDestination(IJavaElement destination, int location) throws JavaModelException {
            IJavaElement parent;
            IJavaElement[] elements = this.getJavaElements();
            int i = 0;
            while (i < elements.length) {
                parent = destination.getParent();
                while (parent != null) {
                    if (parent.equals(elements[i])) {
                        return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ReorgPolicyFactory_cannot);
                    }
                    parent = parent.getParent();
                }
                ++i;
            }
            RefactoringStatus superStatus = super.verifyDestination(destination, location);
            if (superStatus.hasFatalError()) {
                return superStatus;
            }
            if (location == 3) {
                Object commonParent = new ParentChecker(new IResource[0], this.getJavaElements()).getCommonParent();
                if (destination.equals(commonParent) || Arrays.asList(this.getJavaElements()).contains(destination)) {
                    return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ReorgPolicyFactory_element2parent);
                }
                return superStatus;
            }
            if (this.contains(elements, destination)) {
                return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ReorgPolicyFactory_cannot);
            }
            parent = destination.getParent();
            if (!(parent instanceof IType)) {
                return superStatus;
            }
            if (!this.allInSameParent(elements, parent)) {
                return superStatus;
            }
            ArrayList<IJavaElement> sortedChildren = this.getSortedChildren((IType)parent);
            int destinationIndex = sortedChildren.indexOf(destination);
            int i2 = 0;
            while (i2 < elements.length) {
                int elementIndex = sortedChildren.indexOf(elements[i2]);
                if (location == 2 && elementIndex == destinationIndex + 1) {
                    return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ReorgPolicyFactory_cannot);
                }
                if (location == 1 && elementIndex == destinationIndex - 1) {
                    return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ReorgPolicyFactory_cannot);
                }
                ++i2;
            }
            return superStatus;
        }

        private ArrayList<IJavaElement> getSortedChildren(IType parent) throws JavaModelException {
            IJavaElement[] children = parent.getChildren();
            ArrayList<IJavaElement> sortedChildren = new ArrayList<IJavaElement>(Arrays.asList(children));
            Collections.sort(sortedChildren, new Comparator<IJavaElement>(){

                @Override
                public int compare(IJavaElement e1, IJavaElement e2) {
                    ISourceRange sr2;
                    ISourceRange sr1;
                    block5: {
                        if (!(e1 instanceof ISourceReference)) {
                            return 0;
                        }
                        if (!(e2 instanceof ISourceReference)) {
                            return 0;
                        }
                        try {
                            sr1 = ((ISourceReference)e1).getSourceRange();
                            sr2 = ((ISourceReference)e2).getSourceRange();
                            if (sr1 != null && sr2 != null) break block5;
                            return 0;
                        }
                        catch (JavaModelException javaModelException) {
                            return 0;
                        }
                    }
                    return sr1.getOffset() - sr2.getOffset();
                }
            });
            return sortedChildren;
        }

        private boolean contains(IJavaElement[] elements, IJavaElement element) {
            int i = 0;
            while (i < elements.length) {
                if (element.equals(elements[i])) {
                    return true;
                }
                ++i;
            }
            return false;
        }

        private boolean allInSameParent(IJavaElement[] elements, IJavaElement parent) {
            int i = 0;
            while (i < elements.length) {
                if (!elements[i].getParent().equals(parent)) {
                    return false;
                }
                ++i;
            }
            return true;
        }

        @Override
        public boolean canEnableQualifiedNameUpdating() {
            return false;
        }

        @Override
        public boolean getUpdateQualifiedNames() {
            return false;
        }

        @Override
        public boolean canUpdateQualifiedNames() {
            return false;
        }

        @Override
        public void setUpdateQualifiedNames(boolean update) {
        }

        @Override
        public void setFilePatterns(String patterns) {
        }

        @Override
        public String getFilePatterns() {
            return null;
        }

        @Override
        public boolean canUpdateJavaReferences() {
            return false;
        }

        @Override
        public boolean getUpdateReferences() {
            return this.fUpdateReferences;
        }

        @Override
        public void setUpdateReferences(boolean update) {
            this.fUpdateReferences = update;
        }

        @Override
        public boolean hasAllInputSet() {
            return this.getJavaElementDestination() != null || this.getResourceDestination() != null;
        }
    }

    private static final class NewNameProposer {
        private final Set<String> fAutoGeneratedNewNames = new HashSet<String>(2);

        private NewNameProposer() {
        }

        private static boolean isNewNameOk(IContainer container, String newName) {
            return container.findMember(newName) == null;
        }

        private static boolean isNewNameOk(IPackageFragment dest, String newName) {
            return !dest.getCompilationUnit(newName).exists();
        }

        private static boolean isNewNameOk(IPackageFragmentRoot root, String newName) {
            return !root.getPackageFragment(newName).exists();
        }

        private String computeNewName(String str, int resourceType) {
            Pattern p;
            Matcher m;
            int lastIndexOfDot = str.lastIndexOf(46);
            String fileExtension = "";
            String fileNameNoExtension = str;
            if (resourceType == 1 && lastIndexOfDot > 0) {
                fileExtension = str.substring(lastIndexOfDot);
                fileNameNoExtension = str.substring(0, lastIndexOfDot);
            }
            if ((m = (p = Pattern.compile("[0-9]+$")).matcher(fileNameNoExtension)).find()) {
                int newNumber = Integer.parseInt(m.group()) + 1;
                String numberStr = m.replaceFirst(Integer.toString(newNumber));
                return String.valueOf(numberStr) + fileExtension;
            }
            return String.valueOf(fileNameNoExtension) + "2" + fileExtension;
        }

        public String createNewName(ICompilationUnit cu, IPackageFragment destination) {
            if (NewNameProposer.isNewNameOk(destination, cu.getElementName())) {
                return null;
            }
            if (!ReorgUtils.isParentInWorkspaceOrOnDisk(cu, destination)) {
                return null;
            }
            int resourceType = cu.getResource().getType();
            String newName = this.computeNewName(cu.getElementName(), resourceType);
            while (true) {
                if (NewNameProposer.isNewNameOk(destination, newName) && !this.fAutoGeneratedNewNames.contains(newName)) {
                    this.fAutoGeneratedNewNames.add(newName);
                    return JavaCore.removeJavaLikeExtension((String)newName);
                }
                newName = this.computeNewName(newName, resourceType);
            }
        }

        public String createNewName(IPackageFragment pack, IPackageFragmentRoot destination) {
            if (NewNameProposer.isNewNameOk(destination, pack.getElementName())) {
                return null;
            }
            if (!ReorgUtils.isParentInWorkspaceOrOnDisk(pack, destination)) {
                return null;
            }
            int i = 1;
            while (true) {
                String newName;
                if (NewNameProposer.isNewNameOk(destination, newName = i == 1 ? Messages.format(RefactoringCoreMessages.CopyRefactoring_package_copyOf1, pack.getElementName()) : Messages.format(RefactoringCoreMessages.CopyRefactoring_package_copyOfMore, new String[]{String.valueOf(i), pack.getElementName()})) && !this.fAutoGeneratedNewNames.contains(newName)) {
                    this.fAutoGeneratedNewNames.add(newName);
                    return newName;
                }
                ++i;
            }
        }

        public String createNewName(IResource res, IContainer destination) {
            if (NewNameProposer.isNewNameOk(destination, res.getName())) {
                return null;
            }
            if (!ReorgUtils.isParentInWorkspaceOrOnDisk(res, (IResource)destination)) {
                return null;
            }
            int resourceType = res.getType();
            String newName = this.computeNewName(res.getName(), resourceType);
            while (true) {
                if (NewNameProposer.isNewNameOk(destination, newName) && !this.fAutoGeneratedNewNames.contains(newName)) {
                    this.fAutoGeneratedNewNames.add(newName);
                    return newName;
                }
                newName = this.computeNewName(newName, resourceType);
            }
        }
    }

    private static final class NoCopyPolicy
    extends ReorgPolicy
    implements IReorgPolicy.ICopyPolicy {
        private NoCopyPolicy() {
        }

        @Override
        public boolean canEnable() throws JavaModelException {
            return false;
        }

        @Override
        public Change createChange(IProgressMonitor pm, INewNameQueries copyQueries) {
            return new NullChange();
        }

        @Override
        protected String getDescriptionPlural() {
            return ReorgPolicyFactory.UNUSED_STRING;
        }

        @Override
        protected String getDescriptionSingular() {
            return ReorgPolicyFactory.UNUSED_STRING;
        }

        @Override
        public ChangeDescriptor getDescriptor() {
            return null;
        }

        @Override
        protected String getHeaderPatternSingular() {
            return ReorgPolicyFactory.UNUSED_STRING;
        }

        @Override
        protected String getHeaderPatternPlural() {
            return ReorgPolicyFactory.UNUSED_STRING;
        }

        @Override
        public IJavaElement[] getJavaElements() {
            return new IJavaElement[0];
        }

        @Override
        public String getPolicyId() {
            return ReorgPolicyFactory.NO_POLICY;
        }

        @Override
        protected String getProcessorId() {
            return ReorgPolicyFactory.NO_ID;
        }

        @Override
        protected String getRefactoringId() {
            return ReorgPolicyFactory.NO_ID;
        }

        @Override
        public ReorgExecutionLog getReorgExecutionLog() {
            return null;
        }

        @Override
        public IResource[] getResources() {
            return new IResource[0];
        }

        @Override
        public RefactoringStatus initialize(JavaRefactoringArguments arguments) {
            return new RefactoringStatus();
        }

        @Override
        protected RefactoringStatus verifyDestination(IJavaElement javaElement) throws JavaModelException {
            return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ReorgPolicyFactory_noCopying);
        }

        @Override
        protected RefactoringStatus verifyDestination(IResource resource) throws JavaModelException {
            return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ReorgPolicyFactory_noCopying);
        }
    }

    private static final class NoMovePolicy
    extends ReorgPolicy
    implements IReorgPolicy.IMovePolicy {
        private NoMovePolicy() {
        }

        @Override
        public boolean canEnable() throws JavaModelException {
            return false;
        }

        @Override
        public Change createChange(IProgressMonitor pm) {
            return new NullChange();
        }

        @Override
        public CreateTargetExecutionLog getCreateTargetExecutionLog() {
            return new CreateTargetExecutionLog();
        }

        @Override
        public ICreateTargetQuery getCreateTargetQuery(ICreateTargetQueries createQueries) {
            return null;
        }

        @Override
        protected String getDescriptionPlural() {
            return ReorgPolicyFactory.UNUSED_STRING;
        }

        @Override
        protected String getDescriptionSingular() {
            return ReorgPolicyFactory.UNUSED_STRING;
        }

        @Override
        public ChangeDescriptor getDescriptor() {
            return null;
        }

        @Override
        protected String getHeaderPatternSingular() {
            return ReorgPolicyFactory.UNUSED_STRING;
        }

        @Override
        protected String getHeaderPatternPlural() {
            return ReorgPolicyFactory.UNUSED_STRING;
        }

        @Override
        public IJavaElement[] getJavaElements() {
            return new IJavaElement[0];
        }

        @Override
        public String getPolicyId() {
            return ReorgPolicyFactory.NO_POLICY;
        }

        @Override
        protected String getProcessorId() {
            return ReorgPolicyFactory.NO_ID;
        }

        @Override
        protected String getRefactoringId() {
            return ReorgPolicyFactory.NO_ID;
        }

        @Override
        public IResource[] getResources() {
            return new IResource[0];
        }

        @Override
        public RefactoringStatus initialize(JavaRefactoringArguments arguments) {
            return new RefactoringStatus();
        }

        @Override
        public boolean isTextualMove() {
            return true;
        }

        @Override
        public Change postCreateChange(Change[] participantChanges, IProgressMonitor pm) throws CoreException {
            return null;
        }

        @Override
        public void setDestinationCheck(boolean check) {
            this.fCheckDestination = check;
        }

        @Override
        protected RefactoringStatus verifyDestination(IJavaElement javaElement) throws JavaModelException {
            return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ReorgPolicyFactory_noMoving);
        }

        @Override
        protected RefactoringStatus verifyDestination(IResource resource) throws JavaModelException {
            return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ReorgPolicyFactory_noMoving);
        }

        @Override
        public boolean canEnableQualifiedNameUpdating() {
            return false;
        }

        @Override
        public boolean getUpdateQualifiedNames() {
            return false;
        }

        @Override
        public boolean canUpdateQualifiedNames() {
            return false;
        }

        @Override
        public void setUpdateQualifiedNames(boolean update) {
        }

        @Override
        public void setFilePatterns(String patterns) {
        }

        @Override
        public String getFilePatterns() {
            return null;
        }

        @Override
        public boolean canUpdateJavaReferences() {
            return false;
        }

        @Override
        public boolean getUpdateReferences() {
            return false;
        }

        @Override
        public void setUpdateReferences(boolean update) {
        }

        @Override
        public boolean hasAllInputSet() {
            return this.getJavaElementDestination() != null || this.getResourceDestination() != null;
        }
    }

    private static abstract class PackageFragmentRootsReorgPolicy
    extends ReorgPolicy {
        private IPackageFragmentRoot[] fPackageFragmentRoots;

        public PackageFragmentRootsReorgPolicy(IPackageFragmentRoot[] roots) {
            this.fPackageFragmentRoots = roots;
        }

        @Override
        public boolean canChildrenBeDestinations(IJavaElement javaElement) {
            switch (javaElement.getElementType()) {
                case 1: 
                case 2: {
                    return true;
                }
            }
            return false;
        }

        @Override
        public boolean canChildrenBeDestinations(IResource resource) {
            return resource instanceof IContainer;
        }

        @Override
        public boolean canElementBeDestination(IJavaElement javaElement) {
            return javaElement.getElementType() == 2;
        }

        @Override
        public boolean canElementBeDestination(IResource resource) {
            return resource instanceof IContainer;
        }

        @Override
        public boolean canEnable() throws JavaModelException {
            if (!super.canEnable() || this.fPackageFragmentRoots.length == 0) {
                return false;
            }
            int i = 0;
            while (i < this.fPackageFragmentRoots.length) {
                IPackageFragmentRoot root = this.fPackageFragmentRoots[i];
                if (!(ReorgUtils.isSourceFolder((IJavaElement)root) || root.isArchive() && !root.isExternal())) {
                    return false;
                }
                ++i;
            }
            return !ReorgUtils.containsLinkedResources((IJavaElement[])this.fPackageFragmentRoots);
        }

        @Override
        public RefactoringStatus checkFinalConditions(IProgressMonitor pm, CheckConditionsContext context, IReorgQueries reorgQueries) throws CoreException {
            this.confirmOverwriting(reorgQueries);
            RefactoringStatus status = super.checkFinalConditions(pm, context, reorgQueries);
            return status;
        }

        private void confirmOverwriting(IReorgQueries reorgQueries) {
            OverwriteHelper oh = new OverwriteHelper();
            oh.setPackageFragmentRoots(this.fPackageFragmentRoots);
            IJavaProject javaProject = this.getDestinationJavaProject();
            if (javaProject == null) {
                oh.confirmOverwriting(reorgQueries, this.getResourceDestination());
            } else {
                oh.confirmOverwriting(reorgQueries, javaProject);
            }
            this.fPackageFragmentRoots = oh.getPackageFragmentRootsWithoutUnconfirmedOnes();
        }

        protected abstract JavaRefactoringDescriptor createRefactoringDescriptor(JDTRefactoringDescriptorComment var1, Map<String, String> var2, String var3, String var4, int var5);

        @Override
        public final ChangeDescriptor getDescriptor() {
            HashMap<String, String> arguments = new HashMap<String, String>();
            int length = this.fPackageFragmentRoots.length;
            String description = length == 1 ? this.getDescriptionSingular() : this.getDescriptionPlural();
            IProject resource = this.getSingleProject();
            String project = resource != null ? resource.getName() : null;
            String header = length == 1 ? Messages.format(this.getHeaderPatternSingular(), new String[]{this.fPackageFragmentRoots[0].getElementName(), this.getDestinationLabel()}) : Messages.format(this.getHeaderPatternPlural(), new String[]{String.valueOf(length), this.getDestinationLabel()});
            int flags = 6;
            JDTRefactoringDescriptorComment comment = new JDTRefactoringDescriptorComment(project, this, header);
            arguments.put(ReorgPolicyFactory.ATTRIBUTE_POLICY, this.getPolicyId());
            arguments.put(ReorgPolicyFactory.ATTRIBUTE_ROOTS, new Integer(this.fPackageFragmentRoots.length).toString());
            int offset = 0;
            while (offset < this.fPackageFragmentRoots.length) {
                arguments.put("element" + (offset + 1), JavaRefactoringDescriptorUtil.elementToHandle(project, (IJavaElement)this.fPackageFragmentRoots[offset]));
                ++offset;
            }
            arguments.putAll(this.getRefactoringArguments(project));
            JavaRefactoringDescriptor descriptor = this.createRefactoringDescriptor(comment, arguments, description, project, flags);
            return new RefactoringChangeDescriptor((RefactoringDescriptor)descriptor);
        }

        private IJavaProject getDestinationAsJavaProject(IJavaElement javaElementDestination) {
            if (javaElementDestination == null) {
                return null;
            }
            return javaElementDestination.getJavaProject();
        }

        protected IJavaProject getDestinationJavaProject() {
            return this.getDestinationAsJavaProject(this.getJavaElementDestination());
        }

        @Override
        public IJavaElement[] getJavaElements() {
            return this.fPackageFragmentRoots;
        }

        protected IPackageFragmentRoot[] getPackageFragmentRoots() {
            return this.fPackageFragmentRoots;
        }

        @Override
        public IResource[] getResources() {
            return new IResource[0];
        }

        public IPackageFragmentRoot[] getRoots() {
            return this.fPackageFragmentRoots;
        }

        private IProject getSingleProject() {
            IProject result = null;
            int index = 0;
            while (index < this.fPackageFragmentRoots.length) {
                if (result == null) {
                    result = this.fPackageFragmentRoots[index].getJavaProject().getProject();
                } else if (!result.equals((Object)this.fPackageFragmentRoots[index].getJavaProject().getProject())) {
                    return null;
                }
                ++index;
            }
            return result;
        }

        @Override
        public RefactoringStatus initialize(JavaRefactoringArguments arguments) {
            RefactoringStatus status = new RefactoringStatus();
            int rootCount = 0;
            String value = arguments.getAttribute(ReorgPolicyFactory.ATTRIBUTE_ROOTS);
            if (value != null && !"".equals(value)) {
                try {
                    rootCount = Integer.parseInt(value);
                }
                catch (NumberFormatException numberFormatException) {
                    return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, ReorgPolicyFactory.ATTRIBUTE_ROOTS));
                }
            } else {
                return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, ReorgPolicyFactory.ATTRIBUTE_ROOTS));
            }
            String handle = null;
            ArrayList<IJavaElement> elements = new ArrayList<IJavaElement>();
            int index = 0;
            while (index < rootCount) {
                String attribute = "element" + (index + 1);
                handle = arguments.getAttribute(attribute);
                if (handle != null && !"".equals(handle)) {
                    IJavaElement element = JavaRefactoringDescriptorUtil.handleToElement(arguments.getProject(), handle, false);
                    if (element == null || !element.exists() || element.getElementType() != 3) {
                        status.merge(JavaRefactoringDescriptorUtil.createInputWarningStatus(element, this.getProcessorId(), this.getRefactoringId()));
                    } else {
                        elements.add(element);
                    }
                } else {
                    return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, attribute));
                }
                ++index;
            }
            this.fPackageFragmentRoots = elements.toArray(new IPackageFragmentRoot[elements.size()]);
            status.merge(super.initialize(arguments));
            return status;
        }

        @Override
        protected RefactoringStatus verifyDestination(IJavaElement javaElement) throws JavaModelException {
            Assert.isNotNull((Object)javaElement);
            if (!this.fCheckDestination) {
                return new RefactoringStatus();
            }
            if (!javaElement.exists()) {
                return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ReorgPolicyFactory_cannot1);
            }
            if (javaElement instanceof IJavaModel) {
                return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ReorgPolicyFactory_jmodel);
            }
            if (!(javaElement instanceof IJavaProject)) {
                return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ReorgPolicyFactory_src2proj);
            }
            if (javaElement.isReadOnly()) {
                return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ReorgPolicyFactory_src2writable);
            }
            if (ReorgUtils.isPackageFragmentRoot(javaElement.getJavaProject())) {
                return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ReorgPolicyFactory_src2nosrc);
            }
            return new RefactoringStatus();
        }

        @Override
        protected RefactoringStatus verifyDestination(IResource resource) {
            Assert.isNotNull((Object)resource);
            if (!resource.exists() || resource.isPhantom()) {
                return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ReorgPolicyFactory_phantom);
            }
            if (!resource.isAccessible()) {
                return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ReorgPolicyFactory_inaccessible);
            }
            if (!(resource instanceof IContainer)) {
                return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ReorgPolicyFactory_not_this_resource);
            }
            if (resource.getType() == 8) {
                return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ReorgPolicyFactory_not_this_resource);
            }
            if (this.isChildOfOrEqualToAnyFolder(resource)) {
                return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ReorgPolicyFactory_not_this_resource);
            }
            if (this.containsLinkedResources() && !ReorgUtils.canBeDestinationForLinkedResources(resource)) {
                return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ReorgPolicyFactory_linked);
            }
            return new RefactoringStatus();
        }

        private boolean isChildOfOrEqualToAnyFolder(IResource resource) {
            int i = 0;
            while (i < this.fPackageFragmentRoots.length) {
                IResource fragmentRootResource = this.fPackageFragmentRoots[i].getResource();
                if (fragmentRootResource.equals((Object)resource) || ParentChecker.isDescendantOf(resource, fragmentRootResource)) {
                    return true;
                }
                ++i;
            }
            return false;
        }

        protected boolean containsLinkedResources() {
            int i = 0;
            while (i < this.fPackageFragmentRoots.length) {
                if (this.fPackageFragmentRoots[i].getResource().isLinked()) {
                    return true;
                }
                ++i;
            }
            return false;
        }
    }

    private static abstract class PackagesReorgPolicy
    extends ReorgPolicy {
        private IPackageFragment[] fPackageFragments;

        public PackagesReorgPolicy(IPackageFragment[] packageFragments) {
            this.fPackageFragments = packageFragments;
        }

        @Override
        public boolean canChildrenBeDestinations(IJavaElement javaElement) {
            switch (javaElement.getElementType()) {
                case 1: 
                case 2: 
                case 3: {
                    return true;
                }
            }
            return false;
        }

        @Override
        public boolean canChildrenBeDestinations(IResource resource) {
            return resource instanceof IContainer;
        }

        @Override
        public boolean canElementBeDestination(IJavaElement javaElement) {
            switch (javaElement.getElementType()) {
                case 2: 
                case 3: {
                    return true;
                }
            }
            return false;
        }

        @Override
        public boolean canElementBeDestination(IResource resource) {
            return resource instanceof IContainer;
        }

        @Override
        public boolean canEnable() throws JavaModelException {
            if (this.fPackageFragments.length == 0) {
                return false;
            }
            int i = 0;
            while (i < this.fPackageFragments.length) {
                if (JavaElementUtil.isDefaultPackage(this.fPackageFragments[i]) || this.fPackageFragments[i].isReadOnly()) {
                    return false;
                }
                ++i;
            }
            return !ReorgUtils.containsLinkedResources((IJavaElement[])this.fPackageFragments);
        }

        @Override
        public RefactoringStatus checkFinalConditions(IProgressMonitor pm, CheckConditionsContext context, IReorgQueries reorgQueries) throws CoreException {
            this.confirmOverwriting(reorgQueries);
            RefactoringStatus refactoringStatus = super.checkFinalConditions(pm, context, reorgQueries);
            return refactoringStatus;
        }

        private void confirmOverwriting(IReorgQueries reorgQueries) throws JavaModelException {
            OverwriteHelper helper = new OverwriteHelper();
            helper.setPackages(this.fPackageFragments);
            IPackageFragmentRoot destRoot = this.getDestinationAsPackageFragmentRoot();
            if (destRoot == null) {
                helper.confirmOverwriting(reorgQueries, this.getResourceDestination());
            } else {
                helper.confirmOverwriting(reorgQueries, destRoot);
            }
            this.fPackageFragments = helper.getPackagesWithoutUnconfirmedOnes();
        }

        protected abstract JavaRefactoringDescriptor createRefactoringDescriptor(JDTRefactoringDescriptorComment var1, Map<String, String> var2, String var3, String var4, int var5);

        @Override
        public final ChangeDescriptor getDescriptor() {
            HashMap<String, String> arguments = new HashMap<String, String>();
            int length = this.fPackageFragments.length;
            String description = length == 1 ? this.getDescriptionSingular() : this.getDescriptionPlural();
            IProject resource = this.getSingleProject();
            String project = resource != null ? resource.getName() : null;
            String header = length == 1 ? Messages.format(this.getHeaderPatternSingular(), new String[]{this.fPackageFragments[0].getElementName(), this.getDestinationLabel()}) : Messages.format(this.getHeaderPatternPlural(), new String[]{String.valueOf(length), this.getDestinationLabel()});
            int flags = 589830;
            JDTRefactoringDescriptorComment comment = new JDTRefactoringDescriptorComment(project, this, header);
            arguments.put(ReorgPolicyFactory.ATTRIBUTE_POLICY, this.getPolicyId());
            arguments.put(ReorgPolicyFactory.ATTRIBUTE_FRAGMENTS, new Integer(this.fPackageFragments.length).toString());
            int offset = 0;
            while (offset < this.fPackageFragments.length) {
                arguments.put("element" + (offset + 1), JavaRefactoringDescriptorUtil.elementToHandle(project, (IJavaElement)this.fPackageFragments[offset]));
                ++offset;
            }
            arguments.putAll(this.getRefactoringArguments(project));
            JavaRefactoringDescriptor descriptor = this.createRefactoringDescriptor(comment, arguments, description, project, flags);
            return new RefactoringChangeDescriptor((RefactoringDescriptor)descriptor);
        }

        protected IPackageFragmentRoot getDestinationAsPackageFragmentRoot() throws JavaModelException {
            return this.getDestinationAsPackageFragmentRoot(this.getJavaElementDestination());
        }

        private IPackageFragmentRoot getDestinationAsPackageFragmentRoot(IJavaElement javaElement) throws JavaModelException {
            IPackageFragment pack;
            if (javaElement == null) {
                return null;
            }
            if (javaElement instanceof IPackageFragmentRoot) {
                return (IPackageFragmentRoot)javaElement;
            }
            if (javaElement instanceof IPackageFragment && (pack = (IPackageFragment)javaElement).getParent() instanceof IPackageFragmentRoot) {
                return (IPackageFragmentRoot)pack.getParent();
            }
            if (javaElement instanceof IJavaProject) {
                return ReorgUtils.getCorrespondingPackageFragmentRoot((IJavaProject)javaElement);
            }
            return null;
        }

        @Override
        public IJavaElement[] getJavaElements() {
            return this.fPackageFragments;
        }

        protected IPackageFragment[] getPackages() {
            return this.fPackageFragments;
        }

        @Override
        public IResource[] getResources() {
            return new IResource[0];
        }

        private IProject getSingleProject() {
            IProject result = null;
            int index = 0;
            while (index < this.fPackageFragments.length) {
                if (result == null) {
                    result = this.fPackageFragments[index].getJavaProject().getProject();
                } else if (!result.equals((Object)this.fPackageFragments[index].getJavaProject().getProject())) {
                    return null;
                }
                ++index;
            }
            return result;
        }

        @Override
        public RefactoringStatus initialize(JavaRefactoringArguments arguments) {
            RefactoringStatus status = new RefactoringStatus();
            int fragmentCount = 0;
            String value = arguments.getAttribute(ReorgPolicyFactory.ATTRIBUTE_FRAGMENTS);
            if (value != null && !"".equals(value)) {
                try {
                    fragmentCount = Integer.parseInt(value);
                }
                catch (NumberFormatException numberFormatException) {
                    return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, ReorgPolicyFactory.ATTRIBUTE_FRAGMENTS));
                }
            } else {
                return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, ReorgPolicyFactory.ATTRIBUTE_FRAGMENTS));
            }
            String handle = null;
            ArrayList<IJavaElement> elements = new ArrayList<IJavaElement>();
            int index = 0;
            while (index < fragmentCount) {
                String attribute = "element" + (index + 1);
                handle = arguments.getAttribute(attribute);
                if (handle != null && !"".equals(handle)) {
                    IJavaElement element = JavaRefactoringDescriptorUtil.handleToElement(arguments.getProject(), handle, false);
                    if (element == null || !element.exists() || element.getElementType() != 4) {
                        status.merge(JavaRefactoringDescriptorUtil.createInputWarningStatus(element, this.getProcessorId(), this.getRefactoringId()));
                    } else {
                        elements.add(element);
                    }
                } else {
                    return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, attribute));
                }
                ++index;
            }
            this.fPackageFragments = elements.toArray(new IPackageFragment[elements.size()]);
            status.merge(super.initialize(arguments));
            return status;
        }

        @Override
        protected RefactoringStatus verifyDestination(IJavaElement javaElement) throws JavaModelException {
            Assert.isNotNull((Object)javaElement);
            if (!this.fCheckDestination) {
                return new RefactoringStatus();
            }
            if (!javaElement.exists()) {
                return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ReorgPolicyFactory_cannot1);
            }
            if (javaElement instanceof IJavaModel) {
                return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ReorgPolicyFactory_jmodel);
            }
            IPackageFragmentRoot destRoot = this.getDestinationAsPackageFragmentRoot(javaElement);
            if (!ReorgUtils.isSourceFolder((IJavaElement)destRoot)) {
                return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ReorgPolicyFactory_packages);
            }
            return new RefactoringStatus();
        }

        @Override
        protected RefactoringStatus verifyDestination(IResource resource) {
            Assert.isNotNull((Object)resource);
            if (!resource.exists() || resource.isPhantom()) {
                return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ReorgPolicyFactory_phantom);
            }
            if (!resource.isAccessible()) {
                return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ReorgPolicyFactory_inaccessible);
            }
            if (!(resource instanceof IContainer)) {
                return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ReorgPolicyFactory_not_this_resource);
            }
            if (resource.getType() == 8) {
                return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ReorgPolicyFactory_not_this_resource);
            }
            if (this.isChildOfOrEqualToAnyFolder(resource)) {
                return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ReorgPolicyFactory_not_this_resource);
            }
            if (this.containsLinkedResources() && !ReorgUtils.canBeDestinationForLinkedResources(resource)) {
                return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ReorgPolicyFactory_linked);
            }
            return new RefactoringStatus();
        }

        private boolean isChildOfOrEqualToAnyFolder(IResource resource) {
            int i = 0;
            while (i < this.fPackageFragments.length) {
                IFolder folder = (IFolder)this.fPackageFragments[i].getResource();
                if (folder.equals((Object)resource) || ParentChecker.isDescendantOf(resource, (IResource)folder)) {
                    return true;
                }
                ++i;
            }
            return false;
        }

        protected boolean containsLinkedResources() {
            int i = 0;
            while (i < this.fPackageFragments.length) {
                if (this.fPackageFragments[i].getResource().isLinked()) {
                    return true;
                }
                ++i;
            }
            return false;
        }
    }

    private static abstract class ReorgPolicy
    implements IReorgPolicy {
        private static final String ATTRIBUTE_DESTINATION = "destination";
        private static final String ATTRIBUTE_TARGET = "target";
        protected boolean fCheckDestination = true;
        private IReorgDestination fDestination;

        private ReorgPolicy() {
        }

        @Override
        public boolean canChildrenBeDestinations(IReorgDestination destination) {
            if (destination instanceof ReorgDestinationFactory.JavaElementDestination) {
                return this.canChildrenBeDestinations(((ReorgDestinationFactory.JavaElementDestination)destination).getJavaElement());
            }
            if (destination instanceof ReorgDestinationFactory.ResourceDestination) {
                return this.canChildrenBeDestinations(((ReorgDestinationFactory.ResourceDestination)destination).getResource());
            }
            return false;
        }

        public boolean canChildrenBeDestinations(IResource resource) {
            return true;
        }

        public boolean canChildrenBeDestinations(IJavaElement javaElement) {
            return true;
        }

        @Override
        public boolean canElementBeDestination(IReorgDestination destination) {
            if (destination instanceof ReorgDestinationFactory.JavaElementDestination) {
                return this.canElementBeDestination(((ReorgDestinationFactory.JavaElementDestination)destination).getJavaElement());
            }
            if (destination instanceof ReorgDestinationFactory.ResourceDestination) {
                return this.canElementBeDestination(((ReorgDestinationFactory.ResourceDestination)destination).getResource());
            }
            return false;
        }

        public boolean canElementBeDestination(IResource resource) {
            return true;
        }

        public boolean canElementBeDestination(IJavaElement javaElement) {
            return true;
        }

        @Override
        public boolean canEnable() throws JavaModelException {
            IResource[] resources = this.getResources();
            int i = 0;
            while (i < resources.length) {
                IResource resource = resources[i];
                if (!resource.exists() || resource.isPhantom() || !resource.isAccessible()) {
                    return false;
                }
                ++i;
            }
            IJavaElement[] javaElements = this.getJavaElements();
            int i2 = 0;
            while (i2 < javaElements.length) {
                IJavaElement element = javaElements[i2];
                if (!element.exists()) {
                    return false;
                }
                ++i2;
            }
            return resources.length > 0 || javaElements.length > 0;
        }

        @Override
        public int getSaveMode() {
            return 2;
        }

        @Override
        public RefactoringStatus checkFinalConditions(IProgressMonitor pm, CheckConditionsContext context, IReorgQueries reorgQueries) throws CoreException {
            Assert.isNotNull((Object)reorgQueries);
            ResourceChangeChecker checker = (ResourceChangeChecker)context.getChecker(ResourceChangeChecker.class);
            IFile[] allModifiedFiles = this.getAllModifiedFiles();
            RefactoringModifications modifications = this.getModifications();
            IResourceChangeDescriptionFactory deltaFactory = checker.getDeltaFactory();
            int i = 0;
            while (i < allModifiedFiles.length) {
                deltaFactory.change(allModifiedFiles[i]);
                ++i;
            }
            if (modifications != null) {
                modifications.buildDelta(deltaFactory);
                modifications.buildValidateEdits((ValidateEditChecker)context.getChecker(ValidateEditChecker.class));
            }
            return new RefactoringStatus();
        }

        protected IFile[] getAllModifiedFiles() {
            return new IFile[0];
        }

        protected abstract String getDescriptionPlural();

        protected abstract String getDescriptionSingular();

        protected String getDestinationLabel() {
            IJavaElement destination = this.getJavaElementDestination();
            if (destination == null) {
                destination = this.getResourceDestination();
            }
            return JavaElementLabels.getTextLabel(destination, JavaElementLabels.ALL_FULLY_QUALIFIED);
        }

        protected abstract String getHeaderPatternSingular();

        protected abstract String getHeaderPatternPlural();

        @Override
        public final IJavaElement getJavaElementDestination() {
            if (!(this.fDestination instanceof ReorgDestinationFactory.JavaElementDestination)) {
                return null;
            }
            ReorgDestinationFactory.JavaElementDestination javaElementDestination = (ReorgDestinationFactory.JavaElementDestination)this.fDestination;
            return javaElementDestination.getJavaElement();
        }

        public final int getLocation() {
            return this.fDestination.getLocation();
        }

        protected RefactoringModifications getModifications() throws CoreException {
            return null;
        }

        protected abstract String getProcessorId();

        protected Map<String, String> getRefactoringArguments(String project) {
            HashMap<String, String> arguments = new HashMap<String, String>();
            IJavaElement element = this.getJavaElementDestination();
            if (element != null) {
                arguments.put(ATTRIBUTE_DESTINATION, JavaRefactoringDescriptorUtil.elementToHandle(project, element));
            } else {
                IResource resource = this.getResourceDestination();
                if (resource != null) {
                    arguments.put(ATTRIBUTE_TARGET, JavaRefactoringDescriptorUtil.resourceToHandle(null, resource));
                }
            }
            return arguments;
        }

        protected abstract String getRefactoringId();

        @Override
        public final IResource getResourceDestination() {
            if (!(this.fDestination instanceof ReorgDestinationFactory.ResourceDestination)) {
                return null;
            }
            ReorgDestinationFactory.ResourceDestination resourceDestination = (ReorgDestinationFactory.ResourceDestination)this.fDestination;
            return resourceDestination.getResource();
        }

        @Override
        public RefactoringStatus initialize(JavaRefactoringArguments arguments) {
            String handle = arguments.getAttribute(ATTRIBUTE_DESTINATION);
            if (handle != null) {
                IJavaElement element = JavaRefactoringDescriptorUtil.handleToElement(arguments.getProject(), handle, false);
                if (element != null) {
                    if (this.fCheckDestination && !element.exists()) {
                        return JavaRefactoringDescriptorUtil.createInputFatalStatus(element, this.getProcessorId(), this.getRefactoringId());
                    }
                    try {
                        IReorgDestination destination = ReorgDestinationFactory.createDestination(element);
                        this.setDestination(destination);
                        return this.verifyDestination(destination);
                    }
                    catch (JavaModelException exception) {
                        JavaPlugin.log(exception);
                        return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_illegal_argument, new String[]{handle, "input"}));
                    }
                }
                IResource resource = JavaRefactoringDescriptorUtil.handleToResource(arguments.getProject(), handle);
                if (resource == null || this.fCheckDestination && !resource.exists()) {
                    return JavaRefactoringDescriptorUtil.createInputFatalStatus(resource, this.getProcessorId(), this.getRefactoringId());
                }
                try {
                    IReorgDestination destination = ReorgDestinationFactory.createDestination(resource);
                    this.setDestination(destination);
                    return this.verifyDestination(destination);
                }
                catch (JavaModelException exception) {
                    JavaPlugin.log(exception);
                    return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_illegal_argument, new String[]{handle, "input"}));
                }
            }
            handle = arguments.getAttribute(ATTRIBUTE_TARGET);
            if (handle != null) {
                IResource resource = JavaRefactoringDescriptorUtil.handleToResource(arguments.getProject(), handle);
                if (resource == null || this.fCheckDestination && !resource.exists()) {
                    return JavaRefactoringDescriptorUtil.createInputFatalStatus(resource, this.getProcessorId(), this.getRefactoringId());
                }
                try {
                    IReorgDestination destination = ReorgDestinationFactory.createDestination(resource);
                    this.setDestination(destination);
                    return this.verifyDestination(destination);
                }
                catch (JavaModelException exception) {
                    JavaPlugin.log(exception);
                    return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_illegal_argument, new String[]{handle, "input"}));
                }
            }
            return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, "input"));
        }

        @Override
        public final RefactoringParticipant[] loadParticipants(RefactoringStatus status, RefactoringProcessor processor, String[] natures, SharableParticipants shared) throws CoreException {
            RefactoringModifications modifications = this.getModifications();
            if (modifications != null) {
                return modifications.loadParticipants(status, processor, natures, shared);
            }
            return new RefactoringParticipant[0];
        }

        @Override
        public final void setDestination(IReorgDestination destination) {
            this.fDestination = destination;
        }

        @Override
        public RefactoringStatus verifyDestination(IReorgDestination destination) throws JavaModelException {
            if (destination instanceof ReorgDestinationFactory.JavaElementDestination) {
                return this.verifyDestination(((ReorgDestinationFactory.JavaElementDestination)destination).getJavaElement());
            }
            if (destination instanceof ReorgDestinationFactory.ResourceDestination) {
                return this.verifyDestination(((ReorgDestinationFactory.ResourceDestination)destination).getResource());
            }
            return RefactoringStatus.createErrorStatus((String)RefactoringCoreMessages.ReorgPolicyFactory_invalidDestinationKind);
        }

        protected RefactoringStatus verifyDestination(IJavaElement destination) throws JavaModelException {
            return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ReorgPolicyFactory_no_java_element);
        }

        protected RefactoringStatus verifyDestination(IResource destination) throws JavaModelException {
            return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ReorgPolicyFactory_no_resource);
        }
    }

    private static abstract class SubCuElementReorgPolicy
    extends ReorgPolicy {
        private IJavaElement[] fJavaElements;

        protected static CompilationUnitChange createCompilationUnitChange(CompilationUnitRewrite rewrite) throws CoreException {
            CompilationUnitChange change = rewrite.createChange(true);
            if (change != null) {
                change.setSaveMode(1);
            }
            return change;
        }

        protected static final ICompilationUnit getEnclosingCompilationUnit(IJavaElement element) {
            if (element instanceof ICompilationUnit) {
                return (ICompilationUnit)element;
            }
            return (ICompilationUnit)element.getAncestor(5);
        }

        private static IType getEnclosingType(IJavaElement element) {
            if (element instanceof IType) {
                return (IType)element;
            }
            return (IType)element.getAncestor(7);
        }

        private static String getUnindentedSource(ISourceReference sourceReference) throws JavaModelException {
            String[] lines = Strings.convertIntoLines((String)sourceReference.getSource());
            IJavaProject project = ((IJavaElement)sourceReference).getJavaProject();
            Strings.trimIndentation((String[])lines, (IJavaProject)project, (boolean)false);
            return Strings.concatenate((String[])lines, (String)StubUtility.getLineDelimiterUsed((IJavaElement)sourceReference));
        }

        SubCuElementReorgPolicy(IJavaElement[] javaElements) {
            this.fJavaElements = javaElements;
        }

        @Override
        public boolean canChildrenBeDestinations(IResource resource) {
            return false;
        }

        @Override
        public boolean canElementBeDestination(IJavaElement javaElement) {
            return true;
        }

        @Override
        public boolean canEnable() throws JavaModelException {
            if (!super.canEnable() || this.fJavaElements.length == 0) {
                return false;
            }
            int i = 0;
            while (i < this.fJavaElements.length) {
                IMember member;
                if (this.fJavaElements[i] instanceof IMember && (member = (IMember)this.fJavaElements[i]).isBinary() && member.getSourceRange() == null) {
                    return false;
                }
                ++i;
            }
            return true;
        }

        @Override
        public int getSaveMode() {
            return 4;
        }

        private void copyImportsToDestination(IImportContainer container, ASTRewrite rewrite, CompilationUnit sourceCuNode, CompilationUnit destinationCuNode) throws JavaModelException {
            ListRewrite listRewrite = rewrite.getListRewrite((ASTNode)destinationCuNode, CompilationUnit.IMPORTS_PROPERTY);
            IJavaElement[] importDeclarations = container.getChildren();
            int i = 0;
            while (i < importDeclarations.length) {
                IImportDeclaration declaration = (IImportDeclaration)importDeclarations[i];
                ImportDeclaration sourceNode = ASTNodeSearchUtil.getImportDeclarationNode(declaration, sourceCuNode);
                ImportDeclaration copiedNode = (ImportDeclaration)ASTNode.copySubtree((AST)rewrite.getAST(), (ASTNode)sourceNode);
                if (this.getLocation() == 1) {
                    listRewrite.insertFirst((ASTNode)copiedNode, null);
                } else {
                    listRewrite.insertLast((ASTNode)copiedNode, null);
                }
                ++i;
            }
        }

        private void copyImportToDestination(IImportDeclaration declaration, ASTRewrite targetRewrite, CompilationUnit sourceCuNode, CompilationUnit destinationCuNode) throws JavaModelException {
            ImportDeclaration sourceNode = ASTNodeSearchUtil.getImportDeclarationNode(declaration, sourceCuNode);
            ImportDeclaration copiedNode = (ImportDeclaration)ASTNode.copySubtree((AST)targetRewrite.getAST(), (ASTNode)sourceNode);
            ListRewrite listRewrite = targetRewrite.getListRewrite((ASTNode)destinationCuNode, CompilationUnit.IMPORTS_PROPERTY);
            if (this.getJavaElementDestination() instanceof IImportDeclaration) {
                ImportDeclaration destinationNode = ASTNodeSearchUtil.getImportDeclarationNode((IImportDeclaration)this.getJavaElementDestination(), destinationCuNode);
                this.insertRelative((ASTNode)copiedNode, (ASTNode)destinationNode, listRewrite);
            } else {
                listRewrite.insertLast((ASTNode)copiedNode, null);
            }
        }

        private void copyInitializerToDestination(IInitializer initializer, CompilationUnitRewrite targetRewriter, CompilationUnit sourceCuNode, CompilationUnit targetCuNode) throws JavaModelException {
            BodyDeclaration newInitializer = (BodyDeclaration)targetRewriter.getASTRewrite().createStringPlaceholder(SubCuElementReorgPolicy.getUnindentedSource((ISourceReference)initializer), 28);
            this.copyMemberToDestination((IMember)initializer, targetRewriter, sourceCuNode, targetCuNode, newInitializer);
        }

        private void copyMemberToDestination(IMember member, CompilationUnitRewrite targetRewriter, CompilationUnit sourceCuNode, CompilationUnit targetCuNode, BodyDeclaration newMember) throws JavaModelException {
            BodyDeclaration decl;
            ListRewrite listRewrite;
            IJavaElement javaElementDestination = this.getJavaElementDestination();
            ASTNode nodeDestination = this.getDestinationNode(javaElementDestination, targetCuNode);
            ASTNode destinationContainer = this.getLocation() == 3 && (javaElementDestination instanceof IType || javaElementDestination instanceof ICompilationUnit) ? nodeDestination : nodeDestination.getParent();
            if (destinationContainer instanceof AbstractTypeDeclaration) {
                listRewrite = newMember instanceof EnumConstantDeclaration && destinationContainer instanceof EnumDeclaration ? targetRewriter.getASTRewrite().getListRewrite(destinationContainer, EnumDeclaration.ENUM_CONSTANTS_PROPERTY) : targetRewriter.getASTRewrite().getListRewrite(destinationContainer, ((AbstractTypeDeclaration)destinationContainer).getBodyDeclarationsProperty());
            } else if (destinationContainer instanceof CompilationUnit) {
                listRewrite = targetRewriter.getASTRewrite().getListRewrite(destinationContainer, CompilationUnit.TYPES_PROPERTY);
            } else if (destinationContainer instanceof Block) {
                listRewrite = targetRewriter.getASTRewrite().getListRewrite(destinationContainer, Block.STATEMENTS_PROPERTY);
            } else if (destinationContainer instanceof SwitchStatement) {
                listRewrite = targetRewriter.getASTRewrite().getListRewrite(destinationContainer, SwitchStatement.STATEMENTS_PROPERTY);
            } else if (destinationContainer instanceof AnonymousClassDeclaration) {
                listRewrite = targetRewriter.getASTRewrite().getListRewrite(destinationContainer, AnonymousClassDeclaration.BODY_DECLARATIONS_PROPERTY);
            } else {
                listRewrite = null;
                Assert.isLegal((boolean)false);
            }
            if (this.getLocation() == 3) {
                listRewrite.insertAt((ASTNode)newMember, BodyDeclarationRewrite.getInsertionIndex(newMember, listRewrite.getRewrittenList()), null);
            } else {
                this.insertRelative((ASTNode)newMember, nodeDestination, listRewrite);
            }
            if (!(member instanceof IInitializer) && (decl = ASTNodeSearchUtil.getBodyDeclarationNode(member, sourceCuNode)) != null) {
                ContextSensitiveImportRewriteContext context = new ContextSensitiveImportRewriteContext(destinationContainer, targetRewriter.getImportRewrite());
                ImportRewriteUtil.addImports(targetRewriter, context, (ASTNode)decl, new HashMap<Name, String>(), new HashMap<Name, String>(), false);
            }
        }

        private ASTNode getDestinationNode(IJavaElement destination, CompilationUnit target) throws JavaModelException {
            switch (destination.getElementType()) {
                case 10: {
                    return ASTNodeSearchUtil.getInitializerNode((IInitializer)destination, target);
                }
                case 8: {
                    return ASTNodeSearchUtil.getFieldOrEnumConstantDeclaration((IField)destination, target);
                }
                case 9: {
                    return ASTNodeSearchUtil.getMethodOrAnnotationTypeMemberDeclarationNode((IMethod)destination, target);
                }
                case 7: {
                    IType typeDestination = (IType)destination;
                    if (typeDestination.isAnonymous()) {
                        return ASTNodeSearchUtil.getClassInstanceCreationNode(typeDestination, target).getAnonymousClassDeclaration();
                    }
                    return ASTNodeSearchUtil.getAbstractTypeDeclarationNode(typeDestination, target);
                }
                case 5: {
                    IType mainType = JavaElementUtil.getMainType((ICompilationUnit)destination);
                    if (mainType == null) break;
                    return ASTNodeSearchUtil.getAbstractTypeDeclarationNode(mainType, target);
                }
            }
            return null;
        }

        private void insertRelative(ASTNode newNode, ASTNode relativeNode, ListRewrite listRewrite) {
            List list = listRewrite.getOriginalList();
            int index = list.indexOf(relativeNode);
            if (this.getLocation() == 1) {
                listRewrite.insertBefore(newNode, (ASTNode)list.get(index), null);
            } else if (index + 1 < list.size()) {
                listRewrite.insertBefore(newNode, (ASTNode)list.get(index + 1), null);
            } else {
                listRewrite.insertLast(newNode, null);
            }
        }

        private void copyMethodToDestination(IMethod method, CompilationUnitRewrite targetRewriter, CompilationUnit sourceCuNode, CompilationUnit targetCuNode) throws JavaModelException {
            MethodDeclaration newMethod = (MethodDeclaration)targetRewriter.getASTRewrite().createStringPlaceholder(SubCuElementReorgPolicy.getUnindentedSource((ISourceReference)method), 31);
            newMethod.setConstructor(method.isConstructor());
            this.copyMemberToDestination((IMember)method, targetRewriter, sourceCuNode, targetCuNode, (BodyDeclaration)newMethod);
        }

        private void copyPackageDeclarationToDestination(IPackageDeclaration declaration, ASTRewrite targetRewrite, CompilationUnit sourceCuNode, CompilationUnit destinationCuNode) throws JavaModelException {
            if (destinationCuNode.getPackage() != null) {
                return;
            }
            PackageDeclaration sourceNode = ASTNodeSearchUtil.getPackageDeclarationNode(declaration, sourceCuNode);
            PackageDeclaration copiedNode = (PackageDeclaration)ASTNode.copySubtree((AST)targetRewrite.getAST(), (ASTNode)sourceNode);
            targetRewrite.set((ASTNode)destinationCuNode, (StructuralPropertyDescriptor)CompilationUnit.PACKAGE_PROPERTY, (Object)copiedNode, null);
        }

        protected void copyToDestination(IJavaElement element, CompilationUnitRewrite targetRewriter, CompilationUnit sourceCuNode, CompilationUnit targetCuNode) throws CoreException {
            ASTRewrite rewrite = targetRewriter.getASTRewrite();
            switch (element.getElementType()) {
                case 8: {
                    this.copyMemberToDestination((IMember)element, targetRewriter, sourceCuNode, targetCuNode, this.createNewFieldDeclarationNode((IField)element, rewrite, sourceCuNode));
                    break;
                }
                case 12: {
                    this.copyImportsToDestination((IImportContainer)element, rewrite, sourceCuNode, targetCuNode);
                    break;
                }
                case 13: {
                    this.copyImportToDestination((IImportDeclaration)element, rewrite, sourceCuNode, targetCuNode);
                    break;
                }
                case 10: {
                    this.copyInitializerToDestination((IInitializer)element, targetRewriter, sourceCuNode, targetCuNode);
                    break;
                }
                case 9: {
                    this.copyMethodToDestination((IMethod)element, targetRewriter, sourceCuNode, targetCuNode);
                    break;
                }
                case 11: {
                    this.copyPackageDeclarationToDestination((IPackageDeclaration)element, rewrite, sourceCuNode, targetCuNode);
                    break;
                }
                case 7: {
                    this.copyTypeToDestination((IType)element, targetRewriter, sourceCuNode, targetCuNode);
                    break;
                }
                default: {
                    Assert.isTrue((boolean)false);
                }
            }
        }

        private void copyTypeToDestination(IType type, CompilationUnitRewrite targetRewriter, CompilationUnit sourceCuNode, CompilationUnit targetCuNode) throws JavaModelException {
            AbstractTypeDeclaration newType = (AbstractTypeDeclaration)targetRewriter.getASTRewrite().createStringPlaceholder(SubCuElementReorgPolicy.getUnindentedSource((ISourceReference)type), 55);
            IType enclosingType = SubCuElementReorgPolicy.getEnclosingType(this.getJavaElementDestination());
            if (enclosingType != null) {
                this.copyMemberToDestination((IMember)type, targetRewriter, sourceCuNode, targetCuNode, (BodyDeclaration)newType);
            } else {
                targetRewriter.getASTRewrite().getListRewrite((ASTNode)targetCuNode, CompilationUnit.TYPES_PROPERTY).insertLast((ASTNode)newType, null);
            }
        }

        private BodyDeclaration createNewFieldDeclarationNode(IField field, ASTRewrite rewrite, CompilationUnit sourceCuNode) throws CoreException {
            AST targetAst = rewrite.getAST();
            FieldDeclaration newDeclaration = null;
            BodyDeclaration bodyDeclaration = ASTNodeSearchUtil.getFieldOrEnumConstantDeclaration(field, sourceCuNode);
            if (bodyDeclaration instanceof FieldDeclaration) {
                FieldDeclaration fieldDeclaration = (FieldDeclaration)bodyDeclaration;
                if (fieldDeclaration.fragments().size() == 1) {
                    return (FieldDeclaration)rewrite.createStringPlaceholder(SubCuElementReorgPolicy.getUnindentedSource((ISourceReference)field), 23);
                }
                VariableDeclarationFragment originalFragment = ASTNodeSearchUtil.getFieldDeclarationFragmentNode(field, sourceCuNode);
                VariableDeclarationFragment copiedFragment = (VariableDeclarationFragment)ASTNode.copySubtree((AST)targetAst, (ASTNode)originalFragment);
                newDeclaration = targetAst.newFieldDeclaration(copiedFragment);
                newDeclaration.setType((Type)ASTNode.copySubtree((AST)targetAst, (ASTNode)fieldDeclaration.getType()));
            } else if (bodyDeclaration instanceof EnumConstantDeclaration) {
                String content;
                EnumConstantDeclaration constantDeclaration = (EnumConstantDeclaration)bodyDeclaration;
                EnumConstantDeclaration newConstDeclaration = targetAst.newEnumConstantDeclaration();
                newConstDeclaration.setName((SimpleName)ASTNode.copySubtree((AST)targetAst, (ASTNode)constantDeclaration.getName()));
                AnonymousClassDeclaration anonymousDeclaration = constantDeclaration.getAnonymousClassDeclaration();
                if (anonymousDeclaration != null && (content = ASTNodes.getNodeSource((ASTNode)anonymousDeclaration, (boolean)false, (boolean)true)) != null) {
                    newConstDeclaration.setAnonymousClassDeclaration((AnonymousClassDeclaration)rewrite.createStringPlaceholder(content, 1));
                }
                newDeclaration = newConstDeclaration;
            } else {
                Assert.isTrue((boolean)false);
            }
            if (newDeclaration != null) {
                String content;
                newDeclaration.modifiers().addAll(ASTNodeFactory.newModifiers(targetAst, bodyDeclaration.getModifiers()));
                Javadoc javadoc = bodyDeclaration.getJavadoc();
                if (javadoc != null && (content = ASTNodes.getNodeSource((ASTNode)javadoc, (boolean)false, (boolean)true)) != null) {
                    newDeclaration.setJavadoc((Javadoc)rewrite.createStringPlaceholder(content, 29));
                }
            }
            return newDeclaration;
        }

        protected abstract JavaRefactoringDescriptor createRefactoringDescriptor(JDTRefactoringDescriptorComment var1, Map<String, String> var2, String var3, String var4, int var5);

        @Override
        public final ChangeDescriptor getDescriptor() {
            HashMap<String, String> arguments = new HashMap<String, String>();
            int length = this.fJavaElements.length;
            String description = length == 1 ? this.getDescriptionSingular() : this.getDescriptionPlural();
            IProject resource = this.getSingleProject();
            String project = resource != null ? resource.getName() : null;
            String header = length == 1 ? Messages.format(this.getHeaderPatternSingular(), new String[]{JavaElementLabels.getTextLabel(this.fJavaElements[0].getElementName(), JavaElementLabels.ALL_FULLY_QUALIFIED), this.getDestinationLabel()}) : Messages.format(this.getHeaderPatternPlural(), new String[]{String.valueOf(length), this.getDestinationLabel()});
            int flags = 589830;
            JDTRefactoringDescriptorComment comment = new JDTRefactoringDescriptorComment(project, this, header);
            arguments.put(ReorgPolicyFactory.ATTRIBUTE_POLICY, this.getPolicyId());
            arguments.put(ReorgPolicyFactory.ATTRIBUTE_MEMBERS, new Integer(this.fJavaElements.length).toString());
            int offset = 0;
            while (offset < this.fJavaElements.length) {
                arguments.put("element" + (offset + 1), JavaRefactoringDescriptorUtil.elementToHandle(project, this.fJavaElements[offset]));
                ++offset;
            }
            arguments.putAll(this.getRefactoringArguments(project));
            JavaRefactoringDescriptor descriptor = this.createRefactoringDescriptor(comment, arguments, description, project, flags);
            return new RefactoringChangeDescriptor((RefactoringDescriptor)descriptor);
        }

        @Override
        public final IJavaElement[] getJavaElements() {
            return this.fJavaElements;
        }

        @Override
        public final IResource[] getResources() {
            return new IResource[0];
        }

        private IProject getSingleProject() {
            IProject result = null;
            int index = 0;
            while (index < this.fJavaElements.length) {
                if (result == null) {
                    result = this.fJavaElements[index].getJavaProject().getProject();
                } else if (!result.equals((Object)this.fJavaElements[index].getJavaProject().getProject())) {
                    return null;
                }
                ++index;
            }
            return result;
        }

        protected final ICompilationUnit getSourceCu() {
            return SubCuElementReorgPolicy.getEnclosingCompilationUnit(this.fJavaElements[0]);
        }

        @Override
        public RefactoringStatus initialize(JavaRefactoringArguments arguments) {
            RefactoringStatus status = new RefactoringStatus();
            int memberCount = 0;
            String value = arguments.getAttribute(ReorgPolicyFactory.ATTRIBUTE_MEMBERS);
            if (value != null && !"".equals(value)) {
                try {
                    memberCount = Integer.parseInt(value);
                }
                catch (NumberFormatException numberFormatException) {
                    return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, ReorgPolicyFactory.ATTRIBUTE_MEMBERS));
                }
            } else {
                return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, ReorgPolicyFactory.ATTRIBUTE_MEMBERS));
            }
            String handle = null;
            ArrayList<IJavaElement> elements = new ArrayList<IJavaElement>();
            int index = 0;
            while (index < memberCount) {
                String attribute = "element" + (index + 1);
                handle = arguments.getAttribute(attribute);
                if (handle != null && !"".equals(handle)) {
                    IJavaElement element = JavaRefactoringDescriptorUtil.handleToElement(arguments.getProject(), handle, false);
                    if (element == null || !element.exists()) {
                        status.merge(JavaRefactoringDescriptorUtil.createInputWarningStatus(element, this.getProcessorId(), this.getRefactoringId()));
                    } else {
                        elements.add(element);
                    }
                } else {
                    return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, attribute));
                }
                ++index;
            }
            this.fJavaElements = elements.toArray(new IJavaElement[elements.size()]);
            status.merge(super.initialize(arguments));
            return status;
        }

        protected RefactoringStatus verifyDestination(IJavaElement destination, int location) throws JavaModelException {
            Assert.isNotNull((Object)destination);
            if (!this.fCheckDestination) {
                return new RefactoringStatus();
            }
            if (!destination.exists()) {
                return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ReorgPolicyFactory_doesnotexist1);
            }
            if (destination instanceof IJavaModel) {
                return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ReorgPolicyFactory_jmodel);
            }
            if (!(destination instanceof ICompilationUnit) && !ReorgUtils.isInsideCompilationUnit(destination)) {
                return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ReorgPolicyFactory_cannot);
            }
            ICompilationUnit destinationCu = SubCuElementReorgPolicy.getEnclosingCompilationUnit(destination);
            Assert.isNotNull((Object)destinationCu);
            if (destinationCu.isReadOnly()) {
                return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ReorgPolicyFactory_cannot_modify);
            }
            switch (destination.getElementType()) {
                case 5: {
                    if (location != 3) {
                        return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ReorgPolicyFactory_cannot);
                    }
                    int[] types0 = new int[]{7, 11, 12, 13};
                    if (ReorgUtils.hasOnlyElementsOfType(this.getJavaElements(), types0) || JavaElementUtil.getMainType(destinationCu) != null && ReorgUtils.hasOnlyElementsOfType(this.getJavaElements(), new int[]{8, 10, 9, 7})) break;
                    return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ReorgPolicyFactory_cannot);
                }
                case 11: {
                    return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ReorgPolicyFactory_package_decl);
                }
                case 12: {
                    if (!(location == 3 ? ReorgUtils.hasElementsNotOfType(this.getJavaElements(), 13) : ReorgUtils.hasElementsNotOfType(this.getJavaElements(), 12))) break;
                    return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ReorgPolicyFactory_cannot);
                }
                case 13: {
                    if (location == 3) {
                        return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ReorgPolicyFactory_cannot);
                    }
                    if (!ReorgUtils.hasElementsNotOfType(this.getJavaElements(), 13)) break;
                    return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ReorgPolicyFactory_cannot);
                }
                case 8: 
                case 9: 
                case 10: {
                    if (location == 3) {
                        if (this.getJavaElements().length != 1) {
                            return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ReorgPolicyFactory_cannot);
                        }
                        if (destination.equals(this.getJavaElements()[0])) break;
                        return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ReorgPolicyFactory_cannot);
                    }
                    int[] types = new int[]{8, 10, 9, 7};
                    if (ReorgUtils.hasOnlyElementsOfType(this.getJavaElements(), types)) break;
                    return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ReorgPolicyFactory_cannot);
                }
                case 7: {
                    if (location == 3) {
                        int[] types1 = new int[]{8, 10, 9, 7};
                        if (ReorgUtils.hasOnlyElementsOfType(this.getJavaElements(), types1)) break;
                        return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ReorgPolicyFactory_cannot);
                    }
                    if (destination.getParent() instanceof IMethod) {
                        return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ReorgPolicyFactory_cannot);
                    }
                    int[] types = new int[]{8, 10, 9, 7};
                    if (ReorgUtils.hasOnlyElementsOfType(this.getJavaElements(), types)) break;
                    return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ReorgPolicyFactory_cannot);
                }
            }
            return new RefactoringStatus();
        }

        @Override
        public RefactoringStatus verifyDestination(IReorgDestination destination) throws JavaModelException {
            if (!(destination instanceof ReorgDestinationFactory.JavaElementDestination)) {
                return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ReorgPolicyFactory_invalidDestinationKind);
            }
            ReorgDestinationFactory.JavaElementDestination javaElementDestination = (ReorgDestinationFactory.JavaElementDestination)destination;
            return this.verifyDestination(javaElementDestination.getJavaElement(), javaElementDestination.getLocation());
        }
    }
}

