/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.monitoring;

import java.util.ArrayList;
import org.eclipse.fordiac.ide.deployment.ui.views.DownloadSelectionTreeView;
import org.eclipse.fordiac.ide.model.libraryElement.AutomationSystem;
import org.eclipse.fordiac.ide.monitoring.Activator;
import org.eclipse.fordiac.ide.monitoring.MonitoringManager;
import org.eclipse.fordiac.ide.systemmanagement.SystemManager;
import org.eclipse.jface.action.ContributionItem;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.actions.CompoundContributionItem;
import org.eclipse.ui.navigator.CommonNavigator;

public class MonitoredSystems
extends CompoundContributionItem {
    protected IContributionItem[] getContributionItems() {
        ArrayList<MonitorSystemContribution> menuList = new ArrayList<MonitorSystemContribution>();
        for (AutomationSystem system : SystemManager.INSTANCE.getSystems()) {
            menuList.add(new MonitorSystemContribution(system));
        }
        return menuList.toArray(new IContributionItem[menuList.size()]);
    }

    private static void createSystemMonitoringMenuEntry(AutomationSystem system, Menu menu, int index) {
        MenuItem item = new MenuItem(menu, 32);
        item.setText(system.getName());
        MonitoringManager manager = MonitoringManager.getInstance();
        item.setSelection(manager.monitoringForSystemEnabled(system));
        item.addSelectionListener((SelectionListener)new SystemMonitoringSelectionAdapter(system));
    }

    public static void createMenuEntriesForSystems(Menu menu) {
        for (AutomationSystem system : SystemManager.INSTANCE.getSystems()) {
            MonitoredSystems.createSystemMonitoringMenuEntry(system, menu, -1);
        }
    }

    public static void refreshSystemTree() {
        CommonNavigator treeView;
        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        IViewPart view = page.findView("org.eclipse.fordiac.ide.systemmanagement.ui.systemexplorer");
        if (view != null && view instanceof CommonNavigator) {
            treeView = (CommonNavigator)view;
            treeView.getCommonViewer().refresh();
        }
        if ((view = page.findView("org.eclipse.fordiac.ide.deployment.ui.views.DownloadSelectionTreeView")) != null && view instanceof DownloadSelectionTreeView) {
            treeView = (DownloadSelectionTreeView)view;
            treeView.getViewer().refresh();
        }
    }

    private static class MonitorSystemContribution
    extends ContributionItem {
        private final AutomationSystem system;

        MonitorSystemContribution(AutomationSystem system) {
            this.system = system;
        }

        public void fill(Menu menu, int index) {
            MonitoredSystems.createSystemMonitoringMenuEntry(this.system, menu, index);
        }
    }

    private static final class SystemMonitoringSelectionAdapter
    extends SelectionAdapter {
        private final AutomationSystem system;

        private SystemMonitoringSelectionAdapter(AutomationSystem system) {
            this.system = system;
        }

        public void widgetSelected(SelectionEvent e) {
            MenuItem menuItem = (MenuItem)e.getSource();
            MonitoringManager manager = MonitoringManager.getInstance();
            if (menuItem.getSelection()) {
                manager.enableSystem(this.system.getName());
                IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                try {
                    window.getWorkbench().showPerspective("org.eclipse.fordiac.ide.monitoring.MonitoringPerspective", window);
                }
                catch (WorkbenchException e1) {
                    Activator.getDefault().logError(e1.getMessage(), (Exception)((Object)e1));
                }
            } else {
                manager.disableSystem(this.system.getName());
            }
            MonitoredSystems.refreshSystemTree();
        }
    }
}

