/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model.monitoring.impl;

import java.util.ArrayList;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.fordiac.ide.model.monitoring.MonitoringElement;
import org.eclipse.fordiac.ide.model.monitoring.MonitoringPackage;
import org.eclipse.fordiac.ide.model.monitoring.impl.MonitoringBaseElementImpl;
import org.eclipse.fordiac.ide.monitoring.editparts.MonitoringEditPart;
import org.eclipse.gef.EditPart;

public class MonitoringElementImpl
extends MonitoringBaseElementImpl
implements MonitoringElement {
    protected static final boolean FORCE_EDEFAULT = false;
    protected boolean force = false;
    protected static final String FORCE_VALUE_EDEFAULT = null;
    protected String forceValue = FORCE_VALUE_EDEFAULT;
    protected static final boolean BREAKPOINT_EDEFAULT = false;
    protected boolean breakpoint = false;
    protected static final boolean BREAKPOINT_ACTIVE_EDEFAULT = false;
    protected boolean breakpointActive = false;
    protected static final String BREAKPOINT_CONDITION_EDEFAULT = null;
    protected String breakpointCondition = BREAKPOINT_CONDITION_EDEFAULT;
    protected static final String CURRENT_VALUE_EDEFAULT = null;
    protected String currentValue = CURRENT_VALUE_EDEFAULT;
    protected static final long SEC_EDEFAULT = 0L;
    protected long sec = 0L;
    protected static final long USEC_EDEFAULT = 0L;
    protected long usec = 0L;
    private int nrOfHistory = 120;
    private ArrayList<String> historyValues = new ArrayList(120);
    private ArrayList<Long> historySec = new ArrayList(120);
    private ArrayList<Long> historyUSec = new ArrayList(120);
    private int currentInt = 0;

    protected MonitoringElementImpl() {
    }

    @Override
    protected EClass eStaticClass() {
        return MonitoringPackage.Literals.MONITORING_ELEMENT;
    }

    @Override
    public boolean isForce() {
        return this.force;
    }

    @Override
    public void setForce(boolean newForce) {
        boolean oldForce = this.force;
        this.force = newForce;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 2, oldForce, this.force));
        }
    }

    @Override
    public String getForceValue() {
        return this.forceValue;
    }

    @Override
    public void setForceValue(String newForceValue) {
        String oldForceValue = this.forceValue;
        this.forceValue = newForceValue;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 3, (Object)oldForceValue, (Object)this.forceValue));
        }
    }

    @Override
    public boolean isBreakpoint() {
        return this.breakpoint;
    }

    @Override
    public void setBreakpoint(boolean newBreakpoint) {
        boolean oldBreakpoint = this.breakpoint;
        this.breakpoint = newBreakpoint;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 4, oldBreakpoint, this.breakpoint));
        }
    }

    @Override
    public boolean isBreakpointActive() {
        return this.breakpointActive;
    }

    @Override
    public void setBreakpointActive(boolean newBreakpointActive) {
        if (this.breakpointActive != newBreakpointActive) {
            boolean oldBreakpointActive = this.breakpointActive;
            this.breakpointActive = newBreakpointActive;
            if (this.eNotificationRequired()) {
                this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 5, oldBreakpointActive, this.breakpointActive));
            }
        }
    }

    @Override
    public String getBreakpointCondition() {
        return this.breakpointCondition;
    }

    @Override
    public void setBreakpointCondition(String newBreakpointCondition) {
        String oldBreakpointCondition = this.breakpointCondition;
        this.breakpointCondition = newBreakpointCondition;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 6, (Object)oldBreakpointCondition, (Object)this.breakpointCondition));
        }
    }

    @Override
    public String getCurrentValue() {
        return this.currentValue == null ? "N/A" : this.currentValue;
    }

    @Override
    public void setCurrentValue(String newCurrentValue) {
        if (this.currentValue == null || this.currentValue != null && !this.currentValue.equals(newCurrentValue)) {
            String oldCurrentValue = this.currentValue;
            this.currentValue = newCurrentValue;
            if (this.eNotificationRequired()) {
                this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 7, (Object)oldCurrentValue, (Object)this.currentValue));
            }
        }
        this.historyValues.add(this.currentInt % this.nrOfHistory, newCurrentValue);
        this.historySec.add(this.currentInt % this.nrOfHistory, this.getSec());
        this.historyUSec.add(this.currentInt % this.nrOfHistory, this.getUsec());
        ++this.currentInt;
    }

    @Override
    public long getSec() {
        return this.sec;
    }

    @Override
    public void setSec(long newSec) {
        long oldSec = this.sec;
        this.sec = newSec;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 8, oldSec, this.sec));
        }
    }

    @Override
    public long getUsec() {
        return this.usec;
    }

    @Override
    public void setUsec(long newUsec) {
        long oldUsec = this.usec;
        this.usec = newUsec;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 9, oldUsec, this.usec));
        }
    }

    @Override
    public void forceValue(String value) {
        if (value != null && !value.equals("")) {
            this.setForce(true);
            this.setForceValue(value);
        } else {
            this.setForce(false);
            this.setForceValue(null);
        }
    }

    @Override
    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 2: {
                return this.isForce();
            }
            case 3: {
                return this.getForceValue();
            }
            case 4: {
                return this.isBreakpoint();
            }
            case 5: {
                return this.isBreakpointActive();
            }
            case 6: {
                return this.getBreakpointCondition();
            }
            case 7: {
                return this.getCurrentValue();
            }
            case 8: {
                return this.getSec();
            }
            case 9: {
                return this.getUsec();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    @Override
    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 2: {
                this.setForce((Boolean)newValue);
                return;
            }
            case 3: {
                this.setForceValue((String)newValue);
                return;
            }
            case 4: {
                this.setBreakpoint((Boolean)newValue);
                return;
            }
            case 5: {
                this.setBreakpointActive((Boolean)newValue);
                return;
            }
            case 6: {
                this.setBreakpointCondition((String)newValue);
                return;
            }
            case 7: {
                this.setCurrentValue((String)newValue);
                return;
            }
            case 8: {
                this.setSec((Long)newValue);
                return;
            }
            case 9: {
                this.setUsec((Long)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    @Override
    public void eUnset(int featureID) {
        switch (featureID) {
            case 2: {
                this.setForce(false);
                return;
            }
            case 3: {
                this.setForceValue(FORCE_VALUE_EDEFAULT);
                return;
            }
            case 4: {
                this.setBreakpoint(false);
                return;
            }
            case 5: {
                this.setBreakpointActive(false);
                return;
            }
            case 6: {
                this.setBreakpointCondition(BREAKPOINT_CONDITION_EDEFAULT);
                return;
            }
            case 7: {
                this.setCurrentValue(CURRENT_VALUE_EDEFAULT);
                return;
            }
            case 8: {
                this.setSec(0L);
                return;
            }
            case 9: {
                this.setUsec(0L);
                return;
            }
        }
        super.eUnset(featureID);
    }

    @Override
    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 2: {
                return this.force;
            }
            case 3: {
                return FORCE_VALUE_EDEFAULT == null ? this.forceValue != null : !FORCE_VALUE_EDEFAULT.equals(this.forceValue);
            }
            case 4: {
                return this.breakpoint;
            }
            case 5: {
                return this.breakpointActive;
            }
            case 6: {
                return BREAKPOINT_CONDITION_EDEFAULT == null ? this.breakpointCondition != null : !BREAKPOINT_CONDITION_EDEFAULT.equals(this.breakpointCondition);
            }
            case 7: {
                return CURRENT_VALUE_EDEFAULT == null ? this.currentValue != null : !CURRENT_VALUE_EDEFAULT.equals(this.currentValue);
            }
            case 8: {
                return this.sec != 0L;
            }
            case 9: {
                return this.usec != 0L;
            }
        }
        return super.eIsSet(featureID);
    }

    @Override
    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (force: ");
        result.append(this.force);
        result.append(", forceValue: ");
        result.append(this.forceValue);
        result.append(", breakpoint: ");
        result.append(this.breakpoint);
        result.append(", breakpointActive: ");
        result.append(this.breakpointActive);
        result.append(", breakpointCondition: ");
        result.append(this.breakpointCondition);
        result.append(", currentValue: ");
        result.append(this.currentValue);
        result.append(", sec: ");
        result.append(this.sec);
        result.append(", usec: ");
        result.append(this.usec);
        result.append(')');
        return result.toString();
    }

    @Override
    public int getCurrentPos() {
        return this.currentInt;
    }

    @Override
    public long getHistorySec(int pos) {
        if (pos >= this.historySec.size()) {
            return 0L;
        }
        return this.historySec.get(pos);
    }

    @Override
    public long getHistoryUSec(int pos) {
        if (pos >= this.historyUSec.size()) {
            return 0L;
        }
        return this.historyUSec.get(pos);
    }

    @Override
    public String getHistoryValue(int pos, boolean time) {
        if (pos >= this.historyValues.size()) {
            return "No Data available";
        }
        if (time) {
            return this.historyValues.get(pos);
        }
        return this.historyValues.get(pos);
    }

    public EditPart createEditPart() {
        return new MonitoringEditPart();
    }
}

