/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.gef.editparts;

import java.util.ArrayList;
import org.eclipse.core.commands.IHandler;
import org.eclipse.draw2d.ConnectionLayer;
import org.eclipse.draw2d.FreeformLayer;
import org.eclipse.draw2d.FreeformLayeredPane;
import org.eclipse.draw2d.FreeformLayout;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayeredPane;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.gef.editparts.GridLayer;
import org.eclipse.gef.editparts.ScalableFreeformRootEditPart;
import org.eclipse.gef.editparts.ZoomManager;
import org.eclipse.gef.ui.actions.ActionRegistry;
import org.eclipse.gef.ui.actions.ZoomInAction;
import org.eclipse.gef.ui.actions.ZoomOutAction;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.commands.ActionHandler;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.handlers.IHandlerService;

public class ZoomScalableFreeformRootEditPart
extends ScalableFreeformRootEditPart {
    public static final String TOPLAYER = "TOPLAYER";
    private static final float[] GRID_DASHES_STYLE = new float[]{1.0f, 5.0f};
    private ConnectionLayer connectionLayer;

    public ZoomScalableFreeformRootEditPart(IWorkbenchPartSite site, ActionRegistry actionRegistry) {
        this.configureZoomManger();
        this.setupZoomActions(site, actionRegistry);
    }

    protected LayeredPane createPrintableLayers() {
        FreeformLayeredPane layeredPane = new FreeformLayeredPane();
        layeredPane.add((IFigure)new FreeformLayer(), (Object)"Primary Layer");
        this.connectionLayer = new ConnectionLayer();
        layeredPane.add((IFigure)this.connectionLayer, (Object)"Connection Layer");
        FreeformLayer topLayer = new FreeformLayer();
        topLayer.setLayoutManager((LayoutManager)new FreeformLayout());
        layeredPane.add((IFigure)topLayer, (Object)TOPLAYER);
        return layeredPane;
    }

    protected GridLayer createGridLayer() {
        return new GridLayer(){

            protected void paintGrid(Graphics g) {
                int origLineStyle = g.getLineStyle();
                g.setLineStyle(6);
                g.setLineDash(GRID_DASHES_STYLE);
                super.paintGrid(g);
                g.setLineStyle(origLineStyle);
            }
        };
    }

    private void configureZoomManger() {
        ArrayList<String> zoomLevels = new ArrayList<String>(3);
        zoomLevels.add(ZoomManager.FIT_ALL);
        zoomLevels.add(ZoomManager.FIT_WIDTH);
        zoomLevels.add(ZoomManager.FIT_HEIGHT);
        this.getZoomManager().setZoomLevelContributions(zoomLevels);
        this.getZoomManager().setZoomLevels(new double[]{0.25, 0.5, 0.75, 0.8, 0.85, 0.9, 1.0, 1.5, 2.0, 2.5, 3.0, 4.0});
        this.getZoomManager().setZoomAnimationStyle(1);
    }

    private void setupZoomActions(IWorkbenchPartSite site, ActionRegistry actionRegistry) {
        ZoomInAction zoomIn = new ZoomInAction(this.getZoomManager());
        ZoomOutAction zoomOut = new ZoomOutAction(this.getZoomManager());
        actionRegistry.registerAction((IAction)zoomIn);
        actionRegistry.registerAction((IAction)zoomOut);
        IHandlerService zoomInService = (IHandlerService)site.getService(IHandlerService.class);
        zoomInService.activateHandler(zoomIn.getActionDefinitionId(), (IHandler)new ActionHandler((IAction)zoomIn));
        IHandlerService zoomOutService = (IHandlerService)site.getService(IHandlerService.class);
        zoomOutService.activateHandler(zoomOut.getActionDefinitionId(), (IHandler)new ActionHandler((IAction)zoomOut));
    }
}

