/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.deployment.ui.views;

import java.io.ByteArrayOutputStream;
import java.io.StringReader;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.fordiac.ide.deployment.DeploymentCoordinator;
import org.eclipse.fordiac.ide.deployment.ui.Messages;
import org.eclipse.fordiac.ide.deployment.ui.views.AnnotationMarkerAccess;
import org.eclipse.fordiac.ide.deployment.ui.views.ErrorAnnotation;
import org.eclipse.fordiac.ide.deployment.ui.views.LogListener;
import org.eclipse.fordiac.ide.deployment.ui.xml.XMLConfiguration;
import org.eclipse.fordiac.ide.deployment.ui.xml.XMLPartitionScanner;
import org.eclipse.fordiac.ide.deployment.util.IDeploymentListener;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.text.DefaultInformationControl;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.IPainter;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextHover;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.rules.FastPartitioner;
import org.eclipse.jface.text.rules.IPartitionTokenScanner;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.AnnotationBarHoverManager;
import org.eclipse.jface.text.source.AnnotationModel;
import org.eclipse.jface.text.source.AnnotationPainter;
import org.eclipse.jface.text.source.AnnotationRulerColumn;
import org.eclipse.jface.text.source.CompositeRuler;
import org.eclipse.jface.text.source.IAnnotationAccess;
import org.eclipse.jface.text.source.IAnnotationHover;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.IOverviewRuler;
import org.eclipse.jface.text.source.ISharedTextColors;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.jface.text.source.IVerticalRulerColumn;
import org.eclipse.jface.text.source.IVerticalRulerInfo;
import org.eclipse.jface.text.source.OverviewRuler;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;
import org.xml.sax.InputSource;

public class Output
extends ViewPart
implements IDeploymentListener {
    private SourceViewer sv;
    private CompositeRuler compositeRuler;
    private OverviewRuler overviewRuler;
    private AnnotationPainter ap;
    private static String ERROR_TYPE = Messages.Output_DownloadError;
    private static String WARNING_TYPE = Messages.Output_DownloadWarning;
    protected AnnotationModel fAnnotationModel = new AnnotationModel();
    private StringBuffer buffer = new StringBuffer();

    public void createPartControl(Composite parent) {
        Composite root = new Composite(parent, 0);
        root.setLayout((Layout)new GridLayout());
        this.createSourceViewer(root);
        this.contributeToActionBars();
        DeploymentCoordinator.getInstance().addDeploymentListener((IDeploymentListener)this);
    }

    private void contributeToActionBars() {
        IActionBars bars = this.getViewSite().getActionBars();
        this.fillLocalToolBar(bars.getToolBarManager());
    }

    private void fillLocalToolBar(IToolBarManager manager) {
        Action clearAction = new Action(Messages.Output_ClearActionLabel){

            public void run() {
                Output.this.clearOutput();
            }
        };
        clearAction.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_ETOOL_CLEAR"));
        clearAction.setToolTipText(Messages.Output_ClearTooltip);
        clearAction.setDescription(Messages.Output_ClearDescription);
        manager.add((IAction)clearAction);
    }

    private void createSourceViewer(Composite parent) {
        AnnotationMarkerAccess annotationMarker = new AnnotationMarkerAccess();
        ColorCache colorCache = new ColorCache();
        this.compositeRuler = new CompositeRuler();
        this.overviewRuler = new OverviewRuler((IAnnotationAccess)annotationMarker, 12, (ISharedTextColors)colorCache);
        AnnotationRulerColumn annotationRuler = new AnnotationRulerColumn((IAnnotationModel)this.fAnnotationModel, 16, (IAnnotationAccess)annotationMarker);
        this.compositeRuler.setModel((IAnnotationModel)this.fAnnotationModel);
        this.overviewRuler.setModel((IAnnotationModel)this.fAnnotationModel);
        this.compositeRuler.addDecorator(0, (IVerticalRulerColumn)annotationRuler);
        annotationRuler.addAnnotationType((Object)ERROR_TYPE);
        annotationRuler.addAnnotationType((Object)WARNING_TYPE);
        this.overviewRuler.addAnnotationType((Object)ERROR_TYPE);
        this.overviewRuler.addAnnotationType((Object)WARNING_TYPE);
        this.overviewRuler.addHeaderAnnotationType((Object)ERROR_TYPE);
        this.overviewRuler.addHeaderAnnotationType((Object)WARNING_TYPE);
        this.overviewRuler.setAnnotationTypeLayer((Object)ERROR_TYPE, 3);
        this.overviewRuler.setAnnotationTypeLayer((Object)WARNING_TYPE, 4);
        this.overviewRuler.setAnnotationTypeColor((Object)ERROR_TYPE, colorCache.getColor(new RGB(255, 0, 0)));
        this.overviewRuler.setAnnotationTypeColor((Object)WARNING_TYPE, colorCache.getColor(new RGB(255, 255, 0)));
        this.sv = new SourceViewer(parent, (IVerticalRuler)this.compositeRuler, (IOverviewRuler)this.overviewRuler, true, 770);
        GridData gd = new GridData(4, 4, true, true);
        this.sv.getControl().setLayoutData((Object)gd);
        Document document = new Document();
        this.sv.setDocument((IDocument)document);
        this.sv.setEditable(false);
        document.addDocumentListener((IDocumentListener)new LogListener(this.fAnnotationModel));
        if (document != null) {
            FastPartitioner partitioner = new FastPartitioner((IPartitionTokenScanner)new XMLPartitionScanner(), new String[]{"__xml_tag", "__xml_comment"});
            partitioner.connect((IDocument)document);
            document.setDocumentPartitioner((IDocumentPartitioner)partitioner);
        }
        this.sv.setDocument((IDocument)document, (IAnnotationModel)this.fAnnotationModel);
        this.sv.configure((SourceViewerConfiguration)new XMLConfiguration());
        AnnotationBarHoverManager fAnnotationHoverManager = new AnnotationBarHoverManager((IVerticalRulerInfo)this.compositeRuler, (ISourceViewer)this.sv, (IAnnotationHover)new AnnotationHover(), (IInformationControlCreator)new AnnotationConfiguration());
        fAnnotationHoverManager.install(annotationRuler.getControl());
        this.ap = new AnnotationPainter((ISourceViewer)this.sv, (IAnnotationAccess)annotationMarker);
        this.ap.addAnnotationType((Object)ERROR_TYPE);
        this.ap.setAnnotationTypeColor((Object)ERROR_TYPE, colorCache.getColor(new RGB(255, 0, 0)));
        this.sv.addPainter((IPainter)this.ap);
    }

    public void setFocus() {
    }

    public void postCommandSent(final String command, final String destination) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                String temp = MessageFormat.format(Messages.Output_Comment, destination);
                Output.this.buffer.append("\n\n");
                Output.this.buffer.append(temp);
                Output.this.buffer.append("\n");
                Output.this.buffer.append(Output.this.getFormattedXML(command));
            }
        });
    }

    public void postCommandSent(final String message) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                Output.this.buffer.append("\n");
                Output.this.buffer.append(message);
            }
        });
    }

    private String getFormattedXML(String command) throws TransformerFactoryConfigurationError {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            org.w3c.dom.Document doc = documentBuilder.parse(new InputSource(new StringReader(command)));
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("omit-xml-declaration", "yes");
            transformer.setOutputProperty("{http://xml.apache.org/xalan}indent-amount", "2");
            DOMSource domSource = new DOMSource(doc);
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            StreamResult streamResult = new StreamResult(outputStream);
            transformer.transform(domSource, streamResult);
            String newXML = ((Object)outputStream).toString();
            return newXML;
        }
        catch (Exception e) {
            return "The given command:\n" + command + "\n has an issue. The reason is: " + e.getMessage();
        }
    }

    public void responseReceived(final String response, String source) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                Output.this.buffer.append("\n");
                Output.this.buffer.append(Output.this.getFormattedXML(response));
            }
        });
    }

    public void finished() {
        final IDocument document = this.sv.getDocument();
        if (document != null) {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    document.set(Output.this.buffer.toString());
                }
            });
        }
    }

    public void postCommandSent(String info, String destination, String command) {
    }

    public void clearOutput() {
        this.sv.getDocument().set("");
        this.buffer = this.buffer.delete(0, this.buffer.length());
    }

    class AnnotationConfiguration
    implements IInformationControlCreator {
        AnnotationConfiguration() {
        }

        public IInformationControl createInformationControl(Shell shell) {
            return new DefaultInformationControl(shell);
        }
    }

    class AnnotationHover
    implements IAnnotationHover,
    ITextHover {
        AnnotationHover() {
        }

        public String getHoverInfo(ISourceViewer sourceViewer, int lineNumber) {
            HashMap<String, String> annotations = new HashMap<String, String>();
            Iterator iterator = Output.this.fAnnotationModel.getAnnotationIterator();
            while (iterator.hasNext()) {
                Annotation annotation = (Annotation)iterator.next();
                if (!(annotation instanceof ErrorAnnotation)) continue;
                ErrorAnnotation err = (ErrorAnnotation)annotation;
                annotations.put(Integer.toString(err.getLine()), err.getText());
            }
            return (String)annotations.get(Integer.toString(lineNumber));
        }

        public String getHoverInfo(ITextViewer textViewer, IRegion hoverRegion) {
            return null;
        }

        public IRegion getHoverRegion(ITextViewer textViewer, int offset) {
            return null;
        }
    }

    class ColorCache
    implements ISharedTextColors {
        private final Hashtable<RGB, Color> rgbs = new Hashtable();

        ColorCache() {
        }

        public Color getColor(RGB rgb) {
            if (!this.rgbs.containsKey(rgb)) {
                this.rgbs.put(rgb, new Color((Device)Display.getDefault(), rgb));
            }
            return this.rgbs.get(rgb);
        }

        public void dispose() {
            Enumeration<Color> colors = this.rgbs.elements();
            while (colors.hasMoreElements()) {
                Color c = colors.nextElement();
                if (c.isDisposed()) continue;
                c.dispose();
            }
        }
    }
}

