/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.ILogListener;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.fordiac.ide.Messages;
import org.eclipse.fordiac.ide.ui.UIPlugin;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.browser.IWebBrowser;

public class FordiacLogListener
implements ILogListener {
    private static final String FORDIAC_IDE_BUGZILLA_URL = "https://bugs.eclipse.org/bugs/enter_bug.cgi?product=4DIAC&component=4DIAC-IDE";

    public void logging(IStatus status, String plugin) {
        if (status.getSeverity() == 4 && status.getException() != null) {
            FordiacLogListener.showErrorDialog(FordiacLogListener.createStatusWithStackTrace(status));
        }
    }

    private static IStatus createStatusWithStackTrace(IStatus status) {
        String stackTrace = FordiacLogListener.getStackTrace(status.getException());
        List<IStatus> stackList = Arrays.stream(stackTrace.split(System.getProperty("line.separator"))).map(l -> new Status(4, status.getPlugin(), l)).collect(Collectors.toList());
        return new MultiStatus(status.getPlugin(), 4, stackList.toArray(new IStatus[stackList.size()]), status.getMessage(), status.getException());
    }

    private static String getStackTrace(Throwable exception) {
        StringWriter writer = new StringWriter();
        exception.printStackTrace(new PrintWriter(writer));
        return writer.toString();
    }

    private static void showErrorDialog(IStatus displayStatus) {
        LogErrorDialog dialog;
        if (Display.getCurrent() != null && Display.getCurrent().getActiveShell() != null && 2 == (dialog = new LogErrorDialog(Display.getCurrent().getActiveShell(), displayStatus)).open()) {
            FordiacLogListener.openBugReportBrowser();
        }
    }

    private static void openBugReportBrowser() {
        try {
            IWorkbench wb = PlatformUI.getWorkbench();
            IWebBrowser browser = wb.getBrowserSupport().createBrowser("org.eclipse.fordiac.ide");
            browser.openURL(new URL(FORDIAC_IDE_BUGZILLA_URL));
        }
        catch (MalformedURLException | PartInitException e) {
            UIPlugin.getDefault().logError("Error in opening the 4diac bugzilla web-page!", (Exception)e);
        }
    }

    private static final class LogErrorDialog
    extends ErrorDialog {
        private LogErrorDialog(Shell parentShell, IStatus status) {
            super(parentShell, Messages.FordiacLogListener_ErrorDialogTitle, Messages.FordiacLogListener_ErrorDialogDescription, status, 7);
        }

        protected void createButtonsForButtonBar(Composite parent) {
            this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
            this.createDetailsButton(parent);
            Button button = this.createButton(parent, 2, Messages.FordiacLogListener_ReportIssue, false);
            button.addListener(13, ev -> {
                this.setReturnCode(2);
                this.close();
            });
        }
    }
}

