/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.comgeneration.implementation.mediagenerators;

import java.text.MessageFormat;
import org.eclipse.fordiac.ide.comgeneration.implementation.ChannelEnd;
import org.eclipse.fordiac.ide.comgeneration.implementation.mediagenerators.MediaSpecificGenerator;
import org.eclipse.fordiac.ide.comgeneration.plugin.Activator;
import org.eclipse.fordiac.ide.comgeneration.plugin.Messages;
import org.eclipse.fordiac.ide.model.Palette.FBTypePaletteEntry;
import org.eclipse.fordiac.ide.model.Palette.Palette;
import org.eclipse.fordiac.ide.model.libraryElement.FB;
import org.eclipse.fordiac.ide.model.libraryElement.VarDeclaration;

public abstract class AbstractMediaSpecificGenerator
implements MediaSpecificGenerator {
    private static final String[] PALETTE_ENTRY_SOURCE_LOCAL = new String[]{"PUBL_0", "PUBL_1", "PUBL_2", "PUBL_3", "PUBL_4"};
    private static final String[] PALETTE_ENTRY_DESTINATION_LOCAL = new String[]{"SUBL_0", "SUBL_1", "SUBL_2", "net/SUBL_3", "net/SUBL_4"};
    private static final String[] PALETTE_ENTRY_SOURCE = new String[]{"PUBLISH_0", "PUBLISH_1", "PUBLISH_2", "PUBLISH_3", "PUBLISH_4"};
    private static final String[] PALETTE_ENTRY_DESTINATION = new String[]{"SUBSCRIBE_0", "SUBSCRIBE_1", "UBSCRIBE_2", "SUBSCRIBE_3", "SUBSCRIBE_4"};
    private final Palette palette;

    protected AbstractMediaSpecificGenerator(Palette palette) {
        this.palette = palette;
    }

    public Palette getPalette() {
        return this.palette;
    }

    @Override
    public FBTypePaletteEntry getPaletteType(ChannelEnd end, int numDataPorts, boolean local) {
        String[] paletteEntries = local ? (end == ChannelEnd.SOURCE ? PALETTE_ENTRY_SOURCE_LOCAL : PALETTE_ENTRY_DESTINATION_LOCAL) : (end == ChannelEnd.SOURCE ? PALETTE_ENTRY_SOURCE : PALETTE_ENTRY_DESTINATION);
        FBTypePaletteEntry entry = this.getPalette().getFBTypeEntry(paletteEntries[numDataPorts]);
        if (entry == null) {
            Activator.getDefault().logError(MessageFormat.format(Messages.CommGenerator_FBTypePaletteEntryNotFound, paletteEntries[numDataPorts]));
        }
        return entry;
    }

    @Override
    public VarDeclaration getTargetInputData(int index, FB fb) {
        String dataName = "SD_" + (index + 1);
        for (VarDeclaration inputVar : fb.getInterface().getInputVars()) {
            if (!inputVar.getName().equals(dataName)) continue;
            return inputVar;
        }
        return null;
    }

    @Override
    public VarDeclaration getTargetOutputData(int index, FB fb) {
        String dataName = "RD_" + (index + 1);
        for (VarDeclaration outputVar : fb.getInterface().getOutputVars()) {
            if (!outputVar.getName().equals(dataName)) continue;
            return outputVar;
        }
        return null;
    }
}

