/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.systemconfiguration.editparts;

import org.eclipse.draw2d.ConnectionRouter;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.PolylineConnection;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.fordiac.ide.gef.policies.FeedbackConnectionEndpointEditPolicy;
import org.eclipse.fordiac.ide.gef.router.BendpointPolicyRouter;
import org.eclipse.fordiac.ide.gef.router.RouterUtil;
import org.eclipse.fordiac.ide.model.libraryElement.Color;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElementPackage;
import org.eclipse.fordiac.ide.model.libraryElement.Link;
import org.eclipse.fordiac.ide.systemconfiguration.policies.DeleteLinkEditPolicy;
import org.eclipse.fordiac.ide.systemconfiguration.routers.LinkConnectionRouter;
import org.eclipse.fordiac.ide.util.ColorManager;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.editparts.AbstractConnectionEditPart;

public class LinkEditPart
extends AbstractConnectionEditPart {
    private final Adapter adapter = new AdapterImpl(){

        public void notifyChanged(Notification notification) {
            super.notifyChanged(notification);
            Object feature = notification.getFeature();
            if (LibraryElementPackage.eINSTANCE.getColorizableElement_Color().equals(feature)) {
                LinkEditPart.this.updateLinkColor(LinkEditPart.this.getFigure());
            }
            LinkEditPart.this.refreshVisuals();
        }
    };

    public Link getModel() {
        return (Link)super.getModel();
    }

    protected void updateLinkColor(IFigure connection) {
        Color segmentColor;
        if (this.getModel().getSegment() != null && (segmentColor = this.getModel().getSegment().getColor()) != null) {
            connection.setForegroundColor(ColorManager.getColor((Color)segmentColor));
        }
    }

    protected void createEditPolicies() {
        this.installEditPolicy("Connection Endpoint Policy", (EditPolicy)new FeedbackConnectionEndpointEditPolicy());
        this.installEditPolicy("ConnectionEditPolicy", (EditPolicy)new DeleteLinkEditPolicy());
        if (this.getConnectionFigure().getConnectionRouter() instanceof BendpointPolicyRouter) {
            this.installEditPolicy("Connection Bendpoint Policy", ((BendpointPolicyRouter)this.getConnectionFigure().getConnectionRouter()).getBendpointPolicy((Object)this.getModel()));
        }
    }

    protected IFigure createFigure() {
        PolylineConnection connection = RouterUtil.getConnectionRouterFactory(null).createConnectionFigure();
        connection.setConnectionRouter((ConnectionRouter)new LinkConnectionRouter(this));
        connection.setLineWidth(3);
        this.updateLinkColor((IFigure)connection);
        return connection;
    }

    public void activate() {
        if (!this.isActive()) {
            super.activate();
            this.getModel().eAdapters().add((Object)this.adapter);
            this.getModel().getSegment().eAdapters().add((Object)this.adapter);
        }
    }

    public void deactivate() {
        if (this.isActive()) {
            super.deactivate();
            this.getModel().eAdapters().remove((Object)this.adapter);
            if (this.getModel().getSegment() != null) {
                this.getModel().getSegment().eAdapters().remove((Object)this.adapter);
            }
        }
    }
}

