/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model.typelibrary;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.fordiac.ide.model.Activator;
import org.eclipse.fordiac.ide.model.Palette.DataTypePaletteEntry;
import org.eclipse.fordiac.ide.model.Palette.FBTypePaletteEntry;
import org.eclipse.fordiac.ide.model.Palette.Palette;
import org.eclipse.fordiac.ide.model.Palette.PaletteEntry;
import org.eclipse.fordiac.ide.model.Palette.PaletteFactory;
import org.eclipse.fordiac.ide.model.typelibrary.DataTypeLibrary;
import org.eclipse.fordiac.ide.model.typelibrary.IPaletteEntryCreator;
import org.eclipse.fordiac.ide.model.typelibrary.TypeLibraryTags;

public final class TypeLibrary
implements TypeLibraryTags {
    private static Map<IProject, TypeLibrary> typeLibraryList = new HashMap<IProject, TypeLibrary>();
    private final Palette blockTypeLib = PaletteFactory.eINSTANCE.createPalette();
    private final Palette errorTypeLib = PaletteFactory.eINSTANCE.createPalette();
    private final DataTypeLibrary dataTypeLib = new DataTypeLibrary();
    private IProject project;
    private static IPaletteEntryCreator[] paletteCreators = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TypeLibrary getTypeLibrary(IProject proj) {
        Map<IProject, TypeLibrary> map = typeLibraryList;
        synchronized (map) {
            return typeLibraryList.computeIfAbsent(proj, TypeLibrary::new);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeProject(IProject project) {
        Map<IProject, TypeLibrary> map = typeLibraryList;
        synchronized (map) {
            typeLibraryList.remove(project);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void renameProject(IProject oldProject, IProject newProject) {
        Map<IProject, TypeLibrary> map = typeLibraryList;
        synchronized (map) {
            TypeLibrary typelib = typeLibraryList.remove(oldProject);
            if (typelib != null) {
                typelib.project = newProject;
                typeLibraryList.put(newProject, typelib);
            }
        }
    }

    public static String getTypeNameFromFile(IFile element) {
        return TypeLibrary.getTypeNameFromFileName(element.getName());
    }

    public static String getTypeNameFromFileName(String fileName) {
        String name = fileName;
        int index = fileName.lastIndexOf(46);
        if (-1 != index) {
            name = fileName.substring(0, index);
        }
        return name;
    }

    public static PaletteEntry getPaletteEntryForFile(IFile typeFile) {
        TypeLibrary typeLib = TypeLibrary.getTypeLibrary(typeFile.getProject());
        return typeLib.getPaletteEntry(typeFile);
    }

    public PaletteEntry getPaletteEntry(IFile typeFile) {
        if (TypeLibrary.isDataTypeFile(typeFile)) {
            return this.dataTypeLib.getDerivedDataTypes().get(TypeLibrary.getTypeNameFromFile(typeFile));
        }
        EMap<String, ? extends PaletteEntry> typeEntryList = this.getTypeList(typeFile);
        if (typeEntryList != null) {
            return (PaletteEntry)typeEntryList.get((Object)TypeLibrary.getTypeNameFromFile(typeFile));
        }
        return null;
    }

    private static boolean isDataTypeFile(IFile typeFile) {
        return "DTP".equalsIgnoreCase(typeFile.getFileExtension());
    }

    public Palette getBlockTypeLib() {
        return this.blockTypeLib;
    }

    public DataTypeLibrary getDataTypeLibrary() {
        return this.dataTypeLib;
    }

    public IProject getProject() {
        return this.project;
    }

    private EMap<String, ? extends PaletteEntry> getTypeList(IFile typeFile) {
        block22: {
            String extension = typeFile.getFileExtension();
            if (extension == null) break block22;
            switch (extension.toUpperCase()) {
                case "ADP": {
                    return this.blockTypeLib.getAdapterTypes();
                }
                case "DEV": {
                    return this.blockTypeLib.getDeviceTypes();
                }
                case "FBT": {
                    return this.blockTypeLib.getFbTypes();
                }
                case "RES": {
                    return this.blockTypeLib.getResourceTypes();
                }
                case "SEG": {
                    return this.blockTypeLib.getSegmentTypes();
                }
                case "SUB": {
                    return this.blockTypeLib.getSubAppTypes();
                }
            }
        }
        return null;
    }

    private TypeLibrary(IProject project) {
        this.project = project;
        this.blockTypeLib.setTypeLibrary(this);
        this.errorTypeLib.setTypeLibrary(this);
        if (project != null && project.exists()) {
            this.loadPaletteFolderMembers((IContainer)project);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void loadToolLibrary() {
        Map<IProject, TypeLibrary> map = typeLibraryList;
        synchronized (map) {
            IProject toolLibProject = TypeLibrary.getToolLibProject();
            typeLibraryList.computeIfAbsent(toolLibProject, TypeLibrary::createToolLibrary);
        }
    }

    private static TypeLibrary createToolLibrary(IProject toolLibProject) {
        if (toolLibProject.exists()) {
            try {
                toolLibProject.delete(true, (IProgressMonitor)new NullProgressMonitor());
            }
            catch (CoreException e) {
                Activator.getDefault().logError(e.getMessage(), (Exception)((Object)e));
            }
        }
        TypeLibrary.createToolLibProject(toolLibProject);
        return new TypeLibrary(toolLibProject);
    }

    private void loadPaletteFolderMembers(IContainer container) {
        try {
            IResource[] members;
            IResource[] iResourceArray = members = container.members();
            int n = members.length;
            int n2 = 0;
            while (n2 < n) {
                IResource iResource = iResourceArray[n2];
                if (iResource instanceof IFolder) {
                    this.loadPaletteFolderMembers((IContainer)((IFolder)iResource));
                }
                if (iResource instanceof IFile) {
                    this.createPaletteEntry((IFile)iResource);
                }
                ++n2;
            }
        }
        catch (CoreException e) {
            Activator.getDefault().logError(e.getMessage(), (Exception)((Object)e));
        }
    }

    public PaletteEntry createPaletteEntry(IFile file) {
        PaletteEntry entry = null;
        IPaletteEntryCreator[] iPaletteEntryCreatorArray = TypeLibrary.getPaletteCreators();
        int n = iPaletteEntryCreatorArray.length;
        int n2 = 0;
        while (n2 < n) {
            IPaletteEntryCreator in = iPaletteEntryCreatorArray[n2];
            if (in.canHandle(file)) {
                entry = in.createPaletteEntry();
                TypeLibrary.configurePaletteEntry(entry, file);
                this.addPaletteEntry(entry);
            }
            ++n2;
        }
        return entry;
    }

    public void addPaletteEntry(PaletteEntry entry) {
        FBTypePaletteEntry errorEntry = this.errorTypeLib.getFBTypeEntry(entry.getLabel());
        if (errorEntry != null) {
            this.errorTypeLib.removePaletteEntry(errorEntry);
        }
        if (entry instanceof DataTypePaletteEntry) {
            entry.setPalette(this.blockTypeLib);
            this.dataTypeLib.addPaletteEntry((DataTypePaletteEntry)entry);
        } else {
            this.blockTypeLib.addPaletteEntry(entry);
        }
    }

    public void removePaletteEntry(PaletteEntry entry) {
        if (entry instanceof DataTypePaletteEntry) {
            this.dataTypeLib.removePaletteEntry((DataTypePaletteEntry)entry);
        } else {
            this.blockTypeLib.removePaletteEntry(entry);
        }
    }

    private static void setPaletteCreators() {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IConfigurationElement[] elems = registry.getConfigurationElementsFor("org.eclipse.fordiac.ide.model", "PaletteEntryCreator");
        int countPaletteCreater = 0;
        paletteCreators = new IPaletteEntryCreator[elems.length];
        IConfigurationElement[] iConfigurationElementArray = elems;
        int n = elems.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement elem = iConfigurationElementArray[n2];
            try {
                Object object = elem.createExecutableExtension("class");
                if (object instanceof IPaletteEntryCreator) {
                    TypeLibrary.paletteCreators[countPaletteCreater] = (IPaletteEntryCreator)object;
                    ++countPaletteCreater;
                }
            }
            catch (CoreException e) {
                Activator.getDefault().logError(e.getMessage(), (Exception)((Object)e));
            }
            ++n2;
        }
    }

    private static IPaletteEntryCreator[] getPaletteCreators() {
        if (paletteCreators == null) {
            TypeLibrary.setPaletteCreators();
        }
        return paletteCreators;
    }

    private static void configurePaletteEntry(PaletteEntry entry, IFile file) {
        entry.setType(null);
        entry.setLabel(TypeLibrary.getTypeNameFromFile(file));
        entry.setFile(file);
    }

    public static void refreshTypeLib(IFile file) {
        TypeLibrary typeLib = TypeLibrary.getTypeLibrary(file.getProject());
        typeLib.refresh();
    }

    private void refresh() {
        try {
            this.project.refreshLocal(2, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException e) {
            Activator.getDefault().logError(e.getMessage(), (Exception)((Object)e));
        }
        this.checkDeletions();
        this.checkAdditions((IContainer)this.project);
    }

    private void checkDeletions() {
        TypeLibrary.checkDeletionsForTypeGroup(this.blockTypeLib.getAdapterTypes().values());
        TypeLibrary.checkDeletionsForTypeGroup(this.blockTypeLib.getDeviceTypes().values());
        TypeLibrary.checkDeletionsForTypeGroup(this.blockTypeLib.getFbTypes().values());
        TypeLibrary.checkDeletionsForTypeGroup(this.blockTypeLib.getResourceTypes().values());
        TypeLibrary.checkDeletionsForTypeGroup(this.blockTypeLib.getSegmentTypes().values());
        TypeLibrary.checkDeletionsForTypeGroup(this.blockTypeLib.getSubAppTypes().values());
        TypeLibrary.checkDeletionsForTypeGroup(this.dataTypeLib.getDerivedDataTypes().values());
    }

    private static void checkDeletionsForTypeGroup(Collection<? extends PaletteEntry> typeEntries) {
        typeEntries.removeIf(e -> !e.getFile().exists());
    }

    private void checkAdditions(IContainer container) {
        try {
            IResource[] members;
            IResource[] iResourceArray = members = container.members();
            int n = members.length;
            int n2 = 0;
            while (n2 < n) {
                IResource resource = iResourceArray[n2];
                if (resource instanceof IFolder) {
                    this.checkAdditions((IContainer)((IFolder)resource));
                }
                if (resource instanceof IFile && !this.containsType((IFile)resource)) {
                    this.createPaletteEntry((IFile)resource);
                }
                ++n2;
            }
        }
        catch (CoreException e) {
            Activator.getDefault().logError(e.getMessage(), (Exception)((Object)e));
        }
    }

    public boolean containsType(IFile file) {
        return this.getPaletteEntry(file) != null;
    }

    private static IProject getToolLibProject() {
        IWorkspaceRoot myWorkspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        return myWorkspaceRoot.getProject("Tool Library");
    }

    public static IFolder getToolLibFolder() {
        IFolder toolLibFolder;
        IProject toolLibProject = TypeLibrary.getToolLibProject();
        if (!toolLibProject.exists()) {
            TypeLibrary.createToolLibProject(toolLibProject);
        }
        if (!(toolLibFolder = toolLibProject.getFolder("Tool Library")).exists()) {
            TypeLibrary.createToolLibLink(toolLibProject);
            toolLibFolder = toolLibProject.getFolder("Tool Library");
        }
        return toolLibFolder;
    }

    private static void createToolLibProject(IProject toolLibProject) {
        NullProgressMonitor progressMonitor = new NullProgressMonitor();
        try {
            toolLibProject.create((IProgressMonitor)progressMonitor);
            toolLibProject.open((IProgressMonitor)progressMonitor);
        }
        catch (Exception e) {
            Activator.getDefault().logError(e.getMessage(), e);
        }
        TypeLibrary.createToolLibLink(toolLibProject);
    }

    private static void createToolLibLink(IProject toolLibProject) {
        String typeLibPath;
        Path location;
        IFolder link;
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        if (workspace.validateLinkLocation((IResource)(link = toolLibProject.getFolder("Tool Library")), (IPath)(location = (typeLibPath = System.getProperty("4diac.typelib.path")) != null && !typeLibPath.isEmpty() ? new Path(typeLibPath) : new Path(String.valueOf(Platform.getInstallLocation().getURL().getFile()) + "typelibrary"))).isOK() && location.toFile().isDirectory()) {
            try {
                link.createLink((IPath)location, 0, null);
            }
            catch (Exception e) {
                Activator.getDefault().logError(e.getMessage(), e);
            }
        }
    }

    public Palette getErrorTypeLib() {
        return this.errorTypeLib;
    }

    public PaletteEntry find(String name) {
        PaletteEntry entry = this.blockTypeLib.getSubAppTypeEntry(name);
        if (entry != null) {
            return entry;
        }
        entry = this.blockTypeLib.getFBTypeEntry(name);
        if (entry != null) {
            return entry;
        }
        entry = this.dataTypeLib.getDerivedDataTypes().get(name);
        if (entry != null) {
            return entry;
        }
        return this.blockTypeLib.getAdapterTypeEntry(name);
    }
}

