/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model.typelibrary;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.fordiac.ide.model.Palette.Palette;
import org.eclipse.fordiac.ide.model.Palette.PaletteEntry;
import org.eclipse.ui.dialogs.SearchPattern;

public class PaletteFilter {
    private final Palette palette;
    private final SearchPattern matcher = new SearchPattern();

    public PaletteFilter(Palette palette) {
        this.palette = palette;
    }

    public List<PaletteEntry> findFBAndSubappTypes(String searchString) {
        Stream<Map.Entry<String, ? extends PaletteEntry>> stream = Stream.concat(this.palette.getFbTypes().entrySet().stream(), this.palette.getSubAppTypes().entrySet().stream());
        return this.findTypes(searchString, stream);
    }

    public List<PaletteEntry> findTypes(String searchString, Stream<Map.Entry<String, ? extends PaletteEntry>> stream) {
        this.setSearchPattern(searchString);
        return stream.filter(entry -> this.matcher.matches((String)entry.getKey())).filter(entry -> ((PaletteEntry)entry.getValue()).getType() != null).map(Map.Entry::getValue).collect(Collectors.toList());
    }

    private void setSearchPattern(String searchString) {
        String searchPattern = searchString;
        if (!searchString.endsWith(" ")) {
            searchPattern = String.valueOf(searchPattern) + "*";
        }
        searchPattern = "*" + searchPattern;
        this.matcher.setPattern(searchPattern);
    }
}

