/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model.datatype.helper;

import org.eclipse.fordiac.ide.model.data.AnyBitType;
import org.eclipse.fordiac.ide.model.data.AnyCharType;
import org.eclipse.fordiac.ide.model.data.AnyCharsType;
import org.eclipse.fordiac.ide.model.data.AnyDateType;
import org.eclipse.fordiac.ide.model.data.AnyElementaryType;
import org.eclipse.fordiac.ide.model.data.AnyIntType;
import org.eclipse.fordiac.ide.model.data.AnyMagnitudeType;
import org.eclipse.fordiac.ide.model.data.AnyNumType;
import org.eclipse.fordiac.ide.model.data.AnyRealType;
import org.eclipse.fordiac.ide.model.data.AnySignedType;
import org.eclipse.fordiac.ide.model.data.AnyStringType;
import org.eclipse.fordiac.ide.model.data.AnyType;
import org.eclipse.fordiac.ide.model.data.AnyUnsignedType;
import org.eclipse.fordiac.ide.model.data.DataType;
import org.eclipse.fordiac.ide.model.datatype.helper.ElementaryDataTypeCompatibility;

public final class GenericDataTypeCompatibility {
    public static boolean isAnyUnsignedCompatibleWith(DataType other) {
        return other instanceof AnyUnsignedType || ElementaryDataTypeCompatibility.isAnyIntCompatibleWith(other);
    }

    public static boolean isAnySignedCompatibleWith(DataType other) {
        return other instanceof AnySignedType || ElementaryDataTypeCompatibility.isAnyIntCompatibleWith(other);
    }

    public static boolean isAnyIntCompatibleWith(DataType other) {
        return other instanceof AnyIntType || ElementaryDataTypeCompatibility.isAnyNumCompatibleWith(other);
    }

    public static boolean isAnyRealCompatibleWith(DataType other) {
        return other instanceof AnyRealType || ElementaryDataTypeCompatibility.isAnyNumCompatibleWith(other);
    }

    public static boolean isAnyNumCompatibleWith(DataType other) {
        return other instanceof AnyNumType || ElementaryDataTypeCompatibility.isAnyMagnitudeCompatibleWith(other);
    }

    public static boolean isAnyMagnitudeCompatibleWith(DataType other) {
        return other instanceof AnyMagnitudeType || ElementaryDataTypeCompatibility.isAnyElementaryCompatibleWith(other);
    }

    public static boolean isAnyElementaryCompatibleWith(DataType other) {
        return other instanceof AnyElementaryType || ElementaryDataTypeCompatibility.isAnyCompatibleWith(other);
    }

    public static boolean isAnyCompatibleWith(DataType other) {
        return other instanceof AnyType;
    }

    public static boolean isAnyBitCompatibleWith(DataType other) {
        return other instanceof AnyBitType || ElementaryDataTypeCompatibility.isAnyElementaryCompatibleWith(other);
    }

    public static boolean isAnyCharsCompatibleWith(DataType other) {
        return other instanceof AnyCharsType || ElementaryDataTypeCompatibility.isAnyElementaryCompatibleWith(other);
    }

    public static boolean isAnyStringCompatibleWith(DataType other) {
        return other instanceof AnyStringType || ElementaryDataTypeCompatibility.isAnyCharsCompatibleWith(other);
    }

    public static boolean isAnyCharCompatibleWith(DataType other) {
        return other instanceof AnyCharType || ElementaryDataTypeCompatibility.isAnyCharsCompatibleWith(other);
    }

    public static boolean isAnyDateCompatibleWith(DataType other) {
        return other instanceof AnyDateType || ElementaryDataTypeCompatibility.isAnyElementaryCompatibleWith(other);
    }

    private GenericDataTypeCompatibility() {
        throw new UnsupportedOperationException();
    }
}

