/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model.dataimport;

import javax.xml.stream.XMLStreamException;
import org.eclipse.core.resources.IFile;
import org.eclipse.fordiac.ide.model.Messages;
import org.eclipse.fordiac.ide.model.data.DataType;
import org.eclipse.fordiac.ide.model.dataimport.CommonElementImporter;
import org.eclipse.fordiac.ide.model.dataimport.exceptions.TypeImportException;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElementFactory;
import org.eclipse.fordiac.ide.model.libraryElement.Value;
import org.eclipse.fordiac.ide.model.libraryElement.VarDeclaration;

public abstract class TypeImporter
extends CommonElementImporter {
    protected TypeImporter(IFile file) {
        super(file);
    }

    protected TypeImporter(CommonElementImporter importer) {
        super(importer);
    }

    protected VarDeclaration parseVarDeclaration() throws TypeImportException, XMLStreamException {
        VarDeclaration v = LibraryElementFactory.eINSTANCE.createVarDeclaration();
        this.readNameCommentAttributes(v);
        String typeName = this.getAttributeValue("Type");
        if (typeName != null) {
            DataType dataType = this.getDataTypeLibrary().getType(typeName);
            v.setTypeName(typeName);
            if (dataType != null) {
                v.setType(dataType);
            }
        } else {
            throw new TypeImportException(Messages.Import_ERROR_InputVariableTypeNotDefined);
        }
        String arraySize = this.getAttributeValue("ArraySize");
        if (arraySize != null) {
            try {
                v.setArraySize(Integer.parseInt(arraySize));
            }
            catch (NumberFormatException nfe) {
                throw new TypeImportException(Messages.Import_ERROR_ArraySize_NumberFormat, nfe);
            }
        } else {
            v.setArraySize(-1);
        }
        String initialValue = this.getAttributeValue("InitialValue");
        if (initialValue != null) {
            Value varInitialization = LibraryElementFactory.eINSTANCE.createValue();
            varInitialization.setValue(initialValue);
            v.setValue(varInitialization);
        }
        this.processChildren("VarDeclaration", name -> {
            if ("Attribute".equals(name)) {
                this.parseGenericAttributeNode(v);
                this.proceedToEndElementNamed("Attribute");
                return true;
            }
            return false;
        });
        this.proceedToEndElementNamed("VarDeclaration");
        return v;
    }
}

