/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model.dataimport;

import java.text.MessageFormat;
import javax.xml.stream.XMLStreamException;
import org.eclipse.core.resources.IFile;
import org.eclipse.fordiac.ide.model.Messages;
import org.eclipse.fordiac.ide.model.data.AnyDerivedType;
import org.eclipse.fordiac.ide.model.data.DataFactory;
import org.eclipse.fordiac.ide.model.data.StructuredType;
import org.eclipse.fordiac.ide.model.dataimport.CommonElementImporter;
import org.eclipse.fordiac.ide.model.dataimport.TypeImporter;
import org.eclipse.fordiac.ide.model.dataimport.exceptions.TypeImportException;

public class DataTypeImporter
extends TypeImporter {
    @Override
    public AnyDerivedType getElement() {
        return (AnyDerivedType)super.getElement();
    }

    public DataTypeImporter(IFile typeFile) {
        super(typeFile);
    }

    @Override
    public void loadElement() {
        super.loadElement();
        if (!(this.getElement() instanceof StructuredType)) {
            this.createErrorMarker(MessageFormat.format(Messages.DataTypeImporter_UNSUPPORTED_DATATYPE_IN_FILE, this.getFile().getName()));
        }
    }

    @Override
    protected AnyDerivedType createRootModelElement() {
        return DataFactory.eINSTANCE.createAnyDerivedType();
    }

    @Override
    protected String getStartElementName() {
        return "DataType";
    }

    @Override
    protected CommonElementImporter.IChildHandler getBaseChildrenHandler() {
        return name -> {
            switch (name) {
                case "Identification": {
                    this.parseIdentification(this.getElement());
                    break;
                }
                case "VersionInfo": {
                    this.parseVersionInfo(this.getElement());
                    break;
                }
                case "CompilerInfo": {
                    this.getElement().setCompilerInfo(this.parseCompilerInfo());
                    break;
                }
                case "ASN1Tag": {
                    this.parseASN1Tag(this.getElement());
                    break;
                }
                case "StructuredType": {
                    this.setElement(DataTypeImporter.convertToStructuredType(this.getElement()));
                    this.parseStructuredType((StructuredType)this.getElement());
                    break;
                }
                default: {
                    return false;
                }
            }
            return true;
        };
    }

    private void parseASN1Tag(AnyDerivedType type) throws XMLStreamException {
        this.proceedToEndElementNamed("ASN1Tag");
    }

    private static StructuredType convertToStructuredType(AnyDerivedType type) {
        StructuredType structuredType = DataFactory.eINSTANCE.createStructuredType();
        DataTypeImporter.copyGeneralTypeInformation(structuredType, type);
        return structuredType;
    }

    private static void copyGeneralTypeInformation(AnyDerivedType dstType, AnyDerivedType srcType) {
        dstType.setName(srcType.getName());
        dstType.setComment(srcType.getComment());
        dstType.setIdentification(srcType.getIdentification());
        dstType.getVersionInfo().addAll(srcType.getVersionInfo());
        dstType.setCompilerInfo(srcType.getCompilerInfo());
    }

    private void parseStructuredType(StructuredType struct) throws TypeImportException, XMLStreamException {
        this.processChildren("StructuredType", name -> {
            if ("VarDeclaration".equals(name)) {
                struct.getMemberVariables().add((Object)this.parseVarDeclaration());
                return true;
            }
            return false;
        });
    }
}

