/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.export;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.fordiac.ide.export.Activator;
import org.eclipse.fordiac.ide.export.ExportException;
import org.eclipse.fordiac.ide.export.ExportFilter;
import org.eclipse.fordiac.ide.export.ICompareEditorOpener;
import org.eclipse.fordiac.ide.export.IExportTemplate;
import org.eclipse.fordiac.ide.export.Messages;
import org.eclipse.fordiac.ide.export.utils.CompareEditorOpenerUtil;
import org.eclipse.fordiac.ide.export.utils.DelayedFiles;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElement;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public abstract class TemplateExportFilter
extends ExportFilter {
    private static final String[] BUTTON_LABELS = new String[]{Messages.TemplateExportFilter_OVERWRITE_LABEL_STRING, Messages.TemplateExportFilter_MERGE_LABEL_STRING, JFaceResources.getString((String)"cancel")};
    private static final int BUTTON_OVERWRITE = Arrays.asList(BUTTON_LABELS).indexOf(Messages.TemplateExportFilter_OVERWRITE_LABEL_STRING);
    private static final int BUTTON_MERGE = Arrays.asList(BUTTON_LABELS).indexOf(Messages.TemplateExportFilter_MERGE_LABEL_STRING);

    protected TemplateExportFilter() {
    }

    private static List<String> reformat(LibraryElement type, List<String> messages) {
        return messages.stream().map(v -> type != null ? MessageFormat.format(Messages.TemplateExportFilter_PREFIX_ERRORMESSAGE_WITH_TYPENAME, type.getName(), v) : v).collect(Collectors.toList());
    }

    @Override
    public final void export(IFile typeFile, String destination, boolean forceOverwrite) throws ExportException {
        this.export(typeFile, destination, forceOverwrite, null);
    }

    private static String stringsToTextualList(List<String> list) {
        String textualList = "";
        if (list.size() == 1) {
            textualList = MessageFormat.format(Messages.TemplateExportFilter_LIST_ONE_ELEMENT, list.get(0));
        } else if (list.size() == 2) {
            textualList = MessageFormat.format(Messages.TemplateExportFilter_LIST_TWO_ELEMENTS, list.get(0), list.get(1));
        } else if (list.size() == 3) {
            textualList = MessageFormat.format(Messages.TemplateExportFilter_LIST_THREE_ELEMENTS, list.get(0), list.get(1), list.get(2));
        } else if (list.size() > 3) {
            textualList = MessageFormat.format(Messages.TemplateExportFilter_LIST_FOUR_OR_MORE_ELEMENTS, list.get(0), list.get(1), list.get(2));
        }
        return textualList;
    }

    @Override
    public void export(IFile typeFile, String destination, boolean forceOverwrite, LibraryElement type) throws ExportException {
        try {
            boolean overwrite;
            DelayedFiles files = this.generateFileContent(destination, type);
            int res = BUTTON_OVERWRITE;
            boolean filesExisted = files.exist();
            if (!forceOverwrite && filesExisted) {
                String msg = MessageFormat.format(Messages.TemplateExportFilter_OVERWRITE_REQUEST, TemplateExportFilter.stringsToTextualList(files.getFilenames()));
                MessageDialog msgDiag = new MessageDialog(Display.getDefault().getActiveShell(), Messages.TemplateExportFilter_FILE_EXISTS, null, msg, 6, BUTTON_LABELS, 0);
                res = msgDiag.open();
            }
            boolean bl = overwrite = forceOverwrite || BUTTON_OVERWRITE == res;
            if (overwrite || BUTTON_MERGE == res) {
                Iterable<DelayedFiles.StoredFiles> writtenFiles = files.write(overwrite);
                if (!overwrite) {
                    TemplateExportFilter.openMergeEditor(writtenFiles);
                }
            }
        }
        catch (Exception t) {
            Activator.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.fordiac.ide.export", 1, Messages.TemplateExportFilter_ErrorDuringTemplateGeneration, (Throwable)t));
            this.getErrors().add(t.getMessage() != null ? t.getMessage() : Messages.TemplateExportFilter_ErrorDuringTemplateGeneration);
        }
    }

    private DelayedFiles generateFileContent(String destination, LibraryElement type) throws ExportException {
        DelayedFiles files = new DelayedFiles();
        Path destinationPath = Paths.get(destination, new String[0]);
        Set<IExportTemplate> templates = this.getTemplates(type);
        for (IExportTemplate template : templates) {
            CharSequence content = template.generate();
            this.getErrors().addAll(TemplateExportFilter.reformat(type, template.getErrors()));
            this.getWarnings().addAll(TemplateExportFilter.reformat(type, template.getWarnings()));
            this.getInfos().addAll(TemplateExportFilter.reformat(type, template.getInfos()));
            if (template.getErrors().isEmpty()) {
                Path templatePath = destinationPath.resolve(template.getPath());
                files.write(templatePath, content);
                continue;
            }
            files.clear();
            break;
        }
        return files;
    }

    private static void openMergeEditor(Iterable<DelayedFiles.StoredFiles> writtenFiles) throws ExportException {
        ICompareEditorOpener opener = CompareEditorOpenerUtil.getOpener();
        if (opener == null) {
            throw new ExportException(Messages.TemplateExportFilter_MERGE_EDITOR_FAILED);
        }
        boolean diffs = false;
        for (DelayedFiles.StoredFiles sf : writtenFiles) {
            if (sf.getNewFile() == null || sf.getOldFile() == null) continue;
            opener.setName(sf.getNewFile().getName());
            opener.setTitle(sf.getNewFile().getName());
            opener.setNewFile(sf.getNewFile());
            opener.setOriginalFile(sf.getOldFile());
            if (!opener.hasDifferences()) continue;
            opener.openCompareEditor();
            diffs = true;
        }
        if (!diffs) {
            MessageDialog.openInformation((Shell)Display.getDefault().getActiveShell(), (String)Messages.TemplateExportFilter_NO_DIFFERENCES_TITLE, (String)Messages.TemplateExportFilter_NO_DIFFERENCES_MESSAGE);
        }
    }

    protected abstract Set<IExportTemplate> getTemplates(LibraryElement var1);
}

