/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.typemanagement.handlers;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.fordiac.ide.model.Palette.PaletteEntry;
import org.eclipse.fordiac.ide.model.edit.providers.ResultListLabelProvider;
import org.eclipse.fordiac.ide.model.typelibrary.TypeLibrary;
import org.eclipse.fordiac.ide.typemanagement.Activator;
import org.eclipse.fordiac.ide.typemanagement.Messages;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;
import org.eclipse.ui.part.FileEditorInput;

public class OpenTypeHandler
extends AbstractHandler {
    ElementListSelectionDialog dialog;
    private final Set<PaletteEntry> entries = new HashSet<PaletteEntry>();
    private final List<IContainer> projects = new ArrayList<IContainer>();
    private int selectedProject = 0;

    public Object execute(ExecutionEvent event) throws ExecutionException {
        this.clear();
        this.collectProjects((IContainer)ResourcesPlugin.getWorkspace().getRoot());
        this.processContainer((IContainer)ResourcesPlugin.getWorkspace().getRoot());
        this.dialog = this.createDialog();
        this.dialog.setElements(this.entries.toArray());
        this.dialog.open();
        Object result = this.dialog.getFirstResult();
        if (result instanceof PaletteEntry) {
            OpenTypeHandler.openEditor(((PaletteEntry)result).getFile());
        }
        return null;
    }

    private void clear() {
        this.dialog = null;
        this.entries.clear();
        this.projects.clear();
        this.selectedProject = 0;
    }

    private void changeDialog() {
        String searchString = this.dialog.getFilter();
        this.dialog.close();
        this.entries.clear();
        this.processContainer(this.projects.get(this.selectedProject));
        this.dialog = this.createDialog();
        this.dialog.setElements(this.entries.toArray());
        this.dialog.setFilter(searchString);
        this.dialog.open();
    }

    private ElementListSelectionDialog createDialog() {
        Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
        ElementListSelectionDialog selDialog = new ElementListSelectionDialog(shell, (ILabelProvider)new ResultListLabelProvider()){

            protected Control createDialogArea(Composite parent) {
                Composite container = (Composite)super.createDialogArea(parent);
                ComboViewer viewer = new ComboViewer(container);
                viewer.getCombo().setLayoutData((Object)new GridData(1, 2, true, false));
                viewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

                    public String getText(Object element) {
                        if (element instanceof IProject) {
                            IProject project = (IProject)element;
                            return project.getName();
                        }
                        return "All Projects";
                    }
                });
                viewer.getCombo().addListener(13, e -> {
                    OpenTypeHandler.this.selectedProject = viewer.getCombo().getSelectionIndex();
                    OpenTypeHandler.this.changeDialog();
                });
                viewer.add(OpenTypeHandler.this.projects.toArray());
                viewer.getCombo().select(OpenTypeHandler.this.selectedProject);
                return container;
            }
        };
        OpenTypeHandler.setDialogSettings(selDialog);
        return selDialog;
    }

    private static void setDialogSettings(ElementListSelectionDialog dialog) {
        dialog.setMatchEmptyString(false);
        dialog.setMultipleSelection(false);
        dialog.setEmptyListMessage(Messages.OpenTypeHandler_NO_FILES_IN_WORKSPACE);
        dialog.setEmptySelectionMessage(Messages.OpenTypeHandler_NO_FILES_SELECTED);
        dialog.setTitle(Messages.OpenTypeHandler_OPEN_TYPE_TITLE);
        dialog.setStatusLineAboveButtons(true);
    }

    private void collectProjects(IContainer container) {
        IResource[] members;
        this.projects.add(0, container);
        try {
            members = container.members();
        }
        catch (CoreException e) {
            Activator.getDefault().logError(e.getMessage(), (Exception)((Object)e));
            members = new IResource[]{};
        }
        IResource[] iResourceArray = members;
        int n = members.length;
        int n2 = 0;
        while (n2 < n) {
            IResource member = iResourceArray[n2];
            if (!(member instanceof IProject) || ((IProject)member).isOpen()) {
                this.projects.add((IContainer)member);
            }
            ++n2;
        }
    }

    private void processContainer(IContainer container) {
        IResource[] members;
        try {
            members = container.members();
        }
        catch (CoreException e) {
            Activator.getDefault().logError(e.getMessage(), (Exception)((Object)e));
            members = new IResource[]{};
        }
        IResource[] iResourceArray = members;
        int n = members.length;
        int n2 = 0;
        while (n2 < n) {
            IResource member = iResourceArray[n2];
            if (!(member instanceof IProject) || ((IProject)member).isOpen()) {
                if (member instanceof IContainer) {
                    this.processContainer((IContainer)member);
                } else if (member instanceof IFile) {
                    this.entries.add(TypeLibrary.getPaletteEntryForFile((IFile)((IFile)member)));
                }
            }
            ++n2;
        }
    }

    private static void openEditor(IFile file) {
        IWorkbenchWindow activeWorkbenchWindow;
        IWorkbench workbench = PlatformUI.getWorkbench();
        if (workbench != null && (activeWorkbenchWindow = workbench.getActiveWorkbenchWindow()) != null) {
            IWorkbenchPage activePage = activeWorkbenchWindow.getActivePage();
            IEditorDescriptor desc = PlatformUI.getWorkbench().getEditorRegistry().getDefaultEditor(file.getName());
            try {
                activePage.openEditor((IEditorInput)new FileEditorInput(file), desc.getId());
            }
            catch (PartInitException e1) {
                Activator.getDefault().logError(e1.getMessage(), (Exception)((Object)e1));
                Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
                MessageDialog.openError((Shell)shell, (String)Messages.OpenTypeHandler_OPEN_TYPE_ERROR_TITLE, (String)Messages.OpenTypeHandler_EDITOR_OPEN_ERROR_MESSAGE);
            }
        }
    }
}

