/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.fbtypeeditor.fbtester;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.fordiac.ide.fbtypeeditor.fbtester.model.ISetValueListener;
import org.eclipse.fordiac.ide.fbtypeeditor.fbtester.model.ITriggerEventListener;
import org.eclipse.fordiac.ide.fbtypeeditor.fbtester.model.TestElement;
import org.eclipse.fordiac.ide.model.libraryElement.Event;
import org.eclipse.fordiac.ide.model.libraryElement.FBType;
import org.eclipse.fordiac.ide.model.libraryElement.VarDeclaration;

public final class TestingManager {
    private static TestingManager instance;
    private final Map<String, TestElement> testElements = new HashMap<String, TestElement>();
    private final Map<String, TestElement> triggerElements = new HashMap<String, TestElement>();

    public static TestingManager getInstance() {
        if (instance == null) {
            instance = new TestingManager();
        }
        return instance;
    }

    private TestingManager() {
    }

    public void addTriggerElement(TestElement element) {
        this.triggerElements.put(TestingManager.generateElementString(element), element);
    }

    private static String generateElementString(TestElement element) {
        return String.valueOf(element.getFBString()) + "_RES." + element.getFBString() + "." + element.getInterfaceElement().getName();
    }

    public Map<String, TestElement> getTriggerElements(FBType type) {
        HashMap<String, TestElement> elements = new HashMap<String, TestElement>();
        for (Map.Entry<String, TestElement> entry : this.triggerElements.entrySet()) {
            TestElement element = entry.getValue();
            if (!element.getFb().getType().equals(type) || !(element.getInterfaceElement() instanceof Event)) continue;
            elements.put(entry.getKey(), element);
        }
        return elements;
    }

    public void addTestElement(TestElement element) {
        this.testElements.put(TestingManager.generateElementString(element), element);
    }

    public Map<String, TestElement> getTestElements(FBType type, ISetValueListener valueListener, ITriggerEventListener eventListener) {
        HashMap<String, TestElement> elements = new HashMap<String, TestElement>();
        for (Map.Entry<String, TestElement> entry : this.testElements.entrySet()) {
            TestElement element = entry.getValue();
            if (!element.getFb().getType().equals(type)) continue;
            element.addSetValueListener(valueListener);
            element.addTriggerEventListener(eventListener);
            if (!(element.getInterfaceElement() instanceof VarDeclaration) && (!(element.getInterfaceElement() instanceof Event) || element.getInterfaceElement().isIsInput())) continue;
            elements.put(entry.getKey(), element);
        }
        return elements;
    }

    public Map<String, TestElement> getTestElements(FBType type) {
        HashMap<String, TestElement> elements = new HashMap<String, TestElement>();
        for (Map.Entry<String, TestElement> entry : this.testElements.entrySet()) {
            TestElement element = entry.getValue();
            if (!element.getFb().getType().equals(type) || !(element.getInterfaceElement() instanceof VarDeclaration) && (!(element.getInterfaceElement() instanceof Event) || element.getInterfaceElement().isIsInput())) continue;
            elements.put(entry.getKey(), element);
        }
        return elements;
    }
}

