/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.export.forte_ng.st;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.fordiac.ide.export.forte_ng.ForteLibraryElementTemplate;
import org.eclipse.fordiac.ide.model.data.DataType;
import org.eclipse.fordiac.ide.model.data.StructuredType;
import org.eclipse.fordiac.ide.model.datatype.helper.IecTypes;
import org.eclipse.fordiac.ide.model.libraryElement.AdapterDeclaration;
import org.eclipse.fordiac.ide.model.libraryElement.AdapterFBType;
import org.eclipse.fordiac.ide.model.libraryElement.BaseFBType;
import org.eclipse.fordiac.ide.model.libraryElement.BasicFBType;
import org.eclipse.fordiac.ide.model.libraryElement.FB;
import org.eclipse.fordiac.ide.model.libraryElement.FBType;
import org.eclipse.fordiac.ide.model.libraryElement.IInterfaceElement;
import org.eclipse.fordiac.ide.model.libraryElement.InterfaceList;
import org.eclipse.fordiac.ide.model.libraryElement.STAlgorithm;
import org.eclipse.fordiac.ide.model.libraryElement.SimpleFBType;
import org.eclipse.fordiac.ide.model.libraryElement.VarDeclaration;
import org.eclipse.fordiac.ide.model.structuredtext.parser.antlr.StructuredTextParser;
import org.eclipse.fordiac.ide.model.structuredtext.structuredText.AdapterRoot;
import org.eclipse.fordiac.ide.model.structuredtext.structuredText.AdapterVariable;
import org.eclipse.fordiac.ide.model.structuredtext.structuredText.Argument;
import org.eclipse.fordiac.ide.model.structuredtext.structuredText.ArrayVariable;
import org.eclipse.fordiac.ide.model.structuredtext.structuredText.AssignmentStatement;
import org.eclipse.fordiac.ide.model.structuredtext.structuredText.BinaryExpression;
import org.eclipse.fordiac.ide.model.structuredtext.structuredText.BinaryOperator;
import org.eclipse.fordiac.ide.model.structuredtext.structuredText.BoolLiteral;
import org.eclipse.fordiac.ide.model.structuredtext.structuredText.Call;
import org.eclipse.fordiac.ide.model.structuredtext.structuredText.CaseClause;
import org.eclipse.fordiac.ide.model.structuredtext.structuredText.CaseStatement;
import org.eclipse.fordiac.ide.model.structuredtext.structuredText.Constant;
import org.eclipse.fordiac.ide.model.structuredtext.structuredText.ContinueStatement;
import org.eclipse.fordiac.ide.model.structuredtext.structuredText.ElseClause;
import org.eclipse.fordiac.ide.model.structuredtext.structuredText.ElseIfClause;
import org.eclipse.fordiac.ide.model.structuredtext.structuredText.ExitStatement;
import org.eclipse.fordiac.ide.model.structuredtext.structuredText.Expression;
import org.eclipse.fordiac.ide.model.structuredtext.structuredText.FBCall;
import org.eclipse.fordiac.ide.model.structuredtext.structuredText.ForStatement;
import org.eclipse.fordiac.ide.model.structuredtext.structuredText.IfStatement;
import org.eclipse.fordiac.ide.model.structuredtext.structuredText.InArgument;
import org.eclipse.fordiac.ide.model.structuredtext.structuredText.IntLiteral;
import org.eclipse.fordiac.ide.model.structuredtext.structuredText.LocalVariable;
import org.eclipse.fordiac.ide.model.structuredtext.structuredText.OutArgument;
import org.eclipse.fordiac.ide.model.structuredtext.structuredText.PartialAccess;
import org.eclipse.fordiac.ide.model.structuredtext.structuredText.PrimaryVariable;
import org.eclipse.fordiac.ide.model.structuredtext.structuredText.RealLiteral;
import org.eclipse.fordiac.ide.model.structuredtext.structuredText.RepeatStatement;
import org.eclipse.fordiac.ide.model.structuredtext.structuredText.ReturnStatement;
import org.eclipse.fordiac.ide.model.structuredtext.structuredText.Statement;
import org.eclipse.fordiac.ide.model.structuredtext.structuredText.StatementList;
import org.eclipse.fordiac.ide.model.structuredtext.structuredText.StringLiteral;
import org.eclipse.fordiac.ide.model.structuredtext.structuredText.StructuredTextAlgorithm;
import org.eclipse.fordiac.ide.model.structuredtext.structuredText.TimeLiteral;
import org.eclipse.fordiac.ide.model.structuredtext.structuredText.UnaryExpression;
import org.eclipse.fordiac.ide.model.structuredtext.structuredText.UnaryOperator;
import org.eclipse.fordiac.ide.model.structuredtext.structuredText.Variable;
import org.eclipse.fordiac.ide.model.structuredtext.structuredText.WhileStatement;
import org.eclipse.fordiac.ide.model.structuredtext.validation.DatetimeLiteral;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.ParserRule;
import org.eclipse.xtext.parser.IParseResult;
import org.eclipse.xtext.parser.IParser;
import org.eclipse.xtext.resource.IResourceServiceProvider;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.resource.XtextResourceSet;
import org.eclipse.xtext.util.CancelIndicator;
import org.eclipse.xtext.util.LazyStringInputStream;
import org.eclipse.xtext.util.Strings;
import org.eclipse.xtext.validation.CheckMode;
import org.eclipse.xtext.validation.IResourceValidator;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.ExclusiveRange;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.eclipse.xtext.xbase.lib.Pair;

public class STAlgorithmFilter {
    private static final String SYNTHETIC_URI_NAME = "__synthetic";
    private static final String URI_SEPERATOR = ".";
    private static final String FB_URI_EXTENSION = "xtextfbt";
    private static final String ST_URI_EXTENSION = "st";
    private static final CharSequence EXPORT_PREFIX = ForteLibraryElementTemplate.EXPORT_PREFIX;
    private static final IResourceServiceProvider SERVICE_PROVIDER = IResourceServiceProvider.Registry.INSTANCE.getResourceServiceProvider(URI.createURI((String)"__synthetic.st"));

    public void createFBResource(XtextResourceSet resourceSet, BaseFBType fbType) {
        Resource fbResource = resourceSet.createResource(this.computeUnusedUri((ResourceSet)resourceSet, FB_URI_EXTENSION));
        fbResource.getContents().add((Object)fbType);
        Consumer<AdapterDeclaration> _function = adp -> this.createAdapterResource(resourceSet, (AdapterDeclaration)adp);
        fbType.getInterfaceList().getSockets().forEach(_function);
        Consumer<AdapterDeclaration> _function_1 = adp -> this.createAdapterResource(resourceSet, (AdapterDeclaration)adp);
        fbType.getInterfaceList().getPlugs().forEach(_function_1);
        Consumer<VarDeclaration> _function_2 = v -> this.createStructResource(resourceSet, (VarDeclaration)v);
        fbType.getInterfaceList().getInputVars().forEach(_function_2);
        Consumer<VarDeclaration> _function_3 = v -> this.createStructResource(resourceSet, (VarDeclaration)v);
        fbType.getInterfaceList().getOutputVars().forEach(_function_3);
        Consumer<VarDeclaration> _function_4 = v -> this.createStructResource(resourceSet, (VarDeclaration)v);
        fbType.getInternalVars().forEach(_function_4);
    }

    public void createAdapterResource(XtextResourceSet resourceSet, AdapterDeclaration adapter) {
        Resource adapterResource = resourceSet.createResource(this.computeUnusedUri((ResourceSet)resourceSet, FB_URI_EXTENSION));
        adapterResource.getContents().add((Object)adapter.getType().getAdapterFBType());
    }

    public void createStructResource(XtextResourceSet resourceSet, VarDeclaration variable) {
        DataType _type = variable.getType();
        if (_type instanceof StructuredType) {
            Resource structResource = resourceSet.createResource(this.computeUnusedUri((ResourceSet)resourceSet, FB_URI_EXTENSION));
            DataType _type_1 = variable.getType();
            StructuredType type = (StructuredType)_type_1;
            structResource.getContents().add((Object)type);
            Consumer<VarDeclaration> _function = v -> this.createStructResource(resourceSet, (VarDeclaration)v);
            type.getMemberVariables().forEach(_function);
        }
    }

    protected URI computeUnusedUri(ResourceSet resourceSet, String fileExtension) {
        ExclusiveRange _doubleDotLessThan = new ExclusiveRange(0, Integer.MAX_VALUE, true);
        for (Integer i : _doubleDotLessThan) {
            boolean _tripleEquals;
            URI syntheticUri = URI.createURI((String)(SYNTHETIC_URI_NAME + i + URI_SEPERATOR + fileExtension));
            Resource _resource = resourceSet.getResource(syntheticUri, false);
            boolean bl = _tripleEquals = _resource == null;
            if (!_tripleEquals) continue;
            return syntheticUri;
        }
        throw new IllegalStateException();
    }

    public XtextResource parseAlgorithm(STAlgorithm alg) {
        try {
            ResourceSet _get = (ResourceSet)SERVICE_PROVIDER.get(ResourceSet.class);
            XtextResourceSet resourceSet = (XtextResourceSet)_get;
            EObject _rootContainer = EcoreUtil.getRootContainer((EObject)alg);
            this.createFBResource(resourceSet, (BaseFBType)_rootContainer);
            Resource _createResource = resourceSet.createResource(this.computeUnusedUri((ResourceSet)resourceSet, ST_URI_EXTENSION));
            XtextResource resource = (XtextResource)_createResource;
            String _text = alg.getText();
            LazyStringInputStream _lazyStringInputStream = new LazyStringInputStream(_text);
            Pair _mappedTo = Pair.of((Object)XtextResource.OPTION_RESOLVE_ALL, (Object)Boolean.TRUE);
            resource.load((InputStream)_lazyStringInputStream, Collections.unmodifiableMap(CollectionLiterals.newHashMap((Pair[])new Pair[]{_mappedTo})));
            EObject _rootASTElement = resource.getParseResult().getRootASTElement();
            StructuredTextAlgorithm stalg = (StructuredTextAlgorithm)_rootASTElement;
            Consumer<VarDeclaration> _function = v -> this.createStructResource(resourceSet, (VarDeclaration)v);
            stalg.getLocalVariables().forEach(_function);
            return resource;
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public EList<VarDeclaration> generateLocalVariables(STAlgorithm alg) {
        IParseResult parseResult = this.parseAlgorithm(alg).getParseResult();
        EObject _rootASTElement = parseResult.getRootASTElement();
        StructuredTextAlgorithm stalg = (StructuredTextAlgorithm)_rootASTElement;
        Consumer<VarDeclaration> _function = v -> v.setTypeName(v.getType().getName());
        stalg.getLocalVariables().forEach(_function);
        return stalg.getLocalVariables();
    }

    public CharSequence generate(STAlgorithm alg, List<String> errors) {
        boolean _not;
        CharSequence _xblockexpression = null;
        XtextResource resource = this.parseAlgorithm(alg);
        IParseResult parseResult = resource.getParseResult();
        IResourceValidator validator = resource.getResourceServiceProvider().getResourceValidator();
        List issues = validator.validate((Resource)resource, CheckMode.ALL, CancelIndicator.NullImpl);
        boolean _isEmpty = issues.isEmpty();
        boolean bl = _not = !_isEmpty;
        if (_not) {
            Functions.Function1 _function = it -> MessageFormat.format("{0}, Line {1}: {2}", alg.getName(), Long.toString(it.getLineNumber().intValue()), it.getMessage());
            errors.addAll(ListExtensions.map((List)issues, (Functions.Function1)_function));
            return null;
        }
        EObject _rootASTElement = parseResult.getRootASTElement();
        StructuredTextAlgorithm stalg = (StructuredTextAlgorithm)_rootASTElement;
        _xblockexpression = this.generateStructuredTextAlgorithm(stalg);
        return _xblockexpression;
    }

    public CharSequence generate(String expression, BasicFBType fb, List<String> errors) {
        IParseResult parseResult;
        CharSequence _xblockexpression;
        block3: {
            try {
                boolean _not;
                _xblockexpression = null;
                ResourceSet _get = (ResourceSet)SERVICE_PROVIDER.get(ResourceSet.class);
                XtextResourceSet resourceSet = (XtextResourceSet)_get;
                BasicFBType _copy = (BasicFBType)EcoreUtil.copy((EObject)fb);
                this.createFBResource(resourceSet, (BaseFBType)_copy);
                Resource _createResource = resourceSet.createResource(this.computeUnusedUri((ResourceSet)resourceSet, ST_URI_EXTENSION));
                XtextResource resource = (XtextResource)_createResource;
                IParser _parser = resource.getParser();
                StructuredTextParser parser = (StructuredTextParser)_parser;
                LazyStringInputStream _lazyStringInputStream = new LazyStringInputStream(expression);
                ParserRule _expressionRule = parser.getGrammarAccess().getExpressionRule();
                Pair _mappedTo = Pair.of((Object)"PARSER_RULE", (Object)_expressionRule);
                resource.load((InputStream)_lazyStringInputStream, Collections.unmodifiableMap(CollectionLiterals.newHashMap((Pair[])new Pair[]{_mappedTo})));
                parseResult = resource.getParseResult();
                IResourceValidator validator = resource.getResourceServiceProvider().getResourceValidator();
                List issues = validator.validate((Resource)resource, CheckMode.ALL, CancelIndicator.NullImpl);
                boolean _isEmpty = issues.isEmpty();
                boolean bl = _not = !_isEmpty;
                if (!_not) break block3;
                Functions.Function1 _function = it -> it.getMessage();
                errors.addAll(ListExtensions.map((List)issues, (Functions.Function1)_function));
                return null;
            }
            catch (Throwable _e) {
                throw Exceptions.sneakyThrow((Throwable)_e);
            }
        }
        EObject _rootASTElement = parseResult.getRootASTElement();
        Expression expr = (Expression)_rootASTElement;
        _xblockexpression = this.generateExpression((EObject)expr);
        return _xblockexpression;
    }

    protected CharSequence generateStructuredTextAlgorithm(StructuredTextAlgorithm alg) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _generateLocalVariables = this.generateLocalVariables((List<VarDeclaration>)alg.getLocalVariables());
        _builder.append((Object)_generateLocalVariables);
        _builder.newLineIfNotEmpty();
        CharSequence _generateStatementList = this.generateStatementList(alg.getStatements());
        _builder.append((Object)_generateStatementList);
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    private int _BitSize(PartialAccess part) {
        int _xifexpression = 0;
        if (part != null) {
            int _xifexpression_1 = 0;
            boolean _isBitaccess = part.isBitaccess();
            if (_isBitaccess) {
                _xifexpression_1 = this.BitSize(IecTypes.ElementaryTypes.BOOL);
            } else {
                int _xifexpression_2 = 0;
                boolean _isByteaccess = part.isByteaccess();
                if (_isByteaccess) {
                    _xifexpression_2 = this.BitSize(IecTypes.ElementaryTypes.BYTE);
                } else {
                    int _xifexpression_3 = 0;
                    boolean _isWordaccess = part.isWordaccess();
                    if (_isWordaccess) {
                        _xifexpression_3 = this.BitSize(IecTypes.ElementaryTypes.WORD);
                    } else {
                        int _xifexpression_4 = 0;
                        boolean _isDwordaccess = part.isDwordaccess();
                        _xifexpression_4 = _isDwordaccess ? this.BitSize(IecTypes.ElementaryTypes.DWORD) : 0;
                        _xifexpression_3 = _xifexpression_4;
                    }
                    _xifexpression_2 = _xifexpression_3;
                }
                _xifexpression_1 = _xifexpression_2;
            }
            _xifexpression = _xifexpression_1;
        } else {
            _xifexpression = 0;
        }
        return _xifexpression;
    }

    private int _BitSize(PrimaryVariable variable) {
        return this.BitSize(variable.getVar().getType());
    }

    private int _BitSize(AdapterVariable variable) {
        return this.BitSize(variable.getVar().getType());
    }

    private int _BitSize(VarDeclaration declaration) {
        return this.BitSize(declaration.getType());
    }

    private int _BitSize(DataType type) {
        int _switchResult = 0;
        boolean _matched = false;
        if (Objects.equal((Object)type, (Object)IecTypes.ElementaryTypes.LWORD)) {
            _matched = true;
            _switchResult = 64;
        }
        if (!_matched && Objects.equal((Object)type, (Object)IecTypes.ElementaryTypes.DWORD)) {
            _matched = true;
            _switchResult = 32;
        }
        if (!_matched && Objects.equal((Object)type, (Object)IecTypes.ElementaryTypes.WORD)) {
            _matched = true;
            _switchResult = 16;
        }
        if (!_matched && Objects.equal((Object)type, (Object)IecTypes.ElementaryTypes.BYTE)) {
            _matched = true;
            _switchResult = 8;
        }
        if (!_matched && Objects.equal((Object)type, (Object)IecTypes.ElementaryTypes.BOOL)) {
            _matched = true;
            _switchResult = 1;
        }
        if (!_matched) {
            _switchResult = 0;
        }
        return _switchResult;
    }

    private int _BitSize(CharSequence str) {
        int _switchResult = 0;
        boolean _matched = false;
        if (Objects.equal((Object)str, (Object)"LWORD")) {
            _matched = true;
            _switchResult = 64;
        }
        if (!_matched && Objects.equal((Object)str, (Object)"DWORD")) {
            _matched = true;
            _switchResult = 32;
        }
        if (!_matched && Objects.equal((Object)str, (Object)"WORD")) {
            _matched = true;
            _switchResult = 16;
        }
        if (!_matched && Objects.equal((Object)str, (Object)"BYTE")) {
            _matched = true;
            _switchResult = 8;
        }
        if (!_matched && Objects.equal((Object)str, (Object)"BOOL")) {
            _matched = true;
            _switchResult = 1;
        }
        if (!_matched) {
            _switchResult = 0;
        }
        return _switchResult;
    }

    protected CharSequence generateArrayDecl(LocalVariable variable) {
        StringConcatenation _builder = new StringConcatenation();
        boolean _isLocated = variable.isLocated();
        if (_isLocated) {
            _builder.newLineIfNotEmpty();
            CharSequence _generateArrayDeclLocated = this.generateArrayDeclLocated(variable);
            _builder.append((Object)_generateArrayDeclLocated);
        } else {
            CharSequence _generateArrayDeclLocal = this.generateArrayDeclLocal(variable);
            _builder.append((Object)_generateArrayDeclLocal);
        }
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    protected CharSequence generateArrayDeclLocated(LocalVariable variable) {
        StringConcatenation _builder;
        StringConcatenation _xblockexpression = null;
        Variable l = variable.getLocation();
        StringConcatenation _switchResult = null;
        boolean _matched = false;
        if (l instanceof PrimaryVariable) {
            _matched = true;
            _builder = new StringConcatenation();
            if (this.BitSize(variable.getType().getName()) > 0 && this.BitSize(((PrimaryVariable)l).getVar().getType().getName()) > 0) {
                int _BitSize_1;
                boolean _greaterThan;
                int _BitSize = this.BitSize(((PrimaryVariable)l).getVar().getType().getName());
                boolean bl = _greaterThan = _BitSize > (_BitSize_1 = this.BitSize(variable.getType().getName()));
                if (_greaterThan) {
                    _builder.append("ARRAY_AT<CIEC_");
                    String _name = variable.getType().getName();
                    _builder.append(_name);
                    _builder.append(", CIEC_");
                    String _name_1 = ((PrimaryVariable)l).getVar().getType().getName();
                    _builder.append(_name_1);
                    _builder.append(", 0, ");
                    int _arraySize = variable.getArraySize();
                    int _minus = _arraySize - 1;
                    _builder.append((Object)_minus);
                    _builder.append("> ");
                    CharSequence _generateVarAccessLocal = this.generateVarAccessLocal(variable);
                    _builder.append((Object)_generateVarAccessLocal);
                    _builder.append("(");
                    CharSequence _generateVarAccess = this.generateVarAccess(((PrimaryVariable)l).getVar());
                    _builder.append((Object)_generateVarAccess);
                    _builder.append(");");
                    _builder.newLineIfNotEmpty();
                } else {
                    _builder.append("#error Accessing CIEC_");
                    String _name_2 = ((PrimaryVariable)l).getVar().getType().getName();
                    _builder.append(_name_2);
                    _builder.append(" via CIEC_");
                    String _name_3 = variable.getType().getName();
                    _builder.append(_name_3);
                    _builder.append(" would result in undefined behaviour");
                    _builder.newLineIfNotEmpty();
                }
            } else {
                _builder.append("#error Piecewise access is supported only for types with defined bit-representation (e.g. not CIEC_");
                String _name_4 = ((PrimaryVariable)l).getVar().getType().getName();
                _builder.append(_name_4);
                _builder.append(" via CIEC_");
                String _name_5 = variable.getType().getName();
                _builder.append(_name_5);
                _builder.append(")");
                _builder.newLineIfNotEmpty();
            }
            _switchResult = _builder;
        }
        if (!_matched) {
            _builder = new StringConcatenation();
            _builder.append("#error unhandled located array");
            _switchResult = _builder;
        }
        _xblockexpression = _switchResult;
        return _xblockexpression;
    }

    protected CharSequence generateArrayDeclLocal(LocalVariable variable) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("CIEC_");
        String _name = variable.getType().getName();
        _builder.append(_name);
        _builder.append(" ");
        _builder.append((Object)EXPORT_PREFIX);
        String _name_1 = variable.getName();
        _builder.append(_name_1);
        _builder.append("[");
        int _arraySize = variable.getArraySize();
        _builder.append((Object)_arraySize);
        _builder.append("]");
        CharSequence _generateLocalVariableInitializer = this.generateLocalVariableInitializer((VarDeclaration)variable);
        _builder.append((Object)_generateLocalVariableInitializer);
        _builder.append(";");
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    protected CharSequence generateVariableDeclLocated(LocalVariable variable) {
        StringConcatenation _builder;
        StringConcatenation _xblockexpression = null;
        Variable l = variable.getLocation();
        StringConcatenation _switchResult = null;
        boolean _matched = false;
        if (l instanceof PrimaryVariable) {
            _matched = true;
            _builder = new StringConcatenation();
            _builder.append("// replacing all instances of ");
            CharSequence _extractTypeInformation = this.extractTypeInformation((EObject)variable);
            _builder.append((Object)_extractTypeInformation);
            _builder.append(":");
            CharSequence _generateVarAccessLocal = this.generateVarAccessLocal(variable);
            _builder.append((Object)_generateVarAccessLocal);
            _builder.append(" with ");
            CharSequence _generateVarAccess = this.generateVarAccess((VarDeclaration)variable);
            _builder.append((Object)_generateVarAccess);
            _switchResult = _builder;
        }
        if (!_matched) {
            _builder = new StringConcatenation();
            _builder.append("#error located variable of unhandled type");
            _switchResult = _builder;
        }
        _xblockexpression = _switchResult;
        return _xblockexpression;
    }

    protected CharSequence generateVariableDeclLocal(LocalVariable variable) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("CIEC_");
        String _name = variable.getType().getName();
        _builder.append(_name);
        _builder.append(" ");
        CharSequence _generateVarAccessLocal = this.generateVarAccessLocal(variable);
        _builder.append((Object)_generateVarAccessLocal);
        CharSequence _generateLocalVariableInitializer = this.generateLocalVariableInitializer((VarDeclaration)variable);
        _builder.append((Object)_generateLocalVariableInitializer);
        _builder.append(";");
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    protected CharSequence generateLocalVariables(List<VarDeclaration> variables) {
        StringConcatenation _builder = new StringConcatenation();
        for (VarDeclaration variable : variables) {
            CharSequence _switchResult = null;
            boolean _matched = false;
            if (variable instanceof LocalVariable && !((LocalVariable)variable).isLocated() && !((LocalVariable)variable).isArray()) {
                _matched = true;
                _switchResult = this.generateVariableDeclLocal((LocalVariable)variable);
            }
            if (!_matched && variable instanceof LocalVariable && !((LocalVariable)variable).isLocated() && ((LocalVariable)variable).isArray()) {
                _matched = true;
                _switchResult = this.generateArrayDeclLocal((LocalVariable)variable);
            }
            if (!_matched && variable instanceof LocalVariable && ((LocalVariable)variable).isLocated() && ((LocalVariable)variable).getLocation() != null && !((LocalVariable)variable).isArray()) {
                _matched = true;
                _switchResult = this.generateVariableDeclLocated((LocalVariable)variable);
            }
            if (!_matched && variable instanceof LocalVariable && ((LocalVariable)variable).isLocated() && ((LocalVariable)variable).getLocation() != null && ((LocalVariable)variable).isArray()) {
                _matched = true;
                _switchResult = this.generateArrayDeclLocated((LocalVariable)variable);
            }
            _builder.append(_switchResult);
            _builder.newLineIfNotEmpty();
        }
        return _builder;
    }

    protected CharSequence generateLocalVariableInitializer(VarDeclaration variable) {
        String _switchResult = null;
        boolean _matched = false;
        if (variable instanceof LocalVariable) {
            boolean _tripleNotEquals;
            Constant _initialValue = ((LocalVariable)variable).getInitialValue();
            boolean bl = _tripleNotEquals = _initialValue != null;
            if (_tripleNotEquals) {
                _matched = true;
                StringConcatenation _builder = new StringConcatenation();
                _builder.append(" ");
                _builder.append("= ");
                CharSequence _generateExpression = this.generateExpression((EObject)((LocalVariable)variable).getInitialValue());
                _builder.append((Object)_generateExpression, " ");
                _switchResult = _builder;
            }
        }
        if (!_matched) {
            _switchResult = "";
        }
        return _switchResult;
    }

    protected CharSequence generateStatementList(StatementList list) {
        StringConcatenation _builder = new StringConcatenation();
        EList _statements = list.getStatements();
        for (Statement stmt : _statements) {
            CharSequence _generateStatement = this.generateStatement(stmt);
            _builder.append((Object)_generateStatement);
            _builder.newLineIfNotEmpty();
        }
        return _builder;
    }

    protected CharSequence _generateStatement(Statement stmt) {
        EClass _eClass = stmt.eClass();
        String _plus = _eClass + " not supported";
        throw new UnsupportedOperationException(_plus);
    }

    protected CharSequence _generateStatement(AssignmentStatement stmt) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _generateExpression = this.generateExpression((EObject)stmt.getVariable());
        _builder.append((Object)_generateExpression);
        _builder.append(" = ");
        CharSequence _generateExpression_1 = this.generateExpression((EObject)stmt.getExpression());
        _builder.append((Object)_generateExpression_1);
        _builder.append(";");
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    protected CharSequence _generateStatement(Call stmt) {
        return this.generateExpression((EObject)stmt);
    }

    protected CharSequence _generateStatement(FBCall fbCall) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _generateInAssignments = this.generateInAssignments(fbCall);
        _builder.append((Object)_generateInAssignments);
        _builder.newLineIfNotEmpty();
        _builder.append("mInternalFBs[");
        Integer _internalFbIndexFromName = this.internalFbIndexFromName(fbCall.getFb());
        _builder.append((Object)_internalFbIndexFromName);
        _builder.append("]->receiveInputEvent(");
        Integer _eventIndexFromName = this.eventIndexFromName(fbCall);
        _builder.append((Object)_eventIndexFromName);
        _builder.append(", nullptr);");
        _builder.newLineIfNotEmpty();
        CharSequence _generateOutAssignments = this.generateOutAssignments(fbCall);
        _builder.append((Object)_generateOutAssignments);
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    public CharSequence generateInAssignments(FBCall call) {
        StringConcatenation _xblockexpression = null;
        Iterable inArgs = Iterables.filter((Iterable)call.getArgs(), InArgument.class);
        StringConcatenation _builder = new StringConcatenation();
        for (InArgument inArg : inArgs) {
            String _generateInAssigmentExpression = this.generateInAssigmentExpression(call.getFb(), inArg);
            _builder.append(_generateInAssigmentExpression);
            _builder.append(" = ");
            CharSequence _generateInAssigmentRHS = this.generateInAssigmentRHS(inArg);
            _builder.append((Object)_generateInAssigmentRHS);
            _builder.append(";");
            _builder.newLineIfNotEmpty();
        }
        _xblockexpression = _builder;
        return _xblockexpression;
    }

    public CharSequence generateInAssigmentRHS(InArgument inArg) {
        CharSequence _xifexpression_1;
        CharSequence _xblockexpression_1;
        CharSequence _xblockexpression = null;
        Expression inArgRHS = inArg.getExpr();
        CharSequence _xifexpression = null;
        if (inArgRHS instanceof PrimaryVariable && ((PrimaryVariable)inArgRHS).getVar().isArray()) {
            _xblockexpression_1 = null;
            VarDeclaration inArgVar = ((PrimaryVariable)inArgRHS).getVar();
            _xifexpression_1 = null;
            EObject _eContainer = ((PrimaryVariable)inArgRHS).getVar().eContainer();
            if (_eContainer instanceof InterfaceList) {
                StringConcatenation _xblockexpression_2 = null;
                EObject _eContainer_1 = ((PrimaryVariable)inArgRHS).getVar().eContainer();
                InterfaceList argFBInterfaceList = (InterfaceList)_eContainer_1;
                StringConcatenation _builder = new StringConcatenation();
                _builder.append("*static_cast<CIEC_ARRAY*>(getDI(");
                Integer _inputIndex = this.getInputIndex(argFBInterfaceList, inArgVar.getName());
                _builder.append((Object)_inputIndex);
                _builder.append("))");
                _xblockexpression_2 = _builder;
                _xifexpression_1 = _xblockexpression_2;
            } else {
                CharSequence _xifexpression_2 = null;
                EObject _eContainer_1 = ((PrimaryVariable)inArgRHS).getVar().eContainer();
                if (_eContainer_1 instanceof SimpleFBType) {
                    StringConcatenation _xblockexpression_3 = null;
                    EObject _eContainer_2 = ((PrimaryVariable)inArgRHS).getVar().eContainer();
                    SimpleFBType fbType = (SimpleFBType)_eContainer_2;
                    StringConcatenation _builder = new StringConcatenation();
                    _builder.append("*static_cast<CIEC_ARRAY*>(");
                    String _generateGetVariable = this.generateGetVariable((FBType)fbType, inArgVar.getName());
                    _builder.append(_generateGetVariable);
                    _builder.append(")");
                    _xblockexpression_3 = _builder;
                    _xifexpression_2 = _xblockexpression_3;
                } else {
                    CharSequence _xifexpression_3 = null;
                    EObject _eContainer_2 = ((PrimaryVariable)inArgRHS).getVar().eContainer();
                    if (_eContainer_2 instanceof StructuredTextAlgorithm) {
                        _xifexpression_3 = this.generateExpression((EObject)inArg.getExpr());
                    }
                    _xifexpression_2 = _xifexpression_3;
                }
                _xifexpression_1 = _xifexpression_2;
            }
        } else {
            return this.generateExpression((EObject)inArg.getExpr());
        }
        _xifexpression = _xblockexpression_1 = _xifexpression_1;
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }

    public String generateInAssigmentExpression(FB calledFb, InArgument argument) {
        VarDeclaration varDec = this.getInputVarDeclaration(calledFb, argument);
        boolean _isArray = varDec.isArray();
        if (_isArray) {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("*static_cast<CIEC_ARRAY*>(mInternalFBs[");
            Integer _internalFbIndexFromName = this.internalFbIndexFromName(calledFb);
            _builder.append((Object)_internalFbIndexFromName);
            _builder.append("]->getDI(");
            Integer _inputIndex = this.getInputIndex(calledFb, argument.getVar());
            _builder.append((Object)_inputIndex);
            _builder.append("))");
            return _builder.toString();
        }
        StringConcatenation _builder_1 = new StringConcatenation();
        _builder_1.append("*static_cast<CIEC_");
        String _name = varDec.getType().getName();
        _builder_1.append(_name);
        _builder_1.append("*>(mInternalFBs[");
        Integer _internalFbIndexFromName_1 = this.internalFbIndexFromName(calledFb);
        _builder_1.append((Object)_internalFbIndexFromName_1);
        _builder_1.append("]->getDI(");
        Integer _inputIndex_1 = this.getInputIndex(calledFb, argument.getVar());
        _builder_1.append((Object)_inputIndex_1);
        _builder_1.append("))");
        return _builder_1.toString();
    }

    public VarDeclaration getInputVarDeclaration(FB fb, InArgument argument) {
        Functions.Function1 _function = it -> {
            String _name = it.getName();
            String _var = argument.getVar();
            return Objects.equal((Object)_name, (Object)_var);
        };
        return (VarDeclaration)IterableExtensions.findFirst((Iterable)fb.getInterface().getInputVars(), (Functions.Function1)_function);
    }

    public Integer getInterfaceElementIndex(EList<? extends IInterfaceElement> interfaceList, String elementName) {
        int index = 0;
        for (IInterfaceElement interfaceElement : interfaceList) {
            String _name = interfaceElement.getName();
            boolean _equals = Objects.equal((Object)_name, (Object)elementName);
            if (_equals) {
                return index;
            }
            ++index;
        }
        return null;
    }

    public Integer getInputIndex(InterfaceList list, String varName) {
        return this.getInterfaceElementIndex((EList<? extends IInterfaceElement>)list.getInputVars(), varName);
    }

    public Integer getInputIndex(FBType fbType, String varName) {
        return this.getInputIndex(fbType.getInterfaceList(), varName);
    }

    public Integer getInputIndex(FB fb, String varName) {
        return this.getInputIndex(fb.getInterface(), varName);
    }

    public CharSequence generateOutAssignments(FBCall call) {
        StringConcatenation _xblockexpression = null;
        Iterable outArgs = Iterables.filter((Iterable)call.getArgs(), OutArgument.class);
        StringConcatenation _builder = new StringConcatenation();
        for (OutArgument outArg : outArgs) {
            CharSequence _generateOutAssignmentLHS = this.generateOutAssignmentLHS(outArg);
            _builder.append((Object)_generateOutAssignmentLHS);
            _builder.append(" = ");
            CharSequence _generateOutAssignmentRHS = this.generateOutAssignmentRHS(call, outArg);
            _builder.append((Object)_generateOutAssignmentRHS);
            _builder.append(";");
            _builder.newLineIfNotEmpty();
        }
        _xblockexpression = _builder;
        return _xblockexpression;
    }

    public CharSequence generateOutAssignmentRHS(FBCall fbCall, OutArgument argument) {
        StringConcatenation _xblockexpression = null;
        FBType fbType = fbCall.getFb().getType();
        VarDeclaration varDec = this.getTargetVarDeclaration(fbType, argument);
        StringConcatenation _xifexpression = null;
        if (varDec != null) {
            StringConcatenation _xifexpression_1 = null;
            boolean _isArray = varDec.isArray();
            if (_isArray) {
                StringConcatenation _builder = new StringConcatenation();
                _builder.append("*static_cast<CIEC_ARRAY*>(mInternalFBs[");
                Integer _internalFbIndexFromName = this.internalFbIndexFromName(fbCall.getFb());
                _builder.append((Object)_internalFbIndexFromName);
                _builder.append("]->");
                String _generateGetVariable = this.generateGetVariable(fbType, varDec.getName());
                _builder.append(_generateGetVariable);
                _builder.append(")");
                _xifexpression_1 = _builder;
            } else {
                StringConcatenation _builder_1 = new StringConcatenation();
                _builder_1.append("*static_cast<CIEC_");
                String _name = varDec.getType().getName();
                _builder_1.append(_name);
                _builder_1.append("*>(mInternalFBs[");
                Integer _internalFbIndexFromName_1 = this.internalFbIndexFromName(fbCall.getFb());
                _builder_1.append((Object)_internalFbIndexFromName_1);
                _builder_1.append("]->");
                String _generateGetVariable_1 = this.generateGetVariable(fbType, varDec.getName());
                _builder_1.append(_generateGetVariable_1);
                _builder_1.append(")");
                _xifexpression_1 = _builder_1;
            }
            _xifexpression = _xifexpression_1;
        }
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }

    public String generateGetVariable(FBType type, String name) {
        Integer inputIndex = this.getInputIndex(type, name);
        if (inputIndex != null) {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("getDI(");
            _builder.append((Object)inputIndex);
            _builder.append(")");
            return _builder.toString();
        }
        Integer outputIndex = this.getOutputIndex(type, name);
        if (outputIndex != null) {
            StringConcatenation _builder_1 = new StringConcatenation();
            _builder_1.append("getDO(");
            _builder_1.append((Object)outputIndex);
            _builder_1.append(")");
            return _builder_1.toString();
        }
        Integer _xifexpression = null;
        _xifexpression = type instanceof BaseFBType ? this.getInternalVarIndex((BaseFBType)type, name) : null;
        Integer internalVariableIndex = _xifexpression;
        if (internalVariableIndex != null) {
            StringConcatenation _builder_2 = new StringConcatenation();
            _builder_2.append("getVarInternal(");
            Integer _internalVarIndex = this.getInternalVarIndex((BaseFBType)type, name);
            _builder_2.append((Object)_internalVarIndex);
            _builder_2.append(")");
            return _builder_2.toString();
        }
        String _name = type.getName();
        String _plus = "Name " + name + " not a variable on FB type " + _name;
        throw new IllegalArgumentException(_plus);
    }

    public CharSequence generateOutAssignmentLHS(OutArgument argument) {
        StringConcatenation _xblockexpression = null;
        Variable goalExpression = argument.getExpr();
        StringConcatenation _xifexpression = null;
        if (goalExpression instanceof PrimaryVariable) {
            StringConcatenation _xblockexpression_1 = null;
            VarDeclaration outVariable = ((PrimaryVariable)goalExpression).getVar();
            EObject _eContainer = outVariable.eContainer().eContainer();
            FBType callingFBType = (FBType)_eContainer;
            StringConcatenation _xifexpression_1 = null;
            boolean _isArray = outVariable.isArray();
            if (_isArray) {
                StringConcatenation _builder = new StringConcatenation();
                _builder.append("*static_cast<CIEC_ARRAY*>(");
                String _generateGetVariable = this.generateGetVariable(callingFBType, outVariable.getName());
                _builder.append(_generateGetVariable);
                _builder.append(")");
                return _builder.toString();
            }
            StringConcatenation _builder_1 = new StringConcatenation();
            CharSequence _generateExpression = this.generateExpression((EObject)argument.getExpr());
            _builder_1.append((Object)_generateExpression);
            _xifexpression = _xblockexpression_1 = (_xifexpression_1 = _builder_1);
        }
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }

    public VarDeclaration getVarDeclaration(EList<? extends IInterfaceElement> interfaceList, String varName) {
        Functions.Function1 _function = it -> {
            String _name = it.getName();
            return Objects.equal((Object)_name, (Object)varName);
        };
        IInterfaceElement _findFirst = (IInterfaceElement)IterableExtensions.findFirst(interfaceList, (Functions.Function1)_function);
        return (VarDeclaration)_findFirst;
    }

    public VarDeclaration getTargetVarDeclaration(FB fb, OutArgument argument) {
        return this.getTargetVarDeclaration(fb.getType(), argument);
    }

    public VarDeclaration getTargetVarDeclaration(FBType fbType, OutArgument argument) {
        VarDeclaration _xblockexpression = null;
        String varName = argument.getVar();
        VarDeclaration _varDeclaration = this.getVarDeclaration((EList<? extends IInterfaceElement>)fbType.getInterfaceList().getOutputVars(), varName);
        VarDeclaration _varDeclaration_1 = this.getVarDeclaration((EList<? extends IInterfaceElement>)fbType.getInterfaceList().getInputVars(), varName);
        VarDeclaration _or = this.operator_or(_varDeclaration, _varDeclaration_1);
        VarDeclaration _xifexpression = null;
        _xifexpression = fbType instanceof BaseFBType ? this.getVarDeclaration((EList<? extends IInterfaceElement>)((BaseFBType)fbType).getInternalVars(), varName) : null;
        _xblockexpression = this.operator_or(_or, _xifexpression);
        return _xblockexpression;
    }

    public VarDeclaration operator_or(VarDeclaration element, VarDeclaration element2) {
        VarDeclaration _xifexpression = null;
        _xifexpression = element != null ? element : element2;
        return _xifexpression;
    }

    public Integer getOutputIndex(FB fb, String varName) {
        return this.getInterfaceElementIndex((EList<? extends IInterfaceElement>)fb.getInterface().getOutputVars(), varName);
    }

    public Integer getOutputIndex(FBType fbType, String varName) {
        return this.getInterfaceElementIndex((EList<? extends IInterfaceElement>)fbType.getInterfaceList().getOutputVars(), varName);
    }

    public Object getInternalVarIndex(FB fb, String varName) {
        FBType _type = fb.getType();
        if (_type instanceof BaseFBType) {
            FBType _type_1 = fb.getType();
            this.getInternalVarIndex((BaseFBType)_type_1, varName);
        }
        return null;
    }

    public Integer getInternalVarIndex(BaseFBType fbType, String varName) {
        return this.getInterfaceElementIndex((EList<? extends IInterfaceElement>)fbType.getInternalVars(), varName);
    }

    public Integer eventIndexFromName(FBCall fbCall) {
        return this.getInterfaceElementIndex((EList<? extends IInterfaceElement>)fbCall.getFb().getInterface().getEventInputs(), fbCall.getEvent());
    }

    public Integer internalFbIndexFromName(FB fb) {
        EObject _eContainer = fb.eContainer();
        BaseFBType fbType = (BaseFBType)_eContainer;
        int index = 0;
        EList _internalFbs = fbType.getInternalFbs();
        for (FB internalFb : _internalFbs) {
            if (fb == internalFb) {
                return index;
            }
            ++index;
        }
        return null;
    }

    protected CharSequence _generateStatement(ReturnStatement stmt) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("return;");
        return _builder;
    }

    protected CharSequence _generateStatement(IfStatement stmt) {
        boolean _tripleNotEquals;
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("if(");
        CharSequence _generateExpression = this.generateExpression((EObject)stmt.getExpression());
        _builder.append((Object)_generateExpression);
        _builder.append(") {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        CharSequence _generateStatementList = this.generateStatementList(stmt.getStatments());
        _builder.append((Object)_generateStatementList, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("}");
        _builder.newLine();
        EList _elseif = stmt.getElseif();
        for (ElseIfClause elseif : _elseif) {
            _builder.append("else if(");
            CharSequence _generateExpression_1 = this.generateExpression((EObject)elseif.getExpression());
            _builder.append((Object)_generateExpression_1);
            _builder.append(") {");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            CharSequence _generateStatementList_1 = this.generateStatementList(elseif.getStatements());
            _builder.append((Object)_generateStatementList_1, "\t");
            _builder.newLineIfNotEmpty();
            _builder.append("}");
            _builder.newLine();
        }
        ElseClause _else = stmt.getElse();
        boolean bl = _tripleNotEquals = _else != null;
        if (_tripleNotEquals) {
            _builder.append("else {");
            _builder.newLine();
            _builder.append("\t");
            CharSequence _generateStatementList_2 = this.generateStatementList(stmt.getElse().getStatements());
            _builder.append((Object)_generateStatementList_2, "\t");
            _builder.newLineIfNotEmpty();
            _builder.append("}");
            _builder.newLine();
        }
        return _builder;
    }

    protected CharSequence _generateStatement(CaseStatement stmt) {
        boolean _tripleNotEquals;
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("switch (");
        CharSequence _generateExpression = this.generateExpression((EObject)stmt.getExpression());
        _builder.append((Object)_generateExpression);
        _builder.append(") {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        EList _case = stmt.getCase();
        for (CaseClause clause : _case) {
            CharSequence _generateCaseClause = this.generateCaseClause(clause);
            _builder.append((Object)_generateCaseClause, "\t");
        }
        _builder.newLineIfNotEmpty();
        ElseClause _else = stmt.getElse();
        boolean bl = _tripleNotEquals = _else != null;
        if (_tripleNotEquals) {
            _builder.append("\t");
            _builder.append("default:");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("\t");
            CharSequence _generateStatementList = this.generateStatementList(stmt.getElse().getStatements());
            _builder.append((Object)_generateStatementList, "\t\t");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("\t");
            _builder.append("break;");
            _builder.newLine();
        }
        _builder.append("}");
        _builder.newLine();
        return _builder;
    }

    protected CharSequence generateCaseClause(CaseClause clause) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("case ");
        EList _case = clause.getCase();
        boolean _hasElements = false;
        for (Constant value : _case) {
            if (!_hasElements) {
                _hasElements = true;
            } else {
                _builder.appendImmediate((Object)" case ", "");
            }
            CharSequence _generateExpression = this.generateExpression((EObject)value);
            _builder.append((Object)_generateExpression);
            _builder.append(":");
        }
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        CharSequence _generateStatementList = this.generateStatementList(clause.getStatements());
        _builder.append((Object)_generateStatementList, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("break;");
        _builder.newLine();
        return _builder;
    }

    protected CharSequence _generateStatement(ExitStatement stmt) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("break;");
        return _builder;
    }

    protected CharSequence _generateStatement(ContinueStatement stmt) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("continue;");
        return _builder;
    }

    private EList<Statement> _containedStatements(IfStatement statement) {
        boolean _tripleNotEquals_1;
        BasicEList list = new BasicEList();
        list.addAll((Collection)statement.getStatments().getStatements());
        EList _elseif = statement.getElseif();
        for (ElseIfClause elseif : _elseif) {
            boolean _tripleNotEquals;
            StatementList _statements = null;
            if (elseif != null) {
                _statements = elseif.getStatements();
            }
            EList _statements_1 = null;
            if (_statements != null) {
                _statements_1 = _statements.getStatements();
            }
            boolean bl = _tripleNotEquals = _statements_1 != null;
            if (!_tripleNotEquals) continue;
            list.addAll((Collection)elseif.getStatements().getStatements());
        }
        ElseClause _else = null;
        if (statement != null) {
            _else = statement.getElse();
        }
        StatementList _statements_2 = null;
        if (_else != null) {
            _statements_2 = _else.getStatements();
        }
        EList _statements_3 = null;
        if (_statements_2 != null) {
            _statements_3 = _statements_2.getStatements();
        }
        boolean bl = _tripleNotEquals_1 = _statements_3 != null;
        if (_tripleNotEquals_1) {
            list.addAll((Collection)statement.getElse().getStatements().getStatements());
        }
        return list;
    }

    private EList<Statement> _containedStatements(CaseStatement statement) {
        boolean _tripleNotEquals_1;
        BasicEList list = new BasicEList();
        EList _case = statement.getCase();
        for (CaseClause casz : _case) {
            boolean _tripleNotEquals;
            StatementList _statements = null;
            if (casz != null) {
                _statements = casz.getStatements();
            }
            EList _statements_1 = null;
            if (_statements != null) {
                _statements_1 = _statements.getStatements();
            }
            boolean bl = _tripleNotEquals = _statements_1 != null;
            if (!_tripleNotEquals) continue;
            list.addAll((Collection)casz.getStatements().getStatements());
        }
        EList _statements_2 = statement.getElse().getStatements().getStatements();
        boolean bl = _tripleNotEquals_1 = _statements_2 != null;
        if (_tripleNotEquals_1) {
            list.addAll((Collection)statement.getElse().getStatements().getStatements());
        }
        return list;
    }

    private EList<Statement> _containedStatements(ForStatement statement) {
        return statement.getStatements().getStatements();
    }

    private EList<Statement> _containedStatements(WhileStatement statement) {
        return statement.getStatements().getStatements();
    }

    private EList<Statement> _containedStatements(RepeatStatement statement) {
        return statement.getStatements().getStatements();
    }

    private EList<Statement> _containedStatements(Statement statement) {
        BasicEList list = new BasicEList();
        return list;
    }

    private String indexForLoopVariables(ForStatement forStatement) {
        boolean _tripleEquals;
        Object _get;
        int i;
        Functions.Function1 _function;
        EObject _rootContainer = EcoreUtil.getRootContainer((EObject)forStatement);
        StructuredTextAlgorithm forRootAlgorithm = (StructuredTextAlgorithm)_rootContainer;
        ForStatement searchItem = forStatement;
        EObject container = forStatement.eContainer().eContainer();
        ArrayList<Integer> indexList = new ArrayList<Integer>();
        while (container != forRootAlgorithm) {
            if (container instanceof Statement) {
                _function = it -> it instanceof ForStatement;
                Iterable forStatementsInContainer = IterableExtensions.filter(this.containedStatements((Statement)container), (Functions.Function1)_function);
                i = 0;
                while (i < IterableExtensions.size((Iterable)forStatementsInContainer)) {
                    _get = ((Object[])Conversions.unwrapArray((Object)forStatementsInContainer, Object.class))[i];
                    boolean bl = _tripleEquals = searchItem == _get;
                    if (_tripleEquals) {
                        indexList.add(i);
                    }
                    ++i;
                }
                searchItem = (Statement)container;
            }
            container = container.eContainer().eContainer();
        }
        _function = it -> it instanceof ForStatement;
        Iterable forStatementsInAlgorithm = IterableExtensions.filter((Iterable)forRootAlgorithm.getStatements().getStatements(), (Functions.Function1)_function);
        i = 0;
        while (i < IterableExtensions.size((Iterable)forStatementsInAlgorithm)) {
            _get = ((Object[])Conversions.unwrapArray((Object)forStatementsInAlgorithm, Object.class))[i];
            boolean bl = _tripleEquals = searchItem == _get;
            if (_tripleEquals) {
                indexList.add(i);
            }
            ++i;
        }
        String indexString = "";
        List _reverse = ListExtensions.reverse(indexList);
        for (Integer i2 : _reverse) {
            String _indexString = indexString;
            indexString = String.valueOf(_indexString) + "_" + i2;
        }
        return indexString;
    }

    protected CharSequence _generateStatement(ForStatement stmt) {
        boolean _tripleNotEquals;
        StringConcatenation _xblockexpression = null;
        String loopVarIndex = this.indexForLoopVariables(stmt);
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("const auto by");
        _builder.append(loopVarIndex);
        _builder.append(" = ");
        Expression _by = stmt.getBy();
        boolean bl = _tripleNotEquals = _by != null;
        if (_tripleNotEquals) {
            CharSequence _generateExpression = this.generateExpression((EObject)stmt.getBy());
            _builder.append((Object)_generateExpression);
        } else {
            _builder.append("1");
        }
        _builder.append(";");
        _builder.newLineIfNotEmpty();
        _builder.append("const auto to");
        _builder.append(loopVarIndex);
        _builder.append(" = ");
        CharSequence _generateExpression_1 = this.generateExpression((EObject)stmt.getTo());
        _builder.append((Object)_generateExpression_1);
        _builder.append(";");
        _builder.newLineIfNotEmpty();
        _builder.append("for(");
        CharSequence _generateExpression_2 = this.generateExpression((EObject)stmt.getVariable());
        _builder.append((Object)_generateExpression_2);
        _builder.append(" = ");
        CharSequence _generateExpression_3 = this.generateExpression((EObject)stmt.getFrom());
        _builder.append((Object)_generateExpression_3);
        _builder.append(";");
        _builder.newLineIfNotEmpty();
        _builder.append("    ");
        _builder.append("(by");
        _builder.append(loopVarIndex, "    ");
        _builder.append(" >  0 && ");
        CharSequence _generateExpression_4 = this.generateExpression((EObject)stmt.getVariable());
        _builder.append((Object)_generateExpression_4, "    ");
        _builder.append(" <= to");
        _builder.append(loopVarIndex, "    ");
        _builder.append(") ||");
        _builder.newLineIfNotEmpty();
        _builder.append("    ");
        _builder.append("(by");
        _builder.append(loopVarIndex, "    ");
        _builder.append(" <= 0 && ");
        CharSequence _generateExpression_5 = this.generateExpression((EObject)stmt.getVariable());
        _builder.append((Object)_generateExpression_5, "    ");
        _builder.append(" >= to");
        _builder.append(loopVarIndex, "    ");
        _builder.append(");");
        _builder.newLineIfNotEmpty();
        _builder.append("    ");
        CharSequence _generateExpression_6 = this.generateExpression((EObject)stmt.getVariable());
        _builder.append((Object)_generateExpression_6, "    ");
        _builder.append(" = ");
        CharSequence _generateExpression_7 = this.generateExpression((EObject)stmt.getVariable());
        _builder.append((Object)_generateExpression_7, "    ");
        _builder.append(" + by");
        _builder.append(loopVarIndex, "    ");
        _builder.append("){");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        CharSequence _generateStatementList = this.generateStatementList(stmt.getStatements());
        _builder.append((Object)_generateStatementList, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("}");
        _builder.newLine();
        _xblockexpression = _builder;
        return _xblockexpression;
    }

    protected CharSequence _generateStatement(WhileStatement stmt) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("while(");
        CharSequence _generateExpression = this.generateExpression((EObject)stmt.getExpression());
        _builder.append((Object)_generateExpression);
        _builder.append(") {");
        _builder.newLineIfNotEmpty();
        _builder.append("  ");
        CharSequence _generateStatementList = this.generateStatementList(stmt.getStatements());
        _builder.append((Object)_generateStatementList, "  ");
        _builder.newLineIfNotEmpty();
        _builder.append("}");
        _builder.newLine();
        return _builder;
    }

    protected CharSequence _generateStatement(RepeatStatement stmt) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("do {");
        _builder.newLine();
        _builder.append("  ");
        CharSequence _generateStatementList = this.generateStatementList(stmt.getStatements());
        _builder.append((Object)_generateStatementList, "  ");
        _builder.newLineIfNotEmpty();
        _builder.append("} while(!((");
        CharSequence _generateExpression = this.generateExpression((EObject)stmt.getExpression());
        _builder.append((Object)_generateExpression);
        _builder.append(")));");
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    protected CharSequence generateBinaryOperator(BinaryOperator op) {
        StringConcatenation _switchResult;
        block14: {
            block13: {
                _switchResult = null;
                if (op == null) break block13;
                switch (op) {
                    case OR: {
                        StringConcatenation _builder = new StringConcatenation();
                        _builder.append("||");
                        _switchResult = _builder;
                        break block14;
                    }
                    case XOR: {
                        StringConcatenation _builder_1 = new StringConcatenation();
                        _builder_1.append("^");
                        _switchResult = _builder_1;
                        break block14;
                    }
                    case AND: {
                        StringConcatenation _builder_2 = new StringConcatenation();
                        _builder_2.append("&&");
                        _switchResult = _builder_2;
                        break block14;
                    }
                    case AMPERSAND: {
                        StringConcatenation _builder_3 = new StringConcatenation();
                        _builder_3.append("&&");
                        _switchResult = _builder_3;
                        break block14;
                    }
                    case EQ: {
                        StringConcatenation _builder_4 = new StringConcatenation();
                        _builder_4.append("==");
                        _switchResult = _builder_4;
                        break block14;
                    }
                    case NE: {
                        StringConcatenation _builder_5 = new StringConcatenation();
                        _builder_5.append("!=");
                        _switchResult = _builder_5;
                        break block14;
                    }
                    case LT: {
                        StringConcatenation _builder_6 = new StringConcatenation();
                        _builder_6.append("<");
                        _switchResult = _builder_6;
                        break block14;
                    }
                    case LE: {
                        StringConcatenation _builder_7 = new StringConcatenation();
                        _builder_7.append("<=");
                        _switchResult = _builder_7;
                        break block14;
                    }
                    case GT: {
                        StringConcatenation _builder_8 = new StringConcatenation();
                        _builder_8.append(">");
                        _switchResult = _builder_8;
                        break block14;
                    }
                    case GE: {
                        StringConcatenation _builder_9 = new StringConcatenation();
                        _builder_9.append(">=");
                        _switchResult = _builder_9;
                        break block14;
                    }
                    case MOD: {
                        StringConcatenation _builder_10 = new StringConcatenation();
                        _builder_10.append("%");
                        _switchResult = _builder_10;
                        break block14;
                    }
                    default: {
                        StringConcatenation _builder_11 = new StringConcatenation();
                        _builder_11.append("The operator ");
                        _builder_11.append((Object)op);
                        _builder_11.append(" is not supported");
                        throw new UnsupportedOperationException(_builder_11.toString());
                    }
                }
            }
            StringConcatenation _builder_11 = new StringConcatenation();
            _builder_11.append("The operator ");
            _builder_11.append((Object)op);
            _builder_11.append(" is not supported");
            throw new UnsupportedOperationException(_builder_11.toString());
        }
        return _switchResult;
    }

    protected CharSequence generateUnaryOperator(UnaryOperator op) {
        StringConcatenation _switchResult = null;
        if (op != null) {
            switch (op) {
                case MINUS: {
                    StringConcatenation _builder = new StringConcatenation();
                    _builder.append("-");
                    _switchResult = _builder;
                    break;
                }
                case PLUS: {
                    StringConcatenation _builder_1 = new StringConcatenation();
                    _builder_1.append("+");
                    _switchResult = _builder_1;
                    break;
                }
                case NOT: {
                    StringConcatenation _builder_2 = new StringConcatenation();
                    _builder_2.append("!");
                    _switchResult = _builder_2;
                    break;
                }
            }
        }
        return _switchResult;
    }

    protected CharSequence _generateExpression(Call expr) {
        StringConcatenation _builder = new StringConcatenation();
        String _func = expr.getFunc();
        _builder.append(_func);
        _builder.append("(");
        EList _args = expr.getArgs();
        boolean _hasElements = false;
        for (Argument arg : _args) {
            if (!_hasElements) {
                _hasElements = true;
            } else {
                _builder.appendImmediate((Object)", ", "");
            }
            CharSequence _generateExpression = this.generateExpression((EObject)arg);
            _builder.append((Object)_generateExpression);
        }
        _builder.append(")");
        return _builder;
    }

    protected CharSequence _generateExpression(InArgument arg) {
        return this.generateExpression((EObject)arg.getExpr());
    }

    protected CharSequence _generateExpression(BinaryExpression expr) {
        StringConcatenation _switchResult = null;
        BinaryOperator _operator = expr.getOperator();
        if (_operator != null) {
            switch (_operator) {
                case POWER: {
                    StringConcatenation _builder = new StringConcatenation();
                    _builder.append("EXPT(");
                    CharSequence _generateExpression = this.generateExpression((EObject)expr.getLeft());
                    _builder.append((Object)_generateExpression);
                    _builder.append(", ");
                    CharSequence _generateExpression_1 = this.generateExpression((EObject)expr.getRight());
                    _builder.append((Object)_generateExpression_1);
                    _builder.append(")");
                    _switchResult = _builder;
                    break;
                }
                case ADD: {
                    StringConcatenation _builder_1 = new StringConcatenation();
                    _builder_1.append("ADD(");
                    CharSequence _generateExpression_2 = this.generateExpression((EObject)expr.getLeft());
                    _builder_1.append((Object)_generateExpression_2);
                    _builder_1.append(", ");
                    CharSequence _generateExpression_3 = this.generateExpression((EObject)expr.getRight());
                    _builder_1.append((Object)_generateExpression_3);
                    _builder_1.append(")");
                    _switchResult = _builder_1;
                    break;
                }
                case SUB: {
                    StringConcatenation _builder_2 = new StringConcatenation();
                    _builder_2.append("SUB(");
                    CharSequence _generateExpression_4 = this.generateExpression((EObject)expr.getLeft());
                    _builder_2.append((Object)_generateExpression_4);
                    _builder_2.append(", ");
                    CharSequence _generateExpression_5 = this.generateExpression((EObject)expr.getRight());
                    _builder_2.append((Object)_generateExpression_5);
                    _builder_2.append(")");
                    _switchResult = _builder_2;
                    break;
                }
                case DIV: {
                    StringConcatenation _builder_3 = new StringConcatenation();
                    _builder_3.append("DIV(");
                    CharSequence _generateExpression_6 = this.generateExpression((EObject)expr.getLeft());
                    _builder_3.append((Object)_generateExpression_6);
                    _builder_3.append(", ");
                    CharSequence _generateExpression_7 = this.generateExpression((EObject)expr.getRight());
                    _builder_3.append((Object)_generateExpression_7);
                    _builder_3.append(")");
                    _switchResult = _builder_3;
                    break;
                }
                case MUL: {
                    StringConcatenation _builder_4 = new StringConcatenation();
                    _builder_4.append("MUL(");
                    CharSequence _generateExpression_8 = this.generateExpression((EObject)expr.getLeft());
                    _builder_4.append((Object)_generateExpression_8);
                    _builder_4.append(", ");
                    CharSequence _generateExpression_9 = this.generateExpression((EObject)expr.getRight());
                    _builder_4.append((Object)_generateExpression_9);
                    _builder_4.append(")");
                    _switchResult = _builder_4;
                    break;
                }
                default: {
                    StringConcatenation _builder_5 = new StringConcatenation();
                    _builder_5.append("(");
                    CharSequence _generateExpression_10 = this.generateExpression((EObject)expr.getLeft());
                    _builder_5.append((Object)_generateExpression_10);
                    _builder_5.append(" ");
                    CharSequence _generateBinaryOperator = this.generateBinaryOperator(expr.getOperator());
                    _builder_5.append((Object)_generateBinaryOperator);
                    _builder_5.append(" ");
                    CharSequence _generateExpression_11 = this.generateExpression((EObject)expr.getRight());
                    _builder_5.append((Object)_generateExpression_11);
                    _builder_5.append(")");
                    _switchResult = _builder_5;
                    break;
                }
            }
        } else {
            StringConcatenation _builder_5 = new StringConcatenation();
            _builder_5.append("(");
            CharSequence _generateExpression_10 = this.generateExpression((EObject)expr.getLeft());
            _builder_5.append((Object)_generateExpression_10);
            _builder_5.append(" ");
            CharSequence _generateBinaryOperator = this.generateBinaryOperator(expr.getOperator());
            _builder_5.append((Object)_generateBinaryOperator);
            _builder_5.append(" ");
            CharSequence _generateExpression_11 = this.generateExpression((EObject)expr.getRight());
            _builder_5.append((Object)_generateExpression_11);
            _builder_5.append(")");
            _switchResult = _builder_5;
        }
        return _switchResult;
    }

    protected CharSequence _generateExpression(TimeLiteral expr) {
        StringConcatenation _builder = new StringConcatenation();
        String _literal = expr.getLiteral();
        DatetimeLiteral _datetimeLiteral = new DatetimeLiteral(_literal);
        _builder.append((Object)_datetimeLiteral);
        return _builder;
    }

    protected CharSequence _generateExpression(UnaryExpression expr) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("(");
        CharSequence _generateUnaryOperator = this.generateUnaryOperator(expr.getOperator());
        _builder.append((Object)_generateUnaryOperator);
        _builder.append(" ");
        CharSequence _generateExpression = this.generateExpression((EObject)expr.getExpression());
        _builder.append((Object)_generateExpression);
        _builder.append(")");
        return _builder;
    }

    protected CharSequence _generateExpression(BoolLiteral expr) {
        StringConcatenation _builder = new StringConcatenation();
        String _string = Boolean.valueOf(expr.isValue()).toString();
        _builder.append(_string);
        return _builder;
    }

    protected CharSequence _generateExpression(IntLiteral expr) {
        StringConcatenation _builder = new StringConcatenation();
        String _string = Long.valueOf(expr.getValue()).toString();
        _builder.append(_string);
        return _builder;
    }

    protected CharSequence _generateExpression(RealLiteral expr) {
        StringConcatenation _builder = new StringConcatenation();
        String _string = Double.valueOf(expr.getValue()).toString();
        _builder.append(_string);
        return _builder;
    }

    protected CharSequence _generateExpression(StringLiteral expr) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("\"");
        String _convertToJavaString = Strings.convertToJavaString((String)expr.getValue());
        _builder.append(_convertToJavaString);
        _builder.append("\"");
        return _builder;
    }

    protected CharSequence _generateExpression(ArrayVariable expr) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _generateExpression = this.generateExpression((EObject)expr.getArray());
        _builder.append((Object)_generateExpression);
        EList _index = expr.getIndex();
        boolean _hasElements = false;
        for (Expression index : _index) {
            if (!_hasElements) {
                _hasElements = true;
                _builder.append("[");
            } else {
                _builder.appendImmediate((Object)"][", "");
            }
            CharSequence _generateExpression_1 = this.generateExpression((EObject)index);
            _builder.append((Object)_generateExpression_1);
        }
        if (_hasElements) {
            _builder.append("]");
        }
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    protected CharSequence _generateExpression(AdapterVariable expr) {
        boolean _not;
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _generateExpression = this.generateExpression((EObject)expr.getCurr());
        _builder.append((Object)_generateExpression);
        _builder.append(URI_SEPERATOR);
        String _name = expr.getVar().getName();
        _builder.append(_name);
        _builder.append("()");
        CharSequence _xifexpression = null;
        EObject _eContainer = expr.eContainer();
        boolean bl = _not = !(_eContainer instanceof AdapterVariable);
        if (_not) {
            _xifexpression = this.generateBitaccess(expr);
        }
        _builder.append(_xifexpression);
        return _builder;
    }

    protected CharSequence _generateExpression(AdapterRoot expr) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _generateVarAccess = this.generateVarAccess(expr.getAdapter());
        _builder.append((Object)_generateVarAccess);
        return _builder;
    }

    public CharSequence generateStructAdapterVarAccess(EList<VarDeclaration> list) {
        StringConcatenation _builder = new StringConcatenation();
        boolean _hasElements = false;
        for (VarDeclaration variable : list) {
            if (!_hasElements) {
                _hasElements = true;
                _builder.append(URI_SEPERATOR);
            } else {
                _builder.appendImmediate((Object)URI_SEPERATOR, "");
            }
            String _name = variable.getName();
            _builder.append(_name);
            _builder.append("()");
        }
        return _builder;
    }

    protected CharSequence _generateExpression(PrimaryVariable expr) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _generateVarAccess = this.generateVarAccess(expr.getVar());
        _builder.append((Object)_generateVarAccess);
        CharSequence _generateBitaccess = this.generateBitaccess(expr);
        _builder.append((Object)_generateBitaccess);
        return _builder;
    }

    protected CharSequence generateVarAccessLocal(LocalVariable variable) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)EXPORT_PREFIX);
        String _name = variable.getName();
        _builder.append(_name);
        return _builder;
    }

    protected CharSequence _generateVarAccess(VarDeclaration variable) {
        StringConcatenation _xifexpression = null;
        EObject _eContainer = variable.eContainer().eContainer();
        if (_eContainer instanceof AdapterFBType) {
            StringConcatenation _builder = new StringConcatenation();
            String _name = variable.getName();
            _builder.append(_name);
            _builder.append("()");
            _xifexpression = _builder;
        } else {
            StringConcatenation _builder_1 = new StringConcatenation();
            _builder_1.append((Object)EXPORT_PREFIX);
            String _name_1 = variable.getName();
            _builder_1.append(_name_1);
            _builder_1.append("()");
            _xifexpression = _builder_1;
        }
        return _xifexpression;
    }

    protected CharSequence _generateVarAccess(LocalVariable variable) {
        StringConcatenation _builder = new StringConcatenation();
        boolean _isLocated = variable.isLocated();
        if (_isLocated) {
            CharSequence _generateVarAccessLocated = this.generateVarAccessLocated(variable);
            _builder.append((Object)_generateVarAccessLocated);
        } else {
            CharSequence _generateVarAccessLocal = this.generateVarAccessLocal(variable);
            _builder.append((Object)_generateVarAccessLocal);
        }
        return _builder;
    }

    protected CharSequence generateVarAccessLocated(LocalVariable variable) {
        StringConcatenation _builder = new StringConcatenation();
        boolean _isArray = variable.isArray();
        if (_isArray) {
            CharSequence _generateVarAccessLocal = this.generateVarAccessLocal(variable);
            _builder.append((Object)_generateVarAccessLocal);
        } else {
            CharSequence _generateExpression = this.generateExpression((EObject)variable.getLocation());
            _builder.append((Object)_generateExpression);
            CharSequence _generateBitaccess = this.generateBitaccess((VarDeclaration)variable, this.extractTypeInformation((EObject)variable.getLocation()), this.extractTypeInformation((EObject)variable), 0);
            _builder.append((Object)_generateBitaccess);
        }
        return _builder;
    }

    protected CharSequence generateBitaccess(AdapterVariable variable) {
        boolean _tripleNotEquals;
        CharSequence _xifexpression = null;
        PartialAccess _part = variable.getPart();
        boolean bl = _tripleNotEquals = _part != null;
        if (_tripleNotEquals) {
            CharSequence _xblockexpression = null;
            VarDeclaration lastvar = variable.getVar();
            _xifexpression = _xblockexpression = this.generateBitaccess(lastvar, variable.getPart());
        }
        return _xifexpression;
    }

    protected CharSequence generateBitaccess(PrimaryVariable variable) {
        boolean _tripleNotEquals;
        CharSequence _xifexpression = null;
        PartialAccess _part = variable.getPart();
        boolean bl = _tripleNotEquals = _part != null;
        if (_tripleNotEquals) {
            _xifexpression = this.generateBitaccess(variable.getVar(), variable.getPart());
        }
        return _xifexpression;
    }

    protected String partialAccessTypeName(PartialAccess part) {
        String _xifexpression = null;
        boolean _isBitaccess = part.isBitaccess();
        if (_isBitaccess) {
            _xifexpression = "BOOL";
        } else {
            String _xifexpression_1 = null;
            boolean _isByteaccess = part.isByteaccess();
            if (_isByteaccess) {
                _xifexpression_1 = "BYTE";
            } else {
                String _xifexpression_2 = null;
                boolean _isWordaccess = part.isWordaccess();
                if (_isWordaccess) {
                    _xifexpression_2 = "WORD";
                } else {
                    String _xifexpression_3 = null;
                    boolean _isDwordaccess = part.isDwordaccess();
                    _xifexpression_3 = _isDwordaccess ? "DWORD" : "";
                    _xifexpression_2 = _xifexpression_3;
                }
                _xifexpression_1 = _xifexpression_2;
            }
            _xifexpression = _xifexpression_1;
        }
        return _xifexpression;
    }

    protected CharSequence generateBitaccess(VarDeclaration variable, PartialAccess part) {
        StringConcatenation _xblockexpression = null;
        int maxVarBitIndex = this.BitSize(variable);
        int _BitSize = this.BitSize(part);
        int _index = part.getIndex();
        int _plus = _index + 1;
        int endBitIndexAccessor = _BitSize * _plus;
        StringConcatenation _xifexpression = null;
        if (maxVarBitIndex > endBitIndexAccessor) {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append(".partial<CIEC_");
            String _partialAccessTypeName = this.partialAccessTypeName(part);
            _builder.append(_partialAccessTypeName);
            _builder.append(",");
            String _string = Long.toString(part.getIndex());
            _builder.append(_string);
            _builder.append(">()");
            _xifexpression = _builder;
        }
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }

    protected CharSequence generateBitaccess(VarDeclaration variable, CharSequence dataType, CharSequence accessorType, int index) {
        StringConcatenation _xifexpression = null;
        if (this.BitSize(accessorType) > 0 && variable.isArray() && variable.getArraySize() * this.BitSize(dataType) > this.BitSize(accessorType)) {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append(".partial<CIEC_");
            _builder.append((Object)accessorType);
            _builder.append(",");
            String _string = Long.toString(index);
            _builder.append(_string);
            _builder.append(">()");
            _xifexpression = _builder;
        } else {
            StringConcatenation _builder_2;
            StringConcatenation _builder_1;
            int _BitSize_1;
            StringConcatenation _xifexpression_1 = null;
            int _BitSize = this.BitSize(dataType);
            boolean _equals = _BitSize == (_BitSize_1 = this.BitSize(accessorType));
            _xifexpression_1 = _equals ? (_builder_1 = new StringConcatenation()) : (_builder_2 = new StringConcatenation());
            _xifexpression = _xifexpression_1;
        }
        return _xifexpression;
    }

    private CharSequence extractTypeInformationWithPartialAccess(PartialAccess part, CharSequence DataType2) {
        CharSequence _xifexpression = null;
        if (part != null) {
            String _xifexpression_1 = null;
            boolean _isBitaccess = part.isBitaccess();
            if (_isBitaccess) {
                _xifexpression_1 = "BOOL";
            } else {
                String _xifexpression_2 = null;
                boolean _isByteaccess = part.isByteaccess();
                if (_isByteaccess) {
                    _xifexpression_2 = "BYTE";
                } else {
                    String _xifexpression_3 = null;
                    boolean _isWordaccess = part.isWordaccess();
                    if (_isWordaccess) {
                        _xifexpression_3 = "WORD";
                    } else {
                        String _xifexpression_4 = null;
                        boolean _isDwordaccess = part.isDwordaccess();
                        _xifexpression_4 = _isDwordaccess ? "DWORD" : "";
                        _xifexpression_3 = _xifexpression_4;
                    }
                    _xifexpression_2 = _xifexpression_3;
                }
                _xifexpression_1 = _xifexpression_2;
            }
            _xifexpression = _xifexpression_1;
        } else {
            _xifexpression = DataType2;
        }
        return _xifexpression;
    }

    private CharSequence extractTypeInformation(PrimaryVariable variable, CharSequence DataType2) {
        CharSequence _xifexpression = null;
        PartialAccess _part = variable.getPart();
        boolean _tripleNotEquals = _part != null;
        _xifexpression = _tripleNotEquals ? this.extractTypeInformationWithPartialAccess(variable.getPart(), DataType2) : DataType2;
        return _xifexpression;
    }

    protected CharSequence _extractTypeInformation(PrimaryVariable variable) {
        return this.extractTypeInformation(variable, this.extractTypeInformation((EObject)variable.getVar()));
    }

    protected CharSequence _extractTypeInformation(VarDeclaration variable) {
        return variable.getType().getName();
    }

    protected CharSequence _extractTypeInformation(AdapterVariable variable) {
        return variable.getVar().getType().getName();
    }

    private int BitSize(Object declaration) {
        if (declaration instanceof VarDeclaration) {
            return this._BitSize((VarDeclaration)declaration);
        }
        if (declaration instanceof DataType) {
            return this._BitSize((DataType)declaration);
        }
        if (declaration instanceof AdapterVariable) {
            return this._BitSize((AdapterVariable)declaration);
        }
        if (declaration instanceof PrimaryVariable) {
            return this._BitSize((PrimaryVariable)declaration);
        }
        if (declaration instanceof PartialAccess) {
            return this._BitSize((PartialAccess)declaration);
        }
        if (declaration instanceof CharSequence) {
            return this._BitSize((CharSequence)declaration);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(declaration).toString());
    }

    protected CharSequence generateStatement(Statement stmt) {
        if (stmt instanceof AssignmentStatement) {
            return this._generateStatement((AssignmentStatement)stmt);
        }
        if (stmt instanceof Call) {
            return this._generateStatement((Call)stmt);
        }
        if (stmt instanceof CaseStatement) {
            return this._generateStatement((CaseStatement)stmt);
        }
        if (stmt instanceof ContinueStatement) {
            return this._generateStatement((ContinueStatement)stmt);
        }
        if (stmt instanceof ExitStatement) {
            return this._generateStatement((ExitStatement)stmt);
        }
        if (stmt instanceof FBCall) {
            return this._generateStatement((FBCall)stmt);
        }
        if (stmt instanceof ForStatement) {
            return this._generateStatement((ForStatement)stmt);
        }
        if (stmt instanceof IfStatement) {
            return this._generateStatement((IfStatement)stmt);
        }
        if (stmt instanceof RepeatStatement) {
            return this._generateStatement((RepeatStatement)stmt);
        }
        if (stmt instanceof ReturnStatement) {
            return this._generateStatement((ReturnStatement)stmt);
        }
        if (stmt instanceof WhileStatement) {
            return this._generateStatement((WhileStatement)stmt);
        }
        if (stmt != null) {
            return this._generateStatement(stmt);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(stmt).toString());
    }

    private EList<Statement> containedStatements(Statement statement) {
        if (statement instanceof CaseStatement) {
            return this._containedStatements((CaseStatement)statement);
        }
        if (statement instanceof ForStatement) {
            return this._containedStatements((ForStatement)statement);
        }
        if (statement instanceof IfStatement) {
            return this._containedStatements((IfStatement)statement);
        }
        if (statement instanceof RepeatStatement) {
            return this._containedStatements((RepeatStatement)statement);
        }
        if (statement instanceof WhileStatement) {
            return this._containedStatements((WhileStatement)statement);
        }
        if (statement != null) {
            return this._containedStatements(statement);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(statement).toString());
    }

    protected CharSequence generateExpression(EObject expr) {
        if (expr instanceof AdapterRoot) {
            return this._generateExpression((AdapterRoot)expr);
        }
        if (expr instanceof IntLiteral) {
            return this._generateExpression((IntLiteral)expr);
        }
        if (expr instanceof RealLiteral) {
            return this._generateExpression((RealLiteral)expr);
        }
        if (expr instanceof AdapterVariable) {
            return this._generateExpression((AdapterVariable)expr);
        }
        if (expr instanceof ArrayVariable) {
            return this._generateExpression((ArrayVariable)expr);
        }
        if (expr instanceof BoolLiteral) {
            return this._generateExpression((BoolLiteral)expr);
        }
        if (expr instanceof PrimaryVariable) {
            return this._generateExpression((PrimaryVariable)expr);
        }
        if (expr instanceof StringLiteral) {
            return this._generateExpression((StringLiteral)expr);
        }
        if (expr instanceof TimeLiteral) {
            return this._generateExpression((TimeLiteral)expr);
        }
        if (expr instanceof BinaryExpression) {
            return this._generateExpression((BinaryExpression)expr);
        }
        if (expr instanceof Call) {
            return this._generateExpression((Call)expr);
        }
        if (expr instanceof InArgument) {
            return this._generateExpression((InArgument)expr);
        }
        if (expr instanceof UnaryExpression) {
            return this._generateExpression((UnaryExpression)expr);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(expr).toString());
    }

    protected CharSequence generateVarAccess(VarDeclaration variable) {
        if (variable instanceof LocalVariable) {
            return this._generateVarAccess((LocalVariable)variable);
        }
        if (variable != null) {
            return this._generateVarAccess(variable);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(variable).toString());
    }

    protected CharSequence extractTypeInformation(EObject variable) {
        if (variable instanceof VarDeclaration) {
            return this._extractTypeInformation((VarDeclaration)variable);
        }
        if (variable instanceof AdapterVariable) {
            return this._extractTypeInformation((AdapterVariable)variable);
        }
        if (variable instanceof PrimaryVariable) {
            return this._extractTypeInformation((PrimaryVariable)variable);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(variable).toString());
    }
}

