/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.runtime.views;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.core.ILaunchesListener;
import org.eclipse.debug.core.ILaunchesListener2;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.fordiac.ide.runtime.Activator;
import org.eclipse.fordiac.ide.ui.widget.TableWidgetFactory;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnPixelData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.IConsoleManager;
import org.eclipse.ui.console.TextConsole;
import org.eclipse.ui.forms.widgets.Form;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class RuntimesView
implements ILaunchesListener2 {
    private static final String DEVICE_NAME = "device_name";
    private static final String PARAMETERS = "parameters";
    private static final int DEVICE_NAME_WIDTH = 200;
    private static final int PARAMETERS_WIDTH = 200;
    private final ILaunchManager lm;
    private final List<RuntimeData> runtimes = new ArrayList<RuntimeData>();
    private FormToolkit toolkit;
    private TableViewer runtimesViewer;
    private Button terminateButton;

    @Inject
    public RuntimesView() {
        this.lm = DebugPlugin.getDefault().getLaunchManager();
    }

    @PostConstruct
    public void postConstruct(Composite parent) {
        this.toolkit = new FormToolkit(parent.getDisplay());
        Form form = this.toolkit.createForm(parent);
        form.getBody().setLayout((Layout)new GridLayout(1, true));
        form.setText("Running Simulated Devices");
        Composite composite = this.toolkit.createComposite(form.getBody());
        composite.setLayout((Layout)new GridLayout(2, false));
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        this.setupButtonArea(composite);
        this.runtimesViewer = RuntimesView.createConnectionsViewer(composite);
        this.runtimesViewer.addSelectionChangedListener(ev -> {
            this.setButtonEnablement(!this.runtimesViewer.getSelection().isEmpty());
            RuntimesView.showConsole(this.runtimesViewer.getSelection());
        });
        this.lm.addLaunchListener((ILaunchesListener)this);
        this.runtimesViewer.setInput(this.runtimes);
    }

    @PreDestroy
    public void preDestroy() {
        this.lm.removeLaunchListener((ILaunchesListener)this);
        this.runtimes.forEach(RuntimesView::terminateRuntime);
    }

    private void setButtonEnablement(boolean enable) {
        this.terminateButton.setEnabled(enable);
        this.terminateButton.setImage(enable ? PlatformUI.getWorkbench().getSharedImages().getImage("IMG_ELCL_STOP") : PlatformUI.getWorkbench().getSharedImages().getImage("IMG_ELCL_STOP_DISABLED"));
    }

    private void setupButtonArea(Composite parent) {
        Composite container = this.toolkit.createComposite(parent, 0);
        GridData buttonCompLayoutData = new GridData(0x1000000, 128, false, false);
        container.setLayoutData((Object)buttonCompLayoutData);
        container.setLayout((Layout)new GridLayout(1, true));
        this.terminateButton = this.toolkit.createButton(container, "", 8);
        this.terminateButton.setToolTipText("Terminate the selected devices");
        this.terminateButton.setImage(PlatformUI.getWorkbench().getSharedImages().getImage("IMG_ELCL_STOP_DISABLED"));
        this.terminateButton.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, false).create());
        this.terminateButton.addListener(13, ev -> this.terminateRuntimes());
    }

    private void terminateRuntimes() {
        if (!this.runtimesViewer.getSelection().isEmpty() && this.runtimesViewer.getSelection() instanceof IStructuredSelection) {
            IStructuredSelection selection = (IStructuredSelection)this.runtimesViewer.getSelection();
            Object[] objectArray = selection.toArray();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object el = objectArray[n2];
                if (el instanceof RuntimeData) {
                    RuntimesView.terminateRuntime((RuntimeData)el);
                }
                ++n2;
            }
        }
    }

    private static void terminateRuntime(RuntimeData runtimeData) {
        try {
            runtimeData.launch.terminate();
        }
        catch (DebugException e) {
            Activator.getDefault().logError(e.getMessage(), (Exception)((Object)e));
        }
    }

    private static TableViewer createConnectionsViewer(Composite parent) {
        TableViewer viewer = TableWidgetFactory.createTableViewer((Composite)parent);
        viewer.getTable().setLayout((Layout)RuntimesView.createTableLayout(viewer.getTable()));
        viewer.setColumnProperties(new String[]{DEVICE_NAME, PARAMETERS});
        viewer.setLabelProvider((IBaseLabelProvider)new RuntimesTableLabelProvider());
        viewer.setContentProvider((IContentProvider)new RuntimesContentProvider());
        return viewer;
    }

    private static TableLayout createTableLayout(Table table) {
        TableColumn column1 = new TableColumn(table, 16384);
        column1.setText("Device Name");
        TableColumn column2 = new TableColumn(table, 16384);
        column2.setText("Parameters");
        TableLayout layout = new TableLayout();
        layout.addColumnData((ColumnLayoutData)new ColumnPixelData(200));
        layout.addColumnData((ColumnLayoutData)new ColumnPixelData(200));
        return layout;
    }

    public void launchesRemoved(ILaunch[] launches) {
        Arrays.stream(launches).forEach(this::removeRuntime);
        Display.getDefault().asyncExec(() -> this.runtimesViewer.refresh());
    }

    public void launchesAdded(ILaunch[] launches) {
        Arrays.stream(launches).forEach(this::addRuntime);
        Display.getDefault().asyncExec(() -> this.runtimesViewer.refresh());
    }

    public void launchesChanged(ILaunch[] launches) {
    }

    public void launchesTerminated(ILaunch[] launches) {
        this.lm.removeLaunches(launches);
    }

    private void addRuntime(ILaunch l) {
        String parameter = "";
        try {
            parameter = l.getLaunchConfiguration().getAttribute("org.eclipse.ui.externaltools.ATTR_TOOL_ARGUMENTS", "");
        }
        catch (CoreException e) {
            Activator.getDefault().logError(e.getMessage(), (Exception)((Object)e));
        }
        this.runtimes.add(new RuntimeData(l, parameter));
    }

    private void removeRuntime(ILaunch l) {
        int i = 0;
        while (i < this.runtimes.size()) {
            if (this.runtimes.get((int)i).launch.equals(l)) {
                this.runtimes.remove(i);
                break;
            }
            ++i;
        }
    }

    private static void showConsole(ISelection selection) {
        if (!selection.isEmpty() && selection instanceof IStructuredSelection) {
            RuntimeData first = (RuntimeData)((IStructuredSelection)selection).getFirstElement();
            IConsole console = RuntimesView.findConsole(first.launch);
            if (console != null) {
                RuntimesView.revealConsole(console);
            }
        }
    }

    private static IConsole findConsole(ILaunch launch) {
        IConsole[] existing;
        IProcess rtProcess = launch.getProcesses()[0];
        IConsoleManager conMan = ConsolePlugin.getDefault().getConsoleManager();
        IConsole[] iConsoleArray = existing = conMan.getConsoles();
        int n = existing.length;
        int n2 = 0;
        while (n2 < n) {
            TextConsole procCons;
            Object conProcess;
            IConsole console = iConsoleArray[n2];
            if (console instanceof TextConsole && rtProcess.equals(conProcess = (procCons = (TextConsole)console).getAttribute("org.eclipse.debug.ui.ATTR_CONSOLE_PROCESS"))) {
                return procCons;
            }
            ++n2;
        }
        return null;
    }

    private static void revealConsole(IConsole console) {
        IConsoleManager conMan = ConsolePlugin.getDefault().getConsoleManager();
        conMan.showConsoleView(console);
    }

    private static class RuntimeData {
        final ILaunch launch;
        final String parameters;

        public RuntimeData(ILaunch launch, String parameters) {
            this.launch = launch;
            this.parameters = parameters;
        }
    }

    private static class RuntimesContentProvider
    implements IStructuredContentProvider {
        private RuntimesContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof List) {
                return ((List)inputElement).toArray();
            }
            return new Object[0];
        }
    }

    private static class RuntimesTableLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        public static final int DEVICE_NAME_COL_INDEX = 0;
        public static final int PARAMETERS_COL_INDEX = 1;

        private RuntimesTableLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            if (element instanceof RuntimeData) {
                RuntimeData runtimeData = (RuntimeData)element;
                switch (columnIndex) {
                    case 0: {
                        return runtimeData.launch.getLaunchConfiguration().getName();
                    }
                    case 1: {
                        return runtimeData.parameters;
                    }
                }
            }
            return super.getText(element);
        }
    }
}

