/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.fbtypeeditor.editparts;

import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.PolygonDecoration;
import org.eclipse.draw2d.PolylineConnection;
import org.eclipse.draw2d.RotatableDecoration;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.fordiac.ide.fbtypeeditor.editparts.InterfaceEditPart;
import org.eclipse.fordiac.ide.model.commands.delete.DeleteWithCommand;
import org.eclipse.fordiac.ide.model.libraryElement.Event;
import org.eclipse.fordiac.ide.model.libraryElement.With;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editparts.AbstractConnectionEditPart;
import org.eclipse.gef.editpolicies.ConnectionEditPolicy;
import org.eclipse.gef.editpolicies.ConnectionEndpointEditPolicy;
import org.eclipse.gef.requests.GroupRequest;

public class WithEditPart
extends AbstractConnectionEditPart {
    public With getCastedModel() {
        return (With)this.getModel();
    }

    private boolean isInput() {
        Event event;
        With with = this.getCastedModel();
        if (with != null && (event = (Event)with.eContainer()) != null) {
            return event.isIsInput();
        }
        return false;
    }

    protected void createEditPolicies() {
        this.installEditPolicy("Connection Endpoint Policy", (EditPolicy)new ConnectionEndpointEditPolicy());
        this.installEditPolicy("ConnectionEditPolicy", (EditPolicy)new ConnectionEditPolicy(){

            protected Command getDeleteCommand(GroupRequest request) {
                return new DeleteWithCommand(WithEditPart.this.getCastedModel());
            }
        });
    }

    protected IFigure createFigure() {
        PolylineConnection connection = (PolylineConnection)super.createFigure();
        this.updateConnection(connection);
        return connection;
    }

    private void updateConnection(PolylineConnection connection) {
        int withPos = InterfaceEditPart.calculateWithPos(this.getCastedModel(), this.isInput());
        PointList rect = this.createPointList(15, withPos);
        PointList targetRect = this.createPointList(15, withPos);
        PolygonDecoration rectDec = new PolygonDecoration();
        rectDec.setTemplate(targetRect.getCopy());
        rectDec.setScale((double)0.2f, (double)0.2f);
        rectDec.setFill(false);
        connection.setTargetDecoration((RotatableDecoration)rectDec);
        PolygonDecoration rectDec2 = new PolygonDecoration();
        rectDec2.setTemplate(rect.getCopy());
        rectDec2.setScale((double)0.2f, (double)0.2f);
        rectDec2.setFill(false);
        connection.setSourceDecoration((RotatableDecoration)rectDec2);
    }

    private PointList createPointList(int h, int withPos) {
        PointList rect = new PointList();
        rect.addPoint(-h, -h);
        rect.addPoint(-h, h);
        rect.addPoint(h, h);
        rect.addPoint(h, -h);
        rect.addPoint(-h, -h);
        rect.addPoint(0, -h);
        if (this.isInput()) {
            rect.addPoint(0, -h - 45);
            rect.addPoint(0, h + 45 * withPos);
        } else {
            rect.addPoint(0, -h - 45 * withPos);
            rect.addPoint(0, h + 45);
        }
        rect.addPoint(0, -h);
        return rect;
    }

    public void updateWithPos() {
        if (this.getCastedModel().eContainer() != null) {
            this.updateConnection((PolylineConnection)this.getFigure());
            this.refreshSourceAnchor();
            this.refreshTargetAnchor();
        }
    }
}

