/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.fbtypeeditor.editors;

import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.draw2d.FreeformViewport;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.RangeModel;
import org.eclipse.fordiac.ide.fbtypeeditor.Activator;
import org.eclipse.fordiac.ide.fbtypeeditor.FBInterfacePaletteFactory;
import org.eclipse.fordiac.ide.fbtypeeditor.FBTypeEditDomain;
import org.eclipse.fordiac.ide.fbtypeeditor.contentprovider.InterfaceContextMenuProvider;
import org.eclipse.fordiac.ide.fbtypeeditor.editors.IFBTEditorPart;
import org.eclipse.fordiac.ide.fbtypeeditor.editparts.FBInterfaceEditPartFactory;
import org.eclipse.fordiac.ide.gef.DiagramEditorWithFlyoutPalette;
import org.eclipse.fordiac.ide.gef.editparts.ZoomScalableFreeformRootEditPart;
import org.eclipse.fordiac.ide.gef.figures.AbstractFreeformFigure;
import org.eclipse.fordiac.ide.gef.figures.MinSpaceFreeformFigure;
import org.eclipse.fordiac.ide.model.libraryElement.AutomationSystem;
import org.eclipse.fordiac.ide.model.libraryElement.FBType;
import org.eclipse.fordiac.ide.model.libraryElement.InterfaceList;
import org.eclipse.fordiac.ide.model.typelibrary.TypeLibrary;
import org.eclipse.fordiac.ide.typemanagement.FBTypeEditorInput;
import org.eclipse.fordiac.ide.ui.FordiacMessages;
import org.eclipse.fordiac.ide.ui.imageprovider.FordiacImage;
import org.eclipse.gef.ContextMenuProvider;
import org.eclipse.gef.EditDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartFactory;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.commands.CommandStack;
import org.eclipse.gef.dnd.TemplateTransferDragSourceListener;
import org.eclipse.gef.dnd.TransferDragSourceListener;
import org.eclipse.gef.editparts.FreeformGraphicalRootEditPart;
import org.eclipse.gef.editparts.GridLayer;
import org.eclipse.gef.editparts.ScalableFreeformRootEditPart;
import org.eclipse.gef.editparts.ZoomManager;
import org.eclipse.gef.palette.PaletteRoot;
import org.eclipse.gef.ui.actions.ActionRegistry;
import org.eclipse.gef.ui.palette.FlyoutPaletteComposite;
import org.eclipse.gef.ui.palette.PaletteViewer;
import org.eclipse.gef.ui.palette.PaletteViewerProvider;
import org.eclipse.gef.ui.parts.GraphicalEditor;
import org.eclipse.gef.ui.parts.ScrollingGraphicalViewer;
import org.eclipse.jface.util.TransferDropTargetListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;

public class FBInterfaceEditor
extends DiagramEditorWithFlyoutPalette
implements IFBTEditorPart {
    private CommandStack commandStack;
    private FBType fbType;
    private PaletteRoot paletteRoot;
    private TypeLibrary typeLib;

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        this.setInput(input);
        if (input instanceof FBTypeEditorInput) {
            FBTypeEditorInput untypedInput = (FBTypeEditorInput)input;
            this.fbType = untypedInput.getContent();
            this.typeLib = untypedInput.getPaletteEntry().getTypeLibrary();
        }
        super.init(site, input);
        this.setPartName(FordiacMessages.Interface);
        this.setTitleImage(FordiacImage.ICON_INTERFACE_EDITOR.getImage());
    }

    protected void setModel(IEditorInput input) {
        super.setModel(input);
        this.setEditDomain(new FBTypeEditDomain(this, this.commandStack));
    }

    protected void createActions() {
        ActionRegistry registry = this.getActionRegistry();
        InterfaceContextMenuProvider.createInterfaceEditingActions((IWorkbenchPart)this, registry, this.getModel());
        super.createActions();
    }

    protected EditPartFactory getEditPartFactory() {
        return new FBInterfaceEditPartFactory((GraphicalEditor)this, this.typeLib);
    }

    protected PaletteRoot getPaletteRoot() {
        if (this.paletteRoot == null) {
            this.paletteRoot = FBInterfacePaletteFactory.createPalette(this.typeLib);
        }
        return this.paletteRoot;
    }

    protected TypeLibrary getTypeLib() {
        return this.typeLib;
    }

    public void doSave(IProgressMonitor monitor) {
    }

    @Override
    public boolean outlineSelectionChanged(Object selectedElement) {
        Object editpart = this.getGraphicalViewer().getEditPartRegistry().get(selectedElement);
        this.getGraphicalViewer().flush();
        if (editpart instanceof EditPart && ((EditPart)editpart).isSelectable()) {
            this.getGraphicalViewer().select((EditPart)editpart);
            return true;
        }
        return selectedElement instanceof InterfaceList;
    }

    @Override
    public void setCommonCommandStack(CommandStack commandStack) {
        this.commandStack = commandStack;
    }

    protected FlyoutPaletteComposite.FlyoutPreferences getPalettePreferences() {
        return FBInterfacePaletteFactory.PALETTE_PREFERENCES;
    }

    protected PaletteViewerProvider createPaletteViewerProvider() {
        return new PaletteViewerProvider((EditDomain)this.getEditDomain()){

            protected void configurePaletteViewer(PaletteViewer viewer) {
                super.configurePaletteViewer(viewer);
                viewer.addDragSourceListener((TransferDragSourceListener)new TemplateTransferDragSourceListener((EditPartViewer)viewer));
            }
        };
    }

    public FBType getModel() {
        return this.fbType;
    }

    protected ContextMenuProvider getContextMenuProvider(ScrollingGraphicalViewer viewer, ZoomManager zoomManager) {
        return new InterfaceContextMenuProvider((EditPartViewer)viewer, zoomManager, this.getActionRegistry(), this.typeLib.getDataTypeLibrary());
    }

    protected TransferDropTargetListener createTransferDropTargetListener() {
        return null;
    }

    public AutomationSystem getSystem() {
        return null;
    }

    public void doSaveAs() {
    }

    public void gotoMarker(IMarker marker) {
    }

    @Override
    public boolean isMarkerTarget(IMarker marker) {
        return false;
    }

    @Override
    public void reloadType(FBType type) {
        this.fbType = type;
        try {
            this.init(this.getEditorSite(), (IEditorInput)new FBTypeEditorInput(type, type.getPaletteEntry()));
        }
        catch (PartInitException e) {
            Activator.getDefault().logError("org.eclipse.fordiac.ide.application.editors.DiagramEditor", (Exception)((Object)e));
        }
        this.getGraphicalViewer().setContents((Object)this.fbType);
    }

    protected ScalableFreeformRootEditPart createRootEditPart() {
        return new ZoomScalableFreeformRootEditPart(this.getSite(), this.getActionRegistry()){

            protected AbstractFreeformFigure createDrawingAreaContainer() {
                return new MinSpaceFreeformFigure();
            }

            protected IFigure createFigure() {
                IFigure rootFigure = super.createFigure();
                GridLayer grid = (GridLayer)this.getLayer("Grid Layer");
                if (grid != null) {
                    grid.setVisible(false);
                }
                return rootFigure;
            }

            protected void refreshGridLayer() {
            }
        };
    }

    protected Point getInitialScrollPos() {
        FreeformGraphicalRootEditPart rootEditPart = (FreeformGraphicalRootEditPart)this.getGraphicalViewer().getRootEditPart();
        FreeformViewport rootviewPort = (FreeformViewport)rootEditPart.getFigure();
        return new Point(FBInterfaceEditor.calculateCenterScrollPos(rootviewPort.getHorizontalRangeModel()), FBInterfaceEditor.calculateCenterScrollPos(rootviewPort.getVerticalRangeModel()));
    }

    private static int calculateCenterScrollPos(RangeModel rangeModel) {
        int center = (rangeModel.getMaximum() + rangeModel.getMinimum()) / 2;
        return center - rangeModel.getExtent() / 2;
    }

    @Override
    public Object getSelectableEditPart() {
        if (this.getGraphicalViewer() == null) {
            return null;
        }
        return this.getGraphicalViewer().getEditPartRegistry().get(this.fbType);
    }
}

