/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.gef.editparts;

import org.eclipse.core.runtime.Assert;
import org.eclipse.fordiac.ide.ui.editors.EditorUtils;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.tools.CellEditorLocator;
import org.eclipse.gef.tools.DirectEditManager;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.part.CellEditorActionHandler;

public abstract class TextDirectEditManager
extends DirectEditManager {
    private IActionBars actionBars;
    private CellEditorActionHandler actionHandler;
    private IAction copy;
    private IAction cut;
    private IAction paste;
    private IAction undo;
    private IAction redo;
    private IAction find;
    private IAction selectAll;
    private IAction delete;

    protected TextDirectEditManager(GraphicalEditPart source, Class editorType, CellEditorLocator locator) {
        super(source, editorType, locator);
        Assert.isTrue((boolean)TextCellEditor.class.isAssignableFrom(editorType));
    }

    protected TextDirectEditManager(GraphicalEditPart source, Class editorType, CellEditorLocator locator, Object feature) {
        super(source, editorType, locator, feature);
        Assert.isTrue((boolean)TextCellEditor.class.isAssignableFrom(editorType));
    }

    protected void initCellEditor() {
        this.setupActions();
    }

    protected void bringDown() {
        this.cleanUpActions();
        super.bringDown();
    }

    private void setupActions() {
        this.actionBars = EditorUtils.getCurrentActiveEditor().getEditorSite().getActionBars();
        this.saveCurrentActions(this.actionBars);
        this.actionHandler = new CellEditorActionHandler(this.actionBars);
        this.actionHandler.addCellEditor(this.getCellEditor());
        this.actionBars.updateActionBars();
    }

    private void cleanUpActions() {
        if (this.actionHandler != null) {
            this.actionHandler.dispose();
            this.actionHandler = null;
        }
        if (this.actionBars != null) {
            this.restoreSavedActions(this.actionBars);
            this.actionBars.updateActionBars();
            this.actionBars = null;
        }
    }

    private void restoreSavedActions(IActionBars actionBars) {
        actionBars.setGlobalActionHandler(ActionFactory.COPY.getId(), this.copy);
        actionBars.setGlobalActionHandler(ActionFactory.PASTE.getId(), this.paste);
        actionBars.setGlobalActionHandler(ActionFactory.DELETE.getId(), this.delete);
        actionBars.setGlobalActionHandler(ActionFactory.SELECT_ALL.getId(), this.selectAll);
        actionBars.setGlobalActionHandler(ActionFactory.CUT.getId(), this.cut);
        actionBars.setGlobalActionHandler(ActionFactory.FIND.getId(), this.find);
        actionBars.setGlobalActionHandler(ActionFactory.UNDO.getId(), this.undo);
        actionBars.setGlobalActionHandler(ActionFactory.REDO.getId(), this.redo);
    }

    private void saveCurrentActions(IActionBars actionBars) {
        this.copy = actionBars.getGlobalActionHandler(ActionFactory.COPY.getId());
        this.paste = actionBars.getGlobalActionHandler(ActionFactory.PASTE.getId());
        this.delete = actionBars.getGlobalActionHandler(ActionFactory.DELETE.getId());
        this.selectAll = actionBars.getGlobalActionHandler(ActionFactory.SELECT_ALL.getId());
        this.cut = actionBars.getGlobalActionHandler(ActionFactory.CUT.getId());
        this.find = actionBars.getGlobalActionHandler(ActionFactory.FIND.getId());
        this.undo = actionBars.getGlobalActionHandler(ActionFactory.UNDO.getId());
        this.redo = actionBars.getGlobalActionHandler(ActionFactory.REDO.getId());
    }
}

