/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.gef.editparts;

import org.eclipse.draw2d.ScalableFigure;
import org.eclipse.draw2d.Viewport;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.gef.editparts.ZoomManager;

public class AdvancedZoomManager
extends ZoomManager {
    private Point lastMousePos;

    AdvancedZoomManager(ScalableFigure pane, Viewport viewport) {
        super(pane, viewport);
    }

    public void setLastMousePos(int x, int y) {
        this.lastMousePos = new Point(x, y);
    }

    protected void primSetZoom(double zoom) {
        Point newViewLocation = this.lastMousePos == null ? this.takeMiddPosition(zoom) : this.calcNewViewLocation(zoom);
        super.primSetZoom(zoom);
        this.setViewLocation(newViewLocation);
    }

    private Point calcNewViewLocation(double newZoom) {
        Point oldViewLocation = this.getViewport().getViewLocation();
        Point newviewLocation = this.lastMousePos.getCopy();
        newviewLocation.performTranslate(oldViewLocation.x, oldViewLocation.y);
        newviewLocation.scale(1.0 / this.getZoom());
        newviewLocation.scale(newZoom);
        newviewLocation.performTranslate(-this.lastMousePos.x, -this.lastMousePos.y);
        return newviewLocation;
    }

    private Point takeMiddPosition(double newZoom) {
        Point oldViewLocation = this.getViewport().getClientArea().getCenter();
        Dimension dif = oldViewLocation.getScaled(newZoom / this.getZoom()).getDifference(oldViewLocation);
        return this.getViewport().getViewLocation().getTranslated(dif.width, dif.height);
    }
}

