/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.fbtypeeditor.ecc.commands;

import org.eclipse.fordiac.ide.fbtypeeditor.ecc.Messages;
import org.eclipse.fordiac.ide.fbtypeeditor.ecc.commands.CreateTransitionCommand;
import org.eclipse.fordiac.ide.fbtypeeditor.ecc.commands.DeleteTransitionCommand;
import org.eclipse.fordiac.ide.model.libraryElement.ECState;
import org.eclipse.fordiac.ide.model.libraryElement.ECTransition;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.requests.ReconnectRequest;

public class ReconnectTransitionCommand
extends Command {
    private final ReconnectRequest request;
    private DeleteTransitionCommand cmd;
    private CreateTransitionCommand dccc;

    public ReconnectTransitionCommand(ReconnectRequest request) {
        super(Messages.ReconnectTransitionCommand_ReconnectTransition);
        this.request = request;
    }

    public boolean canExecute() {
        return true;
    }

    public void execute() {
        ECTransition transition = (ECTransition)this.request.getConnectionEditPart().getModel();
        this.cmd = new DeleteTransitionCommand(transition);
        this.dccc = new CreateTransitionCommand();
        if (this.request.getType().equals("Reconnection target")) {
            this.doReconnectTarget(transition);
        }
        if (this.request.getType().equals("Reconnection source")) {
            this.doReconnectSource(transition);
        }
        this.dccc.setConditionEvent(transition.getConditionEvent());
        this.dccc.setConditionExpression(transition.getConditionExpression());
        this.cmd.execute();
        this.dccc.execute();
    }

    protected void doReconnectSource(ECTransition transition) {
        this.dccc.setSource((ECState)this.request.getTarget().getModel());
        this.dccc.setDestination(transition.getDestination());
        this.dccc.setDestinationLocation(this.dccc.getDestination().getPosition().asPoint());
        this.dccc.setSourceLocation(this.request.getLocation());
    }

    protected void doReconnectTarget(ECTransition transition) {
        this.dccc.setSource(transition.getSource());
        this.dccc.setDestination((ECState)this.request.getTarget().getModel());
        this.dccc.setDestinationLocation(this.request.getLocation());
        this.dccc.setSourceLocation(this.dccc.getSource().getPosition().asPoint());
    }

    public void redo() {
        this.cmd.redo();
        this.dccc.redo();
    }

    public void undo() {
        this.dccc.undo();
        this.cmd.undo();
    }
}

