/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model.commands.delete;

import org.eclipse.fordiac.ide.model.commands.Messages;
import org.eclipse.fordiac.ide.model.commands.delete.DeleteErrorMarkerCommand;
import org.eclipse.fordiac.ide.model.libraryElement.Connection;
import org.eclipse.fordiac.ide.model.libraryElement.ErrorMarkerInterface;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetwork;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetworkElement;
import org.eclipse.fordiac.ide.model.libraryElement.IInterfaceElement;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;

public class DeleteConnectionCommand
extends Command {
    private IInterfaceElement source;
    private IInterfaceElement destination;
    private final Connection connection;
    private final FBNetwork connectionParent;
    private boolean performMappingCheck;
    private DeleteConnectionCommand deleteMapped = null;
    private final CompoundCommand deleteErrorMarkers = new CompoundCommand();
    private FBNetworkElement errorFb;

    public DeleteConnectionCommand(Connection connection) {
        this(connection, null);
        this.errorFb = null;
    }

    public DeleteConnectionCommand(Connection connection, FBNetworkElement errorFb) {
        super(Messages.DeleteConnectionCommand_DeleteConnection);
        this.connection = connection;
        this.connectionParent = this.connection.eContainer() instanceof FBNetwork ? (FBNetwork)this.connection.eContainer() : null;
        this.performMappingCheck = true;
        this.errorFb = errorFb;
    }

    public Connection getConnectionView() {
        return this.connection;
    }

    public void execute() {
        this.source = this.connection.getSource();
        this.destination = this.connection.getDestination();
        if (this.performMappingCheck) {
            this.deleteMapped = this.checkAndDeleteMirroredConnection();
            if (this.deleteMapped != null) {
                this.deleteMapped.execute();
            }
        }
        this.deleteConnection();
        this.handleErrorMarker();
    }

    private void handleErrorMarker() {
        this.checkErrorMarker();
        this.deleteErrorMarkers.execute();
    }

    public void redo() {
        this.deleteConnection();
        this.deleteErrorMarkers.redo();
    }

    private void deleteConnection() {
        this.connection.setSource(null);
        this.connection.setDestination(null);
        if (this.deleteMapped != null) {
            this.deleteMapped.redo();
        }
        if (this.connectionParent != null) {
            this.connectionParent.removeConnection(this.connection);
        }
    }

    public void undo() {
        this.deleteErrorMarkers.undo();
        this.connection.setSource(this.source);
        this.connection.setDestination(this.destination);
        if (this.connectionParent != null) {
            this.connectionParent.addConnection(this.connection);
        }
        if (this.deleteMapped != null) {
            this.deleteMapped.undo();
        }
    }

    private DeleteConnectionCommand checkAndDeleteMirroredConnection() {
        if (this.source != null && this.source.getFBNetworkElement() != null && this.destination != null && this.destination.getFBNetworkElement() != null) {
            Connection con;
            FBNetworkElement opSource = this.source.getFBNetworkElement().getOpposite();
            FBNetworkElement opDestination = this.destination.getFBNetworkElement().getOpposite();
            if (opSource != null && opDestination != null && opSource.getFbNetwork() == opDestination.getFbNetwork() && (con = DeleteConnectionCommand.findConnection(opSource.getInterfaceElement(this.source.getName()), opDestination.getInterfaceElement(this.destination.getName()))) != null) {
                DeleteConnectionCommand cmd = new DeleteConnectionCommand(con);
                cmd.setPerformMappingCheck(false);
                return cmd.canExecute() ? cmd : null;
            }
        }
        return null;
    }

    private static Connection findConnection(IInterfaceElement source, IInterfaceElement destination) {
        for (Connection con : source.getOutputConnections()) {
            if (con.getDestination() != destination) continue;
            return con;
        }
        return null;
    }

    private void setPerformMappingCheck(boolean performMappingCheck) {
        this.performMappingCheck = performMappingCheck;
    }

    private void checkErrorMarker() {
        if (this.source instanceof ErrorMarkerInterface && DeleteConnectionCommand.getConnectionCount(this.source) == 0) {
            this.deleteErrorMarkers.add((Command)new DeleteErrorMarkerCommand((ErrorMarkerInterface)this.source, this.errorFb));
        }
        if (this.destination instanceof ErrorMarkerInterface && DeleteConnectionCommand.getConnectionCount(this.destination) == 0) {
            this.deleteErrorMarkers.add((Command)new DeleteErrorMarkerCommand((ErrorMarkerInterface)this.destination, this.errorFb));
        }
    }

    private static int getConnectionCount(IInterfaceElement ie) {
        return ie.isIsInput() ? ie.getInputConnections().size() : ie.getOutputConnections().size();
    }
}

