/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model.commands.change;

import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.fordiac.ide.model.commands.Messages;
import org.eclipse.fordiac.ide.model.libraryElement.PositionableElement;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.requests.ChangeBoundsRequest;

public class SetPositionCommand
extends Command {
    private final Rectangle newBounds;
    private Rectangle oldBounds;
    private final ChangeBoundsRequest request;
    private final PositionableElement positionableElement;

    public PositionableElement getPositionableElement() {
        return this.positionableElement;
    }

    public SetPositionCommand(PositionableElement positionableElement, ChangeBoundsRequest req, Rectangle newBounds) {
        this.positionableElement = positionableElement;
        this.request = req;
        this.newBounds = newBounds.getCopy();
        this.setLabel(Messages.ViewSetPositionCommand_LABEL_Move);
    }

    public boolean canExecute() {
        Object type = this.request.getType();
        return "move".equals(type) || "move children".equals(type) || "align children".equals(type);
    }

    public void execute() {
        this.oldBounds = new Rectangle(this.positionableElement.getPosition().getX(), this.positionableElement.getPosition().getY(), -1, -1);
        this.setPosition(this.newBounds);
    }

    public void redo() {
        this.setPosition(this.newBounds);
    }

    public void undo() {
        this.setPosition(this.oldBounds);
    }

    protected void setPosition(Rectangle bounds) {
        this.positionableElement.updatePosition(bounds.getTopLeft());
    }
}

