/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.fbtypeeditor.simplefb;

import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.IFigure;
import org.eclipse.fordiac.ide.fbtypeeditor.FBTypeEditDomain;
import org.eclipse.fordiac.ide.fbtypeeditor.editors.IFBTEditorPart;
import org.eclipse.fordiac.ide.fbtypeeditor.simplefb.Activator;
import org.eclipse.fordiac.ide.fbtypeeditor.simplefb.widgets.AlgorithmEditingCompositeSimpleFB;
import org.eclipse.fordiac.ide.gef.editparts.Abstract4diacEditPartFactory;
import org.eclipse.fordiac.ide.model.libraryElement.BaseFBType;
import org.eclipse.fordiac.ide.model.libraryElement.FBType;
import org.eclipse.fordiac.ide.model.libraryElement.SimpleFBType;
import org.eclipse.fordiac.ide.typemanagement.FBTypeEditorInput;
import org.eclipse.fordiac.ide.ui.FordiacMessages;
import org.eclipse.fordiac.ide.ui.imageprovider.FordiacImage;
import org.eclipse.gef.DefaultEditDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartFactory;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.commands.CommandStack;
import org.eclipse.gef.editparts.AbstractGraphicalEditPart;
import org.eclipse.gef.ui.parts.GraphicalEditor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class SimpleFBEditor
extends GraphicalEditor
implements IFBTEditorPart {
    private final AlgorithmEditingCompositeSimpleFB baseAlgorithm = new AlgorithmEditingCompositeSimpleFB();
    private SimpleFBType fbType;
    private CommandStack commandStack;

    public void createPartControl(Composite parent) {
        FormToolkit toolkit = new FormToolkit(parent.getDisplay());
        this.baseAlgorithm.createControls(parent, toolkit);
        this.baseAlgorithm.initialize((BaseFBType)this.fbType, this.commandStack);
        this.baseAlgorithm.setAlgorithm(this.fbType.getAlgorithm());
        super.createPartControl(this.baseAlgorithm.getCodeEditors());
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        FBTypeEditorInput untypedInput;
        super.init(site, input);
        this.setEditDomain((DefaultEditDomain)new FBTypeEditDomain((IEditorPart)this, this.commandStack));
        this.setInput(input);
        if (input instanceof FBTypeEditorInput && (untypedInput = (FBTypeEditorInput)input).getContent() instanceof SimpleFBType) {
            this.fbType = (SimpleFBType)untypedInput.getContent();
        }
        this.setCommonCommandStack(this.commandStack);
        this.setSite((IWorkbenchPartSite)site);
        this.setPartName(FordiacMessages.Algorithm);
        this.setTitleImage(FordiacImage.ICON_ALGORITHM.getImage());
        this.getSite().getWorkbenchWindow().getSelectionService().addSelectionListener((ISelectionListener)this);
    }

    public void doSave(IProgressMonitor monitor) {
        this.commandStack.markSaveLocation();
        this.firePropertyChange(257);
    }

    public void doSaveAs() {
    }

    public boolean isDirty() {
        return false;
    }

    public boolean isSaveAsAllowed() {
        return true;
    }

    public void setFocus() {
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        this.baseAlgorithm.setAlgorithm(this.fbType.getAlgorithm());
    }

    public boolean outlineSelectionChanged(Object selectedElement) {
        return false;
    }

    public void setCommonCommandStack(CommandStack commandStack) {
        this.commandStack = commandStack;
    }

    public void dispose() {
        this.getSite().getWorkbenchWindow().getSelectionService().removeSelectionListener((ISelectionListener)this);
        super.dispose();
    }

    public void gotoMarker(IMarker marker) {
    }

    public boolean isMarkerTarget(IMarker marker) {
        return false;
    }

    public void reloadType(FBType type) {
        if (type instanceof SimpleFBType) {
            this.fbType = (SimpleFBType)type;
            this.baseAlgorithm.setAlgorithm(this.fbType.getAlgorithm());
            try {
                this.init(this.getEditorSite(), (IEditorInput)new FBTypeEditorInput(type, type.getPaletteEntry()));
                this.initializeGraphicalViewer();
            }
            catch (PartInitException e) {
                Activator.getDefault().logError(this.getContentDescription(), (Exception)((Object)e));
            }
        }
    }

    protected void initializeGraphicalViewer() {
        GraphicalViewer viewer = this.getGraphicalViewer();
        viewer.setEditPartFactory((EditPartFactory)new Abstract4diacEditPartFactory(this){

            protected EditPart getPartForElement(EditPart context, Object modelElement) {
                if (modelElement instanceof SimpleFBType) {
                    return new SimpleFBEditPart();
                }
                return null;
            }
        });
        viewer.setContents((Object)this.fbType);
    }

    protected CommandStack getCommandStack() {
        return this.commandStack;
    }

    public Object getSelectableEditPart() {
        if (this.getGraphicalViewer() == null) {
            return null;
        }
        return this.getGraphicalViewer().getEditPartRegistry().get(this.fbType);
    }

    public static final class SimpleFBEditPart
    extends AbstractGraphicalEditPart {
        protected IFigure createFigure() {
            return new Figure();
        }

        protected void createEditPolicies() {
        }
    }
}

