/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.application.tools;

import java.util.HashMap;
import java.util.List;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.fordiac.ide.gef.editparts.InterfaceEditPart;
import org.eclipse.fordiac.ide.gef.tools.AdvancedPanningSelectionTool;
import org.eclipse.fordiac.ide.gef.tools.FordiacConnectionDragCreationTool;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.Request;
import org.eclipse.gef.requests.SelectionRequest;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.MouseEvent;

public class FBNetworkPanningSelectionTool
extends AdvancedPanningSelectionTool {
    private static final int CONNECTION_CREATION_MOD_KEY = SWT.MOD3;
    static final int LEFT_MOUSE = 1;
    static final double TYPE_DISTANCE = 10.0;
    private Point lastLeftClick = new Point(0, 0);
    private InlineConnectionCreationTool connectionCreationTool;

    public void mouseDown(MouseEvent me, EditPartViewer viewer) {
        this.checkConnCreationState(me);
        if (this.connectionCreationTool == null) {
            super.mouseDown(me, viewer);
        }
    }

    public void mouseUp(MouseEvent me, EditPartViewer viewer) {
        if (this.checkConnCreationState(me)) {
            this.connectionCreationTool.mouseUp(me, viewer);
        } else {
            if (1 == me.button) {
                this.lastLeftClick = this.getLocation();
            }
            super.mouseUp(me, viewer);
        }
    }

    public void keyDown(KeyEvent evt, EditPartViewer viewer) {
        EditPart editPart;
        if (Character.isLetterOrDigit(evt.character) && 10.0 > this.getLocation().getDistance(this.lastLeftClick) && (editPart = viewer.findObjectAt(this.getLocation())) != null) {
            SelectionRequest request = new SelectionRequest();
            request.setLocation(this.lastLeftClick);
            request.setType((Object)"open");
            HashMap<String, String> map = new HashMap<String, String>();
            map.put(String.valueOf(evt.character), String.valueOf(evt.character));
            request.setExtendedData(map);
            editPart.performRequest((Request)request);
            return;
        }
        if (evt.keyCode == CONNECTION_CREATION_MOD_KEY && this.connectionCreationTool == null) {
            this.activateConnectionCreation(viewer);
        }
        super.keyDown(evt, viewer);
    }

    public void mouseMove(MouseEvent me, EditPartViewer viewer) {
        if (this.checkConnCreationState(me)) {
            this.connectionCreationTool.mouseDrag(me, viewer);
        } else {
            super.mouseMove(me, viewer);
        }
    }

    public void keyUp(KeyEvent evt, EditPartViewer viewer) {
        if (evt.keyCode == CONNECTION_CREATION_MOD_KEY && this.connectionCreationTool != null) {
            this.deactivateConnectionCreation();
        }
        super.keyUp(evt, viewer);
    }

    private void activateConnectionCreation(EditPartViewer viewer) {
        List editParts = viewer.getSelectedEditParts();
        if (editParts.size() == 1 && editParts.get(0) instanceof InterfaceEditPart) {
            this.connectionCreationTool = new InlineConnectionCreationTool((EditPart)editParts.get(0));
            this.connectionCreationTool.setViewer(viewer);
            this.connectionCreationTool.setEditDomain(this.getDomain());
            this.connectionCreationTool.startup(this.getCurrentInput().getMouseLocation());
        }
    }

    private void deactivateConnectionCreation() {
        this.connectionCreationTool.deactivate();
        this.connectionCreationTool = null;
    }

    private boolean checkConnCreationState(MouseEvent me) {
        if (this.connectionCreationTool != null) {
            if ((me.stateMask & CONNECTION_CREATION_MOD_KEY) == 0) {
                this.deactivateConnectionCreation();
                return false;
            }
            return true;
        }
        return false;
    }

    static class InlineConnectionCreationTool
    extends FordiacConnectionDragCreationTool {
        private final EditPart sourcePart;
        private EditPart lastConnTarget;
        private boolean startup = true;

        public InlineConnectionCreationTool(EditPart sourcePart) {
            this.sourcePart = sourcePart;
        }

        public void startup(Point point) {
            this.startup = true;
            this.activate();
            super.handleButtonDown(1);
            this.startup = false;
            this.handleDragStarted();
            this.getCurrentInput().setMouseLocation(point.x, point.y);
            this.handleMove();
        }

        public void mouseUp(MouseEvent me, EditPartViewer viewer) {
            super.mouseUp(me, viewer);
            this.lastConnTarget = this.getTargetEditPart();
            this.startup(new Point(me.x, me.y));
        }

        protected EditPart getTargetEditPart() {
            if (this.startup) {
                return this.sourcePart;
            }
            EditPart part = super.getTargetEditPart();
            if (part != null && part.equals(this.lastConnTarget)) {
                part = null;
            }
            return part;
        }
    }
}

