/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.application.handlers;

import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.Status;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.fordiac.ide.application.commands.MoveElementsFromSubAppCommand;
import org.eclipse.fordiac.ide.application.editparts.AbstractFBNElementEditPart;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetwork;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetworkElement;
import org.eclipse.fordiac.ide.model.libraryElement.SubApp;
import org.eclipse.fordiac.ide.model.ui.editors.HandlerHelper;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.commands.Command;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.graphics.Point;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.handlers.HandlerUtil;

public class MoveToParentHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        ISelection selection;
        List<FBNetworkElement> fbelements;
        IEditorPart editor = HandlerUtil.getActiveEditor((ExecutionEvent)event);
        if (editor != null && !(fbelements = MoveToParentHandler.getSelectedFBNElements(selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event))).isEmpty()) {
            Rectangle bounds = MoveToParentHandler.getParentSubappBounds(editor, fbelements);
            int destX = bounds.x;
            int destY = bounds.y + bounds.height + 20;
            MoveElementsFromSubAppCommand cmd = new MoveElementsFromSubAppCommand(fbelements, new Point(destX, destY));
            HandlerHelper.getCommandStack((IEditorPart)editor).execute((Command)cmd);
            MoveToParentHandler.selectElements(editor, fbelements);
        }
        return Status.OK_STATUS;
    }

    private static void selectElements(IEditorPart editor, List<FBNetworkElement> fbelements) {
        GraphicalViewer viewer = MoveToParentHandler.getViewer(fbelements.get(0).getFbNetwork(), editor);
        List eps = fbelements.stream().map(el -> (EditPart)viewer.getEditPartRegistry().get(el)).collect(Collectors.toList());
        viewer.setSelection((ISelection)new StructuredSelection(eps));
    }

    private static Rectangle getParentSubappBounds(IEditorPart editor, List<FBNetworkElement> fbelements) {
        FBNetwork subappNetwork = MoveToParentHandler.getParentOfParent(fbelements.get(0));
        GraphicalViewer viewer = MoveToParentHandler.getViewer(subappNetwork, editor);
        viewer.flush();
        GraphicalEditPart ep = (GraphicalEditPart)viewer.getEditPartRegistry().get(fbelements.get(0).getFbNetwork().eContainer());
        return ep.getFigure().getBounds();
    }

    private static GraphicalViewer getViewer(FBNetwork subappNetwork, IEditorPart parent) {
        if (!HandlerHelper.getFBNetwork((IEditorPart)parent).equals(subappNetwork)) {
            return HandlerHelper.getViewer((IEditorPart)HandlerHelper.openEditor((EObject)subappNetwork.eContainer()));
        }
        return HandlerHelper.getViewer((IEditorPart)parent);
    }

    public void setEnabled(Object evaluationContext) {
        ISelection selection = (ISelection)HandlerUtil.getVariable((Object)evaluationContext, (String)"selection");
        List<FBNetworkElement> fbelements = MoveToParentHandler.getSelectedFBNElements(selection);
        if (!fbelements.isEmpty() && fbelements.get(0).getFbNetwork().eContainer() instanceof SubApp) {
            FBNetwork parent = fbelements.get(0).getFbNetwork();
            boolean sameParentNetwork = fbelements.stream().allMatch(el -> parent.equals(el.getFbNetwork()));
            this.setBaseEnabled(sameParentNetwork);
            return;
        }
        this.setBaseEnabled(false);
    }

    private static List<FBNetworkElement> getSelectedFBNElements(ISelection selection) {
        if (selection instanceof IStructuredSelection && !selection.isEmpty()) {
            IStructuredSelection sel = (IStructuredSelection)selection;
            return sel.toList().stream().filter(AbstractFBNElementEditPart.class::isInstance).map(ep -> ((AbstractFBNElementEditPart)((Object)((Object)ep))).getModel()).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    private static FBNetwork getParentOfParent(FBNetworkElement fbNetworkElement) {
        return (FBNetwork)fbNetworkElement.getFbNetwork().eContainer().eContainer();
    }
}

