/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.monitoring.editparts;

import java.text.MessageFormat;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.MarginBorder;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.fordiac.ide.application.Messages;
import org.eclipse.fordiac.ide.gef.draw2d.SetableAlphaLabel;
import org.eclipse.fordiac.ide.model.data.DataType;
import org.eclipse.fordiac.ide.model.libraryElement.Event;
import org.eclipse.fordiac.ide.model.libraryElement.IInterfaceElement;
import org.eclipse.fordiac.ide.model.libraryElement.VarDeclaration;
import org.eclipse.fordiac.ide.model.monitoring.MonitoringElement;
import org.eclipse.fordiac.ide.model.validation.ValueValidator;
import org.eclipse.fordiac.ide.monitoring.Activator;
import org.eclipse.fordiac.ide.monitoring.MonitoringManager;
import org.eclipse.fordiac.ide.monitoring.editparts.AbstractMonitoringBaseEditPart;
import org.eclipse.fordiac.ide.monitoring.preferences.PreferenceConstants;
import org.eclipse.fordiac.ide.monitoring.views.WatchValueTreeNodeUtils;
import org.eclipse.fordiac.ide.ui.errormessages.ErrorMessenger;
import org.eclipse.fordiac.ide.ui.preferences.PreferenceGetter;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editpolicies.DirectEditPolicy;
import org.eclipse.gef.requests.DirectEditRequest;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.swt.widgets.Display;

public class MonitoringEditPart
extends AbstractMonitoringBaseEditPart {
    private final IPropertyChangeListener propertyChangeListener = event -> {
        if (event.getProperty().equals("monitoringTransparency")) {
            ((SetableAlphaLabel)this.getFigure()).setAlpha(PreferenceConstants.getMonitoringTransparency());
        }
    };

    @Override
    public void activate() {
        if (!this.isActive()) {
            super.activate();
            Activator.getDefault().getPreferenceStore().addPropertyChangeListener(this.propertyChangeListener);
        }
    }

    @Override
    public void deactivate() {
        if (this.isActive()) {
            super.deactivate();
            Activator.getDefault().getPreferenceStore().removePropertyChangeListener(this.propertyChangeListener);
        }
    }

    public boolean isEvent() {
        return this.getInterfaceElement() instanceof Event;
    }

    public boolean isVariable() {
        return this.getInterfaceElement() instanceof VarDeclaration;
    }

    @Override
    public MonitoringElement getModel() {
        return (MonitoringElement)super.getModel();
    }

    protected void createEditPolicies() {
        if (!this.isEvent()) {
            this.installEditPolicy("DirectEditPolicy", (EditPolicy)new MonitoringDirectEditPolicy());
        }
    }

    @Override
    protected void setBackgroundColor(IFigure l) {
        if (this.getModel().isForce()) {
            l.setBackgroundColor(PreferenceGetter.getColor((IPreferenceStore)Activator.getDefault().getPreferenceStore(), (String)"forceColor"));
        } else {
            super.setBackgroundColor(l);
        }
    }

    protected IFigure createFigureForModel() {
        SetableAlphaLabel l = new SetableAlphaLabel();
        this.setBackgroundColor((IFigure)l);
        l.setOpaque(true);
        if (this.isInput()) {
            l.setLabelAlignment(4);
            l.setTextAlignment(4);
        } else {
            l.setTextAlignment(1);
            l.setLabelAlignment(1);
        }
        l.setBorder((Border)new MarginBorder(0, 5, 0, 5));
        l.setText(Messages.MonitoringEditPart_Not_Available);
        l.setMinimumSize(new Dimension(50, 1));
        l.setAlpha(PreferenceConstants.getMonitoringTransparency());
        return l;
    }

    protected Adapter createContentAdapter() {
        return new AdapterImpl(){

            public void notifyChanged(Notification notification) {
                super.notifyChanged(notification);
                Display.getDefault().asyncExec(() -> {
                    MonitoringEditPart.this.setValue(MonitoringEditPart.this.getModel().getCurrentValue());
                    MonitoringEditPart.this.refreshVisuals();
                });
            }
        };
    }

    public void performRequest(Request request) {
        if (request.getType() == "direct edit" || request.getType() == "open") {
            if (!this.isEvent()) {
                this.performDirectEdit();
            }
        } else {
            super.performRequest(request);
        }
    }

    @Override
    public boolean understandsRequest(Request request) {
        if (request.getType() == "direct edit" || request.getType() == "open") {
            return this.isVariable();
        }
        return super.understandsRequest(request);
    }

    public void setValue(String input) {
        if (this.isActive() && this.getFigure() != null) {
            Label figure = (Label)this.getFigure();
            if (this.isVariable()) {
                VarDeclaration varDeclaration = (VarDeclaration)this.getInterfaceElement();
                if (this.isForced()) {
                    figure.setText(MessageFormat.format(Messages.MonitoringEditPart_Forced_ValueDisplay, this.getModel().getForceValue(), WatchValueTreeNodeUtils.decorateHexValue(input, varDeclaration.getType(), this.getModel())));
                } else {
                    figure.setText(WatchValueTreeNodeUtils.decorateHexValue(input, varDeclaration.getType(), this.getModel()));
                }
            } else {
                figure.setText(input);
            }
            this.refreshVisuals();
        }
    }

    private boolean isForced() {
        return this.getModel().isForce() && this.getModel().getForceValue() != null;
    }

    private static class MonitoringDirectEditPolicy
    extends DirectEditPolicy {
        private MonitoringDirectEditPolicy() {
        }

        protected Command getDirectEditCommand(DirectEditRequest request) {
            String value = (String)request.getCellEditor().getValue();
            this.applyNewValue(value);
            return null;
        }

        private void applyNewValue(String value) {
            MonitoringEditPart editPart = (MonitoringEditPart)this.getHost();
            if (this.isValid(value)) {
                MonitoringManager.getInstance().writeValue(editPart.getModel(), value);
            }
        }

        protected void showCurrentEditValue(DirectEditRequest request) {
            String value = (String)request.getCellEditor().getValue();
            MonitoringEditPart editPart = (MonitoringEditPart)this.getHost();
            if (editPart != null) {
                editPart.getNameLabel().setText(value);
            }
        }

        private boolean isValid(String newValue) {
            MonitoringEditPart editPart;
            IInterfaceElement ie;
            String validationMsg;
            if (!newValue.isBlank() && (validationMsg = ValueValidator.validateValue((DataType)(ie = (editPart = (MonitoringEditPart)this.getHost()).getModel().getPort().getInterfaceElement()).getType(), (String)newValue)) != null && !validationMsg.trim().isEmpty()) {
                ErrorMessenger.popUpErrorMessage((String)validationMsg);
                return false;
            }
            return true;
        }
    }
}

