/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.monitoring;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.fordiac.ide.deployment.monitoringbase.IMonitoringListener;
import org.eclipse.fordiac.ide.deployment.monitoringbase.MonitoringBaseElement;
import org.eclipse.fordiac.ide.deployment.monitoringbase.PortElement;
import org.eclipse.fordiac.ide.gef.editparts.IChildrenProvider;
import org.eclipse.fordiac.ide.gef.editparts.IEditPartCreator;
import org.eclipse.fordiac.ide.model.libraryElement.Application;
import org.eclipse.fordiac.ide.model.libraryElement.FB;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetwork;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetworkElement;
import org.eclipse.fordiac.ide.model.libraryElement.SubApp;
import org.eclipse.fordiac.ide.model.monitoring.SubappMonitoringElement;
import org.eclipse.fordiac.ide.monitoring.MonitoringManager;

public class MonitoringChildren
implements IMonitoringListener,
IChildrenProvider {
    public MonitoringChildren() {
        MonitoringManager.getInstance().registerMonitoringListener(this);
    }

    public List<IEditPartCreator> getChildren(FBNetwork fbNetwork) {
        if (fbNetwork != null) {
            Collection<MonitoringBaseElement> elementList = MonitoringManager.getInstance().getElementsToMonitor(fbNetwork.getAutomationSystem());
            return elementList.stream().filter(el -> MonitoringChildren.shouldBeAdded(el, fbNetwork)).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    private static boolean shouldBeAdded(MonitoringBaseElement element, FBNetwork fbNetwork) {
        if (element != null && element.getPort().getFb().getFbNetwork() != null) {
            if (element.getPort().getFb().getFbNetwork().equals(fbNetwork)) {
                return true;
            }
            if (element instanceof SubappMonitoringElement || MonitoringChildren.checkResource(element)) {
                EObject parent = element.getPort().getFb().getFbNetwork().eContainer();
                return MonitoringChildren.isInsideMonitoredSubApp(parent, fbNetwork);
            }
        }
        return false;
    }

    private static boolean checkResource(MonitoringBaseElement element) {
        FBNetworkElement fb = element.getPort().getFb();
        return element.getPort().getFb().getResource() != null && fb instanceof FB && !((FB)fb).isResourceFB();
    }

    private static boolean isInsideMonitoredSubApp(Object parent, FBNetwork network) {
        if (parent instanceof SubApp) {
            SubApp subapp = (SubApp)parent;
            if (network.equals(subapp.getSubAppNetwork())) {
                return true;
            }
            if (subapp.isUnfolded()) {
                return MonitoringChildren.isInsideMonitoredSubApp(subapp.eContainer().eContainer(), network);
            }
        }
        if (parent instanceof Application) {
            return network.equals(((Application)parent).getFBNetwork());
        }
        return false;
    }

    public boolean isEnabled() {
        return true;
    }

    public void notifyAddPort(PortElement port) {
    }

    public void notifyRemovePort(PortElement port) {
    }

    public void notifyTriggerEvent(PortElement port) {
    }

    public void notifyWatchesChanged() {
    }
}

