/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.monitoring;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.fordiac.ide.deployment.devResponse.Data;
import org.eclipse.fordiac.ide.deployment.devResponse.FB;
import org.eclipse.fordiac.ide.deployment.devResponse.Port;
import org.eclipse.fordiac.ide.deployment.devResponse.Resource;
import org.eclipse.fordiac.ide.deployment.devResponse.Response;
import org.eclipse.fordiac.ide.deployment.exceptions.DeploymentException;
import org.eclipse.fordiac.ide.deployment.interactors.DeviceManagementInteractorFactory;
import org.eclipse.fordiac.ide.deployment.interactors.IDeviceManagementInteractor;
import org.eclipse.fordiac.ide.deployment.monitoringbase.MonitoringBaseElement;
import org.eclipse.fordiac.ide.model.libraryElement.Device;
import org.eclipse.fordiac.ide.model.libraryElement.Event;
import org.eclipse.fordiac.ide.model.monitoring.MonitoringElement;
import org.eclipse.fordiac.ide.model.monitoring.SubappMonitoringElement;
import org.eclipse.fordiac.ide.monitoring.SystemMonitoringData;
import org.eclipse.fordiac.ide.monitoring.model.SubAppPortHelper;
import org.eclipse.fordiac.ide.monitoring.preferences.PreferenceConstants;
import org.eclipse.fordiac.ide.systemmanagement.Activator;

class DeviceMonitoringHandler
implements Runnable {
    private final Device device;
    private final IDeviceManagementInteractor devInteractor;
    private final SystemMonitoringData systemMonData;
    private final Thread thread;
    private boolean running = true;

    private synchronized void setRunning(boolean val) {
        this.running = val;
    }

    private synchronized boolean isRunning() {
        return this.running;
    }

    public DeviceMonitoringHandler(Device device, SystemMonitoringData systemMonData) {
        this.device = device;
        this.devInteractor = DeviceManagementInteractorFactory.INSTANCE.getDeviceManagementInteractor(device);
        this.systemMonData = systemMonData;
        this.thread = new Thread(this);
    }

    public Thread getThread() {
        return this.thread;
    }

    public IDeviceManagementInteractor getDevMgmInteractor() {
        return this.devInteractor;
    }

    public synchronized void enable() {
        this.setRunning(true);
        this.thread.start();
    }

    public synchronized void disable() {
        this.setRunning(this.running);
    }

    @Override
    public void run() {
        if (this.devInteractor != null) {
            int pollingIntervall = PreferenceConstants.getPollingInterval();
            while (this.isRunning()) {
                try {
                    Thread.sleep(pollingIntervall);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    Activator.getDefault().logError(e.getMessage(), (Exception)e);
                }
                if (this.devInteractor.isConnected()) {
                    try {
                        Response resp = this.devInteractor.readWatches();
                        if (resp == null) continue;
                        this.updateWatches(resp);
                    }
                    catch (DeploymentException deploymentException) {
                        this.handleDeviceIssue();
                    }
                    continue;
                }
                this.setRunning(false);
            }
        }
    }

    private void updateWatches(Response resp) {
        if (resp.getWatches() != null) {
            for (Resource res : resp.getWatches().getResources()) {
                String resName = String.valueOf(this.device.getName()) + "." + res.getName() + ".";
                this.updateFbs(res, resName);
            }
        }
    }

    public void updateFbs(Resource res, String resName) {
        HashMap<String, SubappGroup> collectedGroups = new HashMap<String, SubappGroup>();
        for (FB fb : res.getFbs()) {
            String fbName = String.valueOf(resName) + fb.getName() + ".";
            for (Port port : fb.getPorts()) {
                String portString = String.valueOf(fbName) + port.getName();
                MonitoringBaseElement element = this.systemMonData.getMonitoringElementByPortString(portString);
                if (element instanceof MonitoringElement) {
                    DeviceMonitoringHandler.updateMonitoringElement((MonitoringElement)element, port);
                }
                this.checkSubappGroups(collectedGroups, port, portString, element);
            }
        }
        this.updateSubappPorts(collectedGroups);
    }

    private void checkSubappGroups(HashMap<String, SubappGroup> collectedGroups, Port port, String portString, MonitoringBaseElement element) {
        Map.Entry<String, List<MonitoringElement>> subappEntry;
        List<MonitoringElement> subappPins = this.systemMonData.getSubappElements().get(portString);
        if (element != null && subappPins == null && (subappEntry = this.systemMonData.getSubappElements(element)) != null) {
            subappPins = subappEntry.getValue();
            portString = subappEntry.getKey();
        }
        if (subappPins != null) {
            SubappGroup subappGroup = null;
            if (collectedGroups.containsKey(portString)) {
                subappGroup = collectedGroups.get(portString);
            } else {
                subappGroup = new SubappGroup(subappPins);
                collectedGroups.put(portString, subappGroup);
            }
            if (element != null) {
                subappGroup.assignPort((MonitoringElement)element, port);
            }
            subappGroup.assignSubappPorts(port, portString);
        }
    }

    private void updateSubappPorts(Map<String, SubappGroup> collectedGroups) {
        for (SubappGroup subappGroup : collectedGroups.values()) {
            this.updateSubAppGroup(subappGroup);
        }
    }

    private void updateSubAppGroup(SubappGroup subappGroup) {
        boolean inconsistent = false;
        boolean event = false;
        String currentVal = "";
        for (MonitoringElement monitoringElement : subappGroup.collectedSubappPins) {
            Port port = subappGroup.getPort(monitoringElement);
            if (port != null) {
                DeviceMonitoringHandler.updateMonitoringElement(monitoringElement, port);
            }
            if (currentVal.isEmpty()) {
                currentVal = monitoringElement.getCurrentValue();
            }
            if (DeviceMonitoringHandler.isEventPin(monitoringElement)) {
                event = true;
            } else if (!inconsistent) {
                inconsistent = this.isInconsistent(currentVal, monitoringElement);
            }
            currentVal = monitoringElement.getCurrentValue();
        }
        if (event) {
            this.updateEventPins(subappGroup);
        }
        if (inconsistent) {
            DeviceMonitoringHandler.setSubappPinsToInconsistentState(subappGroup);
        }
    }

    public boolean isInconsistent(String currentVal, MonitoringElement monitoringElement) {
        if (currentVal.isEmpty()) {
            return false;
        }
        if (monitoringElement instanceof SubappMonitoringElement) {
            List<MonitoringElement> findConnectedElements = SubAppPortHelper.findConnectedElements(monitoringElement.getPort().getInterfaceElement());
            for (MonitoringElement e : findConnectedElements) {
                MonitoringElement monitoredElement = (MonitoringElement)this.systemMonData.getMonitoredElement(e.getPort().getInterfaceElement());
                if (monitoredElement == null || monitoredElement.getCurrentValue().equals(currentVal)) continue;
                return true;
            }
        }
        return !currentVal.equals(monitoringElement.getCurrentValue());
    }

    public static boolean isEventPin(MonitoringBaseElement monitoringElement) {
        return monitoringElement.getPort().getInterfaceElement() instanceof Event;
    }

    private void updateEventPins(SubappGroup subappGroup) {
        subappGroup.collectedSubappPins.stream().filter(SubappMonitoringElement.class::isInstance).filter(me -> !me.getPort().getInterfaceElement().isIsInput()).forEach(e -> {
            List<MonitoringElement> findConnectedElements = SubAppPortHelper.findConnectedElements(e.getPort().getInterfaceElement());
            long eventCount = 0L;
            for (MonitoringElement x : findConnectedElements) {
                MonitoringElement monitoredElement = (MonitoringElement)this.systemMonData.getMonitoredElement(x.getPort().getInterfaceElement());
                if (monitoredElement == null || monitoredElement.getCurrentValue().equals("N/A")) continue;
                eventCount += Long.parseLong(monitoredElement.getCurrentValue());
            }
            e.setCurrentValue(Long.toString(eventCount));
        });
    }

    private static void setSubappPinsToInconsistentState(SubappGroup subappGroup) {
        subappGroup.collectedSubappPins.stream().filter(SubappMonitoringElement.class::isInstance).forEach(e -> e.setCurrentValue("?"));
    }

    private static void updateMonitoringElement(MonitoringElement monitoringElement, Port p) {
        for (Data d : p.getDataValues()) {
            long timeAsLong = 0L;
            try {
                timeAsLong = Long.parseLong(d.getTime());
            }
            catch (NumberFormatException numberFormatException) {
                timeAsLong = 0L;
            }
            monitoringElement.setSec(timeAsLong / 1000L);
            monitoringElement.setUsec(timeAsLong % 1000L);
            monitoringElement.setCurrentValue(d.getValue());
            if (d.getForced() == null) continue;
            monitoringElement.setForce(d.getForced().equals("true"));
        }
    }

    private void handleDeviceIssue() {
        try {
            this.devInteractor.disconnect();
        }
        catch (DeploymentException deploymentException) {}
        this.systemMonData.getMonitoredElements().stream().filter(el -> el.getPort().getDevice().equals(this.device) && el instanceof MonitoringElement).forEach(el -> ((MonitoringElement)el).setCurrentValue(""));
    }

    public static class SubappGroup {
        List<MonitoringElement> collectedSubappPins;
        HashMap<MonitoringElement, Port> pins = new HashMap();

        public SubappGroup(List<MonitoringElement> collectedSubappPins) {
            this.collectedSubappPins = collectedSubappPins;
        }

        public Port getPort(MonitoringElement e) {
            return this.pins.get(e);
        }

        public void assignPort(MonitoringElement e, Port p) {
            for (MonitoringElement monitoringElement : this.collectedSubappPins) {
                if (!(monitoringElement instanceof SubappMonitoringElement) || !((SubappMonitoringElement)monitoringElement).getAnchor().equals(e)) continue;
                this.pins.put(monitoringElement, p);
            }
            this.pins.put(e, p);
        }

        public void assignSubappPorts(Port p, String portString) {
            for (MonitoringElement monitoringElement : this.collectedSubappPins) {
                MonitoringBaseElement anchor;
                if (!(monitoringElement instanceof SubappMonitoringElement) || !(anchor = ((SubappMonitoringElement)monitoringElement).getAnchor()).getPort().getPortString().equals(portString)) continue;
                this.pins.computeIfAbsent(monitoringElement, e -> p);
            }
        }
    }
}

