/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.fbtypeeditor.servicesequence.properties;

import java.util.Arrays;
import org.eclipse.fordiac.ide.fbtypeeditor.servicesequence.Messages;
import org.eclipse.fordiac.ide.fbtypeeditor.servicesequence.commands.ChangePrimitiveEventCommand;
import org.eclipse.fordiac.ide.fbtypeeditor.servicesequence.commands.ChangePrimitiveInterfaceCommand;
import org.eclipse.fordiac.ide.fbtypeeditor.servicesequence.commands.ChangePrimitiveParameterCommand;
import org.eclipse.fordiac.ide.fbtypeeditor.servicesequence.commands.CreateOutputPrimitiveCommand;
import org.eclipse.fordiac.ide.fbtypeeditor.servicesequence.commands.DeleteOutputPrimitiveCommand;
import org.eclipse.fordiac.ide.fbtypeeditor.servicesequence.editparts.TransactionEditPart;
import org.eclipse.fordiac.ide.fbtypeeditor.servicesequence.properties.AbstractServiceSection;
import org.eclipse.fordiac.ide.fbtypeeditor.servicesequence.widgets.InterfaceSelectorButton;
import org.eclipse.fordiac.ide.model.commands.change.ChangeOutputPrimitiveOrderCommand;
import org.eclipse.fordiac.ide.model.libraryElement.INamedElement;
import org.eclipse.fordiac.ide.model.libraryElement.OutputPrimitive;
import org.eclipse.fordiac.ide.model.libraryElement.Primitive;
import org.eclipse.fordiac.ide.model.libraryElement.ServiceInterface;
import org.eclipse.fordiac.ide.model.libraryElement.ServiceTransaction;
import org.eclipse.fordiac.ide.ui.FordiacMessages;
import org.eclipse.fordiac.ide.ui.imageprovider.FordiacImage;
import org.eclipse.fordiac.ide.ui.widget.AddDeleteReorderListWidget;
import org.eclipse.fordiac.ide.ui.widget.ComboBoxWidgetFactory;
import org.eclipse.fordiac.ide.ui.widget.CommandExecutor;
import org.eclipse.fordiac.ide.ui.widget.TableWidgetFactory;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CommandStack;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CheckboxCellEditor;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnPixelData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetWidgetFactory;

public class TransactionSection
extends AbstractServiceSection {
    private static final int PARAMETER_COL_WIDTH = 400;
    private static final int EVENT_COL_WIDTH = 200;
    private static final int INDEX_COL_WIDTH = 80;
    private static final int INTERFACE_COL_WIDTH = 30;
    private TableViewer outputPrimitivesViewer;
    private Group outputsGroup;
    private InterfaceSelectorButton interfaceSelector;
    private Composite composite;
    private CCombo eventNameInput;
    private Text parameterNameInput;
    private static final String INTERFACE = "";
    private static final String INDEX = "index";
    private static final String NAME = "name";
    private static final String PARAM = "parameter";

    public void createControls(Composite parent, TabbedPropertySheetPage tabbedPropertySheetPage) {
        this.createSuperControls = false;
        super.createControls(parent, tabbedPropertySheetPage);
        Composite section = this.getWidgetFactory().createComposite(parent);
        section.setLayout((Layout)new GridLayout(1, false));
        section.setLayoutData((Object)new GridData(4, 4, true, true));
        Composite inputsComp = this.getWidgetFactory().createComposite(section);
        inputsComp.setLayout((Layout)new GridLayout(1, false));
        inputsComp.setLayoutData((Object)new GridData(4, 4, true, true));
        this.createInputPrimitiveGroup(inputsComp);
        Composite outputsComp = this.getWidgetFactory().createComposite(section);
        outputsComp.setLayout((Layout)new GridLayout(1, false));
        outputsComp.setLayoutData((Object)new GridData(4, 4, true, true));
        this.createOutputsEdit(outputsComp);
        this.outputPrimitivesViewer.setContentProvider((IContentProvider)new TransactionContentProvider());
        TableWidgetFactory.enableCopyPasteCut((Object)tabbedPropertySheetPage);
    }

    private void createInputPrimitiveGroup(Composite parent) {
        Group inputsGroup = this.getWidgetFactory().createGroup(parent, Messages.TransactionSection_InputPrimitive);
        inputsGroup.setLayout((Layout)new GridLayout(1, false));
        inputsGroup.setLayoutData((Object)new GridData(4, 4, true, true));
        this.composite = this.getWidgetFactory().createComposite((Composite)inputsGroup);
        this.composite.setLayout((Layout)new GridLayout(5, false));
        this.composite.setLayoutData((Object)new GridData(4, 4, true, true));
        this.composite.pack();
        this.interfaceSelector = new InterfaceSelectorButton(this.composite, cmd -> {
            this.executeCommand((Command)cmd);
            this.refresh();
        });
        this.getWidgetFactory().createCLabel(this.composite, Messages.ServiceSection_Name);
        this.eventNameInput = ComboBoxWidgetFactory.createCombo((TabbedPropertySheetWidgetFactory)this.getWidgetFactory(), (Composite)this.composite);
        this.eventNameInput.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        this.eventNameInput.setSize(100, this.getMinimumHeight());
        this.eventNameInput.addListener(13, event -> {
            ChangePrimitiveEventCommand cmd = new ChangePrimitiveEventCommand((Primitive)this.getType().getInputPrimitive(), this.eventNameInput.getText());
            this.executeCommand(cmd);
            this.eventNameInput.redraw();
        });
        this.getWidgetFactory().createCLabel(this.composite, Messages.TransactionSection_Parameter);
        this.parameterNameInput = new Text(this.composite, 2048);
        this.parameterNameInput.setLayoutData((Object)new GridData(4, 0x1000000, true, true));
        this.parameterNameInput.addModifyListener(e -> {
            ChangePrimitiveParameterCommand cmd = new ChangePrimitiveParameterCommand((Primitive)this.getType().getInputPrimitive(), this.parameterNameInput.getText());
            this.executeCommand(cmd);
            this.parameterNameInput.redraw();
        });
    }

    private static TableViewer createTableViewer(Group parent) {
        TableViewer viewer = TableWidgetFactory.createTableViewer((Composite)parent);
        viewer.getTable().setLayout(TransactionSection.createTableLayout(viewer.getTable()));
        viewer.setColumnProperties(TransactionSection.getColumnProperties());
        viewer.setLabelProvider((IBaseLabelProvider)new TransactionLabelProvider());
        return viewer;
    }

    private CellEditor[] createCellEditors(Table table) {
        CheckboxCellEditor interfaceEditor = new CheckboxCellEditor((Composite)table);
        return new CellEditor[]{interfaceEditor, new TextCellEditor((Composite)table), ComboBoxWidgetFactory.createComboBoxCellEditor((Composite)table, (String[])this.getOutputEventNames(), (int)8), new TextCellEditor((Composite)table)};
    }

    private String[] getOutputEventNames() {
        return (String[])this.getType().getServiceSequence().getService().getFBType().getInterfaceList().getEventOutputs().stream().map(INamedElement::getName).toArray(String[]::new);
    }

    private static String[] getColumnProperties() {
        return new String[]{INTERFACE, INDEX, NAME, PARAM};
    }

    private static Layout createTableLayout(Table table) {
        TableColumn interfaceCol = new TableColumn(table, 16384);
        interfaceCol.setText(INTERFACE);
        TableColumn indexCol = new TableColumn(table, 16384);
        indexCol.setText(Messages.TransactionSection_CreateTableLayout_Index);
        TableColumn eventCol = new TableColumn(table, 16384);
        eventCol.setText(FordiacMessages.Event);
        TableColumn paramCol = new TableColumn(table, 16384);
        paramCol.setText(Messages.TransactionSection_CreateTableLayout_Parameter);
        TableLayout layout = new TableLayout();
        layout.addColumnData((ColumnLayoutData)new ColumnPixelData(30));
        layout.addColumnData((ColumnLayoutData)new ColumnPixelData(80));
        layout.addColumnData((ColumnLayoutData)new ColumnPixelData(200));
        layout.addColumnData((ColumnLayoutData)new ColumnPixelData(400));
        return layout;
    }

    private void configureButtonList(AddDeleteReorderListWidget buttons, TableViewer primitiveViewer) {
        buttons.bindToTableViewer(primitiveViewer, (CommandExecutor)this, ref -> this.newCreateCommand((OutputPrimitive)ref, true), ref -> TransactionSection.newDeleteCommand((OutputPrimitive)ref), ref -> TransactionSection.newOrderCommand((OutputPrimitive)ref, true), ref -> TransactionSection.newOrderCommand((OutputPrimitive)ref, false));
    }

    private static Command newOrderCommand(OutputPrimitive ref, boolean up) {
        return new ChangeOutputPrimitiveOrderCommand(ref, up);
    }

    private static Command newDeleteCommand(OutputPrimitive ref) {
        return new DeleteOutputPrimitiveCommand(ref);
    }

    private CreateOutputPrimitiveCommand newCreateCommand(OutputPrimitive ref, boolean isLeftInterface) {
        return new CreateOutputPrimitiveCommand(this.getType(), ref, isLeftInterface);
    }

    private void createOutputsEdit(Composite parent) {
        this.outputsGroup = this.getWidgetFactory().createGroup(parent, this.getInterfaceNames());
        this.outputsGroup.setLayout((Layout)new GridLayout(2, false));
        this.outputsGroup.setLayoutData((Object)new GridData(4, 4, true, true));
        AddDeleteReorderListWidget buttons = new AddDeleteReorderListWidget();
        buttons.createControls((Composite)this.outputsGroup, (FormToolkit)this.getWidgetFactory());
        this.outputPrimitivesViewer = TransactionSection.createTableViewer(this.outputsGroup);
        this.configureButtonList(buttons, this.outputPrimitivesViewer);
    }

    private String getInterfaceNames() {
        if (this.type == null) {
            return Messages.TransactionSection_OutputPrimitives;
        }
        return this.collectOutputPrimitiveGroupName();
    }

    private String collectOutputPrimitiveGroupName() {
        StringBuilder sb = new StringBuilder();
        sb.append(Messages.TransactionSection_CollectOutputPrimitiveGroupName_PrimitivesRightInterface);
        sb.append(" (");
        sb.append(this.getRightInterfaceName());
        sb.append(") ");
        sb.append(Messages.TransactionSection_CollectOutputPrimitiveGroupName_AndLeftInterface);
        sb.append(" (");
        sb.append(this.getLeftInterfaceName());
        sb.append(")");
        return sb.toString();
    }

    private String getLeftInterfaceName() {
        ServiceInterface leftInterface = this.getType().getServiceSequence().getService().getLeftInterface();
        if (leftInterface != null) {
            return leftInterface.getName();
        }
        return INTERFACE;
    }

    private String getRightInterfaceName() {
        ServiceInterface rightInterface = this.getType().getServiceSequence().getService().getRightInterface();
        if (rightInterface != null) {
            return rightInterface.getName();
        }
        return INTERFACE;
    }

    protected ServiceTransaction getType() {
        return (ServiceTransaction)this.type;
    }

    public void refresh() {
        super.refresh();
        CommandStack commandStackBuffer = this.commandStack;
        this.commandStack = null;
        if (this.type != null) {
            this.interfaceSelector.setType((Primitive)this.getType().getInputPrimitive());
            this.outputPrimitivesViewer.setInput((Object)this.getType());
            this.outputsGroup.setText(this.getInterfaceNames());
            this.fillEventNameInputDropdown();
            this.eventNameInput.setText(this.getType().getInputPrimitive().getEvent());
            if (this.getType().getInputPrimitive().getParameters() == null) {
                this.parameterNameInput.setText(INTERFACE);
            } else {
                this.parameterNameInput.setText(this.getType().getInputPrimitive().getParameters());
            }
        }
        this.commandStack = commandStackBuffer;
    }

    private void fillEventNameInputDropdown() {
        String[] inputEvents;
        this.eventNameInput.removeAll();
        String[] stringArray = inputEvents = (String[])this.getType().getServiceSequence().getService().getFBType().getInterfaceList().getEventInputs().stream().map(INamedElement::getName).toArray(String[]::new);
        int n = inputEvents.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            this.eventNameInput.add(s);
            ++n2;
        }
        this.composite.layout();
    }

    protected Object getInputType(Object input) {
        if (input instanceof TransactionEditPart) {
            return ((TransactionEditPart)((Object)input)).getModel();
        }
        if (input instanceof ServiceTransaction) {
            return input;
        }
        return null;
    }

    protected void setInputCode() {
    }

    protected void setInputInit() {
        this.outputPrimitivesViewer.setCellEditors(this.createCellEditors(this.outputPrimitivesViewer.getTable()));
        this.outputPrimitivesViewer.setCellModifier((ICellModifier)new TransactionCellModifier());
    }

    private class TransactionCellModifier
    implements ICellModifier {
        private TransactionCellModifier() {
        }

        public boolean canModify(Object element, String property) {
            return !property.equals(TransactionSection.INDEX);
        }

        public Object getValue(Object element, String property) {
            block17: {
                if (!(element instanceof Primitive)) break block17;
                Primitive primitive = (Primitive)element;
                switch (property) {
                    case "index": {
                        return String.valueOf(primitive.getServiceTransaction().getOutputPrimitive().indexOf((Object)primitive) + 1);
                    }
                    case "name": {
                        return this.getNameOfCurrentEvent(primitive);
                    }
                    case "parameter": {
                        if (primitive.getParameters() == null) {
                            return TransactionSection.INTERFACE;
                        }
                        return primitive.getParameters();
                    }
                    case "": {
                        return true;
                    }
                }
            }
            return element;
        }

        public void modify(Object element, String property, Object value) {
            TableItem tableItem = (TableItem)element;
            OutputPrimitive primitive = (OutputPrimitive)tableItem.getData();
            Command cmd = null;
            switch (property) {
                case "name": {
                    int selectedEv = (Integer)value;
                    String[] eventNames = TransactionSection.this.getOutputEventNames();
                    cmd = new ChangePrimitiveEventCommand((Primitive)primitive, eventNames[selectedEv]);
                    break;
                }
                case "parameter": {
                    cmd = new ChangePrimitiveParameterCommand((Primitive)primitive, value.toString());
                    break;
                }
                case "": {
                    if (primitive.getInterface().isLeftInterface()) {
                        cmd = new ChangePrimitiveInterfaceCommand((Primitive)primitive, primitive.getService().getRightInterface());
                        break;
                    }
                    cmd = new ChangePrimitiveInterfaceCommand((Primitive)primitive, primitive.getService().getLeftInterface());
                    break;
                }
            }
            if (cmd != null) {
                TransactionSection.this.executeCommand(cmd);
                TransactionSection.this.refresh();
            }
        }

        private Object getNameOfCurrentEvent(Primitive primitive) {
            String event = primitive.getEvent();
            if (event == null) {
                return 0;
            }
            String[] eventNames = TransactionSection.this.getOutputEventNames();
            int indexOfEvent = Arrays.asList(eventNames).indexOf(event);
            if (indexOfEvent < 0) {
                return 0;
            }
            return indexOfEvent;
        }
    }

    protected static class TransactionContentProvider
    extends ArrayContentProvider {
        protected TransactionContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            return ((ServiceTransaction)inputElement).getOutputPrimitive().toArray();
        }
    }

    protected static class TransactionLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        public static final int INTERFACE_COL_INDEX = 0;
        public static final int INDEX_COL_INDEX = 1;
        public static final int NAME_COL_INDEX = 2;
        public static final int PARAM_COL_INDEX = 3;

        protected TransactionLabelProvider() {
        }

        public String getColumnText(Object element, int columnIndex) {
            if (element instanceof Primitive) {
                Primitive primitive = (Primitive)element;
                switch (columnIndex) {
                    case 0: {
                        return TransactionSection.INTERFACE;
                    }
                    case 1: {
                        return String.valueOf(primitive.getServiceTransaction().getOutputPrimitive().indexOf((Object)primitive) + 1);
                    }
                    case 2: {
                        return primitive.getEvent();
                    }
                    case 3: {
                        if (primitive.getParameters() == null) {
                            return TransactionSection.INTERFACE;
                        }
                        return primitive.getParameters();
                    }
                }
            }
            return element.toString();
        }

        public Image getColumnImage(Object object, int columnIndex) {
            if (object instanceof Primitive && columnIndex == 0) {
                Primitive primitive = (Primitive)object;
                if (primitive.getInterface().isLeftInterface()) {
                    return FordiacImage.ICON_LEFT_INPUT_PRIMITIVE.getImage();
                }
                return FordiacImage.ICON_RIGHT_INPUT_PRIMITIVE.getImage();
            }
            return null;
        }
    }
}

