/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.fbtypeeditor.servicesequence.handler;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.Status;
import org.eclipse.fordiac.ide.fbtypeeditor.servicesequence.Activator;
import org.eclipse.fordiac.ide.fbtypeeditor.servicesequence.Messages;
import org.eclipse.fordiac.ide.fbtypeeditor.servicesequence.editparts.ServiceSequenceEditPart;
import org.eclipse.fordiac.ide.model.libraryElement.BasicFBType;
import org.eclipse.fordiac.ide.model.libraryElement.ServiceSequence;
import org.eclipse.fordiac.ide.test.fb.interpreter.infra.AbstractInterpreterTest;
import org.eclipse.gef.EditPart;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.handlers.HandlerUtil;

public class RunServiceSequenceHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        IStructuredSelection selection = (IStructuredSelection)HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        for (Object selected : selection.toList()) {
            ServiceSequence seq = RunServiceSequenceHandler.getSequence(selected);
            if (seq == null) continue;
            try {
                AbstractInterpreterTest.runTest((BasicFBType)((BasicFBType)seq.getService().getFBType()), (ServiceSequence)seq);
                MessageDialog.openInformation((Shell)HandlerUtil.getActiveShell((ExecutionEvent)event), (String)Messages.RunServiceSequenceHandler_Success, (String)Messages.RunServiceSequenceHandler_SequenceMatchesECC);
            }
            catch (Exception exception) {
                Activator.getDefault().logError("Service Sequence was inconsistent");
                MessageDialog.openError((Shell)HandlerUtil.getActiveShell((ExecutionEvent)event), (String)Messages.RunServiceSequenceHandler_InconsistencyDetected, (String)Messages.RunServiceSequenceHandler_SequenceDoesNotMatchECC);
            }
        }
        return Status.OK_STATUS;
    }

    public void setEnabled(Object evaluationContext) {
        ISelection selection = (ISelection)HandlerUtil.getVariable((Object)evaluationContext, (String)"selection");
        if (selection instanceof StructuredSelection) {
            Object selected = ((StructuredSelection)selection).getFirstElement();
            if (selected instanceof EditPart) {
                selected = ((EditPart)selected).getModel();
            }
            if (selected instanceof ServiceSequence) {
                this.setBaseEnabled(((ServiceSequence)selected).getService().getFBType() instanceof BasicFBType);
            }
        }
    }

    private static ServiceSequence getSequence(Object selected) {
        if (selected instanceof ServiceSequenceEditPart) {
            return ((ServiceSequenceEditPart)((Object)selected)).getModel();
        }
        if (selected instanceof ServiceSequence) {
            return (ServiceSequence)selected;
        }
        return null;
    }
}

