/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.fbtypeeditor.servicesequence;

import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.draw2d.FreeformViewport;
import org.eclipse.draw2d.RangeModel;
import org.eclipse.fordiac.ide.fbtypeeditor.FBTypeEditDomain;
import org.eclipse.fordiac.ide.fbtypeeditor.editors.FBTypeEditor;
import org.eclipse.fordiac.ide.fbtypeeditor.editors.IFBTEditorPart;
import org.eclipse.fordiac.ide.fbtypeeditor.servicesequence.Messages;
import org.eclipse.fordiac.ide.fbtypeeditor.servicesequence.ServiceInterfacePaletteFactory;
import org.eclipse.fordiac.ide.fbtypeeditor.servicesequence.editparts.InputPrimitiveEditPart;
import org.eclipse.fordiac.ide.fbtypeeditor.servicesequence.editparts.OutputPrimitiveEditPart;
import org.eclipse.fordiac.ide.fbtypeeditor.servicesequence.editparts.SequenceRootEditPart;
import org.eclipse.fordiac.ide.fbtypeeditor.servicesequence.editparts.ServiceSequenceEditPartFactory;
import org.eclipse.fordiac.ide.gef.DiagramEditorWithFlyoutPalette;
import org.eclipse.fordiac.ide.gef.FordiacContextMenuProvider;
import org.eclipse.fordiac.ide.gef.editparts.ZoomScalableFreeformRootEditPart;
import org.eclipse.fordiac.ide.gef.figures.AbstractFreeformFigure;
import org.eclipse.fordiac.ide.gef.figures.ModuloFreeformFigure;
import org.eclipse.fordiac.ide.model.libraryElement.AutomationSystem;
import org.eclipse.fordiac.ide.model.libraryElement.FBType;
import org.eclipse.fordiac.ide.model.libraryElement.Service;
import org.eclipse.fordiac.ide.typemanagement.FBTypeEditorInput;
import org.eclipse.fordiac.ide.ui.imageprovider.FordiacImage;
import org.eclipse.gef.ContextMenuProvider;
import org.eclipse.gef.DefaultEditDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartFactory;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.commands.CommandStack;
import org.eclipse.gef.editparts.FreeformGraphicalRootEditPart;
import org.eclipse.gef.editparts.ScalableFreeformRootEditPart;
import org.eclipse.gef.editparts.ZoomManager;
import org.eclipse.gef.palette.PaletteRoot;
import org.eclipse.gef.ui.parts.GraphicalEditor;
import org.eclipse.gef.ui.parts.ScrollingGraphicalViewer;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.util.TransferDropTargetListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.graphics.Point;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.actions.ActionFactory;

public class ServiceSequenceEditor
extends DiagramEditorWithFlyoutPalette
implements IFBTEditorPart {
    private FBType fbType;
    private CommandStack commandStack;

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        this.setInputWithNotify(input);
        if (input instanceof FBTypeEditorInput) {
            FBTypeEditorInput untypedInput = (FBTypeEditorInput)input;
            this.fbType = untypedInput.getContent();
        }
        this.setEditDomain((DefaultEditDomain)new FBTypeEditDomain((IEditorPart)this, this.commandStack));
        super.init(site, input);
        this.setPartName(Messages.ServiceSequenceEditor_Service);
        this.setTitleImage(FordiacImage.ICON_SERVICE_SEQUENCE.getImage());
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        super.selectionChanged(part, selection);
        if (part.getSite().getPage().getActiveEditor() instanceof FBTypeEditor) {
            this.updateActions(this.getSelectionActions());
            if (!selection.isEmpty() && selection instanceof IStructuredSelection) {
                IStructuredSelection sel = (IStructuredSelection)selection;
                if (sel.getFirstElement() instanceof SequenceRootEditPart) {
                    ((FBType)((SequenceRootEditPart)((Object)sel.getFirstElement())).getModel()).getService();
                } else if (sel.getFirstElement() instanceof OutputPrimitiveEditPart) {
                    ((OutputPrimitiveEditPart)((Object)sel.getFirstElement())).getModel();
                } else if (sel.getFirstElement() instanceof InputPrimitiveEditPart) {
                    ((InputPrimitiveEditPart)((Object)sel.getFirstElement())).getModel();
                }
            }
        }
    }

    protected PaletteRoot getPaletteRoot() {
        return ServiceInterfacePaletteFactory.createPalette();
    }

    public void doSave(IProgressMonitor monitor) {
    }

    public boolean outlineSelectionChanged(Object selectedElement) {
        if (selectedElement != null) {
            Object editpart = this.getGraphicalViewer().getEditPartRegistry().get(selectedElement);
            this.getGraphicalViewer().flush();
            if (editpart instanceof EditPart && ((EditPart)editpart).isSelectable()) {
                this.getGraphicalViewer().select((EditPart)editpart);
                return true;
            }
            if (selectedElement instanceof Service) {
                return true;
            }
        }
        return false;
    }

    public void setCommonCommandStack(CommandStack commandStack) {
        this.commandStack = commandStack;
    }

    public void gotoMarker(IMarker marker) {
    }

    public boolean isMarkerTarget(IMarker marker) {
        return false;
    }

    public void reloadType(FBType type) {
        this.fbType = type;
        this.getGraphicalViewer().setContents((Object)this.fbType);
    }

    public Object getModel() {
        return this.fbType;
    }

    protected EditPartFactory getEditPartFactory() {
        return new ServiceSequenceEditPartFactory((GraphicalEditor)this);
    }

    protected ContextMenuProvider getContextMenuProvider(ScrollingGraphicalViewer viewer, ZoomManager zoomManager) {
        return new FordiacContextMenuProvider((EditPartViewer)viewer, zoomManager, this.getActionRegistry()){

            public void buildContextMenu(IMenuManager menu) {
                super.buildContextMenu(menu);
                IAction action = this.getRegistry().getAction((Object)ActionFactory.DELETE.getId());
                menu.appendToGroup("org.eclipse.gef.group.copy", action);
            }
        };
    }

    protected ScalableFreeformRootEditPart createRootEditPart() {
        return new ZoomScalableFreeformRootEditPart(this.getSite(), this.getActionRegistry()){

            protected AbstractFreeformFigure createDrawingAreaContainer() {
                return new ModuloFreeformFigure((ZoomScalableFreeformRootEditPart)this, false);
            }
        };
    }

    protected Point getInitialScrollPos() {
        FreeformGraphicalRootEditPart rootEditPart = (FreeformGraphicalRootEditPart)this.getGraphicalViewer().getRootEditPart();
        FreeformViewport rootviewPort = (FreeformViewport)rootEditPart.getFigure();
        return new Point(ServiceSequenceEditor.calculateTopLeftScrollPosition(rootviewPort.getHorizontalRangeModel()), ServiceSequenceEditor.calculateTopLeftScrollPosition(rootviewPort.getVerticalRangeModel()));
    }

    private static int calculateTopLeftScrollPosition(RangeModel rangeModel) {
        return rangeModel.getExtent();
    }

    protected TransferDropTargetListener createTransferDropTargetListener() {
        return null;
    }

    public AutomationSystem getSystem() {
        return null;
    }

    public void doSaveAs() {
    }

    public Object getSelectableEditPart() {
        if (this.getGraphicalViewer() == null) {
            return null;
        }
        return this.getGraphicalViewer().getRootEditPart();
    }
}

