/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.fmu.wizard;

import org.eclipse.fordiac.ide.deployment.ui.wizard.CreateBootFilesWizardPage;
import org.eclipse.fordiac.ide.fmu.Activator;
import org.eclipse.fordiac.ide.fmu.Messages;
import org.eclipse.fordiac.ide.fmu.preferences.FMUPreferencePage;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;

public class CreateFMUWizardPage
extends CreateBootFilesWizardPage {
    private Button win32Field = null;
    private Button win64Field;
    private Button linux32Field;
    private Button linux64Field;
    private Button storeSelectedLibaries;

    public Button getWin32Field() {
        return this.win32Field;
    }

    public Button getWin64Field() {
        return this.win64Field;
    }

    public Button getLinux32Field() {
        return this.linux32Field;
    }

    public Button getLinux64Field() {
        return this.linux64Field;
    }

    public Button getStoreSelectedLibaries() {
        return this.storeSelectedLibaries;
    }

    public CreateFMUWizardPage(IStructuredSelection selection) {
        super(Messages.FordiacCreateFMUWizard_PageName, selection);
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        this.setDescription(Messages.FordiacCreateFMUWizard_PageDESCRIPTION);
        this.setTitle(Messages.FordiacCreateFMUWizard_PageTITLE);
    }

    protected void createOptionsGroup(Composite parent) {
        Group librariesGroup = new Group(parent, 0);
        librariesGroup.setText(Messages.CreateFMUWizardPage_IncludeTheFollowingLibrariesInExportedFMU);
        GridLayout gridLayout = new GridLayout(1, false);
        GridData gridData = new GridData(768);
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 1;
        this.win32Field = new Button((Composite)librariesGroup, 32);
        this.win64Field = new Button((Composite)librariesGroup, 32);
        this.linux32Field = new Button((Composite)librariesGroup, 32);
        this.linux64Field = new Button((Composite)librariesGroup, 32);
        this.storeSelectedLibaries = new Button((Composite)librariesGroup, 32);
        Button[] buttons = new Button[]{this.win32Field, this.win64Field, this.linux32Field, this.linux64Field, this.storeSelectedLibaries};
        String[] preferences = new String[]{"win32", "win64", "linux32", "linux64", Messages.CreateFMUWizardPage_SaveSelectedLibrariesForFutureFMUExports};
        int i = 0;
        while (i < buttons.length) {
            buttons[i].setText(preferences[i]);
            buttons[i].setEnabled(false);
            buttons[i].setSelection(false);
            ++i;
        }
        this.storeSelectedLibaries.setEnabled(true);
        for (String found : FMUPreferencePage.getFoundLibraries()) {
            if (found.equals("win32")) {
                this.win32Field.setEnabled(true);
                continue;
            }
            if (found.equals("win64")) {
                this.win64Field.setEnabled(true);
                continue;
            }
            if (found.equals("linux32")) {
                this.linux32Field.setEnabled(true);
                continue;
            }
            if (!found.equals("linux64")) continue;
            this.linux64Field.setEnabled(true);
        }
        i = 0;
        while (i < buttons.length) {
            buttons[i].setSelection(Activator.getDefault().getPreferenceStore().getBoolean(preferences[i]));
            buttons[i].addListener(13, e -> this.updatePageCompletion());
            ++i;
        }
        librariesGroup.setLayoutData((Object)gridData);
        librariesGroup.setLayout((Layout)gridLayout);
    }

    protected boolean validateOptionsGroup() {
        if (!this.isSomeLibrarySelected()) {
            this.setErrorMessage(Messages.CreateFMUWizardPage_NoLibrariesSelectedToInclude);
            return false;
        }
        this.setErrorMessage(null);
        return super.validateOptionsGroup();
    }

    private boolean isSomeLibrarySelected() {
        return CreateFMUWizardPage.isSelected(this.win32Field) || CreateFMUWizardPage.isSelected(this.win64Field) || CreateFMUWizardPage.isSelected(this.linux32Field) || CreateFMUWizardPage.isSelected(this.linux64Field);
    }

    private static boolean isSelected(Button toCheck) {
        return toCheck.isEnabled() && toCheck.getSelection();
    }
}

