/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.fix;

import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.rewrite.ImportRewrite;
import org.eclipse.jdt.core.refactoring.CompilationUnitChange;
import org.eclipse.jdt.internal.corext.codemanipulation.ContextSensitiveImportRewriteContext;
import org.eclipse.jdt.internal.corext.fix.AbstractFix;
import org.eclipse.jdt.internal.corext.fix.FixMessages;
import org.eclipse.jdt.internal.corext.fix.LinkedProposalModelCore;
import org.eclipse.jdt.internal.corext.fix.Messages;
import org.eclipse.jdt.internal.corext.refactoring.structure.CompilationUnitRewrite;
import org.eclipse.ltk.core.refactoring.GroupCategory;
import org.eclipse.ltk.core.refactoring.GroupCategorySet;
import org.eclipse.text.edits.TextEditGroup;

public class CompilationUnitRewriteOperationsFixCore
extends AbstractFix {
    private final CompilationUnitRewriteOperation[] fOperations;
    private final CompilationUnit fCompilationUnit;
    protected LinkedProposalModelCore fLinkedProposalModel;

    public CompilationUnitRewriteOperationsFixCore(String name, CompilationUnit compilationUnit, CompilationUnitRewriteOperation operation) {
        this(name, compilationUnit, new CompilationUnitRewriteOperation[]{operation});
        Assert.isNotNull((Object)operation);
    }

    public CompilationUnitRewriteOperationsFixCore(String name, CompilationUnit compilationUnit, CompilationUnitRewriteOperation[] operations) {
        super(name);
        Assert.isNotNull((Object)operations);
        Assert.isLegal((operations.length > 0 ? 1 : 0) != 0);
        this.fCompilationUnit = compilationUnit;
        this.fOperations = operations;
        this.fLinkedProposalModel = new LinkedProposalModelCore();
    }

    @Override
    public LinkedProposalModelCore getLinkedPositionsCore() {
        if (!this.fLinkedProposalModel.hasLinkedPositions()) {
            return null;
        }
        return this.fLinkedProposalModel;
    }

    @Override
    public CompilationUnitChange createChange(IProgressMonitor progressMonitor) throws CoreException {
        CompilationUnitRewrite cuRewrite = new CompilationUnitRewrite((ICompilationUnit)this.fCompilationUnit.getJavaElement(), this.fCompilationUnit);
        this.fLinkedProposalModel.clear();
        CompilationUnitRewriteOperation[] compilationUnitRewriteOperationArray = this.fOperations;
        int n = this.fOperations.length;
        int n2 = 0;
        while (n2 < n) {
            CompilationUnitRewriteOperation operation = compilationUnitRewriteOperationArray[n2];
            operation.rewriteAST(cuRewrite, this.fLinkedProposalModel);
            ++n2;
        }
        CompilationUnitChange result = cuRewrite.createChange(this.getDisplayString(), true, null);
        if (result == null) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.jdt.core.manipulation", Messages.format(FixMessages.CompilationUnitRewriteOperationsFix_nullChangeError, this.getDisplayString())));
        }
        return result;
    }

    @Override
    public String getAdditionalProposalInfo() {
        StringBuilder sb = new StringBuilder();
        CompilationUnitRewriteOperation[] compilationUnitRewriteOperationArray = this.fOperations;
        int n = this.fOperations.length;
        int n2 = 0;
        while (n2 < n) {
            CompilationUnitRewriteOperation operation = compilationUnitRewriteOperationArray[n2];
            String info = operation.getAdditionalInfo();
            if (info != null) {
                sb.append(info);
            }
            ++n2;
        }
        if (sb.length() == 0) {
            return null;
        }
        return sb.toString();
    }

    public static abstract class CompilationUnitRewriteOperation {
        public abstract void rewriteAST(CompilationUnitRewrite var1, LinkedProposalModelCore var2) throws CoreException;

        protected Type importType(ITypeBinding toImport, ASTNode accessor, ImportRewrite imports, CompilationUnit compilationUnit, ImportRewrite.TypeLocation location) {
            ContextSensitiveImportRewriteContext importContext = new ContextSensitiveImportRewriteContext(compilationUnit, accessor.getStartPosition(), imports);
            return imports.addImport(toImport, compilationUnit.getAST(), (ImportRewrite.ImportRewriteContext)importContext, location);
        }

        protected TextEditGroup createTextEditGroup(String label, CompilationUnitRewrite rewrite) {
            if (label.length() > 0) {
                return rewrite.createCategorizedGroupDescription(label, new GroupCategorySet(new GroupCategory(label, label, label)));
            }
            return rewrite.createGroupDescription(label);
        }

        public String getAdditionalInfo() {
            return null;
        }
    }
}

