/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.metrics.view;

import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.fordiac.ide.metrics.Messages;
import org.eclipse.fordiac.ide.metrics.analyzers.AbstractCodeMetricAnalyzer;
import org.eclipse.fordiac.ide.metrics.analyzers.MetricResult;
import org.eclipse.fordiac.ide.metrics.analyzers.SpiderChartBFBMeasures;
import org.eclipse.fordiac.ide.model.libraryElement.BasicFBType;
import org.eclipse.fordiac.ide.model.libraryElement.FBType;
import org.eclipse.fordiac.ide.model.libraryElement.INamedElement;
import org.eclipse.fordiac.ide.ui.widget.TableWidgetFactory;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.part.ViewPart;

public class MetricsView
extends ViewPart {
    TableViewer viewer;
    Label currentBlock;
    IPartListener2 pl;
    IWorkbenchPage page;
    private final List<MetricResult> data = new ArrayList<MetricResult>();

    private static void calculateMetrics(INamedElement element, List<MetricResult> result) {
        SpiderChartBFBMeasures analyzer = new SpiderChartBFBMeasures();
        analyzer.calculateMetrics(element);
        result.addAll(((AbstractCodeMetricAnalyzer)analyzer).getResults());
    }

    public void createPartControl(Composite parent) {
        parent.setLayout((Layout)new GridLayout(2, true));
        parent.setLayoutData((Object)new GridData(4, 4, true, true));
        FormToolkit toolkit = new FormToolkit(parent.getDisplay());
        Composite composite = toolkit.createComposite(parent);
        composite.setLayout((Layout)new GridLayout(1, true));
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        this.createSCBFBSection(composite, toolkit);
    }

    private void createSCBFBSection(Composite parent, FormToolkit toolkit) {
        final Composite composite = toolkit.createComposite(parent);
        composite.setLayout((Layout)new GridLayout(2, false));
        composite.setLayoutData((Object)new GridData(4, 4, false, false));
        toolkit.createLabel(composite, Messages.SpiderChartBFBMeasuresOf);
        this.currentBlock = toolkit.createLabel(composite, null);
        this.updateMetrics();
        final Composite tableComposite = toolkit.createComposite(parent);
        tableComposite.setLayout((Layout)new GridLayout(1, false));
        tableComposite.setLayoutData((Object)new GridData(4, 4, false, true));
        this.viewer = TableWidgetFactory.createPropertyTableViewer((Composite)tableComposite, (int)2066);
        GridDataFactory.fillDefaults().align(4, 1).grab(true, true).applyTo((Control)this.viewer.getTable());
        MetricsView.configureTableColumns(this.viewer.getTable());
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new MetricsResultLabelProvider());
        this.viewer.setInput(this.data);
        this.viewer.getTable().getVerticalBar().setVisible(false);
        this.page = this.getSite().getPage();
        this.pl = new IPartListener2(){

            public void partActivated(IWorkbenchPartReference ref) {
                MetricsView.this.updateMetrics();
                MetricsView.this.viewer.setInput(MetricsView.this.data);
                composite.pack();
                tableComposite.pack();
            }
        };
        this.page.addPartListener(this.pl);
    }

    protected void updateMetrics() {
        this.data.clear();
        IEditorPart activeEditor = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
        FBType type = (FBType)activeEditor.getAdapter(FBType.class);
        if (type instanceof BasicFBType) {
            this.currentBlock.setText(type.getName());
            MetricsView.calculateMetrics((INamedElement)type, this.data);
        }
        if (this.data.isEmpty()) {
            this.currentBlock.setText(Messages.SpiderChartBFBError);
        }
    }

    private static void configureTableColumns(Table table) {
        new TableColumn(table, 16384).setText(Messages.Measure);
        new TableColumn(table, 131072).setText(Messages.Value);
        TableLayout layout = new TableLayout();
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(65, 100));
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(35, 30));
        table.setLayout((Layout)layout);
        table.setVisible(true);
        table.setLinesVisible(true);
        table.setHeaderVisible(true);
    }

    public void setFocus() {
    }

    public void dispose() {
        this.page.removePartListener(this.pl);
        super.dispose();
    }

    public static class MetricsResultLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        private static final DecimalFormat decimalFormat = new DecimalFormat("#0.00");

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            if (element instanceof MetricResult) {
                switch (columnIndex) {
                    case 0: {
                        return ((MetricResult)element).getName();
                    }
                    case 1: {
                        return decimalFormat.format(((MetricResult)element).getValue());
                    }
                }
            }
            return element.toString();
        }
    }
}

