/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.metrics.analyzers;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.fordiac.ide.metrics.Messages;
import org.eclipse.fordiac.ide.metrics.analyzers.AbstractCodeMetricAnalyzer;
import org.eclipse.fordiac.ide.metrics.analyzers.MetricData;
import org.eclipse.fordiac.ide.metrics.analyzers.MetricResult;
import org.eclipse.fordiac.ide.metrics.analyzers.SpiderChartBFBData;
import org.eclipse.fordiac.ide.model.libraryElement.Algorithm;
import org.eclipse.fordiac.ide.model.libraryElement.BasicFBType;
import org.eclipse.fordiac.ide.model.libraryElement.ECAction;
import org.eclipse.fordiac.ide.model.libraryElement.ECC;
import org.eclipse.fordiac.ide.model.libraryElement.ECState;
import org.eclipse.fordiac.ide.model.libraryElement.InterfaceList;

public class SpiderChartBFBMeasures
extends AbstractCodeMetricAnalyzer {
    static final String[] CONDITIONS = new String[]{"IF", "FOR", "WHILE", "REPEAT"};

    @Override
    public List<MetricResult> getResults() {
        ArrayList<MetricResult> results = new ArrayList<MetricResult>();
        SpiderChartBFBData scData = (SpiderChartBFBData)this.data;
        results.add(new MetricResult(Messages.NumberOfStates, scData.states));
        results.add(new MetricResult(Messages.NumberOfTransitions, scData.transitions));
        results.add(new MetricResult(Messages.AlgorithmLOC, scData.loc));
        results.add(new MetricResult(Messages.NumberOfActions, scData.actions));
        results.add(new MetricResult(Messages.NumberOfInternalVars, scData.internalVar));
        results.add(new MetricResult(Messages.NumberOfIndependentPaths, scData.independentPaths));
        results.add(new MetricResult(Messages.NumberOfInterfaceElements, scData.interfaceEl));
        return results;
    }

    @Override
    protected MetricData analyzeBFB(BasicFBType basicFBType) {
        SpiderChartBFBData data = new SpiderChartBFBData();
        ECC ecc = basicFBType.getECC();
        data.states = ecc.getECState().size();
        data.independentPaths = ecc.getECTransition().size() - ecc.getECState().size() + 2;
        for (Algorithm alg : basicFBType.getAlgorithm()) {
            data.loc += this.calculateLOC(alg.toString());
        }
        data.internalVar = basicFBType.getInternalVars().size();
        data.interfaceEl += this.countInterfaceElements(basicFBType.getInterfaceList());
        for (ECState state : ecc.getECState()) {
            for (ECAction action : state.getECAction()) {
                data.actions += state.getECAction().size();
                if (action.getAlgorithm() == null) continue;
                data.independentPaths = (int)((double)data.independentPaths + SpiderChartBFBMeasures.analyzeAlgorithm(action.getAlgorithm()));
            }
        }
        return data;
    }

    protected int countInterfaceElements(InterfaceList interfaceList) {
        int count = 0;
        int[] adpCount = new int[1];
        count += interfaceList.getInputVars().size();
        count += interfaceList.getOutputVars().size();
        count += interfaceList.getEventInputs().size();
        count += interfaceList.getEventOutputs().size();
        interfaceList.getPlugs().forEach(plug -> {
            int n = adpCount[0] + this.countInterfaceElements(plug.getType().getInterfaceList());
        });
        interfaceList.getSockets().forEach(socket -> {
            int n = adpCount[0] + this.countInterfaceElements(socket.getType().getInterfaceList());
        });
        return count += adpCount[0];
    }

    protected int calculateLOC(String algString) {
        int loc = 0;
        int indStart = algString.indexOf("text:");
        int indEnd = algString.lastIndexOf(41);
        String trimmedAlgString = algString.substring(indStart, indEnd);
        String[] lines = trimmedAlgString.split("\\r?\\n");
        boolean isComment = false;
        String[] stringArray = lines;
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            if (!s.isEmpty()) {
                int indCommentStart1 = s.trim().indexOf("(*");
                int indCommentStart2 = s.trim().indexOf("/*");
                if (indCommentStart1 > 0 || indCommentStart2 > 0) {
                    isComment = true;
                    ++loc;
                } else if (indCommentStart1 == 0 || indCommentStart2 == 0) {
                    isComment = true;
                } else if (!isComment && !s.trim().startsWith("//")) {
                    ++loc;
                }
                int indCommentEnd1 = s.trim().indexOf("*)");
                int indCommentEnd2 = s.trim().indexOf("*/");
                if (isComment && (indCommentEnd1 != -1 || indCommentEnd2 != -1)) {
                    isComment = false;
                    if (indCommentEnd1 < s.trim().length() - 2 && indCommentEnd1 != -1 || indCommentEnd2 < s.trim().length() - 2 && indCommentEnd2 != -1) {
                        ++loc;
                    }
                }
            }
            ++n2;
        }
        return loc;
    }

    private static double analyzeAlgorithm(Algorithm algorithm) {
        double ccAlg = 0.0;
        String algText = algorithm.toString();
        int saveIndex = 0;
        String[] stringArray = CONDITIONS;
        int n = CONDITIONS.length;
        int n2 = 0;
        while (n2 < n) {
            String cond = stringArray[n2];
            int lastIndex = 0;
            while (-1 != lastIndex) {
                saveIndex = cond.equals("REPEAT") ? algText.indexOf(String.valueOf(cond) + "\\r?\\n", lastIndex) : algText.indexOf(String.valueOf(cond) + " ", lastIndex);
                if (saveIndex == 0 || -1 == (lastIndex = saveIndex)) continue;
                ccAlg += 1.0;
                lastIndex += cond.length();
            }
            ++n2;
        }
        return ccAlg;
    }

    @Override
    protected MetricData createDataType() {
        return new SpiderChartBFBData();
    }
}

