/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.fbtypeeditor.fbtester.configuration;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.StringReader;
import java.net.InetAddress;
import java.net.Socket;
import java.text.MessageFormat;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.xmi.impl.XMLResourceImpl;
import org.eclipse.fordiac.ide.deployment.devResponse.Data;
import org.eclipse.fordiac.ide.deployment.devResponse.FB;
import org.eclipse.fordiac.ide.deployment.devResponse.Port;
import org.eclipse.fordiac.ide.deployment.devResponse.Resource;
import org.eclipse.fordiac.ide.deployment.devResponse.Response;
import org.eclipse.fordiac.ide.deployment.iec61499.ResponseMapping;
import org.eclipse.fordiac.ide.fbtester.model.testdata.ValuedVarDecl;
import org.eclipse.fordiac.ide.fbtypeeditor.fbtester.Activator;
import org.eclipse.fordiac.ide.fbtypeeditor.fbtester.IFBTestConfiguration;
import org.eclipse.fordiac.ide.fbtypeeditor.fbtester.IFBTestConfiguratonCreator;
import org.eclipse.fordiac.ide.fbtypeeditor.fbtester.Messages;
import org.eclipse.fordiac.ide.fbtypeeditor.fbtester.TestingManager;
import org.eclipse.fordiac.ide.fbtypeeditor.fbtester.configuration.internal.Utils;
import org.eclipse.fordiac.ide.fbtypeeditor.fbtester.model.TestElement;
import org.eclipse.fordiac.ide.model.libraryElement.Event;
import org.eclipse.fordiac.ide.model.libraryElement.FBType;
import org.eclipse.fordiac.ide.model.libraryElement.VarDeclaration;
import org.eclipse.fordiac.ide.ui.imageprovider.FordiacImage;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Text;
import org.xml.sax.InputSource;

public class FORTERemoteTester
implements IFBTestConfiguratonCreator {
    private static final String LAST_IP = "lastIp";
    private static final String FORTE_REMOTE_TESTER_SETTINGS = "FORTE_REMOTE_TESTER_SETTINGS";
    private Button run;
    private FBType type;
    private boolean running;
    private Socket socket;
    private IDialogSettings forteRemoteTesterSettings;
    private Text ipText;
    private Text runTimePortText;
    private final ResponseMapping data = new ResponseMapping();
    private Map<String, TestElement> testElements;

    public FORTERemoteTester() {
        IDialogSettings settings = Activator.getDefault().getDialogSettings();
        this.forteRemoteTesterSettings = settings.getSection(FORTE_REMOTE_TESTER_SETTINGS);
        if (this.forteRemoteTesterSettings == null) {
            this.forteRemoteTesterSettings = settings.addNewSection(FORTE_REMOTE_TESTER_SETTINGS);
        }
    }

    public boolean isRunning() {
        return this.running;
    }

    public void setRunning(boolean running) {
        this.running = running;
        if (running) {
            this.run.setText(Messages.FORTERemoteTester_StopTestingFB);
            this.run.setImage(FordiacImage.ICON_STOP.getImage());
        } else {
            this.run.setText(Messages.FORTERemoteTester_StartTestingFB);
            this.run.setImage(FordiacImage.ICON_START.getImage());
        }
    }

    @Override
    public IFBTestConfiguration createConfigurationPage(Composite parent) {
        final Composite main = new Composite(parent, 0);
        GridLayout gl = new GridLayout(6, false);
        main.setLayout((Layout)gl);
        Label ipLabel = new Label(main, 0);
        ipLabel.setText(Messages.FORTERemoteTester_IPAddress);
        this.ipText = new Text(main, 2048);
        this.ipText.setText("127.0.0.1");
        Label runTimeLabel = new Label(main, 0);
        runTimeLabel.setText(Messages.FORTERemoteTester_RuntimePort);
        this.runTimePortText = new Text(main, 2048);
        this.runTimePortText.setText("61499");
        this.run = new Button(main, 2);
        this.run.setEnabled(true);
        this.setRunning(false);
        this.run.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                int runtimePort = Integer.parseInt(FORTERemoteTester.this.runTimePortText.getText());
                if (FORTERemoteTester.this.run.getSelection()) {
                    String ipAddress = FORTERemoteTester.this.ipText.getText();
                    FORTERemoteTester.this.forteRemoteTesterSettings.put(FORTERemoteTester.LAST_IP, ipAddress);
                    String response = Utils.deployNetwork(FORTERemoteTester.this.type, FORTERemoteTester.this.ipText.getText(), runtimePort);
                    if (response != null) {
                        MessageBox msb = new MessageBox(Display.getCurrent().getActiveShell(), 1);
                        msb.setMessage(MessageFormat.format(Messages.FORTERemoteTester_FBCanNotBeTestedBecauseOfTheFollowingError, response));
                        msb.open();
                        FORTERemoteTester.this.setRunning(false);
                        FORTERemoteTester.this.run.setSelection(false);
                        return;
                    }
                    try {
                        FORTERemoteTester.this.socket = new Socket(InetAddress.getByName(ipAddress), runtimePort);
                        FORTERemoteTester.this.socket.setSoTimeout(500);
                        FORTERemoteTester.this.addWatches("_" + FORTERemoteTester.this.type.getName());
                        FORTERemoteTester.this.setRunning(true);
                        Thread t = new Thread(new TriggerRequestRunnable(FORTERemoteTester.this.socket, 0));
                        t.start();
                        Thread.sleep(500L);
                    }
                    catch (IOException e1) {
                        Activator.getDefault().logError(e1.getMessage(), e1);
                    }
                    catch (InterruptedException ex) {
                        Thread.currentThread().interrupt();
                        Activator.getDefault().logError(Messages.FORTERemoteTester_ThreadInterrupted, ex);
                    }
                } else {
                    FORTERemoteTester.this.setRunning(false);
                    String response = Utils.cleanNetwork(FORTERemoteTester.this.type, FORTERemoteTester.this.ipText.getText(), runtimePort, FORTERemoteTester.this.socket);
                    if (response != null) {
                        MessageBox msb = new MessageBox(Display.getCurrent().getActiveShell(), 1);
                        msb.setMessage(MessageFormat.format(Messages.FORTERemoteTester_FBCanNotBeCleanedBecauseOfTheFollowingError, response));
                        msb.open();
                    }
                    try {
                        FORTERemoteTester.this.socket.close();
                        FORTERemoteTester.this.socket = null;
                    }
                    catch (IOException e1) {
                        Activator.getDefault().logError(e1.getMessage(), e1);
                    }
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        IFBTestConfiguration configuration = new IFBTestConfiguration(){

            @Override
            public Control getControl() {
                return main;
            }

            @Override
            public void newTestConf(List<TestElement> variables, List<String> values, List<ValuedVarDecl> resultVars, Map<String, Object> params) {
            }
        };
        this.loadLastIp();
        return configuration;
    }

    private void loadLastIp() {
        String lastIp;
        if (this.forteRemoteTesterSettings != null && (lastIp = this.forteRemoteTesterSettings.get(LAST_IP)) != null) {
            this.ipText.setText(lastIp);
            this.run.setEnabled(true);
        }
    }

    private void addWatches(String fbName) {
        this.testElements = TestingManager.getInstance().getTestElements(this.type, this, this);
        for (TestElement element : this.testElements.values()) {
            if (element.getFBString().equals(fbName)) {
                DataOutputStream outputStream = null;
                DataInputStream inputStream = null;
                try {
                    outputStream = new DataOutputStream(new BufferedOutputStream(this.socket.getOutputStream()));
                    inputStream = new DataInputStream(new BufferedInputStream(this.socket.getInputStream()));
                    if (element.getInterfaceElement() instanceof VarDeclaration) {
                        this.addWatch(element, outputStream, inputStream);
                    }
                    if (!(element.getInterfaceElement() instanceof Event) || element.getInterfaceElement().isIsInput()) continue;
                    this.addWatch(element, outputStream, inputStream);
                }
                catch (IOException e1) {
                    Activator.getDefault().logError(e1.getMessage(), e1);
                }
                continue;
            }
            Activator.getDefault().logInfo(MessageFormat.format(Messages.FORTERemoteTester_ElementSkipped, element.getFBString()));
        }
    }

    private void addWatch(TestElement element, DataOutputStream outputStream, DataInputStream inputStream) {
        if (outputStream != null && inputStream != null) {
            String request = MessageFormat.format("<Request ID=\"{0}\" Action=\"CREATE\"><Watch Source=\"{1}\" Destination=\"{2}\" /></Request>", 0, String.valueOf(element.getFBString()) + "." + element.getPortString(), "*");
            this.sendRequest(SendType.ADD_WATCH, element.getResourceString(), request, outputStream, inputStream);
        }
    }

    private synchronized void sendRequest(SendType type, String destination, String request, DataOutputStream outputStream, DataInputStream inputStream) {
        try {
            if (this.socket.isConnected()) {
                outputStream.writeByte(80);
                outputStream.writeShort(destination.length());
                outputStream.writeBytes(destination);
                outputStream.writeByte(80);
                outputStream.writeShort(request.length());
                outputStream.writeBytes(request);
                outputStream.flush();
                if (type.equals((Object)SendType.REQ)) {
                    String response = FORTERemoteTester.parseResponse(inputStream);
                    if (!response.equals("")) {
                        XMLResourceImpl resource = new XMLResourceImpl();
                        InputSource source = new InputSource(new StringReader(response));
                        resource.load(source, this.data.getLoadOptions());
                        for (EObject object : resource.getContents()) {
                            Response resp;
                            if (!(object instanceof Response) || (resp = (Response)object).getWatches() == null) continue;
                            for (Resource res : resp.getWatches().getResources()) {
                                for (FB fb : res.getFbs()) {
                                    for (Port p : fb.getPorts()) {
                                        for (Data d : p.getDataValues()) {
                                            TestElement element = this.testElements.get(String.valueOf(res.getName()) + "." + fb.getName() + "." + p.getName());
                                            if (element == null) continue;
                                            element.updateValue(d.getValue(), 0);
                                        }
                                    }
                                }
                            }
                        }
                    }
                } else if (type.equals((Object)SendType.ADD_WATCH)) {
                    inputStream.available();
                    inputStream.read();
                } else if (!type.equals((Object)SendType.TRIGGER_EVENT) && !type.equals((Object)SendType.REMOVE_WATCH) && !type.equals((Object)SendType.START_EVENT_COUNT) && type.equals((Object)SendType.FORCE_VALUE)) {
                    String forceResp = FORTERemoteTester.parseResponse(inputStream);
                    Activator.getDefault().logInfo(MessageFormat.format(Messages.FORTERemoteTester_ForceResponse, forceResp));
                }
            }
        }
        catch (Exception e) {
            Activator.getDefault().logError(e.getMessage(), e);
        }
    }

    private static String parseResponse(DataInputStream inputStream) throws IOException {
        StringBuilder response = new StringBuilder();
        inputStream.readByte();
        int size = inputStream.readShort();
        int i = 0;
        while (i < size) {
            response.append((char)inputStream.readByte());
            ++i;
        }
        return response.toString();
    }

    public void setValue(TestElement element) {
        if (this.isRunning()) {
            DataOutputStream outputStream = null;
            DataInputStream inputStream = null;
            try {
                outputStream = new DataOutputStream(new BufferedOutputStream(this.socket.getOutputStream()));
                inputStream = new DataInputStream(new BufferedInputStream(this.socket.getInputStream()));
                String request = MessageFormat.format("<Request ID=\"{0}\" Action=\"WRITE\"><Connection Source=\"{1}\" Destination=\"{2}\" force=\"{3}\" /></Request>", 0, element.getValue(), String.valueOf(element.getFBString()) + "." + element.getPortString(), "true");
                this.sendRequest(SendType.FORCE_VALUE, element.getResourceString(), request, outputStream, inputStream);
            }
            catch (IOException e) {
                Activator.getDefault().logError(e.getMessage(), e);
            }
        }
    }

    @Override
    public void sendEvent(TestElement element) {
        if (this.isRunning()) {
            DataOutputStream outputStream = null;
            DataInputStream inputStream = null;
            try {
                outputStream = new DataOutputStream(new BufferedOutputStream(this.socket.getOutputStream()));
                inputStream = new DataInputStream(new BufferedInputStream(this.socket.getInputStream()));
                if (element != null) {
                    String request = MessageFormat.format("<Request ID=\"{0}\" Action=\"WRITE\"><Connection Source=\"{1}\" Destination=\"{2}\" /></Request>", 0, "$e", String.valueOf(element.getFBString()) + "." + element.getPortString());
                    this.sendRequest(SendType.TRIGGER_EVENT, element.getResourceString(), request, outputStream, inputStream);
                }
            }
            catch (IOException e) {
                Activator.getDefault().logError(e.getMessage(), e);
            }
        }
    }

    @Override
    public void setType(FBType type) {
        this.type = type;
    }

    @Override
    public void setValue(TestElement element, String value) {
        this.setValue(element);
    }

    private static enum SendType {
        REQ,
        ADD_WATCH,
        REMOVE_WATCH,
        TRIGGER_EVENT,
        START_EVENT_COUNT,
        FORCE_VALUE;

    }

    class TriggerRequestRunnable
    implements Runnable {
        private final Socket socket;
        private int i = 0;

        public TriggerRequestRunnable(Socket socket, int thread) {
            this.socket = socket;
        }

        @Override
        public void run() {
            DataOutputStream outputStream = null;
            DataInputStream inputStream = null;
            try {
                outputStream = new DataOutputStream(new BufferedOutputStream(this.socket.getOutputStream()));
                inputStream = new DataInputStream(new BufferedInputStream(this.socket.getInputStream()));
            }
            catch (IOException iOException) {
                FORTERemoteTester.this.setRunning(false);
            }
            while (FORTERemoteTester.this.running) {
                ++this.i;
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException interruptedException) {
                    Thread.currentThread().interrupt();
                    FORTERemoteTester.this.setRunning(false);
                }
                String request = MessageFormat.format("<Request ID=\"{0}\" Action=\"READ\"><Watches/></Request>", this.i);
                if (!FORTERemoteTester.this.running) continue;
                FORTERemoteTester.this.sendRequest(SendType.REQ, "", request, outputStream, inputStream);
            }
        }
    }
}

