/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.fbtypeeditor.fbtester;

import org.eclipse.fordiac.ide.fbtester.model.testdata.TestData;
import org.eclipse.fordiac.ide.model.libraryElement.VarDeclaration;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.TableColumn;

public class TestDataEditingSupport
extends EditingSupport {
    private final TableColumn col;

    public TestDataEditingSupport(ColumnViewer viewer, TableColumn column) {
        super(viewer);
        this.col = column;
    }

    protected boolean canEdit(Object element) {
        if (this.col.getData("ColumnType").equals("Name")) {
            return true;
        }
        if (this.col.getData("ColumnType").equals("InputVariable")) {
            return true;
        }
        return this.col.getData("ColumnType").equals("OutputVariable");
    }

    protected CellEditor getCellEditor(Object element) {
        if (this.col.getData("ColumnType").equals("Name") || this.col.getData("ColumnType").equals("InputVariable") || this.col.getData("ColumnType").equals("OutputVariable")) {
            return new TextCellEditor((Composite)((TableViewer)this.getViewer()).getTable());
        }
        return null;
    }

    protected Object getValue(Object element) {
        Object obj;
        if (this.col.getData("ColumnType").equals("Name")) {
            return ((TestData)element).getTestName();
        }
        if (this.col.getData("ColumnType").equals("InputVariable")) {
            Object obj2 = this.col.getData("InputVariable");
            if (obj2 instanceof VarDeclaration) {
                return ((TestData)element).getValueFor(((VarDeclaration)obj2).getName());
            }
        } else if (this.col.getData("ColumnType").equals("OutputVariable") && (obj = this.col.getData("OutputVariable")) instanceof VarDeclaration) {
            return ((TestData)element).getResultFor(((VarDeclaration)obj).getName());
        }
        return null;
    }

    protected void setValue(Object element, Object value) {
        Object obj;
        if (this.col.getData("ColumnType").equals("InputVariable") && (obj = this.col.getData("InputVariable")) instanceof VarDeclaration) {
            ((TestData)element).setValueFor(((VarDeclaration)obj).getName(), value.toString());
            this.getViewer().refresh();
            return;
        }
        if (this.col.getData("ColumnType").equals("OutputVariable") && (obj = this.col.getData("OutputVariable")) instanceof VarDeclaration) {
            ((TestData)element).setResultFor(((VarDeclaration)obj).getName(), value.toString());
            this.getViewer().refresh();
            return;
        }
        if (value instanceof String && !"".equals(value)) {
            ((TestData)element).setTestName(value.toString());
        }
    }
}

