/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.fbtypeeditor.ecc.properties;

import org.eclipse.fordiac.ide.fbtypeeditor.ecc.commands.DeleteAlgorithmCommand;
import org.eclipse.fordiac.ide.fbtypeeditor.ecc.properties.AlgorithmGroup;
import org.eclipse.fordiac.ide.fbtypeeditor.ecc.properties.AlgorithmList;
import org.eclipse.fordiac.ide.fbtypeeditor.ecc.properties.ECCSection;
import org.eclipse.fordiac.ide.gef.properties.AbstractSection;
import org.eclipse.fordiac.ide.model.commands.insert.InsertAlgorithmCommand;
import org.eclipse.fordiac.ide.model.libraryElement.Algorithm;
import org.eclipse.fordiac.ide.model.libraryElement.BaseFBType;
import org.eclipse.fordiac.ide.model.libraryElement.BasicFBType;
import org.eclipse.fordiac.ide.ui.widget.I4diacTableUtil;
import org.eclipse.fordiac.ide.ui.widget.TableWidgetFactory;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;

public class AlgorithmsSection
extends AbstractSection
implements I4diacTableUtil {
    private final AlgorithmGroup algorithmGroup = new AlgorithmGroup();
    private AlgorithmList algorithmList;

    protected BasicFBType getType() {
        return (BasicFBType)this.type;
    }

    protected Object getInputType(Object input) {
        return ECCSection.getECCInputType(input);
    }

    public void createControls(Composite parent, TabbedPropertySheetPage tabbedPropertySheetPage) {
        this.createSuperControls = false;
        super.createControls(parent, tabbedPropertySheetPage);
        this.createAlgorithmControls(parent);
        TableWidgetFactory.enableCopyPasteCut((Object)tabbedPropertySheetPage);
    }

    public void createAlgorithmControls(Composite parent) {
        SashForm view = new SashForm(parent, 65792);
        view.setLayout((Layout)new FillLayout());
        this.algorithmList = new AlgorithmList((Composite)view, this.getWidgetFactory());
        this.setLeftComposite(this.algorithmList.getComposite());
        this.getAlgorithmList().getViewer().addSelectionChangedListener(event -> {
            Object selection = ((IStructuredSelection)this.getAlgorithmList().getViewer().getSelection()).getFirstElement();
            this.algorithmGroup.setAlgorithm(selection instanceof Algorithm ? (Algorithm)selection : null);
        });
        this.setRightComposite(this.getWidgetFactory().createComposite((Composite)view));
        this.getRightComposite().setLayout((Layout)new GridLayout());
        view.setWeights(new int[]{1, 1});
        view.setLayoutData((Object)new GridData(4, 4, true, true));
        this.algorithmGroup.createControls(this.getRightComposite(), (FormToolkit)this.getWidgetFactory());
    }

    protected void setInputCode() {
    }

    protected void setInputInit() {
        this.algorithmGroup.initialize((BaseFBType)this.getType(), this.commandStack);
        this.getAlgorithmList().initialize(this.getType(), this.commandStack);
    }

    private AlgorithmList getAlgorithmList() {
        return this.algorithmList;
    }

    public void refresh() {
        this.getAlgorithmList().refresh();
    }

    public TableViewer getViewer() {
        return this.algorithmList.getViewer();
    }

    public Object getEntry(int index) {
        return this.getAlgorithmList().getType().getAlgorithm().get(index);
    }

    public void addEntry(Object entry, int index, CompoundCommand cmd) {
        if (entry instanceof Algorithm) {
            cmd.add((Command)new InsertAlgorithmCommand(this.getAlgorithmList().getType(), (Algorithm)entry, index));
        }
    }

    public Object removeEntry(int index, CompoundCommand cmd) {
        Algorithm entry = (Algorithm)this.getEntry(index);
        cmd.add((Command)new DeleteAlgorithmCommand(this.getAlgorithmList().getType(), entry));
        return entry;
    }

    public void executeCompoundCommand(CompoundCommand cmd) {
        this.getAlgorithmList().executeCommand((Command)cmd);
        this.getViewer().refresh();
    }
}

