/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.fbtypeeditor.ecc.properties;

import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.fordiac.ide.fbtypeeditor.ecc.Messages;
import org.eclipse.fordiac.ide.fbtypeeditor.ecc.commands.ChangeAlgorithmCommand;
import org.eclipse.fordiac.ide.fbtypeeditor.ecc.commands.ChangeOutputCommand;
import org.eclipse.fordiac.ide.fbtypeeditor.ecc.contentprovider.ECCContentAndLabelProvider;
import org.eclipse.fordiac.ide.fbtypeeditor.ecc.editparts.ECActionAlgorithm;
import org.eclipse.fordiac.ide.fbtypeeditor.ecc.editparts.ECActionAlgorithmEditPart;
import org.eclipse.fordiac.ide.fbtypeeditor.ecc.editparts.ECActionOutputEvent;
import org.eclipse.fordiac.ide.fbtypeeditor.ecc.editparts.ECActionOutputEventEditPart;
import org.eclipse.fordiac.ide.fbtypeeditor.ecc.properties.AlgorithmGroup;
import org.eclipse.fordiac.ide.fbtypeeditor.ecc.properties.AlgorithmList;
import org.eclipse.fordiac.ide.gef.properties.AbstractSection;
import org.eclipse.fordiac.ide.model.libraryElement.Algorithm;
import org.eclipse.fordiac.ide.model.libraryElement.BaseFBType;
import org.eclipse.fordiac.ide.model.libraryElement.BasicFBType;
import org.eclipse.fordiac.ide.model.libraryElement.ECAction;
import org.eclipse.fordiac.ide.model.libraryElement.Event;
import org.eclipse.fordiac.ide.model.libraryElement.INamedElement;
import org.eclipse.fordiac.ide.ui.widget.ComboBoxWidgetFactory;
import org.eclipse.gef.commands.CommandStack;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetWidgetFactory;

public class ActionSection
extends AbstractSection {
    private Composite actionComposite;
    private CCombo algorithmCombo;
    private CCombo outputEventCombo;
    private final AlgorithmGroup algorithmGroup = new AlgorithmGroup();
    private AlgorithmList algorithmList;

    protected ECAction getType() {
        return (ECAction)this.type;
    }

    protected Algorithm getAlgorithm() {
        return this.getType().getAlgorithm();
    }

    private BasicFBType getFBType() {
        return ECCContentAndLabelProvider.getFBType(this.getType());
    }

    protected Object getInputType(Object input) {
        if (input instanceof ECActionAlgorithmEditPart) {
            return ((ECActionAlgorithmEditPart)((Object)input)).getAction();
        }
        if (input instanceof ECActionAlgorithm) {
            return ((ECActionAlgorithm)input).getAction();
        }
        if (input instanceof ECActionOutputEventEditPart) {
            return ((ECActionOutputEventEditPart)((Object)input)).getAction();
        }
        if (input instanceof ECActionOutputEvent) {
            return ((ECActionOutputEvent)input).getAction();
        }
        if (input instanceof ECAction) {
            return input;
        }
        return null;
    }

    public void createControls(Composite parent, TabbedPropertySheetPage tabbedPropertySheetPage) {
        this.createSuperControls = false;
        super.createControls(parent, tabbedPropertySheetPage);
        parent.setLayout((Layout)new GridLayout(3, true));
        parent.setLayoutData((Object)new GridData(4, 4, true, true));
        this.createActionCombos(parent);
        this.algorithmGroup.createControls(parent, (FormToolkit)this.getWidgetFactory());
        this.createAlgorithmView(parent);
    }

    private void createActionCombos(Composite parent) {
        this.actionComposite = this.getWidgetFactory().createComposite(parent);
        GridData actionCompositeLayoutData = new GridData(4, 0, true, false);
        actionCompositeLayoutData.horizontalSpan = 3;
        this.actionComposite.setLayoutData((Object)actionCompositeLayoutData);
        RowLayout layout = new RowLayout();
        layout.fill = true;
        this.actionComposite.setLayout((Layout)layout);
        this.getWidgetFactory().createCLabel(this.actionComposite, Messages.ActionSection_Algorithm);
        this.algorithmCombo = ComboBoxWidgetFactory.createCombo((TabbedPropertySheetWidgetFactory)this.getWidgetFactory(), (Composite)this.actionComposite);
        this.algorithmCombo.addListener(13, event -> {
            this.removeContentAdapter();
            this.executeCommand(new ChangeAlgorithmCommand(this.getType(), this.getFBType().getAlgorithmNamed(this.algorithmCombo.getText())));
            this.algorithmGroup.setAlgorithm(this.getAlgorithm());
            this.algorithmList.refresh();
            this.addContentAdapter();
        });
        this.getWidgetFactory().createCLabel(this.actionComposite, Messages.ActionSection_OutputEvent);
        this.outputEventCombo = ComboBoxWidgetFactory.createCombo((TabbedPropertySheetWidgetFactory)this.getWidgetFactory(), (Composite)this.actionComposite);
        this.outputEventCombo.addListener(13, event -> {
            this.removeContentAdapter();
            List<Event> outputEvents = ECCContentAndLabelProvider.getOutputEvents(this.getFBType());
            int selItem = this.outputEventCombo.getSelectionIndex();
            this.executeCommand(new ChangeOutputCommand(this.getType(), selItem < outputEvents.size() ? outputEvents.get(selItem) : null));
            this.addContentAdapter();
        });
    }

    private void createAlgorithmView(Composite parent) {
        Group algorithmComposite = this.getWidgetFactory().createGroup(parent, Messages.ActionSection_AllAlgorithms);
        algorithmComposite.setLayout((Layout)new GridLayout(1, false));
        algorithmComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        this.algorithmList = new AlgorithmList((Composite)algorithmComposite, this.getWidgetFactory());
    }

    public void setInput(IWorkbenchPart part, ISelection selection) {
        Assert.isTrue((boolean)(selection instanceof IStructuredSelection));
        Object input = ((IStructuredSelection)selection).getFirstElement();
        this.commandStack = this.getCommandStack(part, input);
        if (this.commandStack == null) {
            this.outputEventCombo.removeAll();
            this.outputEventCombo.setEnabled(false);
            this.algorithmCombo.removeAll();
            this.algorithmCombo.setEnabled(false);
        }
        this.setType(input);
        if (this.getFBType() != null) {
            this.algorithmGroup.initialize((BaseFBType)this.getFBType(), this.commandStack);
            this.algorithmList.initialize(this.getFBType(), this.commandStack);
        }
    }

    public void refresh() {
        CommandStack commandStackBuffer = this.commandStack;
        this.commandStack = null;
        if (this.type != null && this.getFBType() != null) {
            ActionSection.setDropdown(this.outputEventCombo, (INamedElement)this.getType().getOutput(), ECCContentAndLabelProvider.getOutputEventNames(this.getFBType()));
            ActionSection.setDropdown(this.algorithmCombo, (INamedElement)this.getAlgorithm(), ECCContentAndLabelProvider.getAlgorithmNames(this.getFBType()));
            this.actionComposite.layout();
            this.algorithmGroup.setAlgorithm(this.getAlgorithm());
            this.algorithmList.refresh();
        }
        this.commandStack = commandStackBuffer;
    }

    private static void setDropdown(CCombo comboBox, INamedElement el, List<String> names) {
        comboBox.removeAll();
        names.forEach(arg_0 -> ((CCombo)comboBox).add(arg_0));
        comboBox.select(el == null ? names.size() - 1 : comboBox.indexOf(el.getName()));
    }

    protected void setInputCode() {
    }

    protected void setInputInit() {
    }
}

