/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.fbtypeeditor.ecc.policies;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.draw2d.Bendpoint;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.fordiac.ide.fbtypeeditor.ecc.commands.MoveBendpointCommand;
import org.eclipse.fordiac.ide.gef.policies.ModifiedMoveHandle;
import org.eclipse.fordiac.ide.model.libraryElement.ECTransition;
import org.eclipse.gef.ConnectionEditPart;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editpolicies.BendpointEditPolicy;
import org.eclipse.gef.handles.BendpointMoveHandle;
import org.eclipse.gef.requests.BendpointRequest;
import org.eclipse.swt.graphics.Color;

public class TransitionBendPointEditPolicy
extends BendpointEditPolicy {
    private final ECTransition transition;

    public TransitionBendPointEditPolicy(ECTransition transition) {
        this.transition = transition;
    }

    protected Command getCreateBendpointCommand(BendpointRequest request) {
        return this.getMoveBendpointCommand(request);
    }

    protected Command getDeleteBendpointCommand(BendpointRequest request) {
        return this.getMoveBendpointCommand(request);
    }

    protected Command getMoveBendpointCommand(BendpointRequest request) {
        Point p = request.getLocation().getCopy();
        this.getConnection().translateToRelative((Translatable)p);
        return new MoveBendpointCommand(this.transition, p);
    }

    protected List createSelectionHandles() {
        ArrayList<BendpointMoveHandle> list = new ArrayList<BendpointMoveHandle>();
        ConnectionEditPart connEP = (ConnectionEditPart)this.getHost();
        PointList points = this.getConnection().getPoints();
        ArrayList bendPoints = (ArrayList)this.getConnection().getRoutingConstraint();
        int bendPointIndex = 0;
        Point currBendPoint = null;
        if (bendPoints == null) {
            bendPoints = new ArrayList();
        } else if (!bendPoints.isEmpty()) {
            currBendPoint = ((Bendpoint)bendPoints.get(0)).getLocation();
        }
        int i = 0;
        while (i < points.size() - 1) {
            if (i < points.size() - 1 && bendPointIndex < bendPoints.size() && points.getPoint(i + 1).equals((Object)currBendPoint)) {
                list.add(TransitionBendPointEditPolicy.createBendPointMoveHandle(connEP, bendPointIndex, i));
                if (++bendPointIndex < bendPoints.size()) {
                    currBendPoint = ((Bendpoint)bendPoints.get(bendPointIndex)).getLocation();
                }
            }
            ++i;
        }
        return list;
    }

    private static BendpointMoveHandle createBendPointMoveHandle(ConnectionEditPart connEP, int bendPointIndex, int i) {
        BendpointMoveHandle handle = new BendpointMoveHandle(connEP, bendPointIndex, i + 1){

            protected Color getBorderColor() {
                return this.isPrimary() ? ColorConstants.white : ModifiedMoveHandle.getSelectionColor();
            }

            protected Color getFillColor() {
                return this.isPrimary() ? ModifiedMoveHandle.getSelectionColor() : ColorConstants.white;
            }
        };
        handle.setPreferredSize(13, 13);
        return handle;
    }
}

