/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.fbtypeeditor.ecc.editors;

import java.util.Map;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.draw2d.FigureCanvas;
import org.eclipse.fordiac.ide.fbtypeeditor.ecc.Messages;
import org.eclipse.fordiac.ide.fbtypeeditor.ecc.actions.AddECCActionAction;
import org.eclipse.fordiac.ide.fbtypeeditor.ecc.actions.DeleteECCAction;
import org.eclipse.fordiac.ide.fbtypeeditor.ecc.actions.ECCSelectAllAction;
import org.eclipse.fordiac.ide.fbtypeeditor.ecc.actions.NewStateAction;
import org.eclipse.fordiac.ide.fbtypeeditor.ecc.editors.ECCEditorEditDomain;
import org.eclipse.fordiac.ide.fbtypeeditor.ecc.editors.ECCPaletteFactory;
import org.eclipse.fordiac.ide.fbtypeeditor.ecc.editparts.ECActionAlgorithm;
import org.eclipse.fordiac.ide.fbtypeeditor.ecc.editparts.ECCEditPartFactory;
import org.eclipse.fordiac.ide.fbtypeeditor.ecc.editparts.ECStateEditPart;
import org.eclipse.fordiac.ide.fbtypeeditor.editors.IFBTEditorPart;
import org.eclipse.fordiac.ide.gef.DiagramEditorWithFlyoutPalette;
import org.eclipse.fordiac.ide.gef.FordiacContextMenuProvider;
import org.eclipse.fordiac.ide.gef.editparts.ZoomScalableFreeformRootEditPart;
import org.eclipse.fordiac.ide.model.libraryElement.AutomationSystem;
import org.eclipse.fordiac.ide.model.libraryElement.BasicFBType;
import org.eclipse.fordiac.ide.model.libraryElement.ECAction;
import org.eclipse.fordiac.ide.model.libraryElement.FBType;
import org.eclipse.fordiac.ide.model.libraryElement.provider.ECCItemProvider;
import org.eclipse.fordiac.ide.model.ui.editors.AdvancedScrollingGraphicalViewer;
import org.eclipse.fordiac.ide.typemanagement.FBTypeEditorInput;
import org.eclipse.fordiac.ide.ui.editors.EditorUtils;
import org.eclipse.fordiac.ide.ui.imageprovider.FordiacImage;
import org.eclipse.gef.ContextMenuProvider;
import org.eclipse.gef.DefaultEditDomain;
import org.eclipse.gef.DragTracker;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartFactory;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.KeyHandler;
import org.eclipse.gef.KeyStroke;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.CommandStack;
import org.eclipse.gef.editparts.ScalableFreeformRootEditPart;
import org.eclipse.gef.editparts.ZoomManager;
import org.eclipse.gef.palette.PaletteRoot;
import org.eclipse.gef.tools.MarqueeSelectionTool;
import org.eclipse.gef.ui.actions.ActionRegistry;
import org.eclipse.gef.ui.palette.FlyoutPaletteComposite;
import org.eclipse.gef.ui.parts.GraphicalEditor;
import org.eclipse.gef.ui.parts.ScrollingGraphicalViewer;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.util.TransferDropTargetListener;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.actions.ActionFactory;

public class ECCEditor
extends DiagramEditorWithFlyoutPalette
implements IFBTEditorPart {
    private BasicFBType fbType;
    private PaletteRoot paletteRoot;
    private CommandStack commandStack;
    private static final String UNKNOWN_LINE = "Unknown";

    public BasicFBType getFbType() {
        return this.fbType;
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        FBTypeEditorInput untypedInput;
        this.setInput(input);
        if (input instanceof FBTypeEditorInput && (untypedInput = (FBTypeEditorInput)input).getContent() instanceof BasicFBType) {
            this.fbType = (BasicFBType)untypedInput.getContent();
        }
        super.init(site, input);
        this.setPartName(Messages.ECCEditor_LABEL_ECCEditorTabName);
        this.setTitleImage(FordiacImage.ICON_ECC.getImage());
    }

    protected void configureGraphicalViewer() {
        super.configureGraphicalViewer();
        AdvancedScrollingGraphicalViewer viewer = this.getGraphicalViewer();
        IAction action = this.getActionRegistry().getAction((Object)"org.eclipse.fordiac.ide.fbtypeeditor.ecc.actions.CreateStateAction");
        ((NewStateAction)action).setViewerControl((FigureCanvas)viewer.getControl());
        ((NewStateAction)action).setZoomManager(this.getZoomManger());
    }

    protected KeyHandler getCommonKeyHandler() {
        KeyHandler keyHandler = super.getCommonKeyHandler();
        keyHandler.put(KeyStroke.getPressed((int)0x1000009, (int)0), this.getActionRegistry().getAction((Object)"org.eclipse.fordiac.ide.fbtypeeditor.ecc.actions.AddECCActionAction"));
        return keyHandler;
    }

    protected ContextMenuProvider getContextMenuProvider(ScrollingGraphicalViewer viewer, ZoomManager zoomManager) {
        return new FordiacContextMenuProvider((EditPartViewer)viewer, zoomManager, this.getActionRegistry()){

            public void buildContextMenu(IMenuManager menu) {
                super.buildContextMenu(menu);
                IAction action = this.getRegistry().getAction((Object)"org.eclipse.fordiac.ide.fbtypeeditor.ecc.actions.CreateStateAction");
                menu.appendToGroup("org.eclipse.gef.group.edit", action);
                action = this.getRegistry().getAction((Object)"org.eclipse.fordiac.ide.fbtypeeditor.ecc.actions.AddECCActionAction");
                menu.appendToGroup("org.eclipse.gef.group.edit", action);
                action = this.getRegistry().getAction((Object)ActionFactory.DELETE.getId());
                menu.appendToGroup("org.eclipse.gef.group.edit", action);
            }
        };
    }

    protected ScalableFreeformRootEditPart createRootEditPart() {
        return new ZoomScalableFreeformRootEditPart(this.getSite(), this.getActionRegistry()){

            public DragTracker getDragTracker(Request req) {
                ZoomScalableFreeformRootEditPart.AdvancedMarqueeDragTracker dragTracker = new ZoomScalableFreeformRootEditPart.AdvancedMarqueeDragTracker((ZoomScalableFreeformRootEditPart)this);
                dragTracker.setMarqueeBehavior(MarqueeSelectionTool.BEHAVIOR_NODES_CONTAINED_AND_RELATED_CONNECTIONS);
                return dragTracker;
            }
        };
    }

    protected PaletteRoot getPaletteRoot() {
        if (this.paletteRoot == null) {
            this.paletteRoot = ECCPaletteFactory.createPalette();
        }
        return this.paletteRoot;
    }

    public void doSave(IProgressMonitor monitor) {
        this.getCommandStack().markSaveLocation();
        this.firePropertyChange(257);
    }

    protected void createActions() {
        ActionRegistry registry = this.getActionRegistry();
        Object action = new NewStateAction((IWorkbenchPart)this);
        registry.registerAction((IAction)action);
        action = new AddECCActionAction((IWorkbenchPart)this);
        registry.registerAction((IAction)action);
        this.getSelectionActions().add(action.getId());
        super.createActions();
        action = registry.getAction((Object)ActionFactory.DELETE.getId());
        registry.removeAction((IAction)action);
        this.getSelectionActions().remove(action.getId());
        action = new DeleteECCAction((IWorkbenchPart)this);
        registry.registerAction((IAction)action);
        this.getSelectionActions().add(action.getId());
        action = registry.getAction((Object)ActionFactory.SELECT_ALL.getId());
        registry.removeAction((IAction)action);
        this.getSelectionActions().remove(action.getId());
        action = new ECCSelectAllAction((IWorkbenchPart)this);
        registry.registerAction((IAction)action);
        this.getSelectionActions().add(action.getId());
    }

    public boolean outlineSelectionChanged(Object selectedElement) {
        Object obj = this.getGraphicalViewer().getEditPartRegistry().get(selectedElement);
        if (obj instanceof EditPart) {
            this.getGraphicalViewer().select((EditPart)obj);
            return true;
        }
        if (selectedElement instanceof ECCItemProvider) {
            return true;
        }
        if (selectedElement instanceof ECAction) {
            this.handleActionOutlineSelection((ECAction)selectedElement);
            return true;
        }
        return false;
    }

    private void handleActionOutlineSelection(ECAction action) {
        Object obj = this.getGraphicalViewer().getEditPartRegistry().get(action.getECState());
        if (obj != null) {
            for (Object element : ((ECStateEditPart)((Object)obj)).getCurrentChildren()) {
                if (!(element instanceof ECActionAlgorithm) || !action.equals(((ECActionAlgorithm)element).getAction()) || (obj = this.getGraphicalViewer().getEditPartRegistry().get(element)) == null) continue;
                this.getGraphicalViewer().select((EditPart)obj);
                break;
            }
        }
    }

    protected void setModel(IEditorInput input) {
        super.setModel(input);
        this.setEditDomain((DefaultEditDomain)new ECCEditorEditDomain((IEditorPart)this, this.commandStack));
    }

    public void setCommonCommandStack(CommandStack commandStack) {
        this.commandStack = commandStack;
    }

    protected FlyoutPaletteComposite.FlyoutPreferences getPalettePreferences() {
        return ECCPaletteFactory.PALETTE_PREFERENCES;
    }

    public Object getModel() {
        return this.fbType.getECC();
    }

    protected EditPartFactory getEditPartFactory() {
        return new ECCEditPartFactory((GraphicalEditor)this);
    }

    protected TransferDropTargetListener createTransferDropTargetListener() {
        return null;
    }

    public AutomationSystem getSystem() {
        return null;
    }

    public void doSaveAs() {
    }

    public void gotoMarker(IMarker marker) {
        Map map = this.getGraphicalViewer().getEditPartRegistry();
        String lineNumber = marker.getAttribute("lineNumber", UNKNOWN_LINE);
        if (!UNKNOWN_LINE.equals(lineNumber)) {
            int hashCode = Integer.parseInt(lineNumber);
            for (Object key : map.keySet()) {
                Object obj;
                if (key.hashCode() != hashCode || !((obj = this.getGraphicalViewer().getEditPartRegistry().get(key)) instanceof EditPart)) continue;
                this.getGraphicalViewer().select((EditPart)obj);
                break;
            }
        }
    }

    public boolean isMarkerTarget(IMarker marker) {
        return marker.getAttribute("location", UNKNOWN_LINE).startsWith("ECC");
    }

    public void reloadType(FBType type) {
        if (type instanceof BasicFBType) {
            this.fbType = (BasicFBType)type;
            this.getGraphicalViewer().setContents((Object)type);
        } else {
            EditorUtils.CloseEditor.run((IEditorPart)this);
        }
    }
}

