/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.export.forte_ng.composite;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.fordiac.ide.export.forte_ng.ForteFBTemplate;
import org.eclipse.fordiac.ide.model.libraryElement.AdapterFB;
import org.eclipse.fordiac.ide.model.libraryElement.AdapterFBType;
import org.eclipse.fordiac.ide.model.libraryElement.CompositeFBType;
import org.eclipse.fordiac.ide.model.libraryElement.Connection;
import org.eclipse.fordiac.ide.model.libraryElement.DataConnection;
import org.eclipse.fordiac.ide.model.libraryElement.EventConnection;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetworkElement;
import org.eclipse.fordiac.ide.model.libraryElement.FBType;
import org.eclipse.fordiac.ide.model.libraryElement.IInterfaceElement;
import org.eclipse.fordiac.ide.model.libraryElement.VarDeclaration;
import org.eclipse.xtend.lib.annotations.AccessorType;
import org.eclipse.xtend.lib.annotations.Accessors;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.Pure;

public class CompositeFBImplTemplate
extends ForteFBTemplate {
    @Accessors(value={AccessorType.PROTECTED_GETTER})
    private CompositeFBType type;
    private ArrayList<FBNetworkElement> fbs = new ArrayList();
    private int numCompFBParams = 0;
    private int eConnNumber = 0;
    private int fannedOutEventConns = 0;
    private int dataConnNumber = 0;
    private int fannedOutDataConns = 0;

    public CompositeFBImplTemplate(CompositeFBType type, String name, Path prefix) {
        super(name, prefix, "CCompositeFB");
        this.type = type;
        Functions.Function1 _function = it -> {
            FBType _type = it.getType();
            return !(_type instanceof AdapterFBType);
        };
        Iterables.addAll(this.fbs, (Iterable)IterableExtensions.filter((Iterable)type.getFBNetwork().getNetworkElements(), (Functions.Function1)_function));
    }

    public CharSequence generate() {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _generateHeader = this.generateHeader();
        _builder.append((Object)_generateHeader);
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        CharSequence _generateImplIncludes = this.generateImplIncludes();
        _builder.append((Object)_generateImplIncludes);
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        CharSequence _generateFBDefinition = this.generateFBDefinition();
        _builder.append((Object)_generateFBDefinition);
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        CharSequence _generateFBInterfaceDefinition = this.generateFBInterfaceDefinition();
        _builder.append((Object)_generateFBInterfaceDefinition);
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        CharSequence _generateFBInterfaceSpecDefinition = this.generateFBInterfaceSpecDefinition();
        _builder.append((Object)_generateFBInterfaceSpecDefinition);
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        CharSequence _generateFBNetwork = this.generateFBNetwork();
        _builder.append((Object)_generateFBNetwork);
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        return _builder;
    }

    protected CharSequence generateFBNetwork() {
        boolean _isEmpty_1;
        boolean _not_1;
        boolean _not;
        StringConcatenation _builder = new StringConcatenation();
        Functions.Function1 _function = it -> {
            FBType _type = it.getType();
            return !(_type instanceof AdapterFBType);
        };
        boolean _exists = IterableExtensions.exists((Iterable)this.type.getFBNetwork().getNetworkElements(), (Functions.Function1)_function);
        if (_exists) {
            _builder.append("const SCFB_FBInstanceData ");
            CharSequence _fBClassName = this.getFBClassName();
            _builder.append((Object)_fBClassName);
            _builder.append("::scm_astInternalFBs[] = {");
            _builder.newLineIfNotEmpty();
            _builder.append("  ");
            boolean _hasElements = false;
            for (FBNetworkElement elem : this.fbs) {
                if (!_hasElements) {
                    _hasElements = true;
                } else {
                    _builder.appendImmediate((Object)",\n", "  ");
                }
                _builder.append("{");
                CharSequence _fORTEString = this.getFORTEString(elem.getName());
                _builder.append((Object)_fORTEString, "  ");
                _builder.append(", ");
                CharSequence _fORTEString_1 = this.getFORTEString(elem.getType().getName());
                _builder.append((Object)_fORTEString_1, "  ");
                _builder.append("}");
            }
            _builder.newLineIfNotEmpty();
            _builder.append("};");
            _builder.newLine();
        }
        _builder.newLine();
        CharSequence _exportFBParams = this.exportFBParams((EList<FBNetworkElement>)this.type.getFBNetwork().getNetworkElements());
        _builder.append((Object)_exportFBParams);
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        boolean _isEmpty = this.type.getFBNetwork().getEventConnections().isEmpty();
        boolean bl = _not = !_isEmpty;
        if (_not) {
            StringBuilder _exportEventConns = this.exportEventConns((EList<EventConnection>)this.type.getFBNetwork().getEventConnections());
            _builder.append((Object)_exportEventConns);
            _builder.newLineIfNotEmpty();
            _builder.newLine();
        }
        boolean bl2 = _not_1 = !(_isEmpty_1 = this.type.getFBNetwork().getDataConnections().isEmpty());
        if (_not_1) {
            StringBuilder _exportDataConns = this.exportDataConns((EList<DataConnection>)this.type.getFBNetwork().getDataConnections());
            _builder.append((Object)_exportDataConns);
            _builder.newLineIfNotEmpty();
            _builder.newLine();
        }
        CharSequence _generateFBNDataStruct = this.generateFBNDataStruct();
        _builder.append((Object)_generateFBNDataStruct);
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    protected CharSequence generateFBNDataStruct() {
        boolean _not;
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("const SCFB_FBNData ");
        CharSequence _fBClassName = this.getFBClassName();
        _builder.append((Object)_fBClassName);
        _builder.append("::scm_stFBNData = {");
        _builder.newLineIfNotEmpty();
        _builder.append("  ");
        int _size = this.fbs.size();
        _builder.append((Object)_size, "  ");
        _builder.append(", ");
        boolean _isEmpty = this.fbs.isEmpty();
        boolean bl = _not = !_isEmpty;
        if (_not) {
            _builder.append("scm_astInternalFBs");
        } else {
            _builder.append("nullptr");
        }
        _builder.append(",");
        _builder.newLineIfNotEmpty();
        _builder.append("  ");
        _builder.append((Object)this.eConnNumber, "  ");
        _builder.append(", ");
        if (this.eConnNumber != 0) {
            _builder.append("scm_astEventConnections");
        } else {
            _builder.append("nullptr");
        }
        _builder.append(",");
        _builder.newLineIfNotEmpty();
        _builder.append("  ");
        _builder.append((Object)this.fannedOutEventConns, "  ");
        _builder.append(", ");
        if (this.fannedOutEventConns != 0) {
            _builder.append("scm_astFannedOutEventConnections");
        } else {
            _builder.append("nullptr");
        }
        _builder.append(",");
        _builder.newLineIfNotEmpty();
        _builder.append("  ");
        _builder.append((Object)this.dataConnNumber, "  ");
        _builder.append(", ");
        if (this.dataConnNumber != 0) {
            _builder.append("scm_astDataConnections");
        } else {
            _builder.append("nullptr");
        }
        _builder.append(",");
        _builder.newLineIfNotEmpty();
        _builder.append("  ");
        _builder.append((Object)this.fannedOutDataConns, "  ");
        _builder.append(", ");
        if (this.fannedOutDataConns != 0) {
            _builder.append("scm_astFannedOutDataConnections");
        } else {
            _builder.append("nullptr");
        }
        _builder.append(",");
        _builder.newLineIfNotEmpty();
        _builder.append("  ");
        _builder.append((Object)this.numCompFBParams, "  ");
        _builder.append(", ");
        if (this.numCompFBParams != 0) {
            _builder.append("scm_astParamters");
        } else {
            _builder.append("nullptr");
        }
        _builder.newLineIfNotEmpty();
        _builder.append("};");
        _builder.newLine();
        _builder.newLine();
        return _builder;
    }

    protected String generateConnectionPortID(IInterfaceElement iface, FBNetworkElement elem) {
        String _xifexpression = null;
        boolean _contains = this.type.getFBNetwork().getNetworkElements().contains((Object)elem);
        if (_contains) {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("GENERATE_CONNECTION_PORT_ID_2_ARG(");
            CharSequence _fORTEString = this.getFORTEString(elem.getName());
            _builder.append((Object)_fORTEString);
            _builder.append(", ");
            CharSequence _fORTEString_1 = this.getFORTEString(iface.getName());
            _builder.append((Object)_fORTEString_1);
            _builder.append("), ");
            CharSequence _fbId = this.fbId(elem);
            _builder.append((Object)_fbId);
            _xifexpression = _builder.toString();
        } else {
            StringConcatenation _builder_1 = new StringConcatenation();
            _builder_1.append("GENERATE_CONNECTION_PORT_ID_1_ARG(");
            CharSequence _fORTEString_2 = this.getFORTEString(iface.getName());
            _builder_1.append((Object)_fORTEString_2);
            _builder_1.append("), -1");
            _xifexpression = _builder_1.toString();
        }
        return _xifexpression;
    }

    protected CharSequence _fbId(FBNetworkElement elem) {
        StringConcatenation _builder = new StringConcatenation();
        int _indexOf = this.fbs.indexOf(elem);
        _builder.append((Object)_indexOf);
        return _builder;
    }

    protected CharSequence _fbId(AdapterFB elem) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("CCompositeFB::scm_nAdapterMarker | ");
        boolean _isPlug = elem.isPlug();
        if (_isPlug) {
            int _plugIndex = this.getPlugIndex(elem);
            _builder.append((Object)_plugIndex);
        } else {
            int _indexOf = this.type.getInterfaceList().getSockets().indexOf((Object)elem.getAdapterDecl());
            _builder.append((Object)_indexOf);
        }
        return _builder;
    }

    protected int getPlugIndex(AdapterFB elem) {
        int _size = this.type.getInterfaceList().getSockets().size();
        int _indexOf = this.type.getInterfaceList().getPlugs().indexOf((Object)elem.getAdapterDecl());
        return _size + _indexOf;
    }

    protected StringBuilder exportEventConns(EList<EventConnection> eConns) {
        StringBuilder _xblockexpression = null;
        StringBuilder retVal = new StringBuilder();
        HashSet<Connection> conSet = new HashSet<Connection>();
        StringBuilder fannedOutConns = new StringBuilder();
        CharSequence _fBClassName = this.getFBClassName();
        String _plus = "const SCFB_FBConnectionData " + _fBClassName;
        String _plus_1 = String.valueOf(_plus) + "::scm_astEventConnections[] = {\n";
        retVal.append(_plus_1);
        for (Connection eConn : eConns) {
            boolean _greaterThan;
            boolean _not;
            boolean _contains = conSet.contains(eConn);
            boolean bl = _not = !_contains;
            if (!_not) continue;
            conSet.add(eConn);
            retVal.append(this.getConnListEntry(eConn));
            int _size = eConn.getSource().getOutputConnections().size();
            boolean bl2 = _greaterThan = _size > 1;
            if (_greaterThan) {
                Functions.Function1 _function = it -> {
                    boolean _equals = Objects.equal((Object)it, (Object)eConn);
                    return !_equals;
                };
                Iterable _filter = IterableExtensions.filter((Iterable)eConn.getSource().getOutputConnections(), (Functions.Function1)_function);
                for (Connection fannedConn : _filter) {
                    conSet.add(fannedConn);
                    fannedOutConns.append(this.genFannedOutConnString(fannedConn, this.eConnNumber));
                    ++this.fannedOutEventConns;
                }
            }
            ++this.eConnNumber;
        }
        retVal.append("};\n");
        CharSequence _fBClassName_1 = this.getFBClassName();
        String _plus_2 = "\nconst SCFB_FBFannedOutConnectionData " + _fBClassName_1;
        String _plus_3 = String.valueOf(_plus_2) + "::scm_astFannedOutEventConnections[] = {\n";
        retVal.append(_plus_3);
        if (this.fannedOutEventConns != 0) {
            retVal.append((CharSequence)fannedOutConns);
        }
        _xblockexpression = retVal.append("};\n");
        return _xblockexpression;
    }

    protected StringBuilder exportDataConns(EList<DataConnection> dataConns) {
        StringBuilder _xblockexpression = null;
        StringBuilder retVal = new StringBuilder();
        HashSet<Connection> conSet = new HashSet<Connection>();
        StringBuilder fannedOutConns = new StringBuilder();
        CharSequence _fBClassName = this.getFBClassName();
        String _plus = "const SCFB_FBConnectionData " + _fBClassName;
        String _plus_1 = String.valueOf(_plus) + "::scm_astDataConnections[] = {\n";
        retVal.append(_plus_1);
        for (DataConnection dConn : dataConns) {
            boolean _greaterThan;
            boolean _not;
            boolean _contains = conSet.contains(dConn);
            boolean bl = _not = !_contains;
            if (!_not) continue;
            Connection primConn = this.getPrimaryDataConn(dConn);
            conSet.add(primConn);
            retVal.append(this.getConnListEntry(primConn));
            int _size = primConn.getSource().getOutputConnections().size();
            boolean bl2 = _greaterThan = _size > 1;
            if (_greaterThan) {
                Functions.Function1 _function = it -> {
                    boolean _equals = Objects.equal((Object)it, (Object)primConn);
                    return !_equals;
                };
                Iterable _filter = IterableExtensions.filter((Iterable)primConn.getSource().getOutputConnections(), (Functions.Function1)_function);
                for (Connection fannedConn : _filter) {
                    conSet.add(fannedConn);
                    if (this.hasCFBInterfaceDestination(fannedConn) && this.hasCFBInterfaceDestination(primConn)) {
                        fannedOutConns.append("#error a fanout to several composite FB's outputs is currently not supported: ");
                        List _errors = this.getErrors();
                        String _name = this.getName();
                        String _plus_2 = " - " + _name;
                        String _plus_3 = String.valueOf(_plus_2) + " FORTE does currently not allow that a data a composite's data connection may be connected to several data outputs of the composite FB.";
                        _errors.add(_plus_3);
                    }
                    fannedOutConns.append(this.genFannedOutConnString(fannedConn, this.dataConnNumber));
                    ++this.fannedOutDataConns;
                }
            }
            ++this.dataConnNumber;
        }
        retVal.append("};\n");
        CharSequence _fBClassName_1 = this.getFBClassName();
        String _plus_2 = "\nconst SCFB_FBFannedOutConnectionData " + _fBClassName_1;
        String _plus_3 = String.valueOf(_plus_2) + "::scm_astFannedOutDataConnections[] = {\n";
        retVal.append(_plus_3);
        if (this.fannedOutDataConns != 0) {
            retVal.append((CharSequence)fannedOutConns);
        }
        _xblockexpression = retVal.append("};\n");
        return _xblockexpression;
    }

    protected CharSequence getConnListEntry(Connection con) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("  ");
        _builder.append("{");
        String _generateConnectionPortID = this.generateConnectionPortID(con.getSource(), con.getSourceElement());
        _builder.append(_generateConnectionPortID, "  ");
        _builder.append(", ");
        String _generateConnectionPortID_1 = this.generateConnectionPortID(con.getDestination(), con.getDestinationElement());
        _builder.append(_generateConnectionPortID_1, "  ");
        _builder.append("},");
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    protected CharSequence genFannedOutConnString(Connection con, int connNum) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("  ");
        _builder.append("{");
        _builder.append((Object)connNum, "  ");
        _builder.append(", ");
        String _generateConnectionPortID = this.generateConnectionPortID(con.getDestination(), con.getDestinationElement());
        _builder.append(_generateConnectionPortID, "  ");
        _builder.append("},");
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    private Connection getPrimaryDataConn(DataConnection dataConn) {
        EList _outputConnections = dataConn.getSource().getOutputConnections();
        for (Connection dc : _outputConnections) {
            boolean _hasCFBInterfaceDestination = this.hasCFBInterfaceDestination(dc);
            if (!_hasCFBInterfaceDestination) continue;
            return dc;
        }
        return dataConn;
    }

    private boolean hasCFBInterfaceDestination(Connection conn) {
        IInterfaceElement _destination = null;
        if (conn != null) {
            _destination = conn.getDestination();
        }
        EObject _eContainer = null;
        if (_destination != null) {
            _eContainer = _destination.eContainer();
        }
        EObject _eContainer_1 = null;
        if (_eContainer != null) {
            _eContainer_1 = _eContainer.eContainer();
        }
        return _eContainer_1 instanceof CompositeFBType;
    }

    protected CharSequence exportFBParams(EList<FBNetworkElement> fbs) {
        StringConcatenation _xblockexpression = null;
        StringBuilder retVal = new StringBuilder();
        for (FBNetworkElement fb : fbs) {
            Functions.Function1 _function = it -> it.getValue() != null && !it.getValue().getValue().isEmpty();
            Iterable _filter = IterableExtensions.filter((Iterable)fb.getInterface().getInputVars(), (Functions.Function1)_function);
            for (VarDeclaration v : _filter) {
                StringConcatenation _builder = new StringConcatenation();
                _builder.append("  ");
                _builder.append("{");
                CharSequence _fbId = this.fbId(fb);
                _builder.append((Object)_fbId, "  ");
                _builder.append(", g_nStringId");
                String _name = v.getName();
                _builder.append(_name, "  ");
                _builder.append(", \"");
                String _paramValue = this.getParamValue(v);
                _builder.append(_paramValue, "  ");
                _builder.append("\"},");
                _builder.newLineIfNotEmpty();
                retVal.append((CharSequence)_builder);
                ++this.numCompFBParams;
            }
        }
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("const SCFB_FBParameter ");
        CharSequence _fBClassName = this.getFBClassName();
        _builder.append((Object)_fBClassName);
        _builder.append("::scm_astParamters[] = {");
        _builder.newLineIfNotEmpty();
        if (this.numCompFBParams != 0) {
            String _string = retVal.toString();
            _builder.append(_string);
        }
        _builder.newLineIfNotEmpty();
        _builder.append("};");
        _xblockexpression = _builder;
        return _xblockexpression;
    }

    private String getParamValue(VarDeclaration v) {
        return v.getValue().getValue().replace("\"", "\\\"");
    }

    protected CharSequence fbId(FBNetworkElement elem) {
        if (elem instanceof AdapterFB) {
            return this._fbId((AdapterFB)elem);
        }
        if (elem != null) {
            return this._fbId(elem);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(elem).toString());
    }

    @Pure
    protected CompositeFBType getType() {
        return this.type;
    }
}

