/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.fbtypeeditor.policies;

import java.util.List;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Locator;
import org.eclipse.draw2d.MouseEvent;
import org.eclipse.draw2d.MouseListener;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.fordiac.ide.fbtypeeditor.editparts.InterfaceEditPart;
import org.eclipse.fordiac.ide.gef.editparts.AbstractDirectEditableEditPart;
import org.eclipse.fordiac.ide.gef.handles.PlusHandle;
import org.eclipse.fordiac.ide.gef.policies.ModifiedNonResizeableEditPolicy;
import org.eclipse.fordiac.ide.model.data.DataType;
import org.eclipse.fordiac.ide.model.libraryElement.IInterfaceElement;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.handles.RelativeHandleLocator;

public abstract class AbstractInterfaceSelectionEditPolicy
extends ModifiedNonResizeableEditPolicy {
    protected AbstractInterfaceSelectionEditPolicy(int cornerDim, Insets insets) {
        super(cornerDim, insets);
    }

    protected void hideSelection() {
        super.hideSelection();
        this.getInterfaceEditPart().setInOutConnectionsWith(0);
    }

    protected void showSelection() {
        super.showSelection();
        this.getInterfaceEditPart().setInOutConnectionsWith(2);
    }

    protected List createSelectionHandles() {
        List list = super.createSelectionHandles();
        InterfaceEditPart part = this.getInterfaceEditPart();
        PlusHandle top = AbstractInterfaceSelectionEditPolicy.createHandle(part, 1);
        list.add(top);
        top.addMouseListener(new MouseListener(){

            public void mousePressed(MouseEvent me) {
                AbstractInterfaceSelectionEditPolicy.this.createInterfaceElement(false);
            }

            public void mouseReleased(MouseEvent me) {
            }

            public void mouseDoubleClicked(MouseEvent me) {
            }
        });
        PlusHandle bottom = AbstractInterfaceSelectionEditPolicy.createHandle(part, 4);
        list.add(bottom);
        bottom.addMouseListener(new MouseListener(){

            public void mousePressed(MouseEvent me) {
                AbstractInterfaceSelectionEditPolicy.this.createInterfaceElement(true);
            }

            public void mouseReleased(MouseEvent me) {
            }

            public void mouseDoubleClicked(MouseEvent me) {
            }
        });
        return list;
    }

    private InterfaceEditPart getInterfaceEditPart() {
        return (InterfaceEditPart)this.getHost();
    }

    private IInterfaceElement getModel() {
        return (IInterfaceElement)this.getInterfaceEditPart().getModel();
    }

    private static PlusHandle createHandle(InterfaceEditPart part, final int direction) {
        return new PlusHandle((GraphicalEditPart)part, (Locator)new RelativeHandleLocator(part.getFigure(), direction){

            public void relocate(IFigure target) {
                super.relocate(target);
                Rectangle targetBounds = target.getBounds();
                Dimension targetSize = target.getPreferredSize();
                targetBounds.x += (targetSize.width + 1) / 4 * this.getXModifcation();
                targetBounds.y += (targetSize.height + 1) / 4 * this.getYModifcation();
                target.setBounds(targetBounds);
            }

            private int getYModifcation() {
                switch (direction & 5) {
                    case 1: {
                        return -1;
                    }
                    case 4: {
                        return 1;
                    }
                }
                return 0;
            }

            private int getXModifcation() {
                switch (direction & 0x18) {
                    case 8: {
                        return -1;
                    }
                    case 16: {
                        return 1;
                    }
                }
                return 0;
            }
        });
    }

    private void createInterfaceElement(boolean after) {
        Command cmd;
        List<? extends IInterfaceElement> list = this.getInterfaceElementList();
        int ref = list.indexOf(this.getModel());
        if (-1 != ref && after) {
            ++ref;
        }
        if ((cmd = this.getIECreateCommand(this.getModel().getType(), ref)) != null) {
            AbstractDirectEditableEditPart.executeCommand((Command)cmd);
        }
    }

    protected abstract List<? extends IInterfaceElement> getInterfaceElementList();

    protected abstract Command getIECreateCommand(DataType var1, int var2);
}

