/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.fbtypeeditor.editors;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.SortedMap;
import java.util.TreeMap;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.fordiac.ide.fbtypeeditor.Activator;
import org.eclipse.fordiac.ide.fbtypeeditor.Messages;
import org.eclipse.fordiac.ide.fbtypeeditor.editors.FBTypeContentOutline;
import org.eclipse.fordiac.ide.fbtypeeditor.editors.FBTypeNavigationLocation;
import org.eclipse.fordiac.ide.fbtypeeditor.editors.IFBTEditorPart;
import org.eclipse.fordiac.ide.fbtypeeditor.editors.IFBTValidation;
import org.eclipse.fordiac.ide.model.Palette.AdapterTypePaletteEntry;
import org.eclipse.fordiac.ide.model.Palette.FBTypePaletteEntry;
import org.eclipse.fordiac.ide.model.Palette.PaletteEntry;
import org.eclipse.fordiac.ide.model.dataexport.AbstractBlockTypeExporter;
import org.eclipse.fordiac.ide.model.libraryElement.AdapterFBType;
import org.eclipse.fordiac.ide.model.libraryElement.BasicFBType;
import org.eclipse.fordiac.ide.model.libraryElement.CompositeFBType;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetworkElement;
import org.eclipse.fordiac.ide.model.libraryElement.FBType;
import org.eclipse.fordiac.ide.model.libraryElement.INamedElement;
import org.eclipse.fordiac.ide.model.libraryElement.ServiceInterfaceFBType;
import org.eclipse.fordiac.ide.model.libraryElement.SimpleFBType;
import org.eclipse.fordiac.ide.model.typelibrary.TypeLibrary;
import org.eclipse.fordiac.ide.systemmanagement.changelistener.IEditorFileChangeListener;
import org.eclipse.fordiac.ide.typemanagement.FBTypeEditorInput;
import org.eclipse.fordiac.ide.ui.editors.AbstractCloseAbleFormEditor;
import org.eclipse.gef.commands.CommandStack;
import org.eclipse.gef.commands.CommandStackEvent;
import org.eclipse.gef.commands.CommandStackEventListener;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorActionBarContributor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.INavigationLocation;
import org.eclipse.ui.INavigationLocationProvider;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.ide.IGotoMarker;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;
import org.eclipse.ui.views.properties.IPropertySheetPage;
import org.eclipse.ui.views.properties.tabbed.ITabbedPropertySheetPageContributor;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;

public class FBTypeEditor
extends AbstractCloseAbleFormEditor
implements ISelectionListener,
CommandStackEventListener,
ITabbedPropertySheetPageContributor,
IGotoMarker,
IEditorFileChangeListener,
INavigationLocationProvider {
    private Collection<IFBTEditorPart> editors;
    private PaletteEntry paletteEntry;
    private FBType fbType;
    private FBTypeContentOutline contentOutline = null;
    private final CommandStack commandStack = new CommandStack();
    private final Adapter adapter = new AdapterImpl(){

        public void notifyChanged(Notification notification) {
            super.notifyChanged(notification);
            Object feature = notification.getFeature();
            if (feature != null && notification.getFeatureID(feature.getClass()) == 0) {
                Display.getDefault().asyncExec(() -> {
                    if (FBTypeEditor.this.paletteEntry != null) {
                        FBTypeEditor.this.setPartName(FBTypeEditor.this.paletteEntry.getFile().getName());
                        FBTypeEditor.this.setInput((IEditorInput)new FileEditorInput(FBTypeEditor.this.paletteEntry.getFile()));
                    }
                });
            }
        }
    };

    public void doSave(IProgressMonitor monitor) {
        if (this.paletteEntry != null && this.checkTypeSaveAble()) {
            this.performPresaveHooks();
            this.editors.forEach(editorPart -> editorPart.doSave(monitor));
            this.getCommandStack().markSaveLocation();
            AbstractBlockTypeExporter.saveType((PaletteEntry)this.paletteEntry);
            this.firePropertyChange(257);
        }
    }

    private void performPresaveHooks() {
        IConfigurationElement[] config;
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IConfigurationElement[] iConfigurationElementArray = config = registry.getConfigurationElementsFor("org.eclipse.fordiac.ide.fbtypeeditor.fBTEditorValidation");
        int n = config.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement e = iConfigurationElementArray[n2];
            try {
                Object o = e.createExecutableExtension("class");
                if (o instanceof IFBTValidation) {
                    ((IFBTValidation)o).invokeValidation((INamedElement)this.fbType);
                }
            }
            catch (CoreException ex) {
                Activator.getDefault().logError(ex.getMessage(), (Exception)((Object)ex));
            }
            ++n2;
        }
    }

    protected boolean checkTypeSaveAble() {
        if (this.fbType instanceof CompositeFBType) {
            for (FBNetworkElement fb : ((CompositeFBType)this.fbType).getFBNetwork().getNetworkElements()) {
                if (fb.getPaletteEntry() != null) continue;
                MessageDialog.openInformation((Shell)this.getSite().getShell(), (String)Messages.FBTypeEditor_CompositeContainsFunctionBlockWithoutType, (String)MessageFormat.format(Messages.FBTypeEditor_CheckTypeSaveAble, fb.getName()));
                return false;
            }
        }
        return true;
    }

    public void doSaveAs() {
    }

    public void init(IEditorSite site, IEditorInput editorInput) throws PartInitException {
        if (editorInput instanceof FileEditorInput) {
            IFile fbTypeFile = ((FileEditorInput)editorInput).getFile();
            if (!fbTypeFile.exists()) {
                throw new PartInitException((IStatus)new Status(4, "org.eclipse.fordiac.ide.fbtypeeditor", Messages.FBTypeEditor_TypeFileDoesnotExist));
            }
            this.paletteEntry = TypeLibrary.getPaletteEntryForFile((IFile)fbTypeFile);
        } else if (editorInput instanceof FBTypeEditorInput) {
            this.paletteEntry = ((FBTypeEditorInput)editorInput).getPaletteEntry();
        }
        if (this.paletteEntry != null) {
            this.setPartName(this.paletteEntry.getLabel());
            this.fbType = this.getFBType(this.paletteEntry);
            if (this.fbType != null) {
                this.fbType.eAdapters().add((Object)this.adapter);
            }
        }
        site.getWorkbenchWindow().getSelectionService().addSelectionListener((ISelectionListener)this);
        this.getCommandStack().addCommandStackEventListener((CommandStackEventListener)this);
        super.init(site, editorInput);
    }

    protected FBType getFBType(PaletteEntry paletteEntry) {
        if (paletteEntry instanceof FBTypePaletteEntry) {
            return ((FBTypePaletteEntry)paletteEntry).getFBType();
        }
        if (paletteEntry instanceof AdapterTypePaletteEntry) {
            return ((AdapterTypePaletteEntry)paletteEntry).getType().getAdapterFBType();
        }
        return null;
    }

    public FBType getFBType() {
        return this.fbType;
    }

    public CommandStack getCommandStack() {
        return this.commandStack;
    }

    public void dispose() {
        if (this.fbType != null && this.fbType.eAdapters().contains((Object)this.adapter)) {
            this.fbType.eAdapters().remove((Object)this.adapter);
        }
        boolean dirty = this.isDirty();
        if (this.getSite() != null) {
            this.getSite().getWorkbenchWindow().getSelectionService().removeSelectionListener((ISelectionListener)this);
        }
        super.dispose();
        if (dirty && this.paletteEntry != null) {
            this.paletteEntry.setType(null);
        }
        this.getCommandStack().removeCommandStackEventListener((CommandStackEventListener)this);
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    protected void addPages() {
        SortedMap<Integer, IFBTEditorPart> sortedEditorsMap = this.getEditorsSorted();
        this.editors = new ArrayList<IFBTEditorPart>();
        FBTypeEditorInput editorInput = this.getFBTypeEditorInput();
        for (IFBTEditorPart fbtEditorPart : sortedEditorsMap.values()) {
            this.editors.add(fbtEditorPart);
            try {
                fbtEditorPart.setCommonCommandStack(this.commandStack);
                int index = this.addPage(fbtEditorPart, (IEditorInput)editorInput);
                this.setPageText(index, fbtEditorPart.getTitle());
                this.setPageImage(index, fbtEditorPart.getTitleImage());
            }
            catch (PartInitException e) {
                Activator.getDefault().logError(e.getMessage(), (Exception)((Object)e));
            }
        }
    }

    private SortedMap<Integer, IFBTEditorPart> getEditorsSorted() {
        IExtension[] extensions;
        TreeMap<Integer, IFBTEditorPart> sortedEditorsMap = new TreeMap<Integer, IFBTEditorPart>();
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint point = registry.getExtensionPoint("org.eclipse.fordiac.ide.fbtypeeditor.fBTEditorTabs");
        IExtension[] iExtensionArray = extensions = point.getExtensions();
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement[] elements;
            IExtension extension = iExtensionArray[n2];
            IConfigurationElement[] iConfigurationElementArray = elements = extension.getConfigurationElements();
            int n3 = elements.length;
            int n4 = 0;
            while (n4 < n3) {
                IConfigurationElement element = iConfigurationElementArray[n4];
                try {
                    Object obj = element.createExecutableExtension("class");
                    if (obj instanceof IFBTEditorPart) {
                        String elementType = element.getAttribute("type");
                        Integer sortIndex = Integer.valueOf(element.getAttribute("sortIndex"));
                        if (this.checkTypeEditorType(this.fbType, elementType)) {
                            sortedEditorsMap.put(sortIndex, (IFBTEditorPart)obj);
                        }
                    }
                }
                catch (Exception e) {
                    Activator.getDefault().logError(e.getMessage(), e);
                }
                ++n4;
            }
            ++n2;
        }
        return sortedEditorsMap;
    }

    protected boolean checkTypeEditorType(FBType fbType, String editorType) {
        return editorType.equals("ForAllTypes") || editorType.equals("ForAllFBTypes") || editorType.equals("ForAllNonAdapterFBTypes") && !(fbType instanceof AdapterFBType) || fbType instanceof BasicFBType && editorType.equals("basic") || fbType instanceof SimpleFBType && editorType.equals("simple") || fbType instanceof ServiceInterfaceFBType && editorType.equals("serviceInterface") || fbType instanceof CompositeFBType && editorType.equals("composite");
    }

    private FBTypeEditorInput getFBTypeEditorInput() {
        return new FBTypeEditorInput(this.fbType, this.paletteEntry);
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        if (((Object)((Object)this)).equals(this.getSite().getPage().getActiveEditor())) {
            this.handleContentOutlineSelection(selection);
        }
    }

    public <T> T getAdapter(Class<T> adapter) {
        if (adapter == IContentOutlinePage.class) {
            if (this.contentOutline == null) {
                this.contentOutline = new FBTypeContentOutline(this.fbType, this);
            }
            return adapter.cast((Object)this.contentOutline);
        }
        if (adapter == CommandStack.class) {
            return adapter.cast(this.getCommandStack());
        }
        if (adapter == IPropertySheetPage.class) {
            return adapter.cast(new TabbedPropertySheetPage((ITabbedPropertySheetPageContributor)this));
        }
        if (adapter == IGotoMarker.class) {
            return adapter.cast((Object)this);
        }
        return (T)super.getAdapter(adapter);
    }

    public void handleContentOutlineSelection(ISelection selection) {
        if (selection instanceof IStructuredSelection && !selection.isEmpty()) {
            Object selectedElement = ((IStructuredSelection)selection).getFirstElement();
            int i = 0;
            for (IFBTEditorPart editorPart : this.editors) {
                if (editorPart.outlineSelectionChanged(selectedElement)) {
                    this.setActivePage(i);
                    break;
                }
                ++i;
            }
        }
    }

    public IEditorActionBarContributor getActionBarContributor() {
        return null;
    }

    public void stackChanged(CommandStackEvent event) {
        this.firePropertyChange(257);
    }

    public String getContributorId() {
        return "property.contributor.fb";
    }

    public void gotoMarker(IMarker marker) {
        int i = 0;
        for (IFBTEditorPart editorPart : this.editors) {
            if (editorPart.isMarkerTarget(marker)) {
                this.setActivePage(i);
                editorPart.gotoMarker(marker);
                break;
            }
            ++i;
        }
    }

    public void reloadFile() {
        if (this.fbType != null && this.fbType.eAdapters().contains((Object)this.adapter)) {
            this.fbType.eAdapters().remove((Object)this.adapter);
        }
        this.fbType = (FBType)this.paletteEntry.getType();
        this.editors.stream().forEach(e -> e.reloadType(this.fbType));
        this.getCommandStack().flush();
        this.fbType.eAdapters().add((Object)this.adapter);
    }

    public IFile getFile() {
        return this.paletteEntry != null ? this.paletteEntry.getFile() : null;
    }

    protected void pageChange(int newPageIndex) {
        super.pageChange(newPageIndex);
        this.getSite().getPage().getNavigationHistory().markLocation((IEditorPart)this);
    }

    public INavigationLocation createEmptyNavigationLocation() {
        return null;
    }

    public INavigationLocation createNavigationLocation() {
        return new FBTypeNavigationLocation(this);
    }
}

