/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.fbtypeeditor;

import org.eclipse.fordiac.ide.fbtypeeditor.DataTypeCreationFactory;
import org.eclipse.fordiac.ide.fbtypeeditor.Messages;
import org.eclipse.fordiac.ide.gef.preferences.PaletteFlyoutPreferences;
import org.eclipse.fordiac.ide.model.Palette.AdapterTypePaletteEntry;
import org.eclipse.fordiac.ide.model.data.DataType;
import org.eclipse.fordiac.ide.model.typelibrary.EventTypeLibrary;
import org.eclipse.fordiac.ide.model.typelibrary.TypeLibrary;
import org.eclipse.fordiac.ide.ui.imageprovider.FordiacImage;
import org.eclipse.gef.palette.CombinedTemplateCreationEntry;
import org.eclipse.gef.palette.PaletteDrawer;
import org.eclipse.gef.palette.PaletteEntry;
import org.eclipse.gef.palette.PaletteRoot;
import org.eclipse.gef.requests.CreationFactory;
import org.eclipse.jface.resource.ImageDescriptor;

public final class FBInterfacePaletteFactory {
    public static final PaletteFlyoutPreferences PALETTE_PREFERENCES = new PaletteFlyoutPreferences("FBInterfacePaletteFactory.Location", "FBInterfacePaletteFactory.Size", "FBInterfacePaletteFactory.State");

    public static PaletteRoot createPalette(TypeLibrary typeLib) {
        PaletteRoot palette = new PaletteRoot();
        FBInterfacePaletteFactory.fillPalette(typeLib, palette);
        return palette;
    }

    private static void fillPalette(TypeLibrary typeLib, PaletteRoot palette) {
        CombinedTemplateCreationEntry combined;
        ImageDescriptor desc;
        PaletteDrawer drawer = new PaletteDrawer(Messages.FBInterfacePaletteFactory_EventTypes);
        for (DataType type : EventTypeLibrary.getInstance().getEventTypes()) {
            desc = FordiacImage.ICON_DATA_TYPE.getImageDescriptor();
            combined = new CombinedTemplateCreationEntry(type.getName(), type.getComment(), (CreationFactory)new DataTypeCreationFactory(type), desc, desc);
            drawer.add((PaletteEntry)combined);
        }
        palette.add((PaletteEntry)drawer);
        drawer = new PaletteDrawer(Messages.FBInterfacePaletteFactory_DataTypes);
        for (DataType dataType : typeLib.getDataTypeLibrary().getDataTypesSorted()) {
            desc = FordiacImage.ICON_DATA_TYPE.getImageDescriptor();
            combined = new CombinedTemplateCreationEntry(dataType.getName(), dataType.getComment(), (CreationFactory)new DataTypeCreationFactory(dataType), desc, desc);
            drawer.add((PaletteEntry)combined);
        }
        palette.add((PaletteEntry)drawer);
        FBInterfacePaletteFactory.createAdapterEntry(palette, typeLib);
    }

    private static void createAdapterEntry(PaletteRoot palette, TypeLibrary typeLib) {
        PaletteDrawer drawer = new PaletteDrawer("Adapters");
        for (AdapterTypePaletteEntry entry : typeLib.getBlockTypeLib().getAdapterTypesSorted()) {
            ImageDescriptor desc = FordiacImage.ICON_DATA_TYPE.getImageDescriptor();
            drawer.add((PaletteEntry)new CombinedTemplateCreationEntry(entry.getLabel(), entry.getType().getComment(), (CreationFactory)new DataTypeCreationFactory((DataType)entry.getType()), desc, desc));
        }
        if (!drawer.getChildren().isEmpty()) {
            palette.add((PaletteEntry)drawer);
        }
    }

    private FBInterfacePaletteFactory() {
        throw new UnsupportedOperationException("Class FBInterfacePaletteFactory should not be created!\n");
    }
}

